// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepSweep_Tool_HeaderFile
#define _BRepSweep_Tool_HeaderFile

#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class Standard_OutOfRange;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides  the  indexation and type  analysis  services <br>
//!          required by the TopoDS generating Shape of BRepSweep. <br>
//! <br>
class BRepSweep_Tool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initialize the tool  with <aShape>.  The IndexTool <br>
//!          must prepare an indexation for  all  the subshapes <br>
//!          of this shape. <br>
Standard_EXPORT BRepSweep_Tool(const TopoDS_Shape& aShape);

//! Returns the number of subshapes in the shape. <br>
Standard_EXPORT   Standard_Integer NbShapes() const;

//! Returns the index of <aShape>. <br>
Standard_EXPORT   Standard_Integer Index(const TopoDS_Shape& aShape) const;

//! Returns the Shape at Index anIdex. <br>
Standard_EXPORT   TopoDS_Shape Shape(const Standard_Integer anIndex) const;

//! Returns the type of <aShape>. <br>
Standard_EXPORT   TopAbs_ShapeEnum Type(const TopoDS_Shape& aShape) const;

//! Returns the Orientation of <aShape>. <br>
Standard_EXPORT   TopAbs_Orientation Orientation(const TopoDS_Shape& aShape) const;

//! Set the Orientation of <aShape> with Or. <br>
Standard_EXPORT   void SetOrientation(TopoDS_Shape& aShape,const TopAbs_Orientation Or) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_IndexedMapOfShape myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
