// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRAlgo_HeaderFile
#define _HLRAlgo_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class HLRAlgo_BiPoint;
class HLRAlgo_ListOfBPoint;
class HLRAlgo_PolyShellData;
class HLRAlgo_PolyInternalData;
class HLRAlgo_PolyInternalSegment;
class HLRAlgo_PolyInternalNode;
class HLRAlgo_PolyData;
class HLRAlgo_PolyHidingData;
class HLRAlgo_TriangleData;
class HLRAlgo_Array1OfPHDat;
class HLRAlgo_HArray1OfPHDat;
class HLRAlgo_Array1OfPISeg;
class HLRAlgo_HArray1OfPISeg;
class HLRAlgo_Array1OfPINod;
class HLRAlgo_HArray1OfPINod;
class HLRAlgo_Array1OfTData;
class HLRAlgo_HArray1OfTData;
class HLRAlgo_PolyAlgo;
class HLRAlgo_EdgeStatus;
class HLRAlgo_Projector;
class HLRAlgo_Intersection;
class HLRAlgo_Coincidence;
class HLRAlgo_Interference;
class HLRAlgo_InterferenceList;
class HLRAlgo_EdgesBlock;
class HLRAlgo_WiresBlock;
class HLRAlgo_EdgeIterator;
class HLRAlgo_ListNodeOfListOfBPoint;
class HLRAlgo_ListIteratorOfListOfBPoint;
class HLRAlgo_ListNodeOfInterferenceList;
class HLRAlgo_ListIteratorOfInterferenceList;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!        In order to have the precision required in <br>
//! industrial design, drawings need to offer the <br>
//! possibility of removing lines, which are hidden <br>
//! in a given projection. To do this, the Hidden <br>
//! Line Removal component provides two <br>
//!   algorithms: HLRBRep_Algo and HLRBRep_PolyAlgo. <br>
//! These algorithms remove or indicate lines <br>
//! hidden by surfaces. For a given projection, they <br>
//! calculate a set of lines characteristic of the <br>
//! object being represented. They are also used <br>
//! in conjunction with extraction utilities, which <br>
//! reconstruct a new, simplified shape from a <br>
//! selection of calculation results. This new shape <br>
//! is made up of edges, which represent the lines <br>
//! of the visualized shape in a plane. This plane is the projection plane. <br>
//! HLRBRep_Algo takes into account the shape <br>
//! itself. HLRBRep_PolyAlgo works with a <br>
//! polyhedral simplification of the shape. When <br>
//! you use HLRBRep_Algo, you obtain an exact <br>
//! result, whereas, when you use <br>
//! HLRBRep_PolyAlgo, you reduce computation <br>
//! time but obtain polygonal segments. <br>
class HLRAlgo  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  void UpdateMinMax(const Standard_Real x,const Standard_Real y,const Standard_Real z,const Standard_Address Min,const Standard_Address Max) ;


Standard_EXPORT static  void EnlargeMinMax(const Standard_Real tol,const Standard_Address Min,const Standard_Address Max) ;


Standard_EXPORT static  void InitMinMax(const Standard_Real Big,const Standard_Address Min,const Standard_Address Max) ;


Standard_EXPORT static  void EncodeMinMax(const Standard_Address Min,const Standard_Address Max,const Standard_Address MinMax) ;


Standard_EXPORT static  Standard_Real SizeBox(const Standard_Address Min,const Standard_Address Max) ;


Standard_EXPORT static  void DecodeMinMax(const Standard_Address MinMax,const Standard_Address Min,const Standard_Address Max) ;


Standard_EXPORT static  void CopyMinMax(const Standard_Address IMin,const Standard_Address IMax,const Standard_Address OMin,const Standard_Address OMax) ;


Standard_EXPORT static  void AddMinMax(const Standard_Address IMin,const Standard_Address IMax,const Standard_Address OMin,const Standard_Address OMax) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class HLRAlgo_BiPoint;
friend class HLRAlgo_ListOfBPoint;
friend class HLRAlgo_PolyShellData;
friend class HLRAlgo_PolyInternalData;
friend class HLRAlgo_PolyInternalSegment;
friend class HLRAlgo_PolyInternalNode;
friend class HLRAlgo_PolyData;
friend class HLRAlgo_PolyHidingData;
friend class HLRAlgo_TriangleData;
friend class HLRAlgo_Array1OfPHDat;
friend class HLRAlgo_HArray1OfPHDat;
friend class HLRAlgo_Array1OfPISeg;
friend class HLRAlgo_HArray1OfPISeg;
friend class HLRAlgo_Array1OfPINod;
friend class HLRAlgo_HArray1OfPINod;
friend class HLRAlgo_Array1OfTData;
friend class HLRAlgo_HArray1OfTData;
friend class HLRAlgo_PolyAlgo;
friend class HLRAlgo_EdgeStatus;
friend class HLRAlgo_Projector;
friend class HLRAlgo_Intersection;
friend class HLRAlgo_Coincidence;
friend class HLRAlgo_Interference;
friend class HLRAlgo_InterferenceList;
friend class HLRAlgo_EdgesBlock;
friend class HLRAlgo_WiresBlock;
friend class HLRAlgo_EdgeIterator;
friend class HLRAlgo_ListNodeOfListOfBPoint;
friend class HLRAlgo_ListIteratorOfListOfBPoint;
friend class HLRAlgo_ListNodeOfInterferenceList;
friend class HLRAlgo_ListIteratorOfInterferenceList;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
