// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESDimen_LeaderArrow_HeaderFile
#define _IGESDimen_LeaderArrow_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESDimen_LeaderArrow_HeaderFile
#include <Handle_IGESDimen_LeaderArrow.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfXY_HeaderFile
#include <Handle_TColgp_HArray1OfXY.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColgp_HArray1OfXY;
class Standard_OutOfRange;
class gp_XY;
class gp_Pnt2d;
class gp_Pnt;


//! defines LeaderArrow, Type <214> Form <1-12> <br>
//!          in package IGESDimen <br>
//!          Consists of one or more line segments except when <br>
//!          leader is part of an angular dimension, with links to <br>
//!          presumed text item <br>
class IGESDimen_LeaderArrow : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESDimen_LeaderArrow();

//! This method is used to set the fields of the class <br>
//!           LeaderArrow <br>
//!       - height      : ArrowHead height <br>
//!       - width       : ArrowHead width <br>
//!       - depth       : Z Depth <br>
//!       - position    : ArrowHead coordinates <br>
//!       - segments    : Segment tail coordinate pairs <br>
Standard_EXPORT   void Init(const Standard_Real height,const Standard_Real width,const Standard_Real depth,const gp_XY& position,const Handle(TColgp_HArray1OfXY)& segments) ;

//! Changes FormNumber (indicates the Shape of the Arrow) <br>
//!           Error if not in range [0-12] <br>
Standard_EXPORT   void SetFormNumber(const Standard_Integer form) ;

//! returns number of segments <br>
Standard_EXPORT   Standard_Integer NbSegments() const;

//! returns ArrowHead height <br>
Standard_EXPORT   Standard_Real ArrowHeadHeight() const;

//! returns ArrowHead width <br>
Standard_EXPORT   Standard_Real ArrowHeadWidth() const;

//! returns Z depth <br>
Standard_EXPORT   Standard_Real ZDepth() const;

//! returns ArrowHead co-ordinates <br>
Standard_EXPORT   gp_Pnt2d ArrowHead() const;

//! returns ArrowHead co-ordinates after Transformation <br>
Standard_EXPORT   gp_Pnt TransformedArrowHead() const;

//! returns segment tail co-ordinates. <br>
//! raises exception if Index <= 0 or Index > NbSegments <br>
Standard_EXPORT   gp_Pnt2d SegmentTail(const Standard_Integer Index) const;

//! returns segment tail co-ordinates after Transformation. <br>
//! raises exception if Index <= 0 or Index > NbSegments <br>
Standard_EXPORT   gp_Pnt TransformedSegmentTail(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESDimen_LeaderArrow();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real theArrowHeadHeight;
Standard_Real theArrowHeadWidth;
Standard_Real theZDepth;
gp_XY theArrowHead;
Handle_TColgp_HArray1OfXY theSegmentTails;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
