// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopCnx_EdgeFaceTransition_HeaderFile
#define _TopCnx_EdgeFaceTransition_HeaderFile

#ifndef _TopTrans_CurveTransition_HeaderFile
#include <TopTrans_CurveTransition.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class gp_Dir;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! TheEdgeFaceTransition is an algorithm to   compute <br>
//!          the  cumulated  transition for interferences on an <br>
//!          edge. <br>
class TopCnx_EdgeFaceTransition  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty algorithm. <br>
Standard_EXPORT TopCnx_EdgeFaceTransition();

//! Initialize  the     algorithm    with the    local <br>
//!          description of the edge. <br>
Standard_EXPORT   void Reset(const gp_Dir& Tgt,const gp_Dir& Norm,const Standard_Real Curv) ;

//! Initialize the algorithm with a linear Edge. <br>
Standard_EXPORT   void Reset(const gp_Dir& Tgt) ;

//! Add a curve  element to the  boundary.  Or  is the <br>
//!          orientation of   the interference on  the boundary <br>
//!          curve. Tr is  the transition  of the interference. <br>
//!          BTr     is   the    boundary  transition    of the <br>
//!          interference. <br>
Standard_EXPORT   void AddInterference(const Standard_Real Tole,const gp_Dir& Tang,const gp_Dir& Norm,const Standard_Real Curv,const TopAbs_Orientation Or,const TopAbs_Orientation Tr,const TopAbs_Orientation BTr) ;

//! Returns the current cumulated transition. <br>
Standard_EXPORT   TopAbs_Orientation Transition() const;

//! Returns the current cumulated BoundaryTransition. <br>
Standard_EXPORT   TopAbs_Orientation BoundaryTransition() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTrans_CurveTransition myCurveTransition;
Standard_Integer nbBoundForward;
Standard_Integer nbBoundReversed;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
