// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopoDSToStep_WireframeBuilder_HeaderFile
#define _TopoDSToStep_WireframeBuilder_HeaderFile

#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _TopoDSToStep_BuilderError_HeaderFile
#include <TopoDSToStep_BuilderError.hxx>
#endif
#ifndef _TopoDSToStep_Root_HeaderFile
#include <TopoDSToStep_Root.hxx>
#endif
#ifndef _Handle_Transfer_FinderProcess_HeaderFile
#include <Handle_Transfer_FinderProcess.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HSequenceOfTransient;
class StdFail_NotDone;
class TopoDS_Shape;
class TopoDSToStep_Tool;
class Transfer_FinderProcess;
class TopoDS_Edge;
class TopoDS_Face;
class MoniTool_DataMapOfShapeTransient;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This builder Class provides services to build <br>
//!          a ProSTEP Wireframemodel from a Cas.Cad BRep. <br>
class TopoDSToStep_WireframeBuilder  : public TopoDSToStep_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT TopoDSToStep_WireframeBuilder();


Standard_EXPORT TopoDSToStep_WireframeBuilder(const TopoDS_Shape& S,TopoDSToStep_Tool& T,const Handle(Transfer_FinderProcess)& FP);


Standard_EXPORT   void Init(const TopoDS_Shape& S,TopoDSToStep_Tool& T,const Handle(Transfer_FinderProcess)& FP) ;


Standard_EXPORT   TopoDSToStep_BuilderError Error() const;


Standard_EXPORT  const Handle_TColStd_HSequenceOfTransient& Value() const;

//! Extraction of Trimmed Curves from TopoDS_Edge for the <br>
//!  Creation of a GeometricallyBoundedWireframeRepresentation <br>
Standard_EXPORT   Standard_Boolean GetTrimmedCurveFromEdge(const TopoDS_Edge& E,const TopoDS_Face& F,MoniTool_DataMapOfShapeTransient& M,Handle(TColStd_HSequenceOfTransient)& L) const;

//! Extraction of Trimmed Curves from TopoDS_Face for the <br>
//!  Creation of a GeometricallyBoundedWireframeRepresentation <br>
Standard_EXPORT   Standard_Boolean GetTrimmedCurveFromFace(const TopoDS_Face& F,MoniTool_DataMapOfShapeTransient& M,Handle(TColStd_HSequenceOfTransient)& L) const;

//! Extraction of Trimmed Curves from any TopoDS_Shape for the <br>
//!  Creation of a GeometricallyBoundedWireframeRepresentation <br>
Standard_EXPORT   Standard_Boolean GetTrimmedCurveFromShape(const TopoDS_Shape& S,MoniTool_DataMapOfShapeTransient& M,Handle(TColStd_HSequenceOfTransient)& L) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HSequenceOfTransient myResult;
TopoDSToStep_BuilderError myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
