// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V3d_Camera_HeaderFile
#define _V3d_Camera_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_V3d_Camera_HeaderFile
#include <Handle_V3d_Camera.hxx>
#endif

#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _V3d_TypeOfRepresentation_HeaderFile
#include <V3d_TypeOfRepresentation.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _V3d_Coordinate_HeaderFile
#include <V3d_Coordinate.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _V3d_TypeOfPickCamera_HeaderFile
#include <V3d_TypeOfPickCamera.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
class Graphic3d_Structure;
class Viewer_BadValue;
class V3d_View;
class Graphic3d_Group;
class Graphic3d_Vertex;


//! Creation and modification of a spot. <br>
class V3d_Camera : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates the camera which relatives of View <br>
Standard_EXPORT V3d_Camera(const Handle(V3d_View)& aView);

//! Defines the position of the camera.     . <br>
Standard_EXPORT   void SetPosition(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Defines the angular position of camera. <br>//!  Warning! raises BadValue from Viewer if Abs(Angle) > 2*PI; <br>
//!	If the angle is <= 0 ou > PI . <br>
Standard_EXPORT   void SetAngle(const Quantity_PlaneAngle Angle) ;

//! Defines the Aperture. <br>//!  Warning! raises BadValue from Viewer if angle <= 0 or > PI <br>
Standard_EXPORT   void SetAperture(const Quantity_PlaneAngle Angle) ;

//! Defines the target of the camera. <br>
Standard_EXPORT   void SetTarget(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Define the radius. <br>//!  Warning! raises BadValue from Viewer if radius <= 0 . <br>
Standard_EXPORT   void SetRadius(const Quantity_Parameter Radius) ;

//! Calculate the position of the camera, on the hide face <br>
//!          of the picking sphere. <br>
Standard_EXPORT   void OnHideFace(const Handle(V3d_View)& aView) ;

//! Calculate the position of the camera, on the seen face <br>
//!          of the picking sphere. <br>
Standard_EXPORT   void OnSeeFace(const Handle(V3d_View)& aView) ;

//! Tracking the camera position, or the picking sphere, <br>
//!          or the radius of the picking sphere, that depends of <br>
//!          initial picking "WhatPick" (see the pick method). <br>
//!          If WhatPick is SPACECAMERA, then the parameters <br>
//!          Xpix, Ypix are the coordinates of a translation vector. <br>
Standard_EXPORT   void Tracking(const Handle(V3d_View)& aView,const V3d_TypeOfPickCamera WathPick,const Standard_Integer Xpix,const Standard_Integer Ypix) ;

//! Permits the driving of the camera in aerial mode. <br>
//!          The user believes fly in plane ... <br>
Standard_EXPORT   void AerialPilot(const Handle(V3d_View)& aView,const Standard_Integer Xpix,const Standard_Integer Ypix) ;

//! Permits the driving of the camera in earth mode. <br>
//!          The user believes drive a car ... <br>
Standard_EXPORT   void EarthPilot(const Handle(V3d_View)& aView,const Standard_Integer Xpix,const Standard_Integer Ypix) ;

//! The camera move or move back in the direction camera, <br>
//!          target of camera. <br>
Standard_EXPORT   void Move(const Quantity_Parameter Dist) ;

//! The camera go up or go down on the z axis, <br>
//!          the direction of camera is the same. <br>
Standard_EXPORT   void GoUp(const Quantity_Parameter Haut) ;

//! Display the graphic structure of camera <br>
//!          in the choosen view. We have two types of representation. <br>
//!          - SIMPLE : Only the camera position is displayed. <br>
//!          - COMPLETE : The position camera, the picking sphere and <br>
//!                       the radius of sphere are displayed. <br>
Standard_EXPORT   void Display(const Handle(V3d_View)& aView,const V3d_TypeOfRepresentation Representation) ;

//! Erase the graphic structure of camera. <br>
Standard_EXPORT   void Erase() ;

//! Returns the position of the camera. <br>
Standard_EXPORT   void Position(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the position of the target of camera. <br>
Standard_EXPORT   void Target(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the angle. <br>
Standard_EXPORT   Quantity_PlaneAngle Angle() const;

//! Returns the Aperture. <br>
Standard_EXPORT   Quantity_PlaneAngle Aperture() const;

//! Returns the radius of the picking sphere. <br>
Standard_EXPORT   Quantity_Parameter Radius() const;

//! Returns a Boolean on the status seen or hidden of the <br>
//!          camera. <br>
//!          If True the camera has seen. <br>
//!          If False the camera has hidden. <br>
Standard_EXPORT   Standard_Boolean SeeOrHide(const Handle(V3d_View)& aView) const;

//! Returns the type of pick element. <br>
//!          "POSITIONCAMERA"  : Representation of camera position. <br>
//!          "SPACECAMERA"     : Representation of picking sphere. <br>
//!          "ExtRADIUSCAMERA" : Representation of extern arrow. <br>
//!          "IntRADIUSCAMERA" : Representation of intern arrow. <br>
//!          "RADIUSTEXTCAMERA": Representation of radius value. <br>
//!          "NOTHINGCAMERA"   : Any component of camera. <br>
//!          Determinate which type of tracking apply. <br>
Standard_EXPORT   V3d_TypeOfPickCamera Pick(const Handle(V3d_View)& aView,const Standard_Integer Xpix,const Standard_Integer Ypix) const;
//Standard_EXPORT ~V3d_Camera();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Defined the representation of camera position. <br>
Standard_EXPORT   void Symbol(const Handle(Graphic3d_Group)& gsymbol,const Handle(V3d_View)& aView) const;

//! Returns the symetric point coordinates of "aPoint" <br>
//!          on the sphere of center "Center" and radius "Radius". <br>
//!          VX,VY,VZ is the project vector of view. <br>
Standard_EXPORT static  void SymetricPointOnSphere(const Handle(V3d_View)& aView,const Graphic3d_Vertex& Center,const Graphic3d_Vertex& aPoint,const Quantity_Parameter Radius,V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z,Quantity_Parameter& VX,Quantity_Parameter& VY,Quantity_Parameter& VZ) ;


 // Fields PRIVATE
 //
Graphic3d_Vertex MyPosition;
Graphic3d_Vertex MyTarget;
Quantity_PlaneAngle MyAngle;
Quantity_PlaneAngle MyAperture;
Handle_Graphic3d_Structure MyGraphicStructure;
Handle_Graphic3d_Structure MyGraphicStructure1;
V3d_TypeOfRepresentation MyTypeOfRepresentation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
