#
# Open Motif 2.1.30 for Linux
#
Summary:  The Open Motif runtime components.
Name:  openmotif
Version:  2.1.30
Release:  2_ICS
Prefix:  /usr/X11R6
Icon:  ics.gif
Copyright:  Copyright 2000 Integrated Computer Solutions, Inc.
Group:  User Interface/Motif
Source:  /usr/src/redhat/SOURCES/openmotif-2.1.30-src.tgz
Source1: /usr/src/redhat/SOURCES/openmotif-2.1.30-icsextra.tgz
Patch0:  /usr/src/redhat/SOURCES/openmotif-2.1.30-icsbuild.patch
Patch1:  /usr/src/redhat/SOURCES/openmotif-2.1.30-mwm.patch
URL:  http://www.motifzone.org/
Distribution:  Linux
Vendor:  Integrated Computer Solutions, Inc.
Packager:  ICS <info@ics.com>
%description
The base package for the industry standard
user interface toolkit for the X Window
System as enhanced by ICS and others for
better integration with GNOME and KDE desktop
environments.  The base package consists of
the Open Motif runtime components -- 
shared libraries and mwm (Motif Window Manager).

%package devel
Version:  2.1.30
Release:  2_ICS
Prefix:  /usr/X11R6
Icon:  icsdev.gif
Summary:  The Open Motif development libraries and tools.
Group:  Development/Libraries
%description devel
The development package includes all of the
Open Motif header files, archive libraries, 
the UIL (User Interface Language) compiler,
examples and ICS enhancements for greater
integration with GNOME and KDE desktop
environments.

%prep
if [ "${RPM_BUILD_DIR}" = "" ];
  then
  RPM_BUILD_DIR="/usr/src/redhat/BUILD"
fi
%setup -q -n motif
%setup -q -n motif -T -D -b 1 
cd  ${RPM_BUILD_DIR}
%patch -P 0
%patch -P 1
mkdir -p ${RPM_BUILD_DIR}/motif/imports/x11
cd ${RPM_BUILD_DIR}/motif/imports/x11
ln -s /usr/X11R6/lib .
ln -s /usr/X11R6/include .
cd ${RPM_BUILD_DIR}/motif/config/cf
mkdir OPENGROUP
mv *.tmpl *.rules *.def *.cf OPENGROUP
ln -s /usr/X11R6/lib/X11/config/* .
rm Motif.tmpl Motif.rules host.def
mv OPENGROUP/{Motif.tmpl,Motif.rules,host.def} .
cd ${RPM_BUILD_DIR}

%build
if [ "${RPM_BUILD_DIR}" = "" ];
  then
  RPM_BUILD_DIR="/usr/src/redhat/BUILD"
fi
cd ${RPM_BUILD_DIR}/motif
make World

%install
if [ "${RPM_BUILD_DIR}" = "" ];
  then
  RPM_BUILD_DIR="/usr/src/redhat/BUILD"
fi
cd ${RPM_BUILD_DIR}/motif/lib
make DESTDIR="${RPM_BUILD_ROOT}" install
cd ${RPM_BUILD_DIR}/motif/clients
make DESTDIR="${RPM_BUILD_ROOT}" install
cd ${RPM_BUILD_DIR}/motif/demos
make DESTDIR="${RPM_BUILD_ROOT}" install
cd ${RPM_BUILD_DIR}/motif/bitmaps
make DESTDIR="${RPM_BUILD_ROOT}" install
cd ${RPM_BUILD_DIR}/motif/bindings
make DESTDIR="${RPM_BUILD_ROOT}" install
cd ${RPM_BUILD_DIR}/motif/doc
tar chf - man | (cd ${RPM_BUILD_ROOT}%{prefix}; tar xf -)
cd ${RPM_BUILD_ROOT}%{prefix}/man
chown -R root:root .
mkdir -p ${RPM_BUILD_ROOT}/usr/doc/openmotif-2.1.30
mkdir -p ${RPM_BUILD_ROOT}/usr/doc/openmotif-devel-2.1.30
cd ${RPM_BUILD_DIR}/motif
cp LICENSE ${RPM_BUILD_ROOT}/usr/doc/openmotif-2.1.30
cp LICENSE ${RPM_BUILD_ROOT}/usr/doc/openmotif-devel-2.1.30
cp ${RPM_BUILD_DIR}/motif/doc/ics/OpenMotifEverywhere.html ${RPM_BUILD_ROOT}/usr/doc/openmotif-2.1.30
cp ${RPM_BUILD_DIR}/motif/doc/ics/OpenMotifEverywhere.html ${RPM_BUILD_ROOT}/usr/doc/openmotif-devel-2.1.30
cp ${RPM_BUILD_DIR}/motif/doc/ics/OpenMotifEverywhere.txt ${RPM_BUILD_ROOT}/usr/doc/openmotif-2.1.30
cp ${RPM_BUILD_DIR}/motif/doc/ics/OpenMotifEverywhere.txt ${RPM_BUILD_ROOT}/usr/doc/openmotif-devel-2.1.30
cd ${RPM_BUILD_DIR}/motif/doc/ps
cp -R README.runtime mot-ug ${RPM_BUILD_ROOT}/usr/doc/openmotif-2.1.30
cp -R README.devel mot-cdesgr.ps.Z mot-csgcc.ps.Z mot-gloss.ps.Z mot-mcsg.ps.Z mot-pg mot-ref mot-wwg.ps.Z ${RPM_BUILD_ROOT}/usr/doc/openmotif-devel-2.1.30
cp -R ${RPM_BUILD_DIR}/motif/demos ${RPM_BUILD_ROOT}%{prefix}
cd ${RPM_BUILD_ROOT}%{prefix}
mv demos xmdemos
cd xmdemos
make -k clean
find . -name Makefile -exec rm {} \;
chown -R root:root .

%clean
if [ "${RPM_BUILD_ROOT}" != "" ];
  then
  rm -rf ${RPM_BUILD_ROOT}
else
  rm -rf %{prefix}/xmdemos
  rm -rf %{prefix}/include/Xm
  rm -rf %{prefix}/include/Mrm
  rm -rf %{prefix}/include/uil
  rm -rf %{prefix}/lib/X11/uid
  rm -f %{prefix}/lib/libXm.so.2.1 %{prefix}/lib/libXm.so.2 %{prefix}/lib/libXm.so %{prefix}/lib/libXm.a %{prefix}/lib/libXm_d.a
  rm -f %{prefix}/lib/libMrm.so.2.1 %{prefix}/lib/libMrm.so.2 %{prefix}/lib/libMrm.so %{prefix}/lib/libMrm.a %{prefix}/lib/libMrm_d.a
  rm -f %{prefix}/lib/libUil.so.2.1 %{prefix}/lib/libUil.so.2 %{prefix}/lib/libUil.so %{prefix}/lib/libUil.a %{prefix}/lib/libUil_d.a
fi

%post
/sbin/ldconfig

%post devel
echo "#define TopLevelProject Motif" >> /usr/X11R6/lib/X11/config/host.def

%preun
if [ "${RPM_INSTALL_PREFIX}" = "" ]; then
  RPM_INSTALL_PREFIX="/usr/X11R6"
fi
rm -f ${RPM_INSTALL_PREFIX}/lib/libXm.so.2
rm -f ${RPM_INSTALL_PREFIX}/lib/libMrm.so.2
rm -f ${RPM_INSTALL_PREFIX}/lib/libUil.so.2

%preun devel
(cd /usr/X11R6/lib/X11/config;
 mv host.def host.def.bak;
 /bin/grep -v "TopLevelProject" host.def.bak >> host.def)

%files devel

%dir /usr/X11R6/xmdemos
%dir /usr/X11R6/xmdemos/doc
%dir /usr/X11R6/xmdemos/doc/programGuide
%dir /usr/X11R6/xmdemos/doc/programGuide/ch05
%dir /usr/X11R6/xmdemos/doc/programGuide/ch05/Scale
%dir /usr/X11R6/xmdemos/doc/programGuide/ch06
%dir /usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box
%dir /usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box
%dir /usr/X11R6/xmdemos/doc/programGuide/ch08
%dir /usr/X11R6/xmdemos/doc/programGuide/ch08/Container
%dir /usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook
%dir /usr/X11R6/xmdemos/doc/programGuide/ch16
%dir /usr/X11R6/xmdemos/doc/programGuide/ch17
%dir /usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drag
%dir /usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drop
%dir /usr/X11R6/xmdemos/lib
%dir /usr/X11R6/xmdemos/lib/Exm
%dir /usr/X11R6/xmdemos/lib/Exm/wml
%dir /usr/X11R6/xmdemos/lib/ExmCxx
%dir /usr/X11R6/xmdemos/lib/Wsm
%dir /usr/X11R6/xmdemos/lib/XmCxx
%dir /usr/X11R6/xmdemos/lib/Xmd
%dir /usr/X11R6/xmdemos/lib/uil
%dir /usr/X11R6/xmdemos/programs
%dir /usr/X11R6/xmdemos/programs/Exm
%dir /usr/X11R6/xmdemos/programs/Exm/app_in_c
%dir /usr/X11R6/xmdemos/programs/Exm/app_in_uil
%dir /usr/X11R6/xmdemos/programs/Exm/simple_app
%dir /usr/X11R6/xmdemos/programs/airport
%dir /usr/X11R6/xmdemos/programs/animate
%dir /usr/X11R6/xmdemos/programs/drag_and_drop
%dir /usr/X11R6/xmdemos/programs/draw
%dir /usr/X11R6/xmdemos/programs/earth
%dir /usr/X11R6/xmdemos/programs/filemanager
%dir /usr/X11R6/xmdemos/programs/fileview
%dir /usr/X11R6/xmdemos/programs/getsubres
%dir /usr/X11R6/xmdemos/programs/hellomotif
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/C
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/C/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/bdf
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/english
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/english/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/french
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/french/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/hebrew
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/hebrew/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/japan
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/japan/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/japanese
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/japanese/uid
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/swedish
%dir /usr/X11R6/xmdemos/programs/hellomotifi18n/swedish/uid
%dir /usr/X11R6/xmdemos/programs/i18ninput
%dir /usr/X11R6/xmdemos/programs/panner
%dir /usr/X11R6/xmdemos/programs/periodic
%dir /usr/X11R6/xmdemos/programs/piano
%dir /usr/X11R6/xmdemos/programs/popups
%dir /usr/X11R6/xmdemos/programs/sampler2_0
%dir /usr/X11R6/xmdemos/programs/setdate
%dir /usr/X11R6/xmdemos/programs/todo
%dir /usr/X11R6/xmdemos/programs/workspace
%dir /usr/X11R6/xmdemos/unsupported
%dir /usr/X11R6/xmdemos/unsupported/Exm
%dir /usr/X11R6/xmdemos/unsupported/aicon
%dir /usr/X11R6/xmdemos/unsupported/cstext
%dir /usr/X11R6/xmdemos/unsupported/cstext/texteditor
%dir /usr/X11R6/xmdemos/unsupported/dainput
%dir /usr/X11R6/xmdemos/unsupported/dogs
%dir /usr/X11R6/xmdemos/unsupported/hellomotif
%dir /usr/X11R6/xmdemos/unsupported/motifshell
%dir /usr/X11R6/xmdemos/unsupported/transfer
%dir /usr/X11R6/xmdemos/unsupported/uilsymdump
%dir /usr/X11R6/xmdemos/unsupported/xmapdef
%dir /usr/X11R6/xmdemos/unsupported/xmfonts
%dir /usr/X11R6/xmdemos/unsupported/xmforc
%dir /usr/X11R6/xmdemos/unsupported/xmform
%dir /usr/X11R6/include/Mrm
%dir /usr/X11R6/include/Xm
%dir /usr/X11R6/include/uil
%dir /usr/X11R6/lib/X11/uid
%dir /usr/X11R6/lib/X11/uid/C
%dir /usr/X11R6/lib/X11/uid/C/uid
%dir /usr/X11R6/lib/X11/uid/english
%dir /usr/X11R6/lib/X11/uid/english/uid
%dir /usr/X11R6/lib/X11/uid/french
%dir /usr/X11R6/lib/X11/uid/french/uid
%dir /usr/X11R6/lib/X11/uid/hebrew
%dir /usr/X11R6/lib/X11/uid/hebrew/uid
%dir /usr/X11R6/lib/X11/uid/japanese
%dir /usr/X11R6/lib/X11/uid/japanese/uid
%dir /usr/X11R6/lib/X11/uid/swedish
%dir /usr/X11R6/lib/X11/uid/swedish/uid
%docdir /usr/doc/openmotif-devel-2.1.30
%docdir /usr/doc/openmotif-devel-2.1.30/mot-pg
%docdir /usr/doc/openmotif-devel-2.1.30/mot-ref
%doc /usr/doc/openmotif-devel-2.1.30/LICENSE
%doc /usr/doc/openmotif-devel-2.1.30/OpenMotifEverywhere.html
%doc /usr/doc/openmotif-devel-2.1.30/OpenMotifEverywhere.txt
%doc /usr/doc/openmotif-devel-2.1.30/README.devel
%doc /usr/doc/openmotif-devel-2.1.30/mot-cdesgr.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-csgcc.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-gloss.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-mcsg.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-wwg.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch01.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch02.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch03.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch04.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch05.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch06.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch07.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch08.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch09.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch10.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch11.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch12.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch13.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch14.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch15.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch16.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch17.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch18.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch19.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch20.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch21.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch22.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-pg/ch23.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch01.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch02.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch03.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch04.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch05.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch06.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch07.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch08.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch09.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch11.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch12.ps.Z
%doc /usr/doc/openmotif-devel-2.1.30/mot-ref/ch14.ps.Z
/usr/X11R6/lib/X11/app-defaults/Fileview
/usr/X11R6/lib/X11/app-defaults/XmdAirport
/usr/X11R6/lib/X11/app-defaults/XmdAnimate
/usr/X11R6/lib/X11/app-defaults/XmdDraw
/usr/X11R6/lib/X11/app-defaults/XmdFilemanager
/usr/X11R6/lib/X11/app-defaults/XmdI18nInput
/usr/X11R6/lib/X11/app-defaults/XmdPeriodic
/usr/X11R6/lib/X11/app-defaults/XmdSampler2_0
/usr/X11R6/lib/X11/app-defaults/XmdSetDate
/usr/X11R6/lib/X11/app-defaults/XmdTodo
/usr/X11R6/bin/DNDDemo
/usr/X11R6/bin/airport
/usr/X11R6/bin/xmanimate
/usr/X11R6/bin/autopopups
/usr/X11R6/bin/dainput
/usr/X11R6/bin/dogs
/usr/X11R6/bin/draw
/usr/X11R6/bin/earth
/usr/X11R6/bin/exm_in_c
/usr/X11R6/bin/exm_in_uil
/usr/X11R6/bin/filemanager
/usr/X11R6/bin/fileview
/usr/X11R6/bin/getsubres
/usr/X11R6/bin/helloint
/usr/X11R6/bin/hellomotif
/usr/X11R6/bin/help
/usr/X11R6/bin/i18ninput
/usr/X11R6/bin/membership
/usr/X11R6/bin/motif
/usr/X11R6/bin/motifshell
/usr/X11R6/bin/panner
/usr/X11R6/bin/periodic
/usr/X11R6/bin/piano
/usr/X11R6/bin/principles
/usr/X11R6/bin/research
/usr/X11R6/bin/sampler2_0
/usr/X11R6/bin/setDate
/usr/X11R6/bin/simpleDemo
/usr/X11R6/bin/simpledrop
/usr/X11R6/bin/todo
/usr/X11R6/bin/uil
/usr/X11R6/bin/uilsymdump
/usr/X11R6/bin/welcome
/usr/X11R6/bin/wsm
/usr/X11R6/bin/xmapdef
/usr/X11R6/bin/xmfonts
/usr/X11R6/bin/xmforc
/usr/X11R6/bin/xmform
%doc /usr/X11R6/man/man1/uil.1
%doc /usr/X11R6/man/man3/ApplicationShell.3
%doc /usr/X11R6/man/man3/Composite.3
%doc /usr/X11R6/man/man3/Constraint.3
%doc /usr/X11R6/man/man3/Core.3
%doc /usr/X11R6/man/man3/MrmCloseHierarchy.3
%doc /usr/X11R6/man/man3/MrmFetchBitmapLiteral.3
%doc /usr/X11R6/man/man3/MrmFetchColorLiteral.3
%doc /usr/X11R6/man/man3/MrmFetchIconLiteral.3
%doc /usr/X11R6/man/man3/MrmFetchLiteral.3
%doc /usr/X11R6/man/man3/MrmFetchSetValues.3
%doc /usr/X11R6/man/man3/MrmFetchWidget.3
%doc /usr/X11R6/man/man3/MrmFetchWidgetOverride.3
%doc /usr/X11R6/man/man3/MrmInitialize.3
%doc /usr/X11R6/man/man3/MrmOpenHierarchy.3
%doc /usr/X11R6/man/man3/MrmOpenHierarchyFromBuffer.3
%doc /usr/X11R6/man/man3/MrmOpenHierarchyPerDisplay.3
%doc /usr/X11R6/man/man3/MrmRegisterClass.3
%doc /usr/X11R6/man/man3/MrmRegisterNames.3
%doc /usr/X11R6/man/man3/MrmRegisterNamesInHierarchy.3
%doc /usr/X11R6/man/man3/Object.3
%doc /usr/X11R6/man/man3/OverrideShell.3
%doc /usr/X11R6/man/man3/RectObj.3
%doc /usr/X11R6/man/man3/Shell.3
%doc /usr/X11R6/man/man3/TopLevelShell.3
%doc /usr/X11R6/man/man3/TransientShell.3
%doc /usr/X11R6/man/man3/Uil.3
%doc /usr/X11R6/man/man3/UilDumpSymbolTable.3
%doc /usr/X11R6/man/man3/VendorShell.3
%doc /usr/X11R6/man/man3/VirtualBindings.3
%doc /usr/X11R6/man/man3/WMShell.3
%doc /usr/X11R6/man/man3/XmActivateProtocol.3
%doc /usr/X11R6/man/man3/XmActivateWMProtocol.3
%doc /usr/X11R6/man/man3/XmAddProtocolCallback.3
%doc /usr/X11R6/man/man3/XmAddProtocols.3
%doc /usr/X11R6/man/man3/XmAddTabGroup.3
%doc /usr/X11R6/man/man3/XmAddToPostFromList.3
%doc /usr/X11R6/man/man3/XmAddWMProtocolCallback.3
%doc /usr/X11R6/man/man3/XmAddWMProtocols.3
%doc /usr/X11R6/man/man3/XmArrowButton.3
%doc /usr/X11R6/man/man3/XmArrowButtonGadget.3
%doc /usr/X11R6/man/man3/XmBulletinBoard.3
%doc /usr/X11R6/man/man3/XmCascadeButton.3
%doc /usr/X11R6/man/man3/XmCascadeButtonGadget.3
%doc /usr/X11R6/man/man3/XmCascadeButtonGadgetHighlight.3
%doc /usr/X11R6/man/man3/XmCascadeButtonHighlight.3
%doc /usr/X11R6/man/man3/XmChangeColor.3
%doc /usr/X11R6/man/man3/XmClipboardCancelCopy.3
%doc /usr/X11R6/man/man3/XmClipboardCopy.3
%doc /usr/X11R6/man/man3/XmClipboardCopyByName.3
%doc /usr/X11R6/man/man3/XmClipboardEndCopy.3
%doc /usr/X11R6/man/man3/XmClipboardEndRetrieve.3
%doc /usr/X11R6/man/man3/XmClipboardInquireCount.3
%doc /usr/X11R6/man/man3/XmClipboardInquireFormat.3
%doc /usr/X11R6/man/man3/XmClipboardInquireLength.3
%doc /usr/X11R6/man/man3/XmClipboardInquirePendingItems.3
%doc /usr/X11R6/man/man3/XmClipboardLock.3
%doc /usr/X11R6/man/man3/XmClipboardRegisterFormat.3
%doc /usr/X11R6/man/man3/XmClipboardRetrieve.3
%doc /usr/X11R6/man/man3/XmClipboardStartCopy.3
%doc /usr/X11R6/man/man3/XmClipboardStartRetrieve.3
%doc /usr/X11R6/man/man3/XmClipboardUndoCopy.3
%doc /usr/X11R6/man/man3/XmClipboardUnlock.3
%doc /usr/X11R6/man/man3/XmClipboardWithdrawFormat.3
%doc /usr/X11R6/man/man3/XmComboBox.3
%doc /usr/X11R6/man/man3/XmComboBoxAddItem.3
%doc /usr/X11R6/man/man3/XmComboBoxDeletePos.3
%doc /usr/X11R6/man/man3/XmComboBoxSelectItem.3
%doc /usr/X11R6/man/man3/XmComboBoxSetItem.3
%doc /usr/X11R6/man/man3/XmComboBoxUpdate.3
%doc /usr/X11R6/man/man3/XmCommand.3
%doc /usr/X11R6/man/man3/XmCommandAppendValue.3
%doc /usr/X11R6/man/man3/XmCommandError.3
%doc /usr/X11R6/man/man3/XmCommandGetChild.3
%doc /usr/X11R6/man/man3/XmCommandSetValue.3
%doc /usr/X11R6/man/man3/XmContainer.3
%doc /usr/X11R6/man/man3/XmContainerCopy.3
%doc /usr/X11R6/man/man3/XmContainerCopyLink.3
%doc /usr/X11R6/man/man3/XmContainerCut.3
%doc /usr/X11R6/man/man3/XmContainerGetItemChildren.3
%doc /usr/X11R6/man/man3/XmContainerPaste.3
%doc /usr/X11R6/man/man3/XmContainerPasteLink.3
%doc /usr/X11R6/man/man3/XmContainerRelayout.3
%doc /usr/X11R6/man/man3/XmContainerReorder.3
%doc /usr/X11R6/man/man3/XmConvertStringToUnits.3
%doc /usr/X11R6/man/man3/XmConvertUnits.3
%doc /usr/X11R6/man/man3/XmCreateArrowButton.3
%doc /usr/X11R6/man/man3/XmCreateArrowButtonGadget.3
%doc /usr/X11R6/man/man3/XmCreateBulletinBoard.3
%doc /usr/X11R6/man/man3/XmCreateBulletinBoardDialog.3
%doc /usr/X11R6/man/man3/XmCreateCascadeButton.3
%doc /usr/X11R6/man/man3/XmCreateCascadeButtonGadget.3
%doc /usr/X11R6/man/man3/XmCreateComboBox.3
%doc /usr/X11R6/man/man3/XmCreateCommand.3
%doc /usr/X11R6/man/man3/XmCreateCommandDialog.3
%doc /usr/X11R6/man/man3/XmCreateContainer.3
%doc /usr/X11R6/man/man3/XmCreateDialogShell.3
%doc /usr/X11R6/man/man3/XmCreateDragIcon.3
%doc /usr/X11R6/man/man3/XmCreateDrawingArea.3
%doc /usr/X11R6/man/man3/XmCreateDrawnButton.3
%doc /usr/X11R6/man/man3/XmCreateDropDownComboBox.3
%doc /usr/X11R6/man/man3/XmCreateDropDownList.3
%doc /usr/X11R6/man/man3/XmCreateErrorDialog.3
%doc /usr/X11R6/man/man3/XmCreateFileSelectionBox.3
%doc /usr/X11R6/man/man3/XmCreateFileSelectionDialog.3
%doc /usr/X11R6/man/man3/XmCreateForm.3
%doc /usr/X11R6/man/man3/XmCreateFormDialog.3
%doc /usr/X11R6/man/man3/XmCreateFrame.3
%doc /usr/X11R6/man/man3/XmCreateIconGadget.3
%doc /usr/X11R6/man/man3/XmCreateInformationDialog.3
%doc /usr/X11R6/man/man3/XmCreateLabel.3
%doc /usr/X11R6/man/man3/XmCreateLabelGadget.3
%doc /usr/X11R6/man/man3/XmCreateList.3
%doc /usr/X11R6/man/man3/XmCreateMainWindow.3
%doc /usr/X11R6/man/man3/XmCreateMenuBar.3
%doc /usr/X11R6/man/man3/XmCreateMenuShell.3
%doc /usr/X11R6/man/man3/XmCreateMessageBox.3
%doc /usr/X11R6/man/man3/XmCreateMessageDialog.3
%doc /usr/X11R6/man/man3/XmCreateNotebook.3
%doc /usr/X11R6/man/man3/XmCreateOptionMenu.3
%doc /usr/X11R6/man/man3/XmCreatePanedWindow.3
%doc /usr/X11R6/man/man3/XmCreatePopupMenu.3
%doc /usr/X11R6/man/man3/XmCreatePromptDialog.3
%doc /usr/X11R6/man/man3/XmCreatePulldownMenu.3
%doc /usr/X11R6/man/man3/XmCreatePushButton.3
%doc /usr/X11R6/man/man3/XmCreatePushButtonGadget.3
%doc /usr/X11R6/man/man3/XmCreateQuestionDialog.3
%doc /usr/X11R6/man/man3/XmCreateRadioBox.3
%doc /usr/X11R6/man/man3/XmCreateRowColumn.3
%doc /usr/X11R6/man/man3/XmCreateScale.3
%doc /usr/X11R6/man/man3/XmCreateScrollBar.3
%doc /usr/X11R6/man/man3/XmCreateScrolledList.3
%doc /usr/X11R6/man/man3/XmCreateScrolledText.3
%doc /usr/X11R6/man/man3/XmCreateScrolledWindow.3
%doc /usr/X11R6/man/man3/XmCreateSelectionBox.3
%doc /usr/X11R6/man/man3/XmCreateSelectionDialog.3
%doc /usr/X11R6/man/man3/XmCreateSeparator.3
%doc /usr/X11R6/man/man3/XmCreateSeparatorGadget.3
%doc /usr/X11R6/man/man3/XmCreateSimpleCheckBox.3
%doc /usr/X11R6/man/man3/XmCreateSimpleMenuBar.3
%doc /usr/X11R6/man/man3/XmCreateSimpleOptionMenu.3
%doc /usr/X11R6/man/man3/XmCreateSimplePopupMenu.3
%doc /usr/X11R6/man/man3/XmCreateSimplePulldownMenu.3
%doc /usr/X11R6/man/man3/XmCreateSimpleRadioBox.3
%doc /usr/X11R6/man/man3/XmCreateSimpleSpinBox.3
%doc /usr/X11R6/man/man3/XmCreateSpinBox.3
%doc /usr/X11R6/man/man3/XmCreateTemplateDialog.3
%doc /usr/X11R6/man/man3/XmCreateText.3
%doc /usr/X11R6/man/man3/XmCreateTextField.3
%doc /usr/X11R6/man/man3/XmCreateToggleButton.3
%doc /usr/X11R6/man/man3/XmCreateToggleButtonGadget.3
%doc /usr/X11R6/man/man3/XmCreateWarningDialog.3
%doc /usr/X11R6/man/man3/XmCreateWorkArea.3
%doc /usr/X11R6/man/man3/XmCreateWorkingDialog.3
%doc /usr/X11R6/man/man3/XmCvtByteStreamToXmString.3
%doc /usr/X11R6/man/man3/XmCvtCTToXmString.3
%doc /usr/X11R6/man/man3/XmCvtStringToUnitType.3
%doc /usr/X11R6/man/man3/XmCvtTextPropertyToXmStringTable.3
%doc /usr/X11R6/man/man3/XmCvtXmStringTableToTextProperty.3
%doc /usr/X11R6/man/man3/XmCvtXmStringToByteStream.3
%doc /usr/X11R6/man/man3/XmCvtXmStringToCT.3
%doc /usr/X11R6/man/man3/XmDeactivateProtocol.3
%doc /usr/X11R6/man/man3/XmDeactivateWMProtocol.3
%doc /usr/X11R6/man/man3/XmDestroyPixmap.3
%doc /usr/X11R6/man/man3/XmDialogShell.3
%doc /usr/X11R6/man/man3/XmDirection.3
%doc /usr/X11R6/man/man3/XmDirectionMatch.3
%doc /usr/X11R6/man/man3/XmDirectionMatchPartial.3
%doc /usr/X11R6/man/man3/XmDirectionToStringDirection.3
%doc /usr/X11R6/man/man3/XmDisplay.3
%doc /usr/X11R6/man/man3/XmDragCancel.3
%doc /usr/X11R6/man/man3/XmDragContext.3
%doc /usr/X11R6/man/man3/XmDragIcon.3
%doc /usr/X11R6/man/man3/XmDragStart.3
%doc /usr/X11R6/man/man3/XmDrawingArea.3
%doc /usr/X11R6/man/man3/XmDrawnButton.3
%doc /usr/X11R6/man/man3/XmDropSite.3
%doc /usr/X11R6/man/man3/XmDropSiteConfigureStackingOrder.3
%doc /usr/X11R6/man/man3/XmDropSiteEndUpdate.3
%doc /usr/X11R6/man/man3/XmDropSiteQueryStackingOrder.3
%doc /usr/X11R6/man/man3/XmDropSiteRegister.3
%doc /usr/X11R6/man/man3/XmDropSiteRegistered.3
%doc /usr/X11R6/man/man3/XmDropSiteRetrieve.3
%doc /usr/X11R6/man/man3/XmDropSiteStartUpdate.3
%doc /usr/X11R6/man/man3/XmDropSiteUnregister.3
%doc /usr/X11R6/man/man3/XmDropSiteUpdate.3
%doc /usr/X11R6/man/man3/XmDropTransfer.3
%doc /usr/X11R6/man/man3/XmDropTransferAdd.3
%doc /usr/X11R6/man/man3/XmDropTransferStart.3
%doc /usr/X11R6/man/man3/XmFileSelectionBox.3
%doc /usr/X11R6/man/man3/XmFileSelectionBoxGetChild.3
%doc /usr/X11R6/man/man3/XmFileSelectionDoSearch.3
%doc /usr/X11R6/man/man3/XmFontList.3
%doc /usr/X11R6/man/man3/XmFontListAdd.3
%doc /usr/X11R6/man/man3/XmFontListAppendEntry.3
%doc /usr/X11R6/man/man3/XmFontListCopy.3
%doc /usr/X11R6/man/man3/XmFontListCreate.3
%doc /usr/X11R6/man/man3/XmFontListEntryCreate.3
%doc /usr/X11R6/man/man3/XmFontListEntryFree.3
%doc /usr/X11R6/man/man3/XmFontListEntryGetFont.3
%doc /usr/X11R6/man/man3/XmFontListEntryGetTag.3
%doc /usr/X11R6/man/man3/XmFontListEntryLoad.3
%doc /usr/X11R6/man/man3/XmFontListFree.3
%doc /usr/X11R6/man/man3/XmFontListFreeFontContext.3
%doc /usr/X11R6/man/man3/XmFontListGetNextFont.3
%doc /usr/X11R6/man/man3/XmFontListInitFontContext.3
%doc /usr/X11R6/man/man3/XmFontListNextEntry.3
%doc /usr/X11R6/man/man3/XmFontListRemoveEntry.3
%doc /usr/X11R6/man/man3/XmForm.3
%doc /usr/X11R6/man/man3/XmFrame.3
%doc /usr/X11R6/man/man3/XmGadget.3
%doc /usr/X11R6/man/man3/XmGetAtomName.3
%doc /usr/X11R6/man/man3/XmGetColorCalculation.3
%doc /usr/X11R6/man/man3/XmGetColors.3
%doc /usr/X11R6/man/man3/XmGetDestination.3
%doc /usr/X11R6/man/man3/XmGetDragContext.3
%doc /usr/X11R6/man/man3/XmGetFocusWidget.3
%doc /usr/X11R6/man/man3/XmGetMenuCursor.3
%doc /usr/X11R6/man/man3/XmGetPixmap.3
%doc /usr/X11R6/man/man3/XmGetPixmapByDepth.3
%doc /usr/X11R6/man/man3/XmGetPostedFromWidget.3
%doc /usr/X11R6/man/man3/XmGetScaledPixmap.3
%doc /usr/X11R6/man/man3/XmGetSecondaryResourceData.3
%doc /usr/X11R6/man/man3/XmGetTabGroup.3
%doc /usr/X11R6/man/man3/XmGetTearOffControl.3
%doc /usr/X11R6/man/man3/XmGetVisibility.3
%doc /usr/X11R6/man/man3/XmGetXmDisplay.3
%doc /usr/X11R6/man/man3/XmGetXmScreen.3
%doc /usr/X11R6/man/man3/XmIconGadget.3
%doc /usr/X11R6/man/man3/XmImCloseXIM.3
%doc /usr/X11R6/man/man3/XmImFreeXIC.3
%doc /usr/X11R6/man/man3/XmImGetXIC.3
%doc /usr/X11R6/man/man3/XmImGetXIM.3
%doc /usr/X11R6/man/man3/XmImMbLookupString.3
%doc /usr/X11R6/man/man3/XmImMbResetIC.3
%doc /usr/X11R6/man/man3/XmImRegister.3
%doc /usr/X11R6/man/man3/XmImSetFocusValues.3
%doc /usr/X11R6/man/man3/XmImSetValues.3
%doc /usr/X11R6/man/man3/XmImSetXIC.3
%doc /usr/X11R6/man/man3/XmImUnregister.3
%doc /usr/X11R6/man/man3/XmImUnsetFocus.3
%doc /usr/X11R6/man/man3/XmImVaSetFocusValues.3
%doc /usr/X11R6/man/man3/XmImVaSetValues.3
%doc /usr/X11R6/man/man3/XmInstallImage.3
%doc /usr/X11R6/man/man3/XmInternAtom.3
%doc /usr/X11R6/man/man3/XmIsMotifWMRunning.3
%doc /usr/X11R6/man/man3/XmIsTraversable.3
%doc /usr/X11R6/man/man3/XmLabel.3
%doc /usr/X11R6/man/man3/XmLabelGadget.3
%doc /usr/X11R6/man/man3/XmList.3
%doc /usr/X11R6/man/man3/XmListAddItem.3
%doc /usr/X11R6/man/man3/XmListAddItemUnselected.3
%doc /usr/X11R6/man/man3/XmListAddItems.3
%doc /usr/X11R6/man/man3/XmListAddItemsUnselected.3
%doc /usr/X11R6/man/man3/XmListDeleteAllItems.3
%doc /usr/X11R6/man/man3/XmListDeleteItem.3
%doc /usr/X11R6/man/man3/XmListDeleteItems.3
%doc /usr/X11R6/man/man3/XmListDeleteItemsPos.3
%doc /usr/X11R6/man/man3/XmListDeletePos.3
%doc /usr/X11R6/man/man3/XmListDeletePositions.3
%doc /usr/X11R6/man/man3/XmListDeselectAllItems.3
%doc /usr/X11R6/man/man3/XmListDeselectItem.3
%doc /usr/X11R6/man/man3/XmListDeselectPos.3
%doc /usr/X11R6/man/man3/XmListGetKbdItemPos.3
%doc /usr/X11R6/man/man3/XmListGetMatchPos.3
%doc /usr/X11R6/man/man3/XmListGetSelectedPos.3
%doc /usr/X11R6/man/man3/XmListItemExists.3
%doc /usr/X11R6/man/man3/XmListItemPos.3
%doc /usr/X11R6/man/man3/XmListPosSelected.3
%doc /usr/X11R6/man/man3/XmListPosToBounds.3
%doc /usr/X11R6/man/man3/XmListReplaceItems.3
%doc /usr/X11R6/man/man3/XmListReplaceItemsPos.3
%doc /usr/X11R6/man/man3/XmListReplaceItemsPosUnselected.3
%doc /usr/X11R6/man/man3/XmListReplaceItemsUnselected.3
%doc /usr/X11R6/man/man3/XmListReplacePositions.3
%doc /usr/X11R6/man/man3/XmListSelectItem.3
%doc /usr/X11R6/man/man3/XmListSelectPos.3
%doc /usr/X11R6/man/man3/XmListSetAddMode.3
%doc /usr/X11R6/man/man3/XmListSetBottomItem.3
%doc /usr/X11R6/man/man3/XmListSetBottomPos.3
%doc /usr/X11R6/man/man3/XmListSetHorizPos.3
%doc /usr/X11R6/man/man3/XmListSetItem.3
%doc /usr/X11R6/man/man3/XmListSetKbdItemPos.3
%doc /usr/X11R6/man/man3/XmListSetPos.3
%doc /usr/X11R6/man/man3/XmListUpdateSelectedList.3
%doc /usr/X11R6/man/man3/XmListYToPos.3
%doc /usr/X11R6/man/man3/XmMainWindow.3
%doc /usr/X11R6/man/man3/XmMainWindowSep1.3
%doc /usr/X11R6/man/man3/XmMainWindowSep2.3
%doc /usr/X11R6/man/man3/XmMainWindowSep3.3
%doc /usr/X11R6/man/man3/XmMainWindowSetAreas.3
%doc /usr/X11R6/man/man3/XmManager.3
%doc /usr/X11R6/man/man3/XmMapSegmentEncoding.3
%doc /usr/X11R6/man/man3/XmMenuPosition.3
%doc /usr/X11R6/man/man3/XmMenuShell.3
%doc /usr/X11R6/man/man3/XmMessageBox.3
%doc /usr/X11R6/man/man3/XmMessageBoxGetChild.3
%doc /usr/X11R6/man/man3/XmNotebook.3
%doc /usr/X11R6/man/man3/XmNotebookGetPageInfo.3
%doc /usr/X11R6/man/man3/XmObjectAtPoint.3
%doc /usr/X11R6/man/man3/XmOptionButtonGadget.3
%doc /usr/X11R6/man/man3/XmOptionLabelGadget.3
%doc /usr/X11R6/man/man3/XmPanedWindow.3
%doc /usr/X11R6/man/man3/XmParseMapping.3
%doc /usr/X11R6/man/man3/XmParseMappingCreate.3
%doc /usr/X11R6/man/man3/XmParseMappingFree.3
%doc /usr/X11R6/man/man3/XmParseMappingGetValues.3
%doc /usr/X11R6/man/man3/XmParseMappingSetValues.3
%doc /usr/X11R6/man/man3/XmParseTable.3
%doc /usr/X11R6/man/man3/XmParseTableFree.3
%doc /usr/X11R6/man/man3/XmPrimitive.3
%doc /usr/X11R6/man/man3/XmPrintPopupPDM.3
%doc /usr/X11R6/man/man3/XmPrintSetup.3
%doc /usr/X11R6/man/man3/XmPrintShell.3
%doc /usr/X11R6/man/man3/XmPrintToFile.3
%doc /usr/X11R6/man/man3/XmProcessTraversal.3
%doc /usr/X11R6/man/man3/XmPushButton.3
%doc /usr/X11R6/man/man3/XmPushButtonGadget.3
%doc /usr/X11R6/man/man3/XmRedisplayWidget.3
%doc /usr/X11R6/man/man3/XmRegisterSegmentEncoding.3
%doc /usr/X11R6/man/man3/XmRemoveFromPostFromList.3
%doc /usr/X11R6/man/man3/XmRemoveProtocolCallback.3
%doc /usr/X11R6/man/man3/XmRemoveProtocols.3
%doc /usr/X11R6/man/man3/XmRemoveTabGroup.3
%doc /usr/X11R6/man/man3/XmRemoveWMProtocolCallback.3
%doc /usr/X11R6/man/man3/XmRemoveWMProtocols.3
%doc /usr/X11R6/man/man3/XmRenderTable.3
%doc /usr/X11R6/man/man3/XmRenderTableAddRenditions.3
%doc /usr/X11R6/man/man3/XmRenderTableCopy.3
%doc /usr/X11R6/man/man3/XmRenderTableCvtFromProp.3
%doc /usr/X11R6/man/man3/XmRenderTableCvtToProp.3
%doc /usr/X11R6/man/man3/XmRenderTableFree.3
%doc /usr/X11R6/man/man3/XmRenderTableGetRendition.3
%doc /usr/X11R6/man/man3/XmRenderTableGetRenditions.3
%doc /usr/X11R6/man/man3/XmRenderTableGetTags.3
%doc /usr/X11R6/man/man3/XmRenderTableRemoveRenditions.3
%doc /usr/X11R6/man/man3/XmRendition.3
%doc /usr/X11R6/man/man3/XmRenditionCreate.3
%doc /usr/X11R6/man/man3/XmRenditionFree.3
%doc /usr/X11R6/man/man3/XmRenditionRetrieve.3
%doc /usr/X11R6/man/man3/XmRenditionUpdate.3
%doc /usr/X11R6/man/man3/XmRepTypeAddReverse.3
%doc /usr/X11R6/man/man3/XmRepTypeGetId.3
%doc /usr/X11R6/man/man3/XmRepTypeGetNameList.3
%doc /usr/X11R6/man/man3/XmRepTypeGetRecord.3
%doc /usr/X11R6/man/man3/XmRepTypeGetRegistered.3
%doc /usr/X11R6/man/man3/XmRepTypeInstallTearOffModelConverter.3
%doc /usr/X11R6/man/man3/XmRepTypeRegister.3
%doc /usr/X11R6/man/man3/XmRepTypeValidValue.3
%doc /usr/X11R6/man/man3/XmResolveAllPartOffsets.3
%doc /usr/X11R6/man/man3/XmResolvePartOffsets.3
%doc /usr/X11R6/man/man3/XmRowColumn.3
%doc /usr/X11R6/man/man3/XmScale.3
%doc /usr/X11R6/man/man3/XmScaleGetValue.3
%doc /usr/X11R6/man/man3/XmScaleSetTicks.3
%doc /usr/X11R6/man/man3/XmScaleSetValue.3
%doc /usr/X11R6/man/man3/XmScreen.3
%doc /usr/X11R6/man/man3/XmScrollBar.3
%doc /usr/X11R6/man/man3/XmScrollBarGetValues.3
%doc /usr/X11R6/man/man3/XmScrollBarSetValues.3
%doc /usr/X11R6/man/man3/XmScrollVisible.3
%doc /usr/X11R6/man/man3/XmScrolledWindow.3
%doc /usr/X11R6/man/man3/XmScrolledWindowSetAreas.3
%doc /usr/X11R6/man/man3/XmSelectionBox.3
%doc /usr/X11R6/man/man3/XmSelectionBoxGetChild.3
%doc /usr/X11R6/man/man3/XmSeparator.3
%doc /usr/X11R6/man/man3/XmSeparatorGadget.3
%doc /usr/X11R6/man/man3/XmSetColorCalculation.3
%doc /usr/X11R6/man/man3/XmSetFontUnit.3
%doc /usr/X11R6/man/man3/XmSetFontUnits.3
%doc /usr/X11R6/man/man3/XmSetMenuCursor.3
%doc /usr/X11R6/man/man3/XmSetProtocolHooks.3
%doc /usr/X11R6/man/man3/XmSetWMProtocolHooks.3
%doc /usr/X11R6/man/man3/XmSimpleSpinBox.3
%doc /usr/X11R6/man/man3/XmSimpleSpinBoxAddItem.3
%doc /usr/X11R6/man/man3/XmSimpleSpinBoxDeletePos.3
%doc /usr/X11R6/man/man3/XmSimpleSpinBoxSetItem.3
%doc /usr/X11R6/man/man3/XmSpinBox.3
%doc /usr/X11R6/man/man3/XmSpinBoxValidatePosition.3
%doc /usr/X11R6/man/man3/XmString.3
%doc /usr/X11R6/man/man3/XmStringBaseline.3
%doc /usr/X11R6/man/man3/XmStringByteCompare.3
%doc /usr/X11R6/man/man3/XmStringByteStreamLength.3
%doc /usr/X11R6/man/man3/XmStringCompare.3
%doc /usr/X11R6/man/man3/XmStringComponentCreate.3
%doc /usr/X11R6/man/man3/XmStringComponentType.3
%doc /usr/X11R6/man/man3/XmStringConcat.3
%doc /usr/X11R6/man/man3/XmStringConcatAndFree.3
%doc /usr/X11R6/man/man3/XmStringCopy.3
%doc /usr/X11R6/man/man3/XmStringCreate.3
%doc /usr/X11R6/man/man3/XmStringCreateLocalized.3
%doc /usr/X11R6/man/man3/XmStringCreateLtoR.3
%doc /usr/X11R6/man/man3/XmStringCreateSimple.3
%doc /usr/X11R6/man/man3/XmStringDirection.3
%doc /usr/X11R6/man/man3/XmStringDirectionCreate.3
%doc /usr/X11R6/man/man3/XmStringDirectionToDirection.3
%doc /usr/X11R6/man/man3/XmStringDraw.3
%doc /usr/X11R6/man/man3/XmStringDrawImage.3
%doc /usr/X11R6/man/man3/XmStringDrawUnderline.3
%doc /usr/X11R6/man/man3/XmStringEmpty.3
%doc /usr/X11R6/man/man3/XmStringExtent.3
%doc /usr/X11R6/man/man3/XmStringFree.3
%doc /usr/X11R6/man/man3/XmStringFreeContext.3
%doc /usr/X11R6/man/man3/XmStringGenerate.3
%doc /usr/X11R6/man/man3/XmStringGetLtoR.3
%doc /usr/X11R6/man/man3/XmStringGetNextComponent.3
%doc /usr/X11R6/man/man3/XmStringGetNextSegment.3
%doc /usr/X11R6/man/man3/XmStringGetNextTriple.3
%doc /usr/X11R6/man/man3/XmStringHasSubstring.3
%doc /usr/X11R6/man/man3/XmStringHeight.3
%doc /usr/X11R6/man/man3/XmStringInitContext.3
%doc /usr/X11R6/man/man3/XmStringIsVoid.3
%doc /usr/X11R6/man/man3/XmStringLength.3
%doc /usr/X11R6/man/man3/XmStringLineCount.3
%doc /usr/X11R6/man/man3/XmStringNConcat.3
%doc /usr/X11R6/man/man3/XmStringNCopy.3
%doc /usr/X11R6/man/man3/XmStringParseText.3
%doc /usr/X11R6/man/man3/XmStringPeekNextComponent.3
%doc /usr/X11R6/man/man3/XmStringPeekNextTriple.3
%doc /usr/X11R6/man/man3/XmStringPutRendition.3
%doc /usr/X11R6/man/man3/XmStringSegmentCreate.3
%doc /usr/X11R6/man/man3/XmStringSeparatorCreate.3
%doc /usr/X11R6/man/man3/XmStringTable.3
%doc /usr/X11R6/man/man3/XmStringTableParseStringArray.3
%doc /usr/X11R6/man/man3/XmStringTableProposeTablist.3
%doc /usr/X11R6/man/man3/XmStringTableToXmString.3
%doc /usr/X11R6/man/man3/XmStringTableUnparse.3
%doc /usr/X11R6/man/man3/XmStringToXmStringTable.3
%doc /usr/X11R6/man/man3/XmStringUnparse.3
%doc /usr/X11R6/man/man3/XmStringWidth.3
%doc /usr/X11R6/man/man3/XmTab.3
%doc /usr/X11R6/man/man3/XmTabCreate.3
%doc /usr/X11R6/man/man3/XmTabFree.3
%doc /usr/X11R6/man/man3/XmTabGetValues.3
%doc /usr/X11R6/man/man3/XmTabList.3
%doc /usr/X11R6/man/man3/XmTabListCopy.3
%doc /usr/X11R6/man/man3/XmTabListFree.3
%doc /usr/X11R6/man/man3/XmTabListGetTab.3
%doc /usr/X11R6/man/man3/XmTabListInsertTabs.3
%doc /usr/X11R6/man/man3/XmTabListRemoveTabs.3
%doc /usr/X11R6/man/man3/XmTabListReplacePositions.3
%doc /usr/X11R6/man/man3/XmTabListTabCount.3
%doc /usr/X11R6/man/man3/XmTabSetValue.3
%doc /usr/X11R6/man/man3/XmTargetsAreCompatible.3
%doc /usr/X11R6/man/man3/XmText.3
%doc /usr/X11R6/man/man3/XmTextClearSelection.3
%doc /usr/X11R6/man/man3/XmTextCopy.3
%doc /usr/X11R6/man/man3/XmTextCopyLink.3
%doc /usr/X11R6/man/man3/XmTextCut.3
%doc /usr/X11R6/man/man3/XmTextDisableRedisplay.3
%doc /usr/X11R6/man/man3/XmTextEnableRedisplay.3
%doc /usr/X11R6/man/man3/XmTextField.3
%doc /usr/X11R6/man/man3/XmTextFieldClearSelection.3
%doc /usr/X11R6/man/man3/XmTextFieldCopy.3
%doc /usr/X11R6/man/man3/XmTextFieldCopyLink.3
%doc /usr/X11R6/man/man3/XmTextFieldCut.3
%doc /usr/X11R6/man/man3/XmTextFieldGetBaseline.3
%doc /usr/X11R6/man/man3/XmTextFieldGetEditable.3
%doc /usr/X11R6/man/man3/XmTextFieldGetInsertionPosition.3
%doc /usr/X11R6/man/man3/XmTextFieldGetLastPosition.3
%doc /usr/X11R6/man/man3/XmTextFieldGetMaxLength.3
%doc /usr/X11R6/man/man3/XmTextFieldGetSelection.3
%doc /usr/X11R6/man/man3/XmTextFieldGetSelectionPosition.3
%doc /usr/X11R6/man/man3/XmTextFieldGetSelectionWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldGetString.3
%doc /usr/X11R6/man/man3/XmTextFieldGetStringWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldGetSubstring.3
%doc /usr/X11R6/man/man3/XmTextFieldGetSubstringWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldInsert.3
%doc /usr/X11R6/man/man3/XmTextFieldInsertWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldPaste.3
%doc /usr/X11R6/man/man3/XmTextFieldPasteLink.3
%doc /usr/X11R6/man/man3/XmTextFieldPosToXY.3
%doc /usr/X11R6/man/man3/XmTextFieldRemove.3
%doc /usr/X11R6/man/man3/XmTextFieldReplace.3
%doc /usr/X11R6/man/man3/XmTextFieldReplaceWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldSetAddMode.3
%doc /usr/X11R6/man/man3/XmTextFieldSetEditable.3
%doc /usr/X11R6/man/man3/XmTextFieldSetHighlight.3
%doc /usr/X11R6/man/man3/XmTextFieldSetInsertionPosition.3
%doc /usr/X11R6/man/man3/XmTextFieldSetMaxLength.3
%doc /usr/X11R6/man/man3/XmTextFieldSetSelection.3
%doc /usr/X11R6/man/man3/XmTextFieldSetString.3
%doc /usr/X11R6/man/man3/XmTextFieldSetStringWcs.3
%doc /usr/X11R6/man/man3/XmTextFieldShowPosition.3
%doc /usr/X11R6/man/man3/XmTextFieldXYToPos.3
%doc /usr/X11R6/man/man3/XmTextFindString.3
%doc /usr/X11R6/man/man3/XmTextFindStringWcs.3
%doc /usr/X11R6/man/man3/XmTextGetBaseline.3
%doc /usr/X11R6/man/man3/XmTextGetCenterline.3
%doc /usr/X11R6/man/man3/XmTextGetEditable.3
%doc /usr/X11R6/man/man3/XmTextGetInsertionPosition.3
%doc /usr/X11R6/man/man3/XmTextGetLastPosition.3
%doc /usr/X11R6/man/man3/XmTextGetMaxLength.3
%doc /usr/X11R6/man/man3/XmTextGetSelection.3
%doc /usr/X11R6/man/man3/XmTextGetSelectionPosition.3
%doc /usr/X11R6/man/man3/XmTextGetSelectionWcs.3
%doc /usr/X11R6/man/man3/XmTextGetSource.3
%doc /usr/X11R6/man/man3/XmTextGetString.3
%doc /usr/X11R6/man/man3/XmTextGetStringWcs.3
%doc /usr/X11R6/man/man3/XmTextGetSubstring.3
%doc /usr/X11R6/man/man3/XmTextGetSubstringWcs.3
%doc /usr/X11R6/man/man3/XmTextGetTopCharacter.3
%doc /usr/X11R6/man/man3/XmTextInsert.3
%doc /usr/X11R6/man/man3/XmTextInsertWcs.3
%doc /usr/X11R6/man/man3/XmTextPaste.3
%doc /usr/X11R6/man/man3/XmTextPasteLink.3
%doc /usr/X11R6/man/man3/XmTextPosToXY.3
%doc /usr/X11R6/man/man3/XmTextPosition.3
%doc /usr/X11R6/man/man3/XmTextRemove.3
%doc /usr/X11R6/man/man3/XmTextReplace.3
%doc /usr/X11R6/man/man3/XmTextReplaceWcs.3
%doc /usr/X11R6/man/man3/XmTextScroll.3
%doc /usr/X11R6/man/man3/XmTextSetAddMode.3
%doc /usr/X11R6/man/man3/XmTextSetEditable.3
%doc /usr/X11R6/man/man3/XmTextSetHighlight.3
%doc /usr/X11R6/man/man3/XmTextSetInsertionPosition.3
%doc /usr/X11R6/man/man3/XmTextSetMaxLength.3
%doc /usr/X11R6/man/man3/XmTextSetSelection.3
%doc /usr/X11R6/man/man3/XmTextSetSource.3
%doc /usr/X11R6/man/man3/XmTextSetString.3
%doc /usr/X11R6/man/man3/XmTextSetStringWcs.3
%doc /usr/X11R6/man/man3/XmTextSetTopCharacter.3
%doc /usr/X11R6/man/man3/XmTextShowPosition.3
%doc /usr/X11R6/man/man3/XmTextXYToPos.3
%doc /usr/X11R6/man/man3/XmToggleButton.3
%doc /usr/X11R6/man/man3/XmToggleButtonGadget.3
%doc /usr/X11R6/man/man3/XmToggleButtonGadgetGetState.3
%doc /usr/X11R6/man/man3/XmToggleButtonGadgetSetState.3
%doc /usr/X11R6/man/man3/XmToggleButtonGetState.3
%doc /usr/X11R6/man/man3/XmToggleButtonSetState.3
%doc /usr/X11R6/man/man3/XmToggleButtonSetValue.3
%doc /usr/X11R6/man/man3/XmTrackingEvent.3
%doc /usr/X11R6/man/man3/XmTrackingLocate.3
%doc /usr/X11R6/man/man3/XmTransferDone.3
%doc /usr/X11R6/man/man3/XmTransferSendRequest.3
%doc /usr/X11R6/man/man3/XmTransferSetParameters.3
%doc /usr/X11R6/man/man3/XmTransferStartRequest.3
%doc /usr/X11R6/man/man3/XmTransferValue.3
%doc /usr/X11R6/man/man3/XmTranslateKey.3
%doc /usr/X11R6/man/man3/XmUninstallImage.3
%doc /usr/X11R6/man/man3/XmUpdateDisplay.3
%doc /usr/X11R6/man/man3/XmVaCreateSimpleCheckBox.3
%doc /usr/X11R6/man/man3/XmVaCreateSimpleMenuBar.3
%doc /usr/X11R6/man/man3/XmVaCreateSimpleOptionMenu.3
%doc /usr/X11R6/man/man3/XmVaCreateSimplePopupMenu.3
%doc /usr/X11R6/man/man3/XmVaCreateSimplePulldownMenu.3
%doc /usr/X11R6/man/man3/XmVaCreateSimpleRadioBox.3
%doc /usr/X11R6/man/man3/XmWidgetGetBaselines.3
%doc /usr/X11R6/man/man3/XmWidgetGetDisplayRect.3
%doc /usr/X11R6/man/man5/Traits.5
%doc /usr/X11R6/man/man5/UIL.5
%doc /usr/X11R6/man/man5/WML.5
/usr/X11R6/xmdemos/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch05/Scale/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch05/Scale/README
/usr/X11R6/xmdemos/doc/programGuide/ch05/Scale/interface.c
/usr/X11R6/xmdemos/doc/programGuide/ch05/Scale/tic_mark.c
/usr/X11R6/xmdemos/doc/programGuide/ch05/Scale/tic_mark.man
/usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box/README
/usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box/combo_box.c
/usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box/combo_box.man
/usr/X11R6/xmdemos/doc/programGuide/ch06/combo_box/interface.c
/usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box/README
/usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box/interface.c
/usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box/spin_box.c
/usr/X11R6/xmdemos/doc/programGuide/ch06/spin_box/spin_box.man
/usr/X11R6/xmdemos/doc/programGuide/ch08/Container/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch08/Container/README
/usr/X11R6/xmdemos/doc/programGuide/ch08/Container/container.c
/usr/X11R6/xmdemos/doc/programGuide/ch08/Container/container.man
/usr/X11R6/xmdemos/doc/programGuide/ch08/Container/interface.c
/usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook/README
/usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook/interface.c
/usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook/notebook.c
/usr/X11R6/xmdemos/doc/programGuide/ch08/Notebook/notebook.man
/usr/X11R6/xmdemos/doc/programGuide/ch16/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch16/README
/usr/X11R6/xmdemos/doc/programGuide/ch16/UTMXmText.c
/usr/X11R6/xmdemos/doc/programGuide/ch16/UTMXmText.man
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drag/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drag/README
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drag/simple_drag.c
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drag/simple_drag.man
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drop/Imakefile
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drop/README
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drop/simple_drop.c
/usr/X11R6/xmdemos/doc/programGuide/ch17/simple_drop/simple_drop.man
/usr/X11R6/xmdemos/lib/Exm/CommandB.c
/usr/X11R6/xmdemos/lib/Exm/CommandB.h
/usr/X11R6/xmdemos/lib/Exm/CommandBP.h
/usr/X11R6/xmdemos/lib/Exm/ExmMrm.c
/usr/X11R6/xmdemos/lib/Exm/ExmMrm.h
/usr/X11R6/xmdemos/lib/Exm/Grid.c
/usr/X11R6/xmdemos/lib/Exm/Grid.h
/usr/X11R6/xmdemos/lib/Exm/GridP.h
/usr/X11R6/xmdemos/lib/Exm/Imakefile
/usr/X11R6/xmdemos/lib/Exm/MenuB.c
/usr/X11R6/xmdemos/lib/Exm/MenuB.h
/usr/X11R6/xmdemos/lib/Exm/MenuBP.h
/usr/X11R6/xmdemos/lib/Exm/Panner.c
/usr/X11R6/xmdemos/lib/Exm/Panner.h
/usr/X11R6/xmdemos/lib/Exm/PannerP.h
/usr/X11R6/xmdemos/lib/Exm/README
/usr/X11R6/xmdemos/lib/Exm/Simple.c
/usr/X11R6/xmdemos/lib/Exm/Simple.h
/usr/X11R6/xmdemos/lib/Exm/SimpleP.h
/usr/X11R6/xmdemos/lib/Exm/String.c
/usr/X11R6/xmdemos/lib/Exm/String.h
/usr/X11R6/xmdemos/lib/Exm/StringP.h
/usr/X11R6/xmdemos/lib/Exm/StringTrans.c
/usr/X11R6/xmdemos/lib/Exm/StringTrans.h
/usr/X11R6/xmdemos/lib/Exm/StringTransP.h
/usr/X11R6/xmdemos/lib/Exm/TabB.c
/usr/X11R6/xmdemos/lib/Exm/TabB.h
/usr/X11R6/xmdemos/lib/Exm/TabBP.h
/usr/X11R6/xmdemos/lib/Exm/wml/Exm.wml
/usr/X11R6/xmdemos/lib/Exm/wml/Imakefile
/usr/X11R6/xmdemos/lib/Exm/wml/README
/usr/X11R6/xmdemos/lib/Exm/wml/wmldbcreate.c
/usr/X11R6/xmdemos/lib/ExmCxx/CxxCommand.cxx
/usr/X11R6/xmdemos/lib/ExmCxx/CxxCommand.h
/usr/X11R6/xmdemos/lib/ExmCxx/CxxGrid.cxx
/usr/X11R6/xmdemos/lib/ExmCxx/CxxGrid.h
/usr/X11R6/xmdemos/lib/ExmCxx/CxxSimple.cxx
/usr/X11R6/xmdemos/lib/ExmCxx/CxxSimple.h
/usr/X11R6/xmdemos/lib/ExmCxx/CxxSimpleDemo.cxx
/usr/X11R6/xmdemos/lib/ExmCxx/CxxString.cxx
/usr/X11R6/xmdemos/lib/ExmCxx/CxxString.h
/usr/X11R6/xmdemos/lib/ExmCxx/Imakefile
/usr/X11R6/xmdemos/lib/Imakefile
/usr/X11R6/xmdemos/lib/Wsm/Imakefile
/usr/X11R6/xmdemos/lib/Wsm/debug.c
/usr/X11R6/xmdemos/lib/Wsm/disp.c
/usr/X11R6/xmdemos/lib/Wsm/free.c
/usr/X11R6/xmdemos/lib/Wsm/pack.c
/usr/X11R6/xmdemos/lib/Wsm/recv.c
/usr/X11R6/xmdemos/lib/Wsm/send.c
/usr/X11R6/xmdemos/lib/Wsm/util.c
/usr/X11R6/xmdemos/lib/Wsm/utm_send.c
/usr/X11R6/xmdemos/lib/Wsm/utm_send.h
/usr/X11R6/xmdemos/lib/Wsm/wsm_funcs.h
/usr/X11R6/xmdemos/lib/Wsm/wsm_proto.h
/usr/X11R6/xmdemos/lib/XmCxx/CxxManager.cxx
/usr/X11R6/xmdemos/lib/XmCxx/CxxManager.h
/usr/X11R6/xmdemos/lib/XmCxx/CxxPrimiti.cxx
/usr/X11R6/xmdemos/lib/XmCxx/CxxPrimiti.h
/usr/X11R6/xmdemos/lib/XmCxx/CxxXmString.cxx
/usr/X11R6/xmdemos/lib/XmCxx/CxxXmString.h
/usr/X11R6/xmdemos/lib/XmCxx/Imakefile
/usr/X11R6/xmdemos/lib/Xmd/AdjView.c
/usr/X11R6/xmdemos/lib/Xmd/AdjView.h
/usr/X11R6/xmdemos/lib/Xmd/Help.c
/usr/X11R6/xmdemos/lib/Xmd/Help.h
/usr/X11R6/xmdemos/lib/Xmd/HelpP.h
/usr/X11R6/xmdemos/lib/Xmd/Imakefile
/usr/X11R6/xmdemos/lib/Xmd/Menus.c
/usr/X11R6/xmdemos/lib/Xmd/Menus.h
/usr/X11R6/xmdemos/lib/Xmd/Print.c
/usr/X11R6/xmdemos/lib/Xmd/Print.h
/usr/X11R6/xmdemos/lib/Xmd/PrintP.h
/usr/X11R6/xmdemos/lib/Xmd/README
/usr/X11R6/xmdemos/lib/Xmd/RegEdit.c
/usr/X11R6/xmdemos/lib/Xmd/RegEdit.h
/usr/X11R6/xmdemos/lib/Xmd/RegEditI.h
/usr/X11R6/xmdemos/lib/Xmd/helpOn.help
/usr/X11R6/xmdemos/lib/Xmd/onHelp.c
/usr/X11R6/xmdemos/lib/uil/menu_cbs.uih
/usr/X11R6/xmdemos/lib/uil/menu_strings.uih
/usr/X11R6/xmdemos/lib/uil/menus.uih
/usr/X11R6/xmdemos/programs/Exm/Exm.uil
/usr/X11R6/xmdemos/programs/Exm/Imakefile
/usr/X11R6/xmdemos/programs/Exm/README
/usr/X11R6/xmdemos/programs/Exm/app_in_c/Imakefile
/usr/X11R6/xmdemos/programs/Exm/app_in_c/README
/usr/X11R6/xmdemos/programs/Exm/app_in_c/exm_in_c.c
/usr/X11R6/xmdemos/programs/Exm/app_in_c/exm_in_c.man
/usr/X11R6/xmdemos/programs/Exm/app_in_uil/Imakefile
/usr/X11R6/xmdemos/programs/Exm/app_in_uil/README
/usr/X11R6/xmdemos/programs/Exm/app_in_uil/exm_in_uil.c
/usr/X11R6/xmdemos/programs/Exm/app_in_uil/exm_in_uil.man
/usr/X11R6/xmdemos/programs/Exm/app_in_uil/exm_in_uil.uil
/usr/X11R6/xmdemos/programs/Exm/simple_app/Imakefile
/usr/X11R6/xmdemos/programs/Exm/simple_app/README
/usr/X11R6/xmdemos/programs/Exm/simple_app/simpleDemo.c
/usr/X11R6/xmdemos/programs/Exm/simple_app/simpleDemo.man
/usr/X11R6/xmdemos/programs/Imakefile
/usr/X11R6/xmdemos/programs/airport/Imakefile
/usr/X11R6/xmdemos/programs/airport/README
/usr/X11R6/xmdemos/programs/airport/XmdAirport.ad
/usr/X11R6/xmdemos/programs/airport/airport.h
/usr/X11R6/xmdemos/programs/airport/dragsource.c
/usr/X11R6/xmdemos/programs/airport/dragsource.h
/usr/X11R6/xmdemos/programs/airport/dropsite.c
/usr/X11R6/xmdemos/programs/airport/dropsite.h
/usr/X11R6/xmdemos/programs/airport/main.c
/usr/X11R6/xmdemos/programs/airport/main.h
/usr/X11R6/xmdemos/programs/animate/Imakefile
/usr/X11R6/xmdemos/programs/animate/README
/usr/X11R6/xmdemos/programs/animate/XmdAnimate.ad
/usr/X11R6/xmdemos/programs/animate/xmanimate.c
/usr/X11R6/xmdemos/programs/animate/animate.help
/usr/X11R6/xmdemos/programs/animate/animate.man
/usr/X11R6/xmdemos/programs/animate/xmanimate.uil
/usr/X11R6/xmdemos/programs/animate/dog.uil
/usr/X11R6/xmdemos/programs/animate/plane.uil
/usr/X11R6/xmdemos/programs/animate/superman.uil
/usr/X11R6/xmdemos/programs/animate/superman1.xbm
/usr/X11R6/xmdemos/programs/animate/superman2.xbm
/usr/X11R6/xmdemos/programs/animate/superman3.xbm
/usr/X11R6/xmdemos/programs/animate/superman4.xbm
/usr/X11R6/xmdemos/programs/animate/superman5.xbm
/usr/X11R6/xmdemos/programs/animate/superman6.xbm
/usr/X11R6/xmdemos/programs/drag_and_drop/DNDDemo.c
/usr/X11R6/xmdemos/programs/drag_and_drop/DNDDemo.h
/usr/X11R6/xmdemos/programs/drag_and_drop/DNDDemo.man
/usr/X11R6/xmdemos/programs/drag_and_drop/DNDDraw.c
/usr/X11R6/xmdemos/programs/drag_and_drop/Imakefile
/usr/X11R6/xmdemos/programs/drag_and_drop/README
/usr/X11R6/xmdemos/programs/drag_and_drop/simpledrop.c
/usr/X11R6/xmdemos/programs/drag_and_drop/simpledrop.man
/usr/X11R6/xmdemos/programs/draw/Imakefile
/usr/X11R6/xmdemos/programs/draw/README
/usr/X11R6/xmdemos/programs/draw/XmdDraw.ad
/usr/X11R6/xmdemos/programs/draw/draw.c
/usr/X11R6/xmdemos/programs/draw/draw.help
/usr/X11R6/xmdemos/programs/draw/draw.man
/usr/X11R6/xmdemos/programs/earth/Imakefile
/usr/X11R6/xmdemos/programs/earth/README
/usr/X11R6/xmdemos/programs/earth/earth.c
/usr/X11R6/xmdemos/programs/earth/earth.man
/usr/X11R6/xmdemos/programs/earth/terre.xbm
/usr/X11R6/xmdemos/programs/filemanager/Imakefile
/usr/X11R6/xmdemos/programs/filemanager/README
/usr/X11R6/xmdemos/programs/filemanager/XmdFilemanager.ad
/usr/X11R6/xmdemos/programs/filemanager/actions.c
/usr/X11R6/xmdemos/programs/filemanager/code.xpm
/usr/X11R6/xmdemos/programs/filemanager/convert.c
/usr/X11R6/xmdemos/programs/filemanager/dir.xpm
/usr/X11R6/xmdemos/programs/filemanager/exec.xpm
/usr/X11R6/xmdemos/programs/filemanager/file.xpm
/usr/X11R6/xmdemos/programs/filemanager/filemanager.c
/usr/X11R6/xmdemos/programs/filemanager/filemanager.h
/usr/X11R6/xmdemos/programs/filemanager/filemanager.help
/usr/X11R6/xmdemos/programs/filemanager/filemanager.man
/usr/X11R6/xmdemos/programs/filemanager/interface.c
/usr/X11R6/xmdemos/programs/filemanager/none.xpm
/usr/X11R6/xmdemos/programs/filemanager/obj.xpm
/usr/X11R6/xmdemos/programs/filemanager/pix.xpm
/usr/X11R6/xmdemos/programs/filemanager/readdir.c
/usr/X11R6/xmdemos/programs/filemanager/s_dir.xpm
/usr/X11R6/xmdemos/programs/filemanager/s_exec.xpm
/usr/X11R6/xmdemos/programs/filemanager/s_file.xpm
/usr/X11R6/xmdemos/programs/filemanager/s_none.xpm
/usr/X11R6/xmdemos/programs/filemanager/s_pix.xpm
/usr/X11R6/xmdemos/programs/fileview/English.df
/usr/X11R6/xmdemos/programs/fileview/English.uil
/usr/X11R6/xmdemos/programs/fileview/Fileview.ad
/usr/X11R6/xmdemos/programs/fileview/French.df
/usr/X11R6/xmdemos/programs/fileview/French.uil
/usr/X11R6/xmdemos/programs/fileview/German.df
/usr/X11R6/xmdemos/programs/fileview/German.uil
/usr/X11R6/xmdemos/programs/fileview/Imakefile
/usr/X11R6/xmdemos/programs/fileview/README
/usr/X11R6/xmdemos/programs/fileview/file.c
/usr/X11R6/xmdemos/programs/fileview/file.h
/usr/X11R6/xmdemos/programs/fileview/fileE.h
/usr/X11R6/xmdemos/programs/fileview/fileview.h
/usr/X11R6/xmdemos/programs/fileview/main.c
/usr/X11R6/xmdemos/programs/fileview/main.h
/usr/X11R6/xmdemos/programs/fileview/mainE.h
/usr/X11R6/xmdemos/programs/fileview/text.c
/usr/X11R6/xmdemos/programs/fileview/text.h
/usr/X11R6/xmdemos/programs/fileview/textE.h
/usr/X11R6/xmdemos/programs/fileview/xmfile
/usr/X11R6/xmdemos/programs/getsubres/Imakefile
/usr/X11R6/xmdemos/programs/getsubres/README
/usr/X11R6/xmdemos/programs/getsubres/getsubres.c
/usr/X11R6/xmdemos/programs/getsubres/getsubres.help
/usr/X11R6/xmdemos/programs/getsubres/getsubres.man
/usr/X11R6/xmdemos/programs/hellomotif/Imakefile
/usr/X11R6/xmdemos/programs/hellomotif/README
/usr/X11R6/xmdemos/programs/hellomotif/hellomotif.c
/usr/X11R6/xmdemos/programs/hellomotif/hellomotif.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/C/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/Imakefile
/usr/X11R6/xmdemos/programs/hellomotifi18n/README
/usr/X11R6/xmdemos/programs/hellomotifi18n/bdf/7x14rk.bdf
/usr/X11R6/xmdemos/programs/hellomotifi18n/bdf/heb8x13.bdf
/usr/X11R6/xmdemos/programs/hellomotifi18n/bdf/k14-1.bdf
/usr/X11R6/xmdemos/programs/hellomotifi18n/english/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/french/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/hebrew/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/helloint.c
/usr/X11R6/xmdemos/programs/hellomotifi18n/helloint.man
/usr/X11R6/xmdemos/programs/hellomotifi18n/helloint.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/japan/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/japanese/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/hellomotifi18n/swedish/uid/l_strings.uil
/usr/X11R6/xmdemos/programs/i18ninput/Imakefile
/usr/X11R6/xmdemos/programs/i18ninput/README
/usr/X11R6/xmdemos/programs/i18ninput/XmdI18nInput.ad
/usr/X11R6/xmdemos/programs/i18ninput/i18ninput.c
/usr/X11R6/xmdemos/programs/i18ninput/i18ninput.help
/usr/X11R6/xmdemos/programs/i18ninput/i18ninput.man
/usr/X11R6/xmdemos/programs/i18ninput/input.c
/usr/X11R6/xmdemos/programs/panner/Imakefile
/usr/X11R6/xmdemos/programs/panner/README
/usr/X11R6/xmdemos/programs/panner/panner.c
/usr/X11R6/xmdemos/programs/panner/panner.man
/usr/X11R6/xmdemos/programs/periodic/Imakefile
/usr/X11R6/xmdemos/programs/periodic/README
/usr/X11R6/xmdemos/programs/periodic/XmdPeriodic.ad
/usr/X11R6/xmdemos/programs/periodic/periodic.c
/usr/X11R6/xmdemos/programs/periodic/periodic.man
/usr/X11R6/xmdemos/programs/periodic/periodic.uil
/usr/X11R6/xmdemos/programs/periodic/periodic_l.uil
/usr/X11R6/xmdemos/programs/piano/Imakefile
/usr/X11R6/xmdemos/programs/piano/Inv8_part1.piano
/usr/X11R6/xmdemos/programs/piano/Inv8_part2.piano
/usr/X11R6/xmdemos/programs/piano/README
/usr/X11R6/xmdemos/programs/piano/piano.c
/usr/X11R6/xmdemos/programs/piano/piano.images
/usr/X11R6/xmdemos/programs/piano/piano.man
/usr/X11R6/xmdemos/programs/popups/Imakefile
/usr/X11R6/xmdemos/programs/popups/README
/usr/X11R6/xmdemos/programs/popups/autopopups.c
/usr/X11R6/xmdemos/programs/popups/autopopups.man
/usr/X11R6/xmdemos/programs/sampler2_0/Imakefile
/usr/X11R6/xmdemos/programs/sampler2_0/README
/usr/X11R6/xmdemos/programs/sampler2_0/XmdSampler2_0.ad
/usr/X11R6/xmdemos/programs/sampler2_0/bee
/usr/X11R6/xmdemos/programs/sampler2_0/bee.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/bomb.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/cherry.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/da.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/girlface.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/k7.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/labir.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/main.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/pile.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/prev.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/sampler2_0.c
/usr/X11R6/xmdemos/programs/sampler2_0/sampler2_0.help
/usr/X11R6/xmdemos/programs/sampler2_0/sampler2_0.man
/usr/X11R6/xmdemos/programs/sampler2_0/spir.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/stack.xpm
/usr/X11R6/xmdemos/programs/sampler2_0/text.xpm
/usr/X11R6/xmdemos/programs/setdate/Imakefile
/usr/X11R6/xmdemos/programs/setdate/README
/usr/X11R6/xmdemos/programs/setdate/XmdSetDate
/usr/X11R6/xmdemos/programs/setdate/XmdSetDate.ad
/usr/X11R6/xmdemos/programs/setdate/setDate.c
/usr/X11R6/xmdemos/programs/setdate/setDate.man
/usr/X11R6/xmdemos/programs/todo/Imakefile
/usr/X11R6/xmdemos/programs/todo/README
/usr/X11R6/xmdemos/programs/todo/XmdTodo.ad
/usr/X11R6/xmdemos/programs/todo/actions.c
/usr/X11R6/xmdemos/programs/todo/example.todo
/usr/X11R6/xmdemos/programs/todo/io.c
/usr/X11R6/xmdemos/programs/todo/page.h
/usr/X11R6/xmdemos/programs/todo/todo.c
/usr/X11R6/xmdemos/programs/todo/todo.help
/usr/X11R6/xmdemos/programs/todo/todo.man
/usr/X11R6/xmdemos/programs/workspace/Imakefile
/usr/X11R6/xmdemos/programs/workspace/README
/usr/X11R6/xmdemos/programs/workspace/client_win.c
/usr/X11R6/xmdemos/programs/workspace/command_ui.c
/usr/X11R6/xmdemos/programs/workspace/command_ui.h
/usr/X11R6/xmdemos/programs/workspace/wsm.c
/usr/X11R6/xmdemos/programs/workspace/wsm.h
/usr/X11R6/xmdemos/programs/workspace/wsm.man
/usr/X11R6/xmdemos/programs/workspace/wsmData.c
/usr/X11R6/xmdemos/programs/workspace/wsmData.h
/usr/X11R6/xmdemos/programs/workspace/wsmDebug.c
/usr/X11R6/xmdemos/programs/workspace/wsmDebug.h
/usr/X11R6/xmdemos/programs/workspace/wsmSend.c
/usr/X11R6/xmdemos/programs/workspace/wsmSend.h
/usr/X11R6/xmdemos/programs/workspace/wsmStruct.c
/usr/X11R6/xmdemos/programs/workspace/wsmStruct.h
/usr/X11R6/xmdemos/programs/workspace/wsm_cb.c
/usr/X11R6/xmdemos/programs/workspace/wsm_cb.h
/usr/X11R6/xmdemos/programs/workspace/wsm_create.c
/usr/X11R6/xmdemos/programs/workspace/wsm_create.h
/usr/X11R6/xmdemos/programs/workspace/wsm_ui.h
/usr/X11R6/xmdemos/programs/workspace/xrmLib.c
/usr/X11R6/xmdemos/programs/workspace/xrmLib.h
/usr/X11R6/xmdemos/unsupported/Exm/Container.c
/usr/X11R6/xmdemos/unsupported/Exm/Container.h
/usr/X11R6/xmdemos/unsupported/Exm/ContainerP.h
/usr/X11R6/xmdemos/unsupported/Exm/Imakefile
/usr/X11R6/xmdemos/unsupported/Imakefile
/usr/X11R6/xmdemos/unsupported/aicon/Imakefile
/usr/X11R6/xmdemos/unsupported/aicon/aicon.c
/usr/X11R6/xmdemos/unsupported/aicon/aicon.help
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/Imakefile
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/README
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/app.c
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/app.h
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/basic.h
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/demo1.bts
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/demo1.help
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/demo1.txt
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/dlg.c
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/dlg.h
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/file.c
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/file.h
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/strings.uil
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/textedit.uil
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/texteditor.c
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/texteditor.help
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/texteditor.man
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/tk.c
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/tk.h
/usr/X11R6/xmdemos/unsupported/cstext/texteditor/tkdef.h
/usr/X11R6/xmdemos/unsupported/dainput/Imakefile
/usr/X11R6/xmdemos/unsupported/dainput/README
/usr/X11R6/xmdemos/unsupported/dainput/dainput.c
/usr/X11R6/xmdemos/unsupported/dainput/dainput.h
/usr/X11R6/xmdemos/unsupported/dainput/dainput_dlg.c
/usr/X11R6/xmdemos/unsupported/dainput/dainput_ui.c
/usr/X11R6/xmdemos/unsupported/dogs/Dog.c
/usr/X11R6/xmdemos/unsupported/dogs/Dog.h
/usr/X11R6/xmdemos/unsupported/dogs/Dog.uil
/usr/X11R6/xmdemos/unsupported/dogs/DogP.h
/usr/X11R6/xmdemos/unsupported/dogs/Imakefile
/usr/X11R6/xmdemos/unsupported/dogs/README
/usr/X11R6/xmdemos/unsupported/dogs/Square.c
/usr/X11R6/xmdemos/unsupported/dogs/Square.h
/usr/X11R6/xmdemos/unsupported/dogs/Square.uil
/usr/X11R6/xmdemos/unsupported/dogs/SquareP.h
/usr/X11R6/xmdemos/unsupported/dogs/bark.bm
/usr/X11R6/xmdemos/unsupported/dogs/dogs.c
/usr/X11R6/xmdemos/unsupported/dogs/dogs.uil
/usr/X11R6/xmdemos/unsupported/dogs/down.bm
/usr/X11R6/xmdemos/unsupported/dogs/up.bm
/usr/X11R6/xmdemos/unsupported/hellomotif/Imakefile
/usr/X11R6/xmdemos/unsupported/hellomotif/hellomotif.c
/usr/X11R6/xmdemos/unsupported/motifshell/Imakefile
/usr/X11R6/xmdemos/unsupported/motifshell/README
/usr/X11R6/xmdemos/unsupported/motifshell/help
/usr/X11R6/xmdemos/unsupported/motifshell/membership
/usr/X11R6/xmdemos/unsupported/motifshell/motif
/usr/X11R6/xmdemos/unsupported/motifshell/motifshell.c
/usr/X11R6/xmdemos/unsupported/motifshell/motifshell.h
/usr/X11R6/xmdemos/unsupported/motifshell/principles
/usr/X11R6/xmdemos/unsupported/motifshell/research
/usr/X11R6/xmdemos/unsupported/motifshell/welcome
/usr/X11R6/xmdemos/unsupported/transfer/Imakefile
/usr/X11R6/xmdemos/unsupported/transfer/README
/usr/X11R6/xmdemos/unsupported/transfer/actions.c
/usr/X11R6/xmdemos/unsupported/transfer/interface.c
/usr/X11R6/xmdemos/unsupported/transfer/interface.h
/usr/X11R6/xmdemos/unsupported/transfer/list.c
/usr/X11R6/xmdemos/unsupported/transfer/transfer.c
/usr/X11R6/xmdemos/unsupported/transfer/transfer.h
/usr/X11R6/xmdemos/unsupported/transfer/transfer.help
/usr/X11R6/xmdemos/unsupported/transfer/transfer.man
/usr/X11R6/xmdemos/unsupported/uilsymdump/Imakefile
/usr/X11R6/xmdemos/unsupported/uilsymdump/README
/usr/X11R6/xmdemos/unsupported/uilsymdump/uilsymdump.c
/usr/X11R6/xmdemos/unsupported/xmapdef/Imakefile
/usr/X11R6/xmdemos/unsupported/xmapdef/xmapdef.c
/usr/X11R6/xmdemos/unsupported/xmfonts/Imakefile
/usr/X11R6/xmdemos/unsupported/xmfonts/xmfonts.c
/usr/X11R6/xmdemos/unsupported/xmforc/Imakefile
/usr/X11R6/xmdemos/unsupported/xmforc/xmforc.c
/usr/X11R6/xmdemos/unsupported/xmform/Imakefile
/usr/X11R6/xmdemos/unsupported/xmform/xmform.c
/usr/X11R6/include/Mrm/MrmAppl.h
/usr/X11R6/include/Mrm/MrmDecls.h
/usr/X11R6/include/Mrm/MrmPublic.h
/usr/X11R6/include/Mrm/MrmosI.h
/usr/X11R6/include/Xm/AccColorT.h
/usr/X11R6/include/Xm/AccTextT.h
/usr/X11R6/include/Xm/ActivatableT.h
/usr/X11R6/include/Xm/ArrowB.h
/usr/X11R6/include/Xm/ArrowBG.h
/usr/X11R6/include/Xm/ArrowBGP.h
/usr/X11R6/include/Xm/ArrowBP.h
/usr/X11R6/include/Xm/AtomMgr.h
/usr/X11R6/include/Xm/BaseClassP.h
/usr/X11R6/include/Xm/BulletinB.h
/usr/X11R6/include/Xm/BulletinBP.h
/usr/X11R6/include/Xm/CacheP.h
/usr/X11R6/include/Xm/CareVisualT.h
/usr/X11R6/include/Xm/CascadeB.h
/usr/X11R6/include/Xm/CascadeBG.h
/usr/X11R6/include/Xm/CascadeBGP.h
/usr/X11R6/include/Xm/CascadeBP.h
/usr/X11R6/include/Xm/ClipWindowP.h
/usr/X11R6/include/Xm/ColorObjP.h
/usr/X11R6/include/Xm/ColorP.h
/usr/X11R6/include/Xm/ComboBox.h
/usr/X11R6/include/Xm/ComboBoxP.h
/usr/X11R6/include/Xm/Command.h
/usr/X11R6/include/Xm/CommandP.h
/usr/X11R6/include/Xm/ContItemT.h
/usr/X11R6/include/Xm/Container.h
/usr/X11R6/include/Xm/ContainerP.h
/usr/X11R6/include/Xm/ContainerT.h
/usr/X11R6/include/Xm/CutPaste.h
/usr/X11R6/include/Xm/DesktopP.h
/usr/X11R6/include/Xm/DialogS.h
/usr/X11R6/include/Xm/DialogSEP.h
/usr/X11R6/include/Xm/DialogSP.h
/usr/X11R6/include/Xm/DialogSavvyT.h
/usr/X11R6/include/Xm/Display.h
/usr/X11R6/include/Xm/DisplayP.h
/usr/X11R6/include/Xm/DragC.h
/usr/X11R6/include/Xm/DragCP.h
/usr/X11R6/include/Xm/DragDrop.h
/usr/X11R6/include/Xm/DragIcon.h
/usr/X11R6/include/Xm/DragIconP.h
/usr/X11R6/include/Xm/DragOverS.h
/usr/X11R6/include/Xm/DragOverSP.h
/usr/X11R6/include/Xm/DrawP.h
/usr/X11R6/include/Xm/DrawingA.h
/usr/X11R6/include/Xm/DrawingAP.h
/usr/X11R6/include/Xm/DrawnB.h
/usr/X11R6/include/Xm/DrawnBP.h
/usr/X11R6/include/Xm/DropSMgr.h
/usr/X11R6/include/Xm/DropSMgrP.h
/usr/X11R6/include/Xm/DropTrans.h
/usr/X11R6/include/Xm/DropTransP.h
/usr/X11R6/include/Xm/ExtObjectP.h
/usr/X11R6/include/Xm/FileSB.h
/usr/X11R6/include/Xm/FileSBP.h
/usr/X11R6/include/Xm/Form.h
/usr/X11R6/include/Xm/FormP.h
/usr/X11R6/include/Xm/Frame.h
/usr/X11R6/include/Xm/FrameP.h
/usr/X11R6/include/Xm/Gadget.h
/usr/X11R6/include/Xm/GadgetP.h
/usr/X11R6/include/Xm/GrabShell.h
/usr/X11R6/include/Xm/GrabShellP.h
/usr/X11R6/include/Xm/IconFile.h
/usr/X11R6/include/Xm/IconFileP.h
/usr/X11R6/include/Xm/IconG.h
/usr/X11R6/include/Xm/IconGP.h
/usr/X11R6/include/Xm/IconH.h
/usr/X11R6/include/Xm/IconHP.h
/usr/X11R6/include/Xm/JoinSideT.h
/usr/X11R6/include/Xm/Label.h
/usr/X11R6/include/Xm/LabelG.h
/usr/X11R6/include/Xm/LabelGP.h
/usr/X11R6/include/Xm/LabelP.h
/usr/X11R6/include/Xm/LayoutT.h
/usr/X11R6/include/Xm/List.h
/usr/X11R6/include/Xm/ListP.h
/usr/X11R6/include/Xm/MainW.h
/usr/X11R6/include/Xm/MainWP.h
/usr/X11R6/include/Xm/Manager.h
/usr/X11R6/include/Xm/ManagerP.h
/usr/X11R6/include/Xm/MenuProcP.h
/usr/X11R6/include/Xm/MenuShell.h
/usr/X11R6/include/Xm/MenuShellP.h
/usr/X11R6/include/Xm/MenuStateP.h
/usr/X11R6/include/Xm/MenuT.h
/usr/X11R6/include/Xm/MenuUtilP.h
/usr/X11R6/include/Xm/MessageB.h
/usr/X11R6/include/Xm/MessageBP.h
/usr/X11R6/include/Xm/MwmUtil.h
/usr/X11R6/include/Xm/NavigatorT.h
/usr/X11R6/include/Xm/Notebook.h
/usr/X11R6/include/Xm/NotebookP.h
/usr/X11R6/include/Xm/PanedW.h
/usr/X11R6/include/Xm/PanedWP.h
/usr/X11R6/include/Xm/PointInT.h
/usr/X11R6/include/Xm/Primitive.h
/usr/X11R6/include/Xm/PrimitiveP.h
/usr/X11R6/include/Xm/Print.h
/usr/X11R6/include/Xm/PrintSP.h
/usr/X11R6/include/Xm/Protocols.h
/usr/X11R6/include/Xm/ProtocolsP.h
/usr/X11R6/include/Xm/PushB.h
/usr/X11R6/include/Xm/PushBG.h
/usr/X11R6/include/Xm/PushBGP.h
/usr/X11R6/include/Xm/PushBP.h
/usr/X11R6/include/Xm/RCLayoutP.h
/usr/X11R6/include/Xm/RCMenuP.h
/usr/X11R6/include/Xm/RepType.h
/usr/X11R6/include/Xm/RowColumn.h
/usr/X11R6/include/Xm/RowColumnP.h
/usr/X11R6/include/Xm/SSpinB.h
/usr/X11R6/include/Xm/SSpinBP.h
/usr/X11R6/include/Xm/SashP.h
/usr/X11R6/include/Xm/Scale.h
/usr/X11R6/include/Xm/ScaleP.h
/usr/X11R6/include/Xm/Screen.h
/usr/X11R6/include/Xm/ScreenP.h
/usr/X11R6/include/Xm/ScrollBar.h
/usr/X11R6/include/Xm/ScrollBarP.h
/usr/X11R6/include/Xm/ScrollFrameT.h
/usr/X11R6/include/Xm/ScrolledW.h
/usr/X11R6/include/Xm/ScrolledWP.h
/usr/X11R6/include/Xm/SelectioB.h
/usr/X11R6/include/Xm/SelectioBP.h
/usr/X11R6/include/Xm/SeparatoG.h
/usr/X11R6/include/Xm/SeparatoGP.h
/usr/X11R6/include/Xm/Separator.h
/usr/X11R6/include/Xm/SeparatorP.h
/usr/X11R6/include/Xm/ShellEP.h
/usr/X11R6/include/Xm/SpecRenderT.h
/usr/X11R6/include/Xm/SpinB.h
/usr/X11R6/include/Xm/SpinBP.h
/usr/X11R6/include/Xm/TakesDefT.h
/usr/X11R6/include/Xm/TearOffBP.h
/usr/X11R6/include/Xm/TearOffP.h
/usr/X11R6/include/Xm/Text.h
/usr/X11R6/include/Xm/TextF.h
/usr/X11R6/include/Xm/TextFP.h
/usr/X11R6/include/Xm/TextFSelP.h
/usr/X11R6/include/Xm/TextInP.h
/usr/X11R6/include/Xm/TextOutP.h
/usr/X11R6/include/Xm/TextP.h
/usr/X11R6/include/Xm/TextSelP.h
/usr/X11R6/include/Xm/TextStrSoP.h
/usr/X11R6/include/Xm/ToggleB.h
/usr/X11R6/include/Xm/ToggleBG.h
/usr/X11R6/include/Xm/ToggleBGP.h
/usr/X11R6/include/Xm/ToggleBP.h
/usr/X11R6/include/Xm/TraitP.h
/usr/X11R6/include/Xm/Transfer.h
/usr/X11R6/include/Xm/TransferP.h
/usr/X11R6/include/Xm/TransferT.h
/usr/X11R6/include/Xm/TransltnsP.h
/usr/X11R6/include/Xm/TravConT.h
/usr/X11R6/include/Xm/TxtPropCv.h
/usr/X11R6/include/Xm/UnhighlightT.h
/usr/X11R6/include/Xm/UnitTypeT.h
/usr/X11R6/include/Xm/VaSimpleP.h
/usr/X11R6/include/Xm/VendorS.h
/usr/X11R6/include/Xm/VendorSEP.h
/usr/X11R6/include/Xm/VendorSP.h
/usr/X11R6/include/Xm/VirtKeys.h
/usr/X11R6/include/Xm/VirtKeysP.h
/usr/X11R6/include/Xm/Xm.h
/usr/X11R6/include/Xm/XmAll.h
/usr/X11R6/include/Xm/XmIm.h
/usr/X11R6/include/Xm/XmP.h
/usr/X11R6/include/Xm/XmStrDefs.h
/usr/X11R6/include/Xm/Xmfuncs.h
/usr/X11R6/include/Xm/XmosP.h
/usr/X11R6/include/Xm/XpmP.h
/usr/X11R6/include/uil/Uil.h
/usr/X11R6/include/uil/UilDBDef.h
/usr/X11R6/include/uil/UilDef.h
/usr/X11R6/include/uil/UilSymDef.h
/usr/X11R6/include/uil/UilSymGl.h
/usr/X11R6/include/uil/XmAppl.uil
/usr/X11R6/lib/X11/uid/C/uid/l_strings.uid
/usr/X11R6/lib/X11/uid/English.uid
/usr/X11R6/lib/X11/uid/French.uid
/usr/X11R6/lib/X11/uid/German.uid
/usr/X11R6/lib/X11/uid/xmanimate.uid
/usr/X11R6/lib/X11/uid/dog.uid
/usr/X11R6/lib/X11/uid/dogs.uid
/usr/X11R6/lib/X11/uid/english/uid/l_strings.uid
/usr/X11R6/lib/X11/uid/exm_in_uil.uid
/usr/X11R6/lib/X11/uid/french/uid/l_strings.uid
/usr/X11R6/lib/X11/uid/hebrew/uid/l_strings.uid
/usr/X11R6/lib/X11/uid/helloint.uid
/usr/X11R6/lib/X11/uid/hellomotif.uid
/usr/X11R6/lib/X11/uid/japanese/uid/l_strings.uid
/usr/X11R6/lib/X11/uid/periodic.uid
/usr/X11R6/lib/X11/uid/plane.uid
/usr/X11R6/lib/X11/uid/superman.uid
/usr/X11R6/lib/X11/uid/swedish/uid/l_strings.uid
/usr/X11R6/lib/libXm.so
/usr/X11R6/lib/libMrm.so
/usr/X11R6/lib/libUil.so
/usr/X11R6/lib/libMrm.a
/usr/X11R6/lib/libMrm_d.a
/usr/X11R6/lib/libUil.a
/usr/X11R6/lib/libUil_d.a
/usr/X11R6/lib/libXm.a
/usr/X11R6/lib/libXm_d.a

%files

%dir /usr/X11R6/include/bitmaps
%docdir /usr/doc/openmotif-2.1.30
%docdir /usr/doc/openmotif-2.1.30/mot-ug
%doc /usr/doc/openmotif-2.1.30/LICENSE
%doc /usr/doc/openmotif-2.1.30/OpenMotifEverywhere.html
%doc /usr/doc/openmotif-2.1.30/OpenMotifEverywhere.txt
%doc /usr/doc/openmotif-2.1.30/README.runtime
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch01.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch02.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch03.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch04.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch05.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch06.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch07.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch08.ps.Z
%doc /usr/doc/openmotif-2.1.30/mot-ug/ch10.ps.Z
%doc /usr/X11R6/man/man4/mwmrc.4
%doc /usr/X11R6/man/man1/mwm.1
%doc /usr/X11R6/man/man1/xmbind.1
/usr/X11R6/lib/X11/app-defaults/Mwm
/usr/X11R6/bin/mwm
/usr/X11R6/bin/xmbind
/usr/X11R6/include/bitmaps/xm_error
/usr/X11R6/include/bitmaps/xm_hour16
/usr/X11R6/include/bitmaps/xm_hour16m
/usr/X11R6/include/bitmaps/xm_hour32
/usr/X11R6/include/bitmaps/xm_hour32m
/usr/X11R6/include/bitmaps/xm_information
/usr/X11R6/include/bitmaps/xm_noenter16
/usr/X11R6/include/bitmaps/xm_noenter16m
/usr/X11R6/include/bitmaps/xm_noenter32
/usr/X11R6/include/bitmaps/xm_noenter32m
/usr/X11R6/include/bitmaps/xm_question
/usr/X11R6/include/bitmaps/xm_warning
/usr/X11R6/include/bitmaps/xm_working
/usr/X11R6/lib/X11/system.mwmrc
/usr/X11R6/lib/libMrm.so.2.1
/usr/X11R6/lib/libUil.so.2.1
/usr/X11R6/lib/libXm.so.2.1

%changelog
*Fri May 19 2000 ICS <info@ics.com> 2.1.30-2_ICS
- Significant overhaul for SRPM distribution
