/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;

public class TempDir {
    public static Path tmpDir;
    public static Path outputDir;
    public static Path phantomJsDir;

    public TempDir() throws IOException {
        tmpDir = Files.createTempDirectory("export", new FileAttribute[0]);
        tmpDir.toFile().deleteOnExit();
        outputDir = Files.createDirectory(Paths.get(tmpDir.toString(), "output"), new FileAttribute[0]);
        phantomJsDir = Files.createDirectory(Paths.get(tmpDir.toString(), "phantomjs"), new FileAttribute[0]);
        System.out.println("Highcharts Export Server using " + TempDir.getTmpDir() + " as TEMP folder.");
    }

    public static Path getTmpDir() {
        return tmpDir;
    }

    public static Path getOutputDir() {
        return outputDir;
    }

    public static Path getPhantomJsDir() {
        return phantomJsDir;
    }

    public static String getDownloadLink(String filename) {
        filename = FilenameUtils.getName((String)filename);
        String link = "files/" + filename;
        return link;
    }
}

