/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		FilePrefsSource.cpp

	Contains:	Implements object defined in FilePrefsSource.h.

	Written by:	Denis Serenyi

	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

	$Log: NetInfoPrefsSource.cpp,v $
	Revision 1.4  1999/08/03 18:45:08  serenyi
	Added StreamThinning logging
	
	Revision 1.3  1999/08/02 23:23:36  serenyi
	Changed thinning to be a bit less agressive
	
	Revision 1.2  1999/06/08 20:35:34  serenyi
	Allow adding 2 values to one pref, have "rtsp_port" take advantage of this
	
	Revision 1.1  1999/06/01 20:50:03  serenyi
	new files for linux
	

*/

#include "nilib2.h"

#include "NetInfoPrefsSource.h"

static char* gQTSSPropertiesPath = "/services/QuickTimeStreamingServer";

const char* kDefaultPrefs[] = {
						/* 1*/	"rtsp_port", "554",
						/* 2*/	"rtsp_timeout", "60",
						/* 3*/	"maximum_connections", "1000",
						/* 4*/	"movie_folder", "/Local/Library/QuickTimeStreaming/Movies",

						/* 5*/	"request_logging", "disabled",
						/* 6*/	"request_logfile_name", "QTStreamingServer",
						/* 7*/	"request_logfile_dir", "/Local/Library/QuickTimeStreaming/Logs/",
						/* 8*/	"request_logfile_size", "10000000",
						/* 9*/	"request_logfile_interval", "7",

						/*10*/	"error_logging", "enabled",
						/*11*/	"error_logfile_name", "Error",
						/*12*/	"error_logfile_dir", "/Local/Library/QuickTimeStreaming/Logs/",
						/*13*/	"error_logfile_size", "256000",
						/*14*/	"error_logfile_interval", "7",
						/*15*/	"error_logfile_verbosity", "3",

						/*16*/	"screen_logging", "disabled",
						/*17*/	"break_on_assert", "disabled",
						/*19*/	"bind_ip_addr", "",
						/*19*/	"history_update_interval", "120",
						/*20*/	"maximum_bandwidth", "100000",
						/*21*/	"buffer_seconds", "8",
						/*22*/	"auto_restart", "enabled",
 						/*23*/	"rtp_timeout", "60",

						/*24*/	"total_bytes_update", "1",
						/*25*/	"reflector_delay", "100",
						/*26*/	"reflector_bucket_size", "16",
						/*27*/	"average_bandwidth_update", "60",
						/*28*/	"safe_play_duration", "600",
						/*29*/	"sdp_url", "",
						/*30*/	"admin_email", "",
						/*31*/	"disable_timeout_on_play", "disabled",
						/*32*/	"max_advance_send_time", "100",
						/*33*/	"web_stats_url", "",
						/*34*/  "remote_status_server_addr", "0.0.0.0",
						/*35*/  "remote_status_server_port", "7072",
						/*36*/	"loss_thin_tolerance", "30",
						/*37*/	"num_losses_to_thin", "3",
						/*38*/	"loss_thick_tolerance", "5",
						/*39*/	"num_losses_to_thick", "6",
						/*40*/	"num_worses_to_thin", "2",
						/*41*/	"real_rtsp_timeout", "180",
						/*42*/	"stream_thinning_log_enabled", "disabled",

						
						//!!!be sure to update kDefaultPrefsArraySize below!!!
};
const int kDefaultPrefsArraySize = 41;	//actually 60, but we treat them as key/value paris


NetInfoPrefsSource::NetInfoPrefsSource()
{
	//setup the defaults...
	char tmpValue[1024]= {};
	unsigned int i = 0;
    for (  i = 0; i<kDefaultPrefsArraySize*2; i +=2)
    {
        if (!this->GetValue( kDefaultPrefs[i], tmpValue ))
        {
        	//This is a TOTAL HACK! Ideally, each key should have N values associated with
        	//it in the above array. But for now, rtsp_port is the only key that has multiple
        	//values, so let's just special case it.
        	if (::strcmp(kDefaultPrefs[i], "rtsp_port") == 0)
        		this->SetValue(kDefaultPrefs[i], kDefaultPrefs[i+1], "7070");
        	else
	   			this->SetValue( kDefaultPrefs[i], kDefaultPrefs[i+1], NULL );
        }
    }

}

int NetInfoPrefsSource::GetValue(const char* inKey, char* ioValue)
{
	return this->GetValueByIndex(inKey, 0, ioValue);
}

int NetInfoPrefsSource::GetValueByIndex(const char* inKey, UInt32 inIndex, char* ioValue)
{
	ni_status status = NI_OK;
	ni_namelist nameList = {};
	void* localDomain = NULL;
	ni_id qtssDir = {};	
	
	ioValue[0] = '\0';

	status = ni_open(NULL, ".", &localDomain);
	if (status != NI_OK)
		return false;
		
	if (status == NI_OK)
		status = ni_pathsearch(localDomain, &qtssDir, gQTSSPropertiesPath);
		
	if (status == NI_OK)
		status = ni_lookupprop(localDomain, &qtssDir, inKey, &nameList);

	if (status == NI_OK)
	{
		if (nameList.ni_namelist_len > inIndex)
			strcpy(ioValue, nameList.ni_namelist_val[inIndex]);
		else
			status = NI_BADID;
		ni_namelist_free(&nameList);
	}
	
	ni_free(localDomain);
	
	return (status == NI_OK);
}

void NetInfoPrefsSource::SetValue(const char* inKey, const char* inValue, const char* inSecondValue)
{
	void* localDomain = NULL;
	ni_status status = NI_OK;
	ni_namelist nameList = {};

	ni_namelist_insert(&nameList, (char*)inValue, NI_INDEX_NULL);
	if (inSecondValue != NULL)
		ni_namelist_insert(&nameList, (char*)inSecondValue, NI_INDEX_NULL);

	status = ni_open(NULL, ".", &localDomain);

	if (status == NI_OK)
	{
		//create the path if it doesn't already exist
		status = ni2_create(localDomain, gQTSSPropertiesPath);

		if (status == NI_OK)
			status = ni2_createprop(localDomain, gQTSSPropertiesPath, (char*)inKey, nameList);
	}
	ni_namelist_free(&nameList);
	ni_free(localDomain);
}