function libn=ilib_for_link(names,files,libs,flag,makename,loadername)
// shared library builder for link command 
// 
[lhs,rhs]=argn(0);
info=1
if rhs <= 4 then makename = 'Makelib';end
if rhs <= 5 then loadername = 'loader.sce';end
// generate a loader file
if info==1 then write(%io(2),'   generate a loader file');end
ilib_link_gen_loader(names,flag,loadername);
// generate a Makefile
if info==1 then write(%io(2),'   generate a Makefile: Makelib');end
ilib_link_gen_Make(names,files,libs,makename);
// we call make
if info==1 then write(%io(2),'   running the makefile');end
libn=ilib_compile('lib'+names(1),makename);

function ilib_link_gen_loader(names,flag,loadername)
//------------------------------------
comp_target = getenv('COMPILER','NO');
if getenv('WIN32','NO')=='OK' then
  select comp_target
	case 'VC++'   then lib_suf='dll';
	case 'ABSOFT' then lib_suf='dll';
	else lib_suf='dll';
  end
else
  lib_suf=ilib_unix_soname();
end
fd=mopen(loadername,"w");
mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"// ------------------------------------------------------\n");
mfprintf(fd,"%s_path=get_file_path(''%s'');\n",names(1),loadername);
mfprintf(fd,"link(%s_path+''/lib%s.%s'',[",names(1),names(1),lib_suf);
names=names(:)';
n = size(names,'*');
for i=1:n
  mfprintf(fd,"''%s''",names(i))
  if i <>n ; mfprintf(fd,","); else mfprintf(fd,"],");end
end
mfprintf(fd,"''%s'');\n",flag);
mclose(fd);

function ilib_link_gen_Make(names,files,libs,makename)
//------------------------------------
// generate a Makefile for gateway
comp_target = getenv('COMPILER','NO');
if getenv('WIN32','NO')=='OK' then
  select comp_target
	case 'VC++'   then Makename = makename+'.mak'
	case 'ABSOFT' then Makename = makename+'.amk'
	else Makename = makename;
  end
  ilib_link_gen_Make_win32(names,files,libs,Makename)
else
  Makename = makename;
  ilib_link_gen_Make_unix(names,files,libs,Makename)
end

function ilib_link_gen_Make_unix(names,files,libs,Makename)
fd=mopen(Makename,"w");
mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"# ------------------------------------------------------\n");
mfprintf(fd,"SCIDIR = %s\n",SCI);
mfprintf(fd,"OBJS = ")
for x=files(:)' ; mfprintf(fd," %s",x);end
mfprintf(fd,"\n") ;
mfprintf(fd,"OTHERLIBS = ")
for x=libs(:)' ; mfprintf(fd," %s",x);end
mfprintf(fd,"\n") ;
mfprintf(fd,"LIBRARY = lib%s\n",names(1));
mfprintf(fd,"include $(SCIDIR)/Makefile.incl\n");
mfprintf(fd,"CFLAGS = $(CC_OPTIONS)\n");
mfprintf(fd,"FFLAGS = $(FC_OPTIONS)\n");
mfprintf(fd,"include $(SCIDIR)/config/Makeso.incl\n");
mclose(fd);

function ilib_link_gen_Make_win32(names,files,libs,Makename)
fd=mopen(Makename,"w");
mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"# ------------------------------------------------------\n");
mfprintf(fd,"SHELL = /bin/sh\n");
mfprintf(fd,"SCIDIR =%s\n",SCI);
mfprintf(fd,"SCIDIR1 =%s\n",WSCI);
mfprintf(fd,"# name of the dll to be built\n"); 
mfprintf(fd,"LIBRARY = lib%s\n",names(1));
mfprintf(fd,"# list of objects file\n");
mfprintf(fd,"OBJS =");
for x=files(:)' ; mfprintf(fd," %s",strsubst(x,".o",".obj"));end
mfprintf(fd,"# added libraries \n");
mfprintf(fd,"OTHERLIBS = ");
for x=libs(:)' ; mfprintf(fd," %s",x);end
mfprintf(fd,"\n################ do not edit below this line ############################\n");
mfprintf(fd,"!include $(SCIDIR1)\\config\\Makedll.incl \n");
mclose(fd);




















