.TH abinv 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
abinv -  AB invariant subspace
.SH CALLING SEQUENCE
.nf
[X,dims,F,U,k,Z]=abinv(Sys,alfa,beta,flag)
.fi
.SH PARAMETERS
.TP
Sys
: \fVsyslin\fR list containing the matrices \fV[A,B,C,D]\fR.
.TP
alfa 
: (optional) real number or vector (possibly complex, location of closed loop poles)
.TP
beta
: (optional) real number or vector (possibly complex, location of closed loop poles)
.TP
flag
: (optional) character string \fV'ge'\fR (default) or \fV'st'\fR or \fV'pp'\fR
.TP
X
: orthogonal matrix of size nx (dim of state space).
.TP
dims
:
integer row vector \fVdims=[dimR,dimVg,dimV,noc,nos]\fR with \fVdimR<=dimVg<=dimV<=noc<=nos\fR. If \fVflag='st'\fR, (resp. \fV'pp'\fR), \fVdims\fR has 4
(resp. 3) components.
.TP
F
: real matrix (state feedback)
.TP
k
: integer (normal rank of \fVSys\fR)
.TP
Z
: non-singular linear system (\fVsyslin\fR list)
.SH DESCRIPTION
Output nulling subspace (maximal unobservable subspace) for
\fVSys\fR = linear system defined by a syslin list containing
the matrices [A,B,C,D] of \fVSys\fR.
The vector \fVdims=[dimR,dimVg,dimV,noc,nos]\fR gives the dimensions
of subspaces defined as columns of \fVX\fR according to partition given
below.
The \fVdimV\fR first columns of \fVX\fR i.e \fVV=X(:,1:dimV)\fR, 
span the AB-invariant subspace of \fVSys\fR i.e the unobservable subspace of 
\fV(A+B*F,C+D*F)\fR. (\fVdimV=nx\fR  iff C^(-1)(D)=X).
.LP
The \fVdimR\fR first columns of \fVX\fR i.e. \fVR=X(:,1:dimR)\fR spans  
the controllable part of \fVSys\fR in \fVV\fR, \fV(dimR<=dimV)\fR. (\fVdimR=0\fR
for a left invertible system). \fVR\fR is the maximal controllability
subspace of \fVSys\fR in \fVkernel(C)\fR.
.LP
The \fVdimVg\fR first columns of \fVX\fR spans 
\fVVg\fR=maximal AB-stabilizable subspace of \fVSys\fR. \fV(dimR<=dimVg<=dimV)\fR.
.LP
\fVF\fR is a decoupling feedback: for \fVX=[V,X2] (X2=X(:,dimV+1:nx))\fR one has 
\fVX2'*(A+B*F)*V=0 and (C+D*F)*V=0\fR.
.LP
The zeros od \fVSys\fR are given by : \fVX0=X(:,dimR+1:dimV); spec(X0'*(A+B*F)*X0)\fR
i.e. there are \fVdimV-dimR\fR closed-loop fixed modes.
.LP
If the optional parameter \fValfa\fR is given as input, 
the \fVdimR\fR controllable modes of \fV(A+BF)\fR in \fVV\fR 
are set to \fValfa\fR (or to \fV[alfa(1), alfa(2), ...]\fR.
(\fValfa\fR can be a vector (real or complex pairs) or a (real) number).
Default value \fValfa=-1\fR.
.LP
If the optional real parameter \fVbeta\fR is given as input, 
the \fVnoc-dimV\fR controllable modes of \fV(A+BF)\fR "outside" \fVV\fR 
are set to \fVbeta\fR (or \fV[beta(1),beta(2),...]\fR). Default value \fVbeta=-1\fR.
.LP
In the \fVX,U\fR bases, the matrices 
\fV[X'*(A+B*F)*X,X'*B*U;(C+D*F)*X,D*U]\fR 
are displayed as follows:
.nf

[A11,*,*,*,*,*]  [B11 * ]
[0,A22,*,*,*,*]  [0   * ]
[0,0,A33,*,*,*]  [0   * ]
[0,0,0,A44,*,*]  [0  B42]
[0,0,0,0,A55,*]  [0   0 ]
[0,0,0,0,0,A66]  [0   0 ]

[0,0,0,*,*,*]    [0  D2]
.fi
where the X-partitioning is defined by \fVdims\fR and 
the U-partitioning is defined by \fVk\fR.
.LP
\fVA11\fR is \fV(dimR x dimR)\fR and has its eigenvalues set to \fValfa(i)'s\fR.
The pair \fV(A11,B11)\fR is controllable and \fVB11\fR has \fVnu-k\fR columns. 
\fVA22\fR is a stable \fV(dimVg-dimR x dimVg-dimR)\fR matrix.
\fVA33\fR is an unstable \fV(dimV-dimVg x dimV-dimVg)\fR matrix (see \fVst_ility\fR).
.LP
\fVA44\fR is \fV(noc-dimV x noc-dimV)\fR and has its eigenvalues set to \fVbeta(i)'s\fR.
The pair \fV(A44,B42)\fR is controllable. 
\fVA55\fR is a stable \fV(nos-noc x nos-noc)\fR matrix.
\fVA66\fR is an unstable \fV(nx-nos x nx-nos)\fR matrix (see \fVst_ility\fR).
.LP
\fVZ\fR is a column compression of \fVSys\fR and \fVk\fR is
the normal rank of \fVSys\fR i.e \fVSys*Z\fR is a column-compressed linear
system. \fVk\fR is the column dimensions of \fVB42,B52,B62\fR and \fVD2\fR.
\fV[B42;B52;B62;D2]\fR is full column rank and has rank \fVk\fR.
.LP
If \fVflag='st'\fR is given, a five blocks partition of the matrices is 
returned and \fRdims\fR has four components. If \fVflag='pp'\fR is 
given a four blocks partition is returned. In case \fVflag='ge'\fR one has
\fVdims=[dimR,dimVg,dimV,dimV+nc2,dimV+ns2]\fR where \fVnc2\fR 
(resp. \fVns2\fR) is the dimension of the controllable (resp. 
stabilizable) pair \fV(A44,B42)\fR (resp. (\fV[A44,*;0,A55],[B42;0])\fR).
In case \fVflag='st'\fR one has \fVdims=[dimR,dimVg,dimVg+nc,dimVg+ns]\fR
and in case \fVflag='pp'\fR one has \fVdims=[dimR,dimR+nc,dimR+ns]\fR.
\fVnc\fR (resp. \fVns\fR) is here the dimension of the controllable
(resp. stabilizable) subspace of the blocks 3 to 6 (resp. 2 to 6).
.LP
This function can be used for the (exact) disturbance decoupling problem.
.nf
DDPS:
   Find u=Fx+Rd=[F,R]*[x;d] which rejects Q*d and stabilizes the plant:

    xdot = Ax+Bu+Qd
       y = Cx+Du+Td

DDPS has a solution if Im(Q) is included in Vg + Im(B) and stabilizability
assumption is satisfied. 
Let G=(X(:,dimVg+1:$))'= left annihilator of Vg i.e. G*Vg=0;
B2=G*B; Q2=G*Q; DDPS solvable iff [B2;D]*R + [Q2;T] =0 has a solution.
The pair F,R  is the solution  (with F=output of abinv).
Im(Q2) is in Im(B2) means row-compression of B2=>row-compression of Q2
Then C*[(sI-A-B*F)^(-1)+D]*(Q+B*R) =0   (<=>G*(Q+B*R)=0)
.fi
.SH EXAMPLE
.nf
nu=3;ny=4;nx=7;
nrt=2;ngt=3;ng0=3;nvt=5;rk=2;
flag=list('on',nrt,ngt,ng0,nvt,rk);
Sys=ssrand(ny,nu,nx,flag);alfa=-1;beta=-2;
[X,dims,F,U,k,Z]=abinv(Sys,alfa,beta);
[A,B,C,D]=abcd(Sys);dimV=dims(3);dimR=dims(1);
V=X(:,1:dimV);X2=X(:,dimV+1:nx);
X2'*(A+B*F)*V
(C+D*F)*V
X0=X(:,dimR+1:dimV); spec(X0'*(A+B*F)*X0)
trzeros(Sys)
spec(A+B*F)   //nr=2 evals at -1 and noc-dimV=2 evals at -2.
clean(ss2tf(Sys*Z))
// 2nd Example
nx=6;ny=3;nu=2;
A=diag(1:6);A(2,2)=-7;A(5,5)=-9;B=[1,2;0,3;0,4;0,5;0,0;0,0];
C=[zeros(ny,ny),eye(ny,ny)];D=[0,1;0,2;0,3];
sl=syslin('c',A,B,C,D);//sl=ss2ss(sl,rand(6,6))*rand(2,2);
[A,B,C,D]=abcd(sl);  //The matrices of sl.
alfa=-1;beta=-2;
[X,dims,F,U,k,Z]=abinv(sl,alfa,beta);dimVg=dims(2);
clean(X'*(A+B*F)*X)
clean(X'*B*U)
clean((C+D*F)*X)
clean(D*U)
G=(X(:,dimVg+1:$))';
B2=G*B;nd=3;
R=rand(nu,nd);Q2T=-[B2;D]*R;
p=size(G,1);Q2=Q2T(1:p,:);T=Q2T(p+1:$,:);
Q=G\Q2;   //a valid [Q;T] since 
[G*B;D]*R + [G*Q;T]  // is zero
closed=syslin('c',A+B*F,Q+B*R,C+D*F,T+D*R); // closed loop: d-->y
ss2tf(closed)       // Closed loop is zero
spec(closed('A'))   //The plant is not stabilizable!
[ns,nc,W,sl1]=st_ility(sl);
[A,B,C,D]=abcd(sl1);A=A(1:ns,1:ns);B=B(1:ns,:);C=C(:,1:ns);
slnew=syslin('c',A,B,C,D);  //Now stabilizable
//Fnew=stabil(slnew('A'),slnew('B'),-11);
//slnew('A')=slnew('A')+slnew('B')*Fnew;
//slnew('C')=slnew('C')+slnew('D')*Fnew;
[X,dims,F,U,k,Z]=abinv(slnew,alfa,beta);dimVg=dims(2);
[A,B,C,D]=abcd(slnew);
G=(X(:,dimVg+1:$))';
B2=G*B;nd=3;
R=rand(nu,nd);Q2T=-[B2;D]*R;
p=size(G,1);Q2=Q2T(1:p,:);T=Q2T(p+1:$,:);
Q=G\Q2;   //a valid [Q;T] since 
[G*B;D]*R + [G*Q;T]  // is zero
closed=syslin('c',A+B*F,Q+B*R,C+D*F,T+D*R); // closed loop: d-->y
ss2tf(closed)       // Closed loop is zero
spec(closed('A'))
.fi
.SH AUTHOR
F.D.
.SH SEE ALSO
cainv, st_ility, ssrand, ss2ss, ddp



