.TH contour 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
contour - level curves on a 3D surface
.SH CALLING SEQUENCE
.nf
contour(x,y,z,nz,[theta,alpha,leg,flag,ebox,zlev])
contour(x,y,z,nz,<opt_args>)
.fi
.SH PARAMETERS
.TP 6
x,y 
: two real row vectors of size n1 and n2.
.TP 6
z   
: real matrix of size (n1,n2), the values of the function.
.TP 6
nz 
: the level values or the number of levels.
.RS
.TP 3
-
If \fVnz\fR is an integer, its value gives the number of level curves 
equally spaced from zmin to zmax as follows:
.nf
 z= zmin + (1:nz)*(zmax-zmin)/(nz+1)
.fi
Note that the \fVzmin\fR and \fVzmax\fR levels are not drawn 
(generically they are reduced to points) but they can be added 
with 
.nf 
 [im,jm] = find(z == zmin);     // or zmax 
 plot2d(x(im)',y(jm)',-9,"000")
.fi 
.TP
-
If \fVnz\fR is a vector, \fVnz(i)\fR gives the value of the ith level
curve. Note that it can be useful in order to see \fVzmin\fR and  
\fVzmax\fR level curves to add an epsilon tolerance: \fVnz=[ zmin+%eps,..,zmax-%eps]\fR.
.RE
.TP
<opt_args>
: a sequence of statements \fVkey1=value1,
key2=value2\fR, ... where keys may be
\fVtheta\fR,\fValpha\fR,\fVleg\fR,\fV flag\fR,
\fVebox\fR,\fVzlev\fR (see below). In this case, the order has no special meaning.
.TP 6
theta, alpha 
: real values giving in degree the spherical coordinates of 
the observation point.
.TP
leg 
: string defining the captions for each axis with @ as a field
separator, for example "X@Y@Z".
.TP
flag
: a real vector of size three \fVflag=[mode,type,box]\fR.
.RS 
.TP 5
mode 
: string (treatment of hidden parts).
.RS
.TP 
mode>0 
the hidden parts of the surface are removed and the surface is painted 
with color \fVmode\fR.
.TP
mode=0
the hidden parts of the surface are drawn.
.TP
mode<0
only the shadow of the surface is painted with color or pattern id
\fV-mode\fR. Use \fVxset()\fR to see the meaning of the ids.
.RE
.TP
type 
: an integer (scaling).
.RS 
.TP 8
type=0
the plot is made using the current 3D scaling (set by a previous call to
\fVparam3d\fR, \fVplot3d\fR, \fVcontour\fR or \fVplot3d1\fR).
.TP
type=1
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are specified by the value of the optional argument \fVebox\fR.
.TP
type=2
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are computed using the given data.
.TP
type=3
3d isometric with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=4
3d isometric bounds  derived from the data, to similarily\fVtype=2\fR
.TP
type=5
3d expanded isometric bounds  with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=6
3d expanded isometric bounds  derived from the data, similarily to \fVtype=2\fR
.RE
.TP
box
: an integer (frame around the plot).
.RS
.TP
box=0 
nothing is drawn around the plot.
.TP
box=1 
unimplemented (like box=0).
.TP
box=2 
only the axes behind the surface are drawn.
.TP
box=3 
a box surrounding the surface is drawn and captions are added.
.TP
box=4
a box surrounding the surface is drawn, captions and axes are added.
.RE
.RE
.TP
ebox
: used when \fVtype\fR in \fVflag\fR is 1. It specifies the boundaries
of the plot as the vector \fV[xmin,xmax,ymin,ymax,zmin,zmax]\fR.
.TP 6
zlev
: real number.
.SH DESCRIPTION
\fVcontour\fR draws level curves of a surface z=f(x,y). The level curves are
drawn on a 3D surface. The optional arguments are the same as for the function 
\fVplot3d\fR (except \fVzlev\fR) and their meanings are the same. 
They control the drawing of level curves on a 3D plot.
Only \fVflag(1)=mode\fR has a special meaning.
.RS
.TP 8
mode=0 
: the level curves are drawn on the surface defined by (x,y,z).
.TP
mode=1
: the level curves are drawn on a 3D plot and on the plan defined by 
the equation z=zlev.
.TP
mode=2 
: the level curves are drawn on a 2D plot.
.RE

You can change the format of the floating point number printed on the levels
by using \fVxset("fpf",string)\fR where \fVstring\fR gives the 
format in C format syntax (for example \fVstring="%.3f"\fR). Use 
\fVstring=""\fR to switch back to default format.
.LP
.LP
Usually we use \fVcontour2d\fR to draw levels curves on a 2D plot.

Enter the command \fVcontour()\fR to see a demo.
.SH EXAMPLE
.nf
t=%pi*[-10:10]/10;
deff("[z]=surf(x,y)","z=sin(x)*cos(y)"); z=feval(t,t,surf);
rect=[-%pi,%pi,-%pi,%pi,-1,1];
contour(t,t,z,10,35,45," ",[0,1,0],rect)
// changing the format of the printing of the levels
xset("fpf","%.2f")
xbasc()
contour(t,t,z,10,flag=[0,1,0],ebox=rect)
.fi
.SH SEE ALSO
contour2d, fcontour, fcontour2d, plot3d, xset
.SH AUTHOR
J.Ph.C.
