.TH auread 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
auread - load .au sound file
.SH CALLING SEQUENCE
.nf
y=auread(aufile)
y=auread(aufile,ext)
[y,Fs,bits]=auread(aufile)
[y,Fs,bits]=auread(aufile,ext)
.fi
.SH PARAMETERS
.TP
aufile
: string (The .au extension is appended if no extension is given)
.TP
Fs
.TP
: integer, frequency sampling in Hz.
.TP
ext
: string (\fV'size'\fR or \fV'snd'\fR) or integer (to read n samples) or 1 x 2 integer vector [n1,n2] (to read from n1 to n2).
.SH DESCRIPTION
Utility function to read \fV.au\fR sound file.
\fVauread(aufile)\fR loads a sound file specified by the string aufile,
returning the sampled data in y. Amplitude values are in the range
[-1,+1].
.LP
Supports multi-channel data in the following formats:
8-bit mu-law, 8-, 16-, and 32-bit linear, and floating point.
.LP
\fV[y,Fs,bits]=auread(aufile)\fR returns the sample rate (Fs) in Hertz
and the number of bits per sample used to encode the data in the file.
.LP
\fVauread(aufile,n)\fR returns the first n samples from each channel.
.LP
\fVauread(aufile,[n1,n2])\fR returns samples n1 to n2.
.LP
\fVauread(aufile,'size')\fR returns the size of the audio data contained
in the file in place of the actual audio data, returning the
vector as [samples channels].
.LP
\fVauread(aufile,'snd')\fR returns information about the sample and data
as a tlist.
.SH SEE ALSO
savewave,  analyze, mapsound
