.TH wavread 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
wavread - load .wav sound file
.SH CALLING SEQUENCE
.nf
y=wavread(wavfile)
y=wavread(wavfile,ext)
[y,Fs,bits]=wavread(wavfile)
[y,Fs,bits]=wavread(wavfile,ext)
.fi
.SH PARAMETERS
.TP
wavfile
: string (The .wav extension is appended if no extension is given)
.TP
Fs
: integer, frequency sampling in Hz.
.TP
ext
: string (\fV'size'\fR) or integer (to read n samples) or 1 x 2 integer vector [n1,n2] (to read from n1 to n2).
.SH DESCRIPTION
Utility function to read \fV.wav\fR sound file.
\fVwavread(wavfile)\fR loads a sound file specified by the string wavfile,
returning the sampled data in y. Amplitude values are in the range [-1,+1].
Supports multi-channel data in the following formats:
8-bit mu-law, 8-, 16-, and 32-bit linear, and floating point.
.LP
\fV[y,Fs,bits]=wavread(wavfile)\fR returns the sample rate (Fs) in Hertz
and the number of bits per sample used to encode the data in the file.
.LP
\fVwavread(wavfile,n)\fR returns the first n samples from each channel.
.LP
\fVwavread(wavfile,[n1,n2])\fR returns samples n1 to n2.
.LP
\fVread(wavfile,'size')\fR returns the size of the audio data contained
in the file in place of the actual audio data, returning the
vector as [samples channels].
.SH SEE ALSO
auread, savewave,  analyze, mapsound
