.TH bifish 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
bifish - shows a bifurcation diagram in a fish population discrete time model 
.SH CALLING SEQUENCE
.nf
bifish([f_ch])
.fi
.SH PARAMETERS
.TP
f_ch 
: can be one of \fVfish\fR, \fVfishr\fR and \fVfishr2\fR. This option selects the population model.
.SH DESCRIPTION
The dynamical system \fVfish\fR is the following :
.nf
           y=b*exp(-0.1*(x(k)_1+x(k)_2));
           x(k+1)=[ y 2*y ; s 0.0]*x(k);
.fi
and the parameters \fVs\fR evolves to show the bifurcation diagram.
\fVfishr\fR and \fVfishr2\fR are constructed as above but with added white noises.
.nf
	fishr
	y=b*exp(-0.1*(xk(1)+xk(2))) 
	xkp1=[ y 2*y ; s*(1+0.1*(rand()-0.5)) 0.0]*xk

	fishr2
	z=exp(-0.1*(xk(1)+xk(2))) 
	xkp1=[ b*z**(1+0.1*(rand()-0.5)) 2*b*z**(1+0.1*(rand()-0.5)) ; s 0.0]*xk
.fi
The three macros \fVfish, fishr, fishr2\fR are loaded in Scilab when calling \fVbifish\fR.
.SH SEE ALSO
ode



