model Source
  parameter Real P0=300000 "Pression de la source";
  parameter Real T0=290 "Temprature de la source";
  parameter Real H0=100000 "Enthalpie spcifique de la source";
  parameter Real option_temperature=1 "1:temprature fixe - 2:enthalpie fixe";
   
  Real Pm "Pression moyenne";
  Real Q "Dbit";
  Real Tm "Temprature moyenne";
  Real Hm "Enthalpie spcifique moyenne";

public 
  PortPHQ2 C ;
equation 
  
  C.P = Pm;
  C.Q = Q;
  C.Hm = Hm;

  Pm = P0;

  Hm = H0;
  
  Tm = if (option_temperature <= 1) then T0 else Hm/4187 + 273.15;
  
end Source;
