package test.contrib;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.SteelBlueColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class CustomSkin {

	protected static class MySkin extends SubstanceAbstractSkin {
		public String getDisplayName() {
			return "My Skin";
		}

		public MySkin() {
			SubstanceTheme activeTheme = new SubstanceTheme(
					new SteelBlueColorScheme(), "Tint Steel Blue",
					ThemeKind.COLD).tint(0.15);
			SubstanceTheme defaultTheme = new SubstanceTheme(
					new MetallicColorScheme(), "Tint Metallic", ThemeKind.COLD)
					.tint(0.05);
			SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme();
			SubstanceTheme activeTitleTheme = activeTheme;

			SubstanceComplexTheme theme = new SubstanceComplexTheme(
					"Custom skin", ThemeKind.COLD, activeTheme, defaultTheme,
					disabledTheme, activeTitleTheme);
			theme.registerComponentStateTheme(defaultTheme, false,
					ComponentState.ROLLOVER_UNSELECTED);
			theme.registerComponentStateTheme(activeTheme, false,
					ComponentState.ROLLOVER_SELECTED);

			this.theme = theme;
			this.buttonShaper = new ClassicButtonShaper();
			this.watermark = new SubstanceNullWatermark();
			this.gradientPainter = new ClassicGradientPainter();
			this.borderPainter = new ClassicBorderPainter();
		}
	}

	public CustomSkin() throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SubstanceLookAndFeel.setSkin(new MySkin());

		JFrame.setDefaultLookAndFeelDecorated(true);

		JFrame f = new JFrame();
		f.setSize(200, 150);

		JPanel panel = new JPanel();
		panel.add(new JButton("Button 1"));
		panel.add(new JToggleButton("Button 2"));

		JMenuBar jmb = new JMenuBar();
		JMenu menu = new JMenu("Menu");
		menu.add(new JMenuItem("Sample"));
		menu.add(new JMenuItem("Sample"));
		menu.add(new JMenuItem("Sample"));
		menu.add(new JMenuItem("Sample"));
		jmb.add(menu);
		f.setJMenuBar(jmb);

		f.add(panel);
		f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					new CustomSkin();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
}
