package test.contrib;

import java.awt.BorderLayout;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TextAreaBorder extends JFrame {

	public TextAreaBorder() {
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setLayout(new BorderLayout());
		this.add(new JLabel("JTextArea with no extra elements"),
				BorderLayout.PAGE_START);
		JTextArea jta = new JTextArea("I am a JTextArea");
		jta.setEditable(false);
		jta.setOpaque(false);
		jta.setBorder(BorderFactory.createEmptyBorder());
		JPanel panel = new JPanel();
		panel.add(jta);
		this.add(panel, BorderLayout.CENTER);
		this.setBounds(50, 50, 200, 200);
		this.pack();
		this.setVisible(true);
	}

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (UnsupportedLookAndFeelException ex) {
			ex.printStackTrace();
		}
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TextAreaBorder();
			}
		});
	}

}