/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private TreeItem currentItem = null;
    private int currentEffect = 0;
    private TreeItem[] selection = new TreeItem[0];

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
    }

    void show(int n, int n2, int n3) {
        TreeItem treeItem = null;
        if (n != 0) {
            treeItem = this.findItem(n2, n3);
        }
        if (treeItem == null) {
            n = 0;
        }
        if (this.currentEffect != n && this.currentEffect == 0) {
            this.selection = this.tree.getSelection();
            this.tree.setSelection(new TreeItem[0]);
        }
        boolean bl = this.currentEffect != n && n == 0;
        this.setDragUnderEffect(n, treeItem);
        if (bl) {
            this.tree.setSelection(this.selection);
            this.selection = new TreeItem[0];
        }
    }

    private TreeItem findItem(int n, int n2) {
        Point point = new Point(n, n2);
        point = this.tree.toControl(point);
        return this.tree.getItem(point);
    }

    private void setDragUnderEffect(int n, TreeItem treeItem) {
        switch (n) {
            case 1: {
                if (this.currentEffect == 4 || this.currentEffect == 2) {
                    this.setInsertMark(null, false);
                    this.currentEffect = 0;
                    this.currentItem = null;
                }
                if (this.currentEffect == n && this.currentItem == treeItem) break;
                this.setDropSelection(treeItem);
                this.currentEffect = 1;
                this.currentItem = treeItem;
                break;
            }
            case 2: 
            case 4: {
                if (this.currentEffect == 1) {
                    this.setDropSelection(null);
                    this.currentEffect = 0;
                    this.currentItem = null;
                }
                if (this.currentEffect == n && this.currentItem == treeItem) break;
                this.setInsertMark(treeItem, n == 4);
                this.currentEffect = n;
                this.currentItem = treeItem;
                break;
            }
            default: {
                if (this.currentEffect == 4 || this.currentEffect == 2) {
                    this.setInsertMark(null, false);
                }
                if (this.currentEffect == 1) {
                    this.setDropSelection(null);
                }
                this.currentEffect = 0;
                this.currentItem = null;
            }
        }
    }

    private void setDropSelection(TreeItem treeItem) {
        if (treeItem == null) {
            this.tree.setSelection(new TreeItem[0]);
        } else {
            this.tree.setSelection(new TreeItem[]{treeItem});
        }
    }

    private void setInsertMark(TreeItem treeItem, boolean bl) {
    }
}

