/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    Image image;
    static final int ButtonProc;
    static final TCHAR ButtonClass;
    static final int CheckWidth;
    static final int CheckHeight;

    static {
        Object object;
        ButtonClass = new TCHAR(0, "BUTTON", true);
        int n = OS.LoadBitmap(0, 32759);
        if (n == 0) {
            CheckWidth = OS.GetSystemMetrics(OS.IsWinCE ? 49 : 2);
            CheckHeight = OS.GetSystemMetrics(OS.IsWinCE ? 50 : 20);
        } else {
            object = new BITMAP();
            OS.GetObject(n, 24, (BITMAP)object);
            OS.DeleteObject(n);
            CheckWidth = ((BITMAP)object).bmWidth / 4;
            CheckHeight = ((BITMAP)object).bmHeight / 3;
        }
        object = new WNDCLASS();
        OS.GetClassInfo(0, ButtonClass, (WNDCLASS)object);
        ButtonProc = ((WNDCLASS)object).lpfnWndProc;
    }

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ButtonProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        if (((n = Widget.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Widget.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Widget.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Widget.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        OS.SendMessage(this.handle, 245, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                n4 += OS.GetSystemMetrics(2);
                n5 += OS.GetSystemMetrics(20);
            } else {
                n4 += OS.GetSystemMetrics(21);
                n5 += OS.GetSystemMetrics(3);
            }
            if (n != -1) {
                n4 = n;
            }
            if (n2 != -1) {
                n5 = n2;
            }
            return new Point(n4 += n3 * 2, n5 += n3 * 2);
        }
        int n6 = 0;
        int n7 = OS.GetWindowLong(this.handle, -16);
        if ((n7 & 0xC0) == 0) {
            int n8 = 0;
            int n9 = OS.GetDC(this.handle);
            int n10 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n10 != 0) {
                n8 = OS.SelectObject(n9, n10);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n9, tEXTMETRIC);
            int n11 = OS.GetWindowTextLength(this.handle);
            if (n11 == 0) {
                n5 += tEXTMETRIC.tmHeight;
            } else {
                n6 = Math.max(8, tEXTMETRIC.tmAveCharWidth);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n11 + 1);
                OS.GetWindowText(this.handle, tCHAR, n11 + 1);
                RECT rECT = new RECT();
                int n12 = 1056;
                OS.DrawText(n9, tCHAR, n11, rECT, n12);
                n4 += rECT.right - rECT.left;
                n5 += rECT.bottom - rECT.top;
            }
            if (n10 != 0) {
                OS.SelectObject(n9, n8);
            }
            OS.ReleaseDC(this.handle, n9);
        } else if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            n4 = rectangle.width;
            n5 = rectangle.height;
            n6 = 8;
        }
        if ((this.style & 0x30) != 0) {
            n4 += CheckWidth + n6;
            n5 = Math.max(n5, CheckHeight + 3);
        }
        if ((this.style & 0xA) != 0) {
            n4 += 12;
            n5 += 10;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        return new Point(n4 += n3 * 2, n5 += n3 * 2);
    }

    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNTEXT);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 1) != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int n = OS.SendMessage(this.handle, 240, 0, 0);
        return (n & 1) != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    boolean isTabItem() {
        return super.isTabItem();
    }

    boolean mnemonicHit(char c) {
        if (!this.setFocus()) {
            return false;
        }
        if ((this.style & 0x10) == 0) {
            this.click();
        }
        return true;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (this != control) {
                control.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n2 = OS.GetWindowLong(this.handle, -16);
        n2 &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            n2 |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n2 |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n2 |= 0x200;
        }
        OS.SetWindowLong(this.handle, -16, n2);
        OS.InvalidateRect(this.handle, null, true);
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        int n = this.menuShell().handle;
        int n2 = OS.GetWindowLong(this.handle, -16);
        if (bl) {
            n2 |= 1;
            OS.SendMessage(n, 1025, this.handle, 0);
        } else {
            n2 &= 0xFFFFFFFE;
            OS.SendMessage(n, 1025, 0, 0);
        }
        OS.SendMessage(this.handle, 244, n2, 1);
    }

    public void setImage(Image image) {
        int n;
        this.checkWidget();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            n2 = image.handle;
            switch (image.type) {
                case 0: {
                    n3 = 128;
                    n4 = 0;
                    break;
                }
                case 1: {
                    n3 = 64;
                    n4 = 1;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        int n5 = n = OS.GetWindowLong(this.handle, -16);
        n &= 0xFFFFFF3F;
        if ((n |= n3) != n5) {
            OS.SetWindowLong(this.handle, -16, n);
        }
        OS.SendMessage(this.handle, 247, n4, n2);
    }

    boolean setRadioFocus() {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return this.setFocus();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    boolean setSavedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setSavedFocus();
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int n = bl ? 1 : 0;
        int n2 = OS.GetWindowLong(this.handle, -16);
        OS.SendMessage(this.handle, 241, n, 0);
        OS.SetWindowLong(this.handle, -16, n2);
    }

    public void setText(String string) {
        int n;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        if ((n &= 0xFFFFFF3F) != (n2 = (n = OS.GetWindowLong(this.handle, -16)))) {
            OS.SetWindowLong(this.handle, -16, n);
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return n | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            n |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 0x200;
        }
        if ((this.style & 8) != 0) {
            return n | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return n | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return n | 4;
        }
        if ((this.style & 2) != 0) {
            return n | 0x1000 | 2;
        }
        return n | 0x10000;
    }

    TCHAR windowClass() {
        return ButtonClass;
    }

    int windowProc() {
        return ButtonProc;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256);
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        int n3 = 0;
        if ((this.style & 0x10) != 0) {
            n3 = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, n3);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = n >> 16;
        switch (n3) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.postEvent(13);
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmDrawChild(int n, int n2) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(n, n2);
        }
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, 48);
        int n3 = 2;
        switch (this.style & 0x24480) {
            case 128: {
                n3 = 0;
                break;
            }
            case 1024: {
                n3 = 1;
                break;
            }
            case 16384: {
                n3 = 2;
                break;
            }
            case 131072: {
                n3 = 3;
            }
        }
        if (!this.getEnabled()) {
            n3 |= 0x100;
        }
        if ((this.style & 0x800000) == 0x800000) {
            n3 |= 0x4000;
        }
        if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
            n3 |= 0x200;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, dRAWITEMSTRUCT.bottom);
        OS.DrawFrameControl(dRAWITEMSTRUCT.hDC, rECT, 3, n3);
        return null;
    }
}

