/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreCharacter;
    int visibleCount = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.SendMessage(this.handle, 323, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 330, n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n2 == -1) {
            this.error(14);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ComboProc, this.handle, n, n2, n3);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Widget.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n == -1) {
            n5 = 0;
            n4 = OS.GetDC(this.handle);
            n3 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n3 != 0) {
                n5 = OS.SelectObject(n4, n3);
            }
            int n9 = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rECT = new RECT();
            int n10 = 3072;
            if ((this.style & 8) == 0) {
                n10 |= 0x2000;
            }
            int n11 = OS.GetWindowTextLength(this.handle);
            int n12 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n12, n11 + 1);
            OS.GetWindowText(this.handle, tCHAR, n11 + 1);
            OS.DrawText(n4, tCHAR, n11, rECT, n10);
            n6 = Math.max(n6, rECT.right - rECT.left);
            int n13 = 0;
            while (n13 < n9) {
                n11 = OS.SendMessage(this.handle, 329, n13, 0);
                if (n11 != -1) {
                    int n14;
                    if (n11 + 1 > tCHAR.length()) {
                        tCHAR = new TCHAR(n12, n11 + 1);
                    }
                    if ((n14 = OS.SendMessage(this.handle, 328, n13, tCHAR)) != -1) {
                        OS.DrawText(n4, tCHAR, n11, rECT, n10);
                        n6 = Math.max(n6, rECT.right - rECT.left);
                    }
                }
                ++n13;
            }
            if ((this.style & 8) != 0) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n4, tEXTMETRIC);
                n8 = tEXTMETRIC.tmInternalLeading;
            }
            if (n3 != 0) {
                OS.SelectObject(n4, n5);
            }
            OS.ReleaseDC(this.handle, n4);
        }
        if (n2 == -1 && (this.style & 0x40) != 0) {
            n3 = OS.SendMessage(this.handle, 326, 0, 0);
            n5 = OS.SendMessage(this.handle, 340, 0, 0);
            n7 = n3 * n5;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n != -1) {
            n6 = n;
        }
        if (n2 != -1) {
            n7 = n2;
        }
        if ((this.style & 8) != 0) {
            n6 += n8 * 2;
        } else {
            n3 = OS.GetDlgItem(this.handle, 1001);
            if (n3 != 0) {
                n5 = OS.SendMessage(n3, 212, 0, 0);
                n4 = (n5 & 0xFFFF) + (n5 >> 16 & 0xFFFF);
                n6 += n4 + 3;
            }
        }
        n3 = OS.GetSystemMetrics(45);
        n5 = OS.SendMessage(this.handle, 340, -1, 0);
        n7 = (this.style & 4) != 0 ? n5 + 6 : (n7 += n5 + 10);
        return new Point(n6 += OS.GetSystemMetrics(2) + n3 * 2, n7);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createHandle() {
        int n;
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLong(n2, -4);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLong(n, -4);
        }
        if ((this.style & 0x40) != 0) {
            int n3 = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, n3);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n3);
        }
    }

    public void cut() {
        this.checkWidget();
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        int n;
        super.deregister();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.removeControl(n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(n);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 327, 0, 0);
        if (n != n2) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    public String getItem(int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 329, n, 0);
        if (n3 != -1 && (n2 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(this.getCodePage(), n3 + 1))) != -1) {
            return tCHAR.toString(0, n3);
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n >= 0 && n < n4) {
            this.error(8);
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 326, 0, 0);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 340, 0, 0);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    public int getTextHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 340, -1, 0);
        if (n == -1) {
            this.error(11);
        }
        return n + 6;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.GetDlgItem(this.handle, 1001);
        if (n == 0) {
            return LIMIT;
        }
        return OS.SendMessage(n, 213, 0, 0);
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    boolean hasFocus() {
        int n = OS.GetFocus();
        if (n == this.handle) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n == n2) {
            return true;
        }
        int n3 = OS.GetDlgItem(this.handle, 1000);
        return n == n3;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                if (string.equals(this.getItem(n3))) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n >= n4) {
            return -1;
        }
        int n5 = n - 1;
        int n6 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n5 = OS.SendMessage(this.handle, 344, n6 = n5, tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    public void paste() {
        this.checkWidget();
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    void register() {
        int n;
        super.register();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.addControl(n2, this);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(n, this);
        }
    }

    public void remove(int n) {
        int n2;
        this.checkWidget();
        int n3 = OS.GetWindowTextLength(this.handle);
        int n4 = OS.SendMessage(this.handle, 324, n, 0);
        if (n4 == -1) {
            n2 = OS.SendMessage(this.handle, 326, 0, 0);
            if (n >= 0 && n < n2) {
                this.error(15);
            }
            this.error(6);
        }
        if (n3 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n2 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        int n5 = n;
        while (n5 <= n2) {
            int n6 = OS.SendMessage(this.handle, 324, n, 0);
            if (n6 == -1) {
                this.error(15);
            }
            ++n5;
        }
        if (n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n3 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
    }

    public void remove(String string) {
        int n = this.indexOf(string, 0);
        if (n == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n >= 0 && n < n2) {
            int n3 = OS.SendMessage(this.handle, 327, 0, 0);
            int n4 = OS.SendMessage(this.handle, 334, n, 0);
            if (n4 != -1 && n4 != n3) {
                this.sendEvent(24);
            }
        }
    }

    void setBackgroundPixel(int n) {
        int n2;
        if (this.background == n) {
            return;
        }
        super.setBackgroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 4) != 0) {
            int n6 = OS.SendMessage(this.handle, 340, -1, 0);
            int n7 = OS.SendMessage(this.handle, 340, 0, 0);
            n4 = n6 + 6 + n7 * this.visibleCount + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0, rECT) != 0) {
                int n8 = rECT.right - rECT.left;
                int n9 = rECT.bottom - rECT.top;
                if (n8 == n3 && n9 == n4) {
                    n5 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
            return;
        }
        if (this.parent.lpwp != null || (n5 & 1) != 0 || !OS.IsWindowVisible(this.handle)) {
            super.setBounds(n, n2, n3, n4, n5);
            return;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        super.setBounds(n, n2, n3, n4, n5);
        int n10 = rECT.right - rECT.left;
        int n11 = rECT.bottom - rECT.top;
        if (n10 != n3 || n11 != n4) {
            if (OS.IsWinCE) {
                int n12;
                int n13 = OS.GetDlgItem(this.handle, 1001);
                if (n13 != 0) {
                    OS.InvalidateRect(n13, null, true);
                }
                if ((n12 = OS.GetDlgItem(this.handle, 1000)) != 0) {
                    OS.InvalidateRect(n12, null, true);
                }
            } else {
                int n14 = 133;
                OS.RedrawWindow(this.handle, null, 0, n14);
            }
        }
    }

    void setForegroundPixel(int n) {
        int n2;
        if (this.foreground == n) {
            return;
        }
        super.setForegroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.remove(n);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int n = this.getCodePage();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            TCHAR tCHAR = new TCHAR(n, string, true);
            int n3 = OS.SendMessage(this.handle, 323, 0, tCHAR);
            if (n3 == -1) {
                this.error(14);
            }
            if (n3 == -2) {
                this.error(14);
            }
            ++n2;
        }
        this.sendEvent(24);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        int n3 = 0x6000000;
        if ((n & n3) == 0 || (n & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n & n3;
        int n4 = OS.GetWindowLong(this.handle, -20);
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
            n4 |= 0x400000;
        } else {
            this.style &= 0xF7FFFFFF;
            n4 &= 0xFFBFFFFF;
        }
        OS.SetWindowLong(this.handle, -20, n4);
        int n5 = 0;
        int n6 = 0;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = 52;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n5 = cOMBOBOXINFO.hwndItem;
            n6 = cOMBOBOXINFO.hwndList;
        }
        if (n5 != 0) {
            n2 = OS.GetWindowLong(n5, -20);
            int n7 = OS.GetWindowLong(n5, -16);
            if ((this.style & 0x4000000) != 0) {
                n2 |= 0x3000;
                n7 |= 2;
            } else {
                n2 &= 0xFFFFCFFF;
                n7 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(n5, -20, n2);
            OS.SetWindowLong(n5, -16, n7);
            RECT rECT = new RECT();
            OS.GetWindowRect(n5, rECT);
            int n8 = rECT.right - rECT.left;
            int n9 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n10 = rECT.right - rECT.left;
            int n11 = rECT.bottom - rECT.top;
            int n12 = 22;
            this.SetWindowPos(n5, 0, 0, 0, n8 - 1, n9 - 1, n12);
            this.SetWindowPos(this.handle, 0, 0, 0, n10 - 1, n11 - 1, n12);
            this.SetWindowPos(n5, 0, 0, 0, n8, n9, n12);
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (n6 != 0) {
            n2 = OS.GetWindowLong(n6, -20);
            n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
            OS.SetWindowLong(n6, -20, n2);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = point.x | point.y << 16;
        OS.SendMessage(this.handle, 322, 0, n);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
            return;
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        if (OS.SetWindowText(this.handle, tCHAR)) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 321, n, 0);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        if ((this.style & 4) != 0) {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n2 = 54;
            this.setBounds(0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
        }
    }

    void subclass() {
        int n;
        super.subclass();
        int n2 = this.display.windowProc;
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.SetWindowLong(n3, -4, n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLong(n, -4, n2);
        }
    }

    boolean translateTraversal(MSG mSG) {
        switch (mSG.wParam) {
            case 13: 
            case 27: {
                if (OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    boolean traverseEscape() {
        if (OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    void unsubclass() {
        int n;
        super.unsubclass();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0 && EditProc != 0) {
            OS.SetWindowLong(n2, -4, EditProc);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLong(n, -4, ListProc);
        }
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x400 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n | 1;
        }
        if ((this.style & 8) != 0) {
            return n | 3;
        }
        return n | 2;
    }

    TCHAR windowClass() {
        return ComboClass;
    }

    int windowProc() {
        return ComboProc;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n != this.handle) {
            int n5 = OS.GetDlgItem(this.handle, 1001);
            int n6 = OS.GetDlgItem(this.handle, 1000);
            if (n5 != 0 && n == n5 || n6 != 0 && n == n6) {
                LRESULT lRESULT = null;
                switch (n2) {
                    case 258: {
                        lRESULT = this.WM_CHAR(n3, n4);
                        break;
                    }
                    case 646: {
                        lRESULT = this.WM_IME_CHAR(n3, n4);
                        break;
                    }
                    case 256: {
                        lRESULT = this.WM_KEYDOWN(n3, n4);
                        break;
                    }
                    case 257: {
                        lRESULT = this.WM_KEYUP(n3, n4);
                        break;
                    }
                    case 262: {
                        lRESULT = this.WM_SYSCHAR(n3, n4);
                        break;
                    }
                    case 260: {
                        lRESULT = this.WM_SYSKEYDOWN(n3, n4);
                        break;
                    }
                    case 261: {
                        lRESULT = this.WM_SYSKEYUP(n3, n4);
                        break;
                    }
                    case 123: {
                        lRESULT = this.WM_CONTEXTMENU(this.handle, n4);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                int n7 = n == n5 ? EditProc : ListProc;
                return OS.CallWindowProc(n7, n, n2, n3, n4);
            }
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_CHAR(int n, int n2) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                this.postEvent(14);
            }
            case 27: {
                if (OS.SendMessage(this.handle, 343, 0, 0) != 0) break;
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_CTLCOLOR(int n, int n2) {
        return this.wmColorChild(n, n2);
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        int n3 = this.callWindowProc(135, n, n2);
        return new LRESULT(n3 | 1);
    }

    LRESULT WM_IME_CHAR(int n, int n2) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n, n2)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n3 = this.callWindowProc(646, n, n2);
        MSG mSG = new MSG();
        int n4 = 10420227;
        while (OS.PeekMessage(mSG, this.handle, 258, 258, n4)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n, n2);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n3);
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        return null;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        return null;
    }

    LRESULT WM_SIZE(int n, int n2) {
        int n3;
        if ((this.style & 8) != 0 || (this.style & 4) == 0) {
            return super.WM_SIZE(n, n2);
        }
        int n4 = OS.SendMessage(this.handle, 327, 0, 0);
        boolean bl = false;
        TCHAR tCHAR = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (n4 == -1 && (n3 = OS.GetWindowTextLength(this.handle)) != 0) {
            tCHAR = new TCHAR(this.getCodePage(), n3 + 1);
            OS.GetWindowText(this.handle, tCHAR, n3 + 1);
            nArray = new int[1];
            nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            boolean bl2 = bl = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            if (bl) {
                this.setRedraw(false);
            }
        }
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (tCHAR != null) {
            OS.SetWindowText(this.handle, tCHAR);
            int n5 = nArray[0] | nArray2[0] << 16;
            OS.SendMessage(this.handle, 322, 0, n5);
            if (bl) {
                this.setRedraw(true);
            }
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = n >> 16;
        switch (n3) {
            case 5: {
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n4 = OS.SendMessage(this.handle, 327, 0, 0);
                if (n4 != -1) {
                    OS.SendMessage(this.handle, 334, n4, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.postEvent(13);
                break;
            }
            case 3: 
            case 4: {
                this.sendFocusEvent(n3 == 3 ? 15 : 16, -1);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(n, n2);
    }
}

