#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int do_drag_scale(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static int result;
	static int dragging;
	static tree dragtree;
	static treetypedata td;
	static int offx, offy, oldx, oldy;
	static tree lasttree;
	static unsigned long lasttime, thistime;

	result=0;

	if(installing)
	{
		lasttree=NULL;
		dragging=0;
		canvas_add_event_function(do_drag_scale, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_scale);
		return(1);
	}
	else if(printing) printf("zdragscale\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				dragtree=(tree)which_scale_bar(c, x, y);
				if(dragtree!=NULL && !globals->autoformat)
				{
					thistime=tevent_time(e);
					if(dragtree==lasttree && thistime-lasttime<DBLCLICK)
					{
						show_scale_info_frame();
						lasttree=NULL;
						result=1;
					}
					else
					{
						lasttree=dragtree;
						lasttime=thistime;

						dragging=1;
						install_dragging_function(do_drag_scale);
						td=tdta(dragtree)->td;
						offx=x-td->px;
						offy=y-td->py;
						oldx=x;
						oldy=y;
						drag_scale_bar(dragtree, x-offx, y-offy, c);
						result=1;
					}
				}
			}
			else
				result=1;
			break;
		case te_mouseup:
			if(dragging)
			{
				dragging=0;
				uninstall_dragging_function(do_drag_scale);
				drag_scale_bar(dragtree, oldx-offx, oldy-offy, c);
				x=x-offx;
				y=y-offy;
				do_command(SetScaleBarPosition, dragtree, NULL, 0.0, 0.0,
					x, y, 0, 0, 0);
				result=1;
			}
			break;
		case te_drag:
			if(dragging)
			{
				/* drag scale bar */
				drag_scale_bar(dragtree, oldx-offx, oldy-offy, c);
				oldx=x;
				oldy=y;
				drag_scale_bar(dragtree, oldx-offx, y-offy, c);
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
