/* bzflag
 * Copyright (c) 1993-2025 Tim Riker
 *
 * This package is free software;  you can redistribute it and/or
 * modify it under the terms of the license found in the file
 * named COPYING that should have accompanied this file.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef __CUSTOMGATE_H__
#define __CUSTOMGATE_H__

/* interface header */
#include "WorldFileObstacle.h"

/* system interface headers */
#include <string>
#include <iostream>

/* local interface headers */
#include "WorldInfo.h"


class CustomGate : public WorldFileObstacle
{
public:
    CustomGate(const char* telename);
    bool read(const char *cmd, std::istream&) override;
    void writeToGroupDef(GroupDefinition*) override;

protected:
    std::string telename;
    float border;
    bool horizontal;
};

#endif  /* __CUSTOMGATE_H__ */

// Local variables: ***
// mode: C++ ***
// tab-width: 4***
// c-basic-offset: 4 ***
// indent-tabs-mode: nil ***
// End: ***
// ex: shiftwidth=4 tabstop=4
