/*
 *	This file was automatically generated by fluxcomp; DO NOT EDIT!
 */
/*
   (c) Copyright 2012-2013  DirectFB integrated media GmbH
   (c) Copyright 2001-2013  The world wide DirectFB Open Source Community (directfb.org)
   (c) Copyright 2000-2004  Convergence (integrated media) GmbH

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Shimokawa <andi@directfb.org>,
              Marek Pikarski <mass@directfb.org>,
              Sven Neumann <neo@directfb.org>,
              Ville Syrjälä <syrjala@sci.fi> and
              Claudio Ciccani <klan@users.sf.net>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <config.h>

#include "SaWManProcess.h"

extern "C" {
#include <directfb_util.h>

#include <direct/debug.h>
#include <direct/mem.h>
#include <direct/memcpy.h>
#include <direct/messages.h>

#include <fusion/conf.h>

#include <core/core.h>

#include <core/CoreDFB_CallMode.h>
}

D_DEBUG_DOMAIN( DirectFB_SaWManProcess, "DirectFB/SaWManProcess", "DirectFB SaWManProcess" );

/*********************************************************************************************************************/

DFBResult
SaWManProcess_SetExiting(
                    SaWManProcess                             *obj

)
{
    DFBResult ret;

    switch (CoreDFB_CallMode( core_dfb )) {
        case COREDFB_CALL_DIRECT:{
            DirectFB::ISaWManProcess_Real real( core_dfb, obj );

            Core_PushCalling();
            ret = real.SetExiting(  );
            Core_PopCalling();

            return ret;
        }
        case COREDFB_CALL_INDIRECT: {
            DirectFB::ISaWManProcess_Requestor requestor( core_dfb, obj );

            Core_PushCalling();
            ret = requestor.SetExiting(  );
            Core_PopCalling();

            return ret;
        }
        case COREDFB_CALL_DENY:
            return DFB_DEAD;
    }

    return DFB_UNIMPLEMENTED;
}

DFBResult
SaWManProcess_RegisterManager(
                    SaWManProcess                             *obj,
                    const SaWManRegisterManagerData           *data,
                    SaWManManager                            **ret_manager
)
{
    DFBResult ret;

    switch (CoreDFB_CallMode( core_dfb )) {
        case COREDFB_CALL_DIRECT:{
            DirectFB::ISaWManProcess_Real real( core_dfb, obj );

            Core_PushCalling();
            ret = real.RegisterManager( data, ret_manager );
            Core_PopCalling();

            return ret;
        }
        case COREDFB_CALL_INDIRECT: {
            DirectFB::ISaWManProcess_Requestor requestor( core_dfb, obj );

            Core_PushCalling();
            ret = requestor.RegisterManager( data, ret_manager );
            Core_PopCalling();

            return ret;
        }
        case COREDFB_CALL_DENY:
            return DFB_DEAD;
    }

    return DFB_UNIMPLEMENTED;
}

/*********************************************************************************************************************/

static FusionCallHandlerResult
SaWManProcess_Dispatch( int           caller,   /* fusion id of the caller */
                     int           call_arg, /* optional call parameter */
                     void         *ptr, /* optional call parameter */
                     unsigned int  length,
                     void         *ctx,      /* optional handler context */
                     unsigned int  serial,
                     void         *ret_ptr,
                     unsigned int  ret_size,
                     unsigned int *ret_length )
{
    SaWManProcess *obj = (SaWManProcess*) ctx;
    DirectFB::SaWManProcessDispatch__Dispatch( obj, caller, call_arg, ptr, length, ret_ptr, ret_size, ret_length );

    return FCHR_RETURN;
}

void SaWManProcess_Init_Dispatch(
                    CoreDFB              *core,
                    SaWManProcess        *obj,
                    FusionCall           *call
)
{
    fusion_call_init3( call, SaWManProcess_Dispatch, obj, core->world );
}

void  SaWManProcess_Deinit_Dispatch(
                    FusionCall           *call
)
{
     fusion_call_destroy( call );
}

/*********************************************************************************************************************/

namespace DirectFB {


static __inline__ void *args_alloc( void *static_buffer, size_t size )
{
    void *buffer = static_buffer;

    if (size > FLUXED_ARGS_BYTES) {
        buffer = D_MALLOC( size );
        if (!buffer)
            return NULL;
    }

    return buffer;
}

static __inline__ void args_free( void *static_buffer, void *buffer )
{
    if (buffer != static_buffer)
        D_FREE( buffer );
}


DFBResult
ISaWManProcess_Requestor::SetExiting(

)
{
    DFBResult           ret = DFB_OK;
    char        args_static[FLUXED_ARGS_BYTES];
    char        return_args_static[FLUXED_ARGS_BYTES];
    SaWManProcessSetExiting       *args = (SaWManProcessSetExiting*) args_alloc( args_static, sizeof(SaWManProcessSetExiting) );
    SaWManProcessSetExitingReturn *return_args;

    if (!args)
        return (DFBResult) D_OOM();

    return_args = (SaWManProcessSetExitingReturn*) args_alloc( return_args_static, sizeof(SaWManProcessSetExitingReturn) );

    if (!return_args) {
        args_free( args_static, args );
        return (DFBResult) D_OOM();
    }

    D_DEBUG_AT( DirectFB_SaWManProcess, "ISaWManProcess_Requestor::%s()\n", __FUNCTION__ );



    ret = (DFBResult) SaWManProcess_Call( obj, FCEF_NONE, SaWManProcess_SetExiting, args, sizeof(SaWManProcessSetExiting), return_args, sizeof(SaWManProcessSetExitingReturn), NULL );
    if (ret) {
        D_DERROR( ret, "%s: SaWManProcess_Call( SaWManProcess_SetExiting ) failed!\n", __FUNCTION__ );
        goto out;
    }

    if (return_args->result) {
        /*D_DERROR( return_args->result, "%s: SaWManProcess_SetExiting failed!\n", __FUNCTION__ );*/
        ret = return_args->result;
        goto out;
    }



out:
    args_free( return_args_static, return_args );
    args_free( args_static, args );
    return ret;
}


DFBResult
ISaWManProcess_Requestor::RegisterManager(
                    const SaWManRegisterManagerData           *data,
                    SaWManManager                            **ret_manager
)
{
    DFBResult           ret = DFB_OK;
    SaWManManager *manager = NULL;
    char        args_static[FLUXED_ARGS_BYTES];
    char        return_args_static[FLUXED_ARGS_BYTES];
    SaWManProcessRegisterManager       *args = (SaWManProcessRegisterManager*) args_alloc( args_static, sizeof(SaWManProcessRegisterManager) );
    SaWManProcessRegisterManagerReturn *return_args;

    if (!args)
        return (DFBResult) D_OOM();

    return_args = (SaWManProcessRegisterManagerReturn*) args_alloc( return_args_static, sizeof(SaWManProcessRegisterManagerReturn) );

    if (!return_args) {
        args_free( args_static, args );
        return (DFBResult) D_OOM();
    }

    D_DEBUG_AT( DirectFB_SaWManProcess, "ISaWManProcess_Requestor::%s()\n", __FUNCTION__ );

    D_ASSERT( data != NULL );
    D_ASSERT( ret_manager != NULL );

    args->data = *data;

    ret = (DFBResult) SaWManProcess_Call( obj, FCEF_NONE, SaWManProcess_RegisterManager, args, sizeof(SaWManProcessRegisterManager), return_args, sizeof(SaWManProcessRegisterManagerReturn), NULL );
    if (ret) {
        D_DERROR( ret, "%s: SaWManProcess_Call( SaWManProcess_RegisterManager ) failed!\n", __FUNCTION__ );
        goto out;
    }

    if (return_args->result) {
        /*D_DERROR( return_args->result, "%s: SaWManProcess_RegisterManager failed!\n", __FUNCTION__ );*/
        ret = return_args->result;
        goto out;
    }


    ret = (DFBResult) SaWManManager_Catch( core, return_args->manager_id, &manager );
    if (ret) {
         D_DERROR( ret, "%s: Catching manager by ID %u failed!\n", __FUNCTION__, return_args->manager_id );
         goto out;
    }

    *ret_manager = manager;


out:
    args_free( return_args_static, return_args );
    args_free( args_static, args );
    return ret;
}

/*********************************************************************************************************************/

static DFBResult
__SaWManProcessDispatch__Dispatch( SaWManProcess *obj,
                                FusionID      caller,
                                int           method,
                                void         *ptr,
                                unsigned int  length,
                                void         *ret_ptr,
                                unsigned int  ret_size,
                                unsigned int *ret_length )
{
    D_UNUSED
    DFBResult ret;


    DirectFB::ISaWManProcess_Real real( core_dfb, obj );


    switch (method) {
        case SaWManProcess_SetExiting: {
            D_UNUSED
            SaWManProcessSetExiting       *args        = (SaWManProcessSetExiting *) ptr;
            SaWManProcessSetExitingReturn *return_args = (SaWManProcessSetExitingReturn *) ret_ptr;

            D_DEBUG_AT( DirectFB_SaWManProcess, "=-> SaWManProcess_SetExiting\n" );

            return_args->result = real.SetExiting(  );
            if (return_args->result == DFB_OK) {
            }

            *ret_length = sizeof(SaWManProcessSetExitingReturn);

            return DFB_OK;
        }

        case SaWManProcess_RegisterManager: {
    SaWManManager *manager = NULL;
            D_UNUSED
            SaWManProcessRegisterManager       *args        = (SaWManProcessRegisterManager *) ptr;
            SaWManProcessRegisterManagerReturn *return_args = (SaWManProcessRegisterManagerReturn *) ret_ptr;

            D_DEBUG_AT( DirectFB_SaWManProcess, "=-> SaWManProcess_RegisterManager\n" );

            return_args->result = real.RegisterManager( &args->data, &manager );
            if (return_args->result == DFB_OK) {
                SaWManManager_Throw( manager, caller, &return_args->manager_id );
            }

            *ret_length = sizeof(SaWManProcessRegisterManagerReturn);

            return DFB_OK;
        }

    }

    return DFB_NOSUCHMETHOD;
}
/*********************************************************************************************************************/

DFBResult
SaWManProcessDispatch__Dispatch( SaWManProcess *obj,
                                FusionID      caller,
                                int           method,
                                void         *ptr,
                                unsigned int  length,
                                void         *ret_ptr,
                                unsigned int  ret_size,
                                unsigned int *ret_length )
{
    DFBResult ret = DFB_OK;

    D_DEBUG_AT( DirectFB_SaWManProcess, "SaWManProcessDispatch::%s( %p )\n", __FUNCTION__, obj );

    Core_PushIdentity( caller );

    ret = __SaWManProcessDispatch__Dispatch( obj, caller, method, ptr, length, ret_ptr, ret_size, ret_length );

    Core_PopIdentity();

    return ret;
}

}
