// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more flow logs.
//
// To view the published flow log records, you must view the log destination. For
// example, the CloudWatch Logs log group, the Amazon S3 bucket, or the Kinesis
// Data Firehose delivery stream.
func (c *Client) DescribeFlowLogs(ctx context.Context, params *DescribeFlowLogsInput, optFns ...func(*Options)) (*DescribeFlowLogsOutput, error) {
	if params == nil {
		params = &DescribeFlowLogsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFlowLogs", params, optFns, c.addOperationDescribeFlowLogsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFlowLogsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFlowLogsInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters.
	//
	//   - deliver-log-status - The status of the logs delivery ( SUCCESS | FAILED ).
	//
	//   - log-destination-type - The type of destination for the flow log data (
	//   cloud-watch-logs | s3 | kinesis-data-firehose ).
	//
	//   - flow-log-id - The ID of the flow log.
	//
	//   - log-group-name - The name of the log group.
	//
	//   - resource-id - The ID of the VPC, subnet, or network interface.
	//
	//   - traffic-type - The type of traffic ( ACCEPT | REJECT | ALL ).
	//
	//   - tag : - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources assigned a tag with a specific key, regardless of the tag value.
	Filter []types.Filter

	// One or more flow log IDs.
	//
	// Constraint: Maximum of 1000 flow log IDs.
	FlowLogIds []string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token to request the next page of items. Pagination continues from the end
	// of the items returned by the previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFlowLogsOutput struct {

	// Information about the flow logs.
	FlowLogs []types.FlowLog

	// The token to request the next page of items. This value is null when there are
	// no more items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFlowLogsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeFlowLogs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeFlowLogs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFlowLogs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFlowLogs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeFlowLogsAPIClient is a client that implements the DescribeFlowLogs
// operation.
type DescribeFlowLogsAPIClient interface {
	DescribeFlowLogs(context.Context, *DescribeFlowLogsInput, ...func(*Options)) (*DescribeFlowLogsOutput, error)
}

var _ DescribeFlowLogsAPIClient = (*Client)(nil)

// DescribeFlowLogsPaginatorOptions is the paginator options for DescribeFlowLogs
type DescribeFlowLogsPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeFlowLogsPaginator is a paginator for DescribeFlowLogs
type DescribeFlowLogsPaginator struct {
	options   DescribeFlowLogsPaginatorOptions
	client    DescribeFlowLogsAPIClient
	params    *DescribeFlowLogsInput
	nextToken *string
	firstPage bool
}

// NewDescribeFlowLogsPaginator returns a new DescribeFlowLogsPaginator
func NewDescribeFlowLogsPaginator(client DescribeFlowLogsAPIClient, params *DescribeFlowLogsInput, optFns ...func(*DescribeFlowLogsPaginatorOptions)) *DescribeFlowLogsPaginator {
	if params == nil {
		params = &DescribeFlowLogsInput{}
	}

	options := DescribeFlowLogsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeFlowLogsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeFlowLogsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeFlowLogs page.
func (p *DescribeFlowLogsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeFlowLogsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeFlowLogs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeFlowLogs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFlowLogs",
	}
}
