// Copyright twenty-panda <twenty-panda@posteo.com>
// SPDX-License-Identifier: MIT

package id

import (
	"fmt"

	"code.forgejo.org/f3/gof3/v3/util"
)

type NodeID interface {
	String() string
	Int() int
	Int64() int64
}

var NilID = NewNodeID("")

type nodeID string

func NewNodeID[T any](id T) NodeID {
	return nodeID(fmt.Sprintf("%v", id))
}

func (o nodeID) String() string {
	return string(o)
}

func (o nodeID) Int() int {
	return int(o.Int64())
}

func (o nodeID) Int64() int64 {
	return util.ParseInt(string(o))
}
