// Code generated by smithy-go-codegen DO NOT EDIT.

package signer

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds cross-account permissions to a signing profile.
func (c *Client) AddProfilePermission(ctx context.Context, params *AddProfilePermissionInput, optFns ...func(*Options)) (*AddProfilePermissionOutput, error) {
	if params == nil {
		params = &AddProfilePermissionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AddProfilePermission", params, optFns, c.addOperationAddProfilePermissionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AddProfilePermissionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AddProfilePermissionInput struct {

	// The AWS Signer action permitted as part of cross-account permissions.
	//
	// This member is required.
	Action *string

	// The AWS principal receiving cross-account permissions. This may be an IAM role
	// or another AWS account ID.
	//
	// This member is required.
	Principal *string

	// The human-readable name of the signing profile.
	//
	// This member is required.
	ProfileName *string

	// A unique identifier for the cross-account permission statement.
	//
	// This member is required.
	StatementId *string

	// The version of the signing profile.
	ProfileVersion *string

	// A unique identifier for the current profile revision.
	RevisionId *string

	noSmithyDocumentSerde
}

type AddProfilePermissionOutput struct {

	// A unique identifier for the current profile revision.
	RevisionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAddProfilePermissionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAddProfilePermission{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAddProfilePermission{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAddProfilePermissionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAddProfilePermission(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAddProfilePermission(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "signer",
		OperationName: "AddProfilePermission",
	}
}
