//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcommerce

import "time"

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// InfoField - Key-value pairs of instance details in the legacy format.
type InfoField struct {
	// Identifies the name of the instance provisioned by the user.
	Project *string
}

// MeterInfo - Detailed information about the meter.
type MeterInfo struct {
	// Indicates the date from which the meter rate is effective.
	EffectiveDate *time.Time

	// The resource quantity that is included in the offer at no cost. Consumption beyond this quantity will be charged.
	IncludedQuantity *float32

	// The category of the meter, e.g., 'Cloud services', 'Networking', etc..
	MeterCategory *string

	// The unique identifier of the resource.
	MeterID *string

	// The name of the meter, within the given meter category
	MeterName *string

	// The list of key/value pairs for the meter rates, in the format 'key':'value' where key = the meter quantity, and value
	// = the corresponding price
	MeterRates map[string]*float32

	// The region in which the Azure service is available.
	MeterRegion *string

	// The subcategory of the meter, e.g., 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string

	// Provides additional meter data. 'Third Party' indicates a meter with no discount. Blanks indicate First Party.
	MeterTags []*string

	// The unit in which the meter consumption is charged, e.g., 'Hours', 'GB', etc.
	Unit *string
}

// MonetaryCommitment - Indicates that a monetary commitment is required for this offer
type MonetaryCommitment struct {
	// REQUIRED; Name of the offer term
	Name *OfferTermInfo

	// Indicates the date from which the offer term is effective.
	EffectiveDate *time.Time

	// An array of meter ids that are excluded from the given offer terms.
	ExcludedMeterIDs []*string

	// The list of key/value pairs for the tiered meter rates, in the format 'key':'value' where key = price, and value = the
	// corresponding discount percentage. This field is used only by offer terms of type
	// 'Monetary Commitment'.
	TieredDiscount map[string]*float64
}

// GetOfferTermInfoAutoGenerated implements the OfferTermInfoAutoGeneratedClassification interface for type MonetaryCommitment.
func (m *MonetaryCommitment) GetOfferTermInfoAutoGenerated() *OfferTermInfoAutoGenerated {
	return &OfferTermInfoAutoGenerated{
		EffectiveDate: m.EffectiveDate,
		Name:          m.Name,
	}
}

// MonetaryCredit - Indicates that this is a monetary credit offer.
type MonetaryCredit struct {
	// REQUIRED; Name of the offer term
	Name *OfferTermInfo

	// The amount of credit provided under the terms of the given offer level.
	Credit *float64

	// Indicates the date from which the offer term is effective.
	EffectiveDate *time.Time

	// An array of meter ids that are excluded from the given offer terms.
	ExcludedMeterIDs []*string
}

// GetOfferTermInfoAutoGenerated implements the OfferTermInfoAutoGeneratedClassification interface for type MonetaryCredit.
func (m *MonetaryCredit) GetOfferTermInfoAutoGenerated() *OfferTermInfoAutoGenerated {
	return &OfferTermInfoAutoGenerated{
		EffectiveDate: m.EffectiveDate,
		Name:          m.Name,
	}
}

// OfferTermInfoAutoGenerated - Describes the offer term.
type OfferTermInfoAutoGenerated struct {
	// REQUIRED; Name of the offer term
	Name *OfferTermInfo

	// Indicates the date from which the offer term is effective.
	EffectiveDate *time.Time
}

// GetOfferTermInfoAutoGenerated implements the OfferTermInfoAutoGeneratedClassification interface for type OfferTermInfoAutoGenerated.
func (o *OfferTermInfoAutoGenerated) GetOfferTermInfoAutoGenerated() *OfferTermInfoAutoGenerated {
	return o
}

// RateCardQueryParameters - Parameters that are used in the odata $filter query parameter for providing RateCard information.
type RateCardQueryParameters struct {
	// REQUIRED; The currency in which the rates need to be provided.
	Currency *string

	// REQUIRED; The culture in which the resource metadata needs to be localized.
	Locale *string

	// REQUIRED; The Offer ID parameter consists of the 'MS-AZR-' prefix, plus the Offer ID number (e.g., MS-AZR-0026P). See https://azure.microsoft.com/en-us/support/legal/offer-details/
	// for more information on the
	// list of available Offer IDs, country/region availability, and billing currency.
	OfferDurableID *string

	// REQUIRED; 2 letter ISO code where the offer was purchased.
	RegionInfo *string
}

// RecurringCharge - Indicates a recurring charge is present for this offer.
type RecurringCharge struct {
	// REQUIRED; Name of the offer term
	Name *OfferTermInfo

	// Indicates the date from which the offer term is effective.
	EffectiveDate *time.Time

	// The amount of recurring charge as per the offer term.
	RecurringCharge *int32
}

// GetOfferTermInfoAutoGenerated implements the OfferTermInfoAutoGeneratedClassification interface for type RecurringCharge.
func (r *RecurringCharge) GetOfferTermInfoAutoGenerated() *OfferTermInfoAutoGenerated {
	return &OfferTermInfoAutoGenerated{
		EffectiveDate: r.EffectiveDate,
		Name:          r.Name,
	}
}

// ResourceRateCardInfo - Price and Metadata information for resources
type ResourceRateCardInfo struct {
	// The currency in which the rates are provided.
	Currency *string

	// All rates are pretax, so this will always be returned as 'false'.
	IsTaxIncluded *bool

	// The culture in which the resource information is localized.
	Locale *string

	// A list of meters.
	Meters []*MeterInfo

	// A list of offer terms.
	OfferTerms []OfferTermInfoAutoGeneratedClassification
}

// UsageAggregation - Describes the usageAggregation.
type UsageAggregation struct {
	// Unique Id for the usage aggregate.
	ID *string

	// Name of the usage aggregate.
	Name *string

	// Usage data.
	Properties *UsageSample

	// Type of the resource being returned.
	Type *string
}

// UsageAggregationListResult - The Get UsageAggregates operation response.
type UsageAggregationListResult struct {
	// Gets or sets the link to the next set of results.
	NextLink *string

	// Gets or sets details for the requested aggregation.
	Value []*UsageAggregation
}

// UsageSample - Describes a sample of the usageAggregation.
type UsageSample struct {
	// Key-value pairs of instance details (legacy format).
	InfoFields *InfoField

	// Key-value pairs of instance details represented as a string.
	InstanceData *string

	// Category of the consumed resource.
	MeterCategory *string

	// Unique ID for the resource that was consumed (aka ResourceID).
	MeterID *string

	// Friendly name of the resource being consumed.
	MeterName *string

	// Region of the meterId used for billing purposes
	MeterRegion *string

	// Sub-category of the consumed resource.
	MeterSubCategory *string

	// The amount of the resource consumption that occurred in this time frame.
	Quantity *float32

	// The subscription identifier for the Azure user.
	SubscriptionID *string

	// The unit in which the usage for this resource is being counted, e.g. Hours, GB.
	Unit *string

	// UTC end time for the usage bucket to which this usage aggregate belongs.
	UsageEndTime *time.Time

	// UTC start time for the usage bucket to which this usage aggregate belongs.
	UsageStartTime *time.Time
}
