//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// DelegatedSubnetServiceClient contains the methods for the DelegatedSubnetService group.
// Don't use this type directly, use NewDelegatedSubnetServiceClient() instead.
type DelegatedSubnetServiceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDelegatedSubnetServiceClient creates a new instance of DelegatedSubnetServiceClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDelegatedSubnetServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DelegatedSubnetServiceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DelegatedSubnetServiceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginDeleteDetails - Delete dnc DelegatedSubnet.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - DelegatedSubnetServiceClientBeginDeleteDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginDeleteDetails
//     method.
func (client *DelegatedSubnetServiceClient) BeginDeleteDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientDeleteDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteDetails(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DelegatedSubnetServiceClientDeleteDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DelegatedSubnetServiceClientDeleteDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteDetails - Delete dnc DelegatedSubnet.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) deleteDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*http.Response, error) {
	var err error
	const operationName = "DelegatedSubnetServiceClient.BeginDeleteDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteDetailsCreateRequest creates the DeleteDetails request.
func (client *DelegatedSubnetServiceClient) deleteDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the specified dnc DelegatedSubnet Link.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - DelegatedSubnetServiceClientGetDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.GetDetails
//     method.
func (client *DelegatedSubnetServiceClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientGetDetailsOptions) (DelegatedSubnetServiceClientGetDetailsResponse, error) {
	var err error
	const operationName = "DelegatedSubnetServiceClient.GetDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	resp, err := client.getDetailsHandleResponse(httpResp)
	return resp, err
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *DelegatedSubnetServiceClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *DelegatedSubnetServiceClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *DelegatedSubnetServiceClient) getDetailsHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientGetDetailsResponse, error) {
	result := DelegatedSubnetServiceClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnet); err != nil {
		return DelegatedSubnetServiceClientGetDetailsResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get all the DelegatedSubnets resources in a resource group.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - DelegatedSubnetServiceClientListByResourceGroupOptions contains the optional parameters for the DelegatedSubnetServiceClient.NewListByResourceGroupPager
//     method.
func (client *DelegatedSubnetServiceClient) NewListByResourceGroupPager(resourceGroupName string, options *DelegatedSubnetServiceClientListByResourceGroupOptions) *runtime.Pager[DelegatedSubnetServiceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DelegatedSubnetServiceClientListByResourceGroupResponse]{
		More: func(page DelegatedSubnetServiceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DelegatedSubnetServiceClientListByResourceGroupResponse) (DelegatedSubnetServiceClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DelegatedSubnetServiceClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return DelegatedSubnetServiceClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *DelegatedSubnetServiceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DelegatedSubnetServiceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *DelegatedSubnetServiceClient) listByResourceGroupHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientListByResourceGroupResponse, error) {
	result := DelegatedSubnetServiceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnets); err != nil {
		return DelegatedSubnetServiceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get all the DelegatedSubnets resources in a subscription.
//
// Generated from API version 2021-03-15
//   - options - DelegatedSubnetServiceClientListBySubscriptionOptions contains the optional parameters for the DelegatedSubnetServiceClient.NewListBySubscriptionPager
//     method.
func (client *DelegatedSubnetServiceClient) NewListBySubscriptionPager(options *DelegatedSubnetServiceClientListBySubscriptionOptions) *runtime.Pager[DelegatedSubnetServiceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DelegatedSubnetServiceClientListBySubscriptionResponse]{
		More: func(page DelegatedSubnetServiceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DelegatedSubnetServiceClientListBySubscriptionResponse) (DelegatedSubnetServiceClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DelegatedSubnetServiceClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return DelegatedSubnetServiceClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *DelegatedSubnetServiceClient) listBySubscriptionCreateRequest(ctx context.Context, options *DelegatedSubnetServiceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DelegatedNetwork/delegatedSubnets"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *DelegatedSubnetServiceClient) listBySubscriptionHandleResponse(resp *http.Response) (DelegatedSubnetServiceClientListBySubscriptionResponse, error) {
	result := DelegatedSubnetServiceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedSubnets); err != nil {
		return DelegatedSubnetServiceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginPatchDetails - Patch delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - Delegated subnet details.
//   - options - DelegatedSubnetServiceClientBeginPatchDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginPatchDetails
//     method.
func (client *DelegatedSubnetServiceClient) BeginPatchDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientPatchDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.patchDetails(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DelegatedSubnetServiceClientPatchDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DelegatedSubnetServiceClientPatchDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PatchDetails - Patch delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) patchDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*http.Response, error) {
	var err error
	const operationName = "DelegatedSubnetServiceClient.BeginPatchDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchDetailsCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// patchDetailsCreateRequest creates the PatchDetails request.
func (client *DelegatedSubnetServiceClient) patchDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ResourceUpdateParameters, options *DelegatedSubnetServiceClientBeginPatchDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginPutDetails - Put delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - Delegated subnet details.
//   - options - DelegatedSubnetServiceClientBeginPutDetailsOptions contains the optional parameters for the DelegatedSubnetServiceClient.BeginPutDetails
//     method.
func (client *DelegatedSubnetServiceClient) BeginPutDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*runtime.Poller[DelegatedSubnetServiceClientPutDetailsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.putDetails(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DelegatedSubnetServiceClientPutDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DelegatedSubnetServiceClientPutDetailsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PutDetails - Put delegated subnet resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *DelegatedSubnetServiceClient) putDetails(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*http.Response, error) {
	var err error
	const operationName = "DelegatedSubnetServiceClient.BeginPutDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.putDetailsCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// putDetailsCreateRequest creates the PutDetails request.
func (client *DelegatedSubnetServiceClient) putDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedSubnet, options *DelegatedSubnetServiceClientBeginPutDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
