//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// IntegrationAccountMapsServer is a fake server for instances of the armlogic.IntegrationAccountMapsClient type.
type IntegrationAccountMapsServer struct {
	// CreateOrUpdate is the fake for method IntegrationAccountMapsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string, mapParam armlogic.IntegrationAccountMap, options *armlogic.IntegrationAccountMapsClientCreateOrUpdateOptions) (resp azfake.Responder[armlogic.IntegrationAccountMapsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method IntegrationAccountMapsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string, options *armlogic.IntegrationAccountMapsClientDeleteOptions) (resp azfake.Responder[armlogic.IntegrationAccountMapsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IntegrationAccountMapsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string, options *armlogic.IntegrationAccountMapsClientGetOptions) (resp azfake.Responder[armlogic.IntegrationAccountMapsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method IntegrationAccountMapsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, integrationAccountName string, options *armlogic.IntegrationAccountMapsClientListOptions) (resp azfake.PagerResponder[armlogic.IntegrationAccountMapsClientListResponse])

	// ListContentCallbackURL is the fake for method IntegrationAccountMapsClient.ListContentCallbackURL
	// HTTP status codes to indicate success: http.StatusOK
	ListContentCallbackURL func(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string, listContentCallbackURL armlogic.GetCallbackURLParameters, options *armlogic.IntegrationAccountMapsClientListContentCallbackURLOptions) (resp azfake.Responder[armlogic.IntegrationAccountMapsClientListContentCallbackURLResponse], errResp azfake.ErrorResponder)
}

// NewIntegrationAccountMapsServerTransport creates a new instance of IntegrationAccountMapsServerTransport with the provided implementation.
// The returned IntegrationAccountMapsServerTransport instance is connected to an instance of armlogic.IntegrationAccountMapsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationAccountMapsServerTransport(srv *IntegrationAccountMapsServer) *IntegrationAccountMapsServerTransport {
	return &IntegrationAccountMapsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armlogic.IntegrationAccountMapsClientListResponse]](),
	}
}

// IntegrationAccountMapsServerTransport connects instances of armlogic.IntegrationAccountMapsClient to instances of IntegrationAccountMapsServer.
// Don't use this type directly, use NewIntegrationAccountMapsServerTransport instead.
type IntegrationAccountMapsServerTransport struct {
	srv          *IntegrationAccountMapsServer
	newListPager *tracker[azfake.PagerResponder[armlogic.IntegrationAccountMapsClientListResponse]]
}

// Do implements the policy.Transporter interface for IntegrationAccountMapsServerTransport.
func (i *IntegrationAccountMapsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationAccountMapsClient.CreateOrUpdate":
		resp, err = i.dispatchCreateOrUpdate(req)
	case "IntegrationAccountMapsClient.Delete":
		resp, err = i.dispatchDelete(req)
	case "IntegrationAccountMapsClient.Get":
		resp, err = i.dispatchGet(req)
	case "IntegrationAccountMapsClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	case "IntegrationAccountMapsClient.ListContentCallbackURL":
		resp, err = i.dispatchListContentCallbackURL(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationAccountMapsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationAccounts/(?P<integrationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maps/(?P<mapName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlogic.IntegrationAccountMap](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	integrationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationAccountName")])
	if err != nil {
		return nil, err
	}
	mapNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mapName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, integrationAccountNameParam, mapNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationAccountMap, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationAccountMapsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if i.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationAccounts/(?P<integrationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maps/(?P<mapName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	integrationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationAccountName")])
	if err != nil {
		return nil, err
	}
	mapNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mapName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Delete(req.Context(), resourceGroupNameParam, integrationAccountNameParam, mapNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationAccountMapsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationAccounts/(?P<integrationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maps/(?P<mapName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	integrationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationAccountName")])
	if err != nil {
		return nil, err
	}
	mapNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mapName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, integrationAccountNameParam, mapNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationAccountMap, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationAccountMapsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationAccounts/(?P<integrationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		integrationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationAccountName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlogic.IntegrationAccountMapsClientListOptions
		if topParam != nil || filterParam != nil {
			options = &armlogic.IntegrationAccountMapsClientListOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := i.srv.NewListPager(resourceGroupNameParam, integrationAccountNameParam, options)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armlogic.IntegrationAccountMapsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}

func (i *IntegrationAccountMapsServerTransport) dispatchListContentCallbackURL(req *http.Request) (*http.Response, error) {
	if i.srv.ListContentCallbackURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListContentCallbackURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationAccounts/(?P<integrationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maps/(?P<mapName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listContentCallbackUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlogic.GetCallbackURLParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	integrationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationAccountName")])
	if err != nil {
		return nil, err
	}
	mapNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mapName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListContentCallbackURL(req.Context(), resourceGroupNameParam, integrationAccountNameParam, mapNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowTriggerCallbackURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
