//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/saas/armsaas"
	"net/http"
	"net/url"
	"regexp"
)

// ResourcesServer is a fake server for instances of the armsaas.ResourcesClient type.
type ResourcesServer struct {
	// NewListPager is the fake for method ResourcesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsaas.ResourcesClientListOptions) (resp azfake.PagerResponder[armsaas.ResourcesClientListResponse])

	// ListAccessToken is the fake for method ResourcesClient.ListAccessToken
	// HTTP status codes to indicate success: http.StatusOK
	ListAccessToken func(ctx context.Context, resourceID string, options *armsaas.ResourcesClientListAccessTokenOptions) (resp azfake.Responder[armsaas.ResourcesClientListAccessTokenResponse], errResp azfake.ErrorResponder)
}

// NewResourcesServerTransport creates a new instance of ResourcesServerTransport with the provided implementation.
// The returned ResourcesServerTransport instance is connected to an instance of armsaas.ResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourcesServerTransport(srv *ResourcesServer) *ResourcesServerTransport {
	return &ResourcesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsaas.ResourcesClientListResponse]](),
	}
}

// ResourcesServerTransport connects instances of armsaas.ResourcesClient to instances of ResourcesServer.
// Don't use this type directly, use NewResourcesServerTransport instead.
type ResourcesServerTransport struct {
	srv          *ResourcesServer
	newListPager *tracker[azfake.PagerResponder[armsaas.ResourcesClientListResponse]]
}

// Do implements the policy.Transporter interface for ResourcesServerTransport.
func (r *ResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourcesClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ResourcesClient.ListAccessToken":
		resp, err = r.dispatchListAccessToken(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourcesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		resp := r.srv.NewListPager(nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsaas.ResourcesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ResourcesServerTransport) dispatchListAccessToken(req *http.Request) (*http.Response, error) {
	if r.srv.ListAccessToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAccessToken not implemented")}
	}
	const regexStr = `/providers/Microsoft\.SaaS/saasresources/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAccessToken`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ListAccessToken(req.Context(), resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessTokenResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
