//
// Copyright (c) 2015-2022 MinIO, Inc.
//
// This file is part of MinIO Object Storage stack
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//
package madmin

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *TierS3) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Endpoint":
			z.Endpoint, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Endpoint")
				return
			}
		case "AccessKey":
			z.AccessKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AccessKey")
				return
			}
		case "SecretKey":
			z.SecretKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SecretKey")
				return
			}
		case "Bucket":
			z.Bucket, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "Region":
			z.Region, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Region")
				return
			}
		case "StorageClass":
			z.StorageClass, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
		case "AWSRole":
			z.AWSRole, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "AWSRole")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *TierS3) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 8
	// write "Endpoint"
	err = en.Append(0x88, 0xa8, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Endpoint)
	if err != nil {
		err = msgp.WrapError(err, "Endpoint")
		return
	}
	// write "AccessKey"
	err = en.Append(0xa9, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.AccessKey)
	if err != nil {
		err = msgp.WrapError(err, "AccessKey")
		return
	}
	// write "SecretKey"
	err = en.Append(0xa9, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.SecretKey)
	if err != nil {
		err = msgp.WrapError(err, "SecretKey")
		return
	}
	// write "Bucket"
	err = en.Append(0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Bucket)
	if err != nil {
		err = msgp.WrapError(err, "Bucket")
		return
	}
	// write "Prefix"
	err = en.Append(0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	if err != nil {
		return
	}
	err = en.WriteString(z.Prefix)
	if err != nil {
		err = msgp.WrapError(err, "Prefix")
		return
	}
	// write "Region"
	err = en.Append(0xa6, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.Region)
	if err != nil {
		err = msgp.WrapError(err, "Region")
		return
	}
	// write "StorageClass"
	err = en.Append(0xac, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73)
	if err != nil {
		return
	}
	err = en.WriteString(z.StorageClass)
	if err != nil {
		err = msgp.WrapError(err, "StorageClass")
		return
	}
	// write "AWSRole"
	err = en.Append(0xa7, 0x41, 0x57, 0x53, 0x52, 0x6f, 0x6c, 0x65)
	if err != nil {
		return
	}
	err = en.WriteBool(z.AWSRole)
	if err != nil {
		err = msgp.WrapError(err, "AWSRole")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TierS3) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 8
	// string "Endpoint"
	o = append(o, 0x88, 0xa8, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74)
	o = msgp.AppendString(o, z.Endpoint)
	// string "AccessKey"
	o = append(o, 0xa9, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79)
	o = msgp.AppendString(o, z.AccessKey)
	// string "SecretKey"
	o = append(o, 0xa9, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79)
	o = msgp.AppendString(o, z.SecretKey)
	// string "Bucket"
	o = append(o, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Prefix"
	o = append(o, 0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	o = msgp.AppendString(o, z.Prefix)
	// string "Region"
	o = append(o, 0xa6, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e)
	o = msgp.AppendString(o, z.Region)
	// string "StorageClass"
	o = append(o, 0xac, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73)
	o = msgp.AppendString(o, z.StorageClass)
	// string "AWSRole"
	o = append(o, 0xa7, 0x41, 0x57, 0x53, 0x52, 0x6f, 0x6c, 0x65)
	o = msgp.AppendBool(o, z.AWSRole)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TierS3) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Endpoint":
			z.Endpoint, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Endpoint")
				return
			}
		case "AccessKey":
			z.AccessKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AccessKey")
				return
			}
		case "SecretKey":
			z.SecretKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SecretKey")
				return
			}
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "Region":
			z.Region, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Region")
				return
			}
		case "StorageClass":
			z.StorageClass, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
		case "AWSRole":
			z.AWSRole, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AWSRole")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TierS3) Msgsize() (s int) {
	s = 1 + 9 + msgp.StringPrefixSize + len(z.Endpoint) + 10 + msgp.StringPrefixSize + len(z.AccessKey) + 10 + msgp.StringPrefixSize + len(z.SecretKey) + 7 + msgp.StringPrefixSize + len(z.Bucket) + 7 + msgp.StringPrefixSize + len(z.Prefix) + 7 + msgp.StringPrefixSize + len(z.Region) + 13 + msgp.StringPrefixSize + len(z.StorageClass) + 8 + msgp.BoolSize
	return
}
