GOPHIAN-ESTIMATE(1)

# NAME

gophian-estimate - Estimate work required to Debianize a given Go package

# SYNOPSIS

*gophian estimate* <IMPORTPATH> [OPTIONS]

# DESCRIPTION

This subcommand recursively finds all dependencies of a given package and checks
if they are packaged in Debian, producing a coloured tree to indicate which
dependencies are already available as packages, and which are not.

By default, each colour denotes the state of the dependency as follows. The
colours can be changed, refer to *OPTIONS* and *ENVIRONMENT*.
- No colour means that the dependency is not packaged.
- Light green means that the dependency is packaged in Debian.
- Dark green means that the dependency is packaged in Debian, but only available
  in experimental.
- Blue means that the dependency is pending in the NEW queue.
- Gray means that the dependency already appears elsewhere in the generated
  tree, to avoid repetition.
Version conflicts between the dependency version specified in go.mod and the
version packaged in Debian will be shown in yellow.

# ARGUMENTS

*IMPORTPATH* - The import path of the Go package being estimated.

# OPTIONS

*--[no-]quiet* - Don't print warnings.

*--[no-]warn-packaged* - Warn if the given Go package has already been packaged
for Debian. (default: on)

*--[no-]include-packaged-deps* - Include packaged dependencies in the estimate.
(default: on)

*--[no-]include-version-conflicts* - Include any version conflicts between the
package's go.mod and the version in Debian unstable. Ignored if
*--no-include-packaged-deps* is passed. (default: on)

*--max-depth* <INT> - Maximum recursion depth of unpackaged dependencies.

*--packaged-unstable-color* <COLOUR> - Colour to denote dependencies packaged in
Debian unstable. Refer to *COLOURS* for accepted values. (default: bright_green)

*--packaged-experimental-color* <COLOUR> - Colour to denote dependencies
packaged in Debian experimental. Refer to *COLOURS* for accepted values.
(default: green)

*--packaged-new-color* <COLOUR> - Colour to denote dependencies pending in the
Debian NEW queue. Refer to *COLOURS* for accepted values. (default: blue)

*--seen-color* <COLOUR> - Colour to denote dependencies that already appear
elsewhere in the output tree. Refer to *COLOURS* for accepted values. (default:
bright_black)

*--unpackaged-color* <COLOUR> - Colour to denote unpackaged dependencies. Refer
to *COLOURS* for accepted values. (default: reset)

*--version-conflicts-color* <COLOUR> - Colour to denote version conflicts. Refer
to *COLOURS* for accepted values. (default: yellow)

*--help* - Show help message and exit.

# ENVIRONMENT

_GOPHIAN_PACKAGED_UNSTABLE_COLOR_ - Used for *--packaged-unstable-color*.

_GOPHIAN_PACKAGED_EXPERIMENTAL_COLOR_ - Used for *--packaged-experimental-color*.

_GOPHIAN_PACKAGED_NEW_COLOR_ - Used for *--packaged-new-color*.

_GOPHIAN_SEEN_COLOR_ - Used for *--seen-color*.

_GOPHIAN_UNPACKAGED_COLOR_ - Used for *--unpackaged-color*.

_GOPHIAN_VERSION_CONFLICTS_COLOR_ - Used for *--version-conflicts-color*.

# COLOURS

A colour value can either be an ANSI colour name, an 8-bit colour (an integer
between 0 and 255), or a 24-bit colour (a hex colour value that starts with a
hash character e.g. "#d70a53").

Supported ANSI colour names are:
- "black"
- "red"
- "green"
- "yellow"
- "blue"
- "magenta"
- "cyan"
- "white"
- "bright_black"
- "bright_red"
- "bright_green"
- "bright_yellow"
- "bright_blue"
- "bright_magenta"
- "bright_cyan"
- "bright_white"
- "reset" (No colour)

# SEE ALSO

_gophian-estimate-graphviz_(1)
