#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-day.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

# Recover from a bad DTSTAMP.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-bad-dtstamp.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-day.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T080000Z/20141126T090000Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

# Reject a bad DTSTART.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-bad-dtstart.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   ! grep -q 'METHOD:REPLY' out4.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-day.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T090000Z/20141126T100000Z' out5.tmp \
&& echo "Success" \
|| echo "Failed"

# Reject a bad DTEND.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-bad-dtend.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   ! grep -q 'METHOD:REPLY' out6.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-day.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T100000Z/20141126T110000Z' out7.tmp \
&& echo "Success" \
|| echo "Failed"
