#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER1="mailto:resource-car-porsche911@example.com"
USER2="mailto:resource-car-fiat500@example.com"
SENDER1="mailto:paul.boddie@example.com"
SENDER2="mailto:vincent.vole@example.com"
USER1ADDRESS="resource-car-porsche911@example.com"
USER2ADDRESS="resource-car-fiat500@example.com"
SENDER1ADDRESS="paul.boddie@example.com"
SENDER2ADDRESS="vincent.vole@example.com"
QUOTA=cars
OTHER_QUOTA=rooms

# Test delegation using the "most-available" policy and without using the
# explicit schedule_in_freebusy function since multiple concurrent reservations
# are to occur without any limits.

# The result should be the reservation of USER1, then the reservation of both
# USER1 and USER2, followed by an attempt to reserve USER1 that results in the
# delegation to USER2 because USER2 is less committed (more available) during
# the period concerned.

mkdir -p "$PREFS/$USER1"
echo 'Europe/Oslo' > "$PREFS/$USER1/TZID"
echo 'share' > "$PREFS/$USER1/freebusy_sharing"
cat > "$PREFS/$USER1/scheduling_function" <<EOF
schedule_for_delegate $QUOTA most-available
EOF

mkdir -p "$PREFS/$USER2"
echo 'Europe/Oslo' > "$PREFS/$USER2/TZID"
echo 'share' > "$PREFS/$USER2/freebusy_sharing"
cat > "$PREFS/$USER2/scheduling_function" <<EOF
schedule_for_delegate $QUOTA most-available
EOF

# Have a common group for all organisers when scheduling.

cat <<EOF | "$SET_QUOTA_GROUPS" "$QUOTA" $SET_QUOTA_GROUPS_ARGS
* all
EOF

# Set a common quota.

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
all *
EOF

# Allow cars to delegate to each other.

cat <<EOF | "$SET_DELEGATES" "$QUOTA" $SET_DELEGATES_ARGS
mailto:resource-car-porsche911@example.com
mailto:resource-car-fiat500@example.com
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-car.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
|  tee out0s.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
|  tee out1f.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "all" \
|  tee out1e.tmp \
|  grep -q "event21@example.com" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule another event.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out2s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2s.tmp" \
&& grep -q "event21@example.com" "out2s.tmp" \
&& grep -q "event25@example.com" "out2s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipients.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=5/;' "$TEMPLATES/event-request-cars-recurring.txt" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
> out2r.tmp

  "$SHOWMAIL" < "out2r.tmp" \
> out2p0.tmp

  "$SHOWMAIL" 1 < "out2r.tmp" \
> out2p1.tmp

   grep -q 'METHOD:REPLY' out2p0.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2p0.tmp \
&& echo "Success" \
|| echo "Failed"

   grep -q 'METHOD:REPLY' out2p1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2p1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out2f0.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f0.tmp" \
&& grep -q "event21@example.com" "out2f0.tmp" \
&& grep -q "event25@example.com" "out2f0.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out2f1.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f1.tmp" \
&& grep -q "event25@example.com" "out2f1.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "all" \
|  tee out2e.tmp \
|  grep -q "event25@example.com" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule another event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-delegating.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy" \
|  tee out3s.tmp \
|  grep -q "^20141126T153000Z${TAB}20141126T163000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-delegating.txt" 2>> $ERROR \
> out3r.tmp

  "$SHOWMAIL" < out3r.tmp \
> out3p0.tmp

  "$SHOWMAIL" 1 < out3r.tmp \
> out3p1.tmp

if grep -q "To: $SENDER2ADDRESS" out3p0.tmp ; then
    ORGFN=out3p0.tmp ; DELFN=out3p1.tmp
else
    ORGFN=out3p1.tmp ; DELFN=out3p0.tmp
fi

# One of the responses will be a request sent to the delegate.

   grep -q "To: $USER2ADDRESS" "$DELFN" \
&& grep -q 'METHOD:REQUEST' "$DELFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=DELEGATED.*:'"$USER1" "$DELFN" \
&& grep -q 'ATTENDEE.*:'"$USER2" "$DELFN" \
&& echo "Success" \
|| echo "Failed"

# The other will be a reply to the organiser.

   grep -q "To: $SENDER2ADDRESS" "$ORGFN" \
&& grep -q 'METHOD:REPLY' "$ORGFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=DELEGATED.*:'"$USER1" "$ORGFN" \
&& grep -q 'ATTENDEE.*:'"$USER2" "$ORGFN" \
&& echo "Success" \
|| echo "Failed"

# Neither the delegator or the delegate will have changed their schedules.

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out4f1.tmp

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" "out4f1.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out4f2.tmp

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" "out4f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is not confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "all" \
>  out4e.tmp

   grep -q "event21@example.com" "out4e.tmp" \
&& grep -q "event25@example.com" "out4e.tmp" \
&& ! grep -q "event27@example.com" "out4e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the reply to the organiser.

  "$PERSON_SCRIPT" $ARGS < "$ORGFN" 2>> "$ERROR" \
| tee out5r.tmp \
| "$SHOWMAIL" \
> out5.tmp

# Check the free/busy status of the attendees at the organiser.
# Currently, neither are attending.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy_other" "$USER1" \
>  out5s0.tmp \

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" out5s0.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy_other" "$USER2" \
>  out5s1.tmp \

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" out5s1.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the request to the delegate.

  "$RESOURCE_SCRIPT" $ARGS < "$DELFN" 2>> "$ERROR" \
> out6r.tmp

  "$SHOWMAIL" < out6r.tmp \
> out6p0.tmp

  "$SHOWMAIL" 1 < out6r.tmp \
> out6p1.tmp

if grep -q "To: $SENDER2ADDRESS" out6p0.tmp ; then
    ORGFN=out6p0.tmp ; DELFN=out6p1.tmp
else
    ORGFN=out6p1.tmp ; DELFN=out6p0.tmp
fi

# One of the responses will be a reply sent to the organiser.

   grep -q "To: $SENDER2ADDRESS" "$ORGFN" \
&& grep -q 'METHOD:REPLY' "$ORGFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=DELEGATED.*:'"$USER1" "$ORGFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED.*:'"$USER2" "$ORGFN" \
&& echo "Success" \
|| echo "Failed"

# The other will be a reply to the delegator.

   grep -q "To: $USER1ADDRESS" "$DELFN" \
&& grep -q 'METHOD:REPLY' "$DELFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=DELEGATED.*:'"$USER1" "$DELFN" \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED.*:'"$USER2" "$DELFN" \
&& echo "Success" \
|| echo "Failed"

# The delegate should now have a changed schedule.

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out7f0.tmp

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" "out7f0.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out7f1.tmp

   grep -q "^20141126T153000Z${TAB}20141126T163000Z" "out7f1.tmp" \
&& grep -q "event27@example.com" "out7f1.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the reply to the organiser.

  "$PERSON_SCRIPT" $ARGS < "$ORGFN" 2>> "$ERROR" \
| tee out8r.tmp \
| "$SHOWMAIL" \
> out8.tmp

# Check the free/busy status of the attendees at the organiser.
# Now, the delegate is attending.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy_other" "$USER1" \
>  out8s0.tmp \

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" out8s0.tmp \
&& ! grep -q "event27@example.com" out8s0.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER2" "freebusy_other" "$USER2" \
>  out8s1.tmp \

   grep -q "^20141126T153000Z${TAB}20141126T163000Z" out8s1.tmp \
&& grep -q "event27@example.com" out8s1.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the reply to the delegator.

  "$RESOURCE_SCRIPT" $ARGS < "$DELFN" 2>> "$ERROR" \
> out9r.tmp
