#ifndef __INPUT_PAD_KEYSYM_STR2VAL_H__
#define __INPUT_PAD_KEYSYM_STR2VAL_H__

#include <X11/Xlib.h>
#include <X11/keysymdef.h>

typedef struct _InputPadKeysymTable InputPadKeysymTable;

struct _InputPadKeysymTable {
  const char *str;
  KeySym keysym;
};

static const InputPadKeysymTable input_pad_keysym_table[] = {
  {"VoidSymbol", XK_VoidSymbol},
#ifdef XK_MISCELLANY
  {"BackSpace", XK_BackSpace},
  {"Tab", XK_Tab},
  {"Linefeed", XK_Linefeed},
  {"Clear", XK_Clear},
  {"Return", XK_Return},
  {"Pause", XK_Pause},
  {"Scroll_Lock", XK_Scroll_Lock},
  {"Sys_Req", XK_Sys_Req},
  {"Escape", XK_Escape},
  {"Delete", XK_Delete},
  {"Multi_key", XK_Multi_key},
  {"Codeinput", XK_Codeinput},
  {"SingleCandidate", XK_SingleCandidate},
  {"MultipleCandidate", XK_MultipleCandidate},
  {"PreviousCandidate", XK_PreviousCandidate},
  {"Kanji", XK_Kanji},
  {"Muhenkan", XK_Muhenkan},
  {"Henkan_Mode", XK_Henkan_Mode},
  {"Henkan", XK_Henkan},
  {"Romaji", XK_Romaji},
  {"Hiragana", XK_Hiragana},
  {"Katakana", XK_Katakana},
  {"Hiragana_Katakana", XK_Hiragana_Katakana},
  {"Zenkaku", XK_Zenkaku},
  {"Hankaku", XK_Hankaku},
  {"Zenkaku_Hankaku", XK_Zenkaku_Hankaku},
  {"Touroku", XK_Touroku},
  {"Massyo", XK_Massyo},
  {"Kana_Lock", XK_Kana_Lock},
  {"Kana_Shift", XK_Kana_Shift},
  {"Eisu_Shift", XK_Eisu_Shift},
  {"Eisu_toggle", XK_Eisu_toggle},
  {"Kanji_Bangou", XK_Kanji_Bangou},
  {"Zen_Koho", XK_Zen_Koho},
  {"Mae_Koho", XK_Mae_Koho},
  {"Home", XK_Home},
  {"Left", XK_Left},
  {"Up", XK_Up},
  {"Right", XK_Right},
  {"Down", XK_Down},
  {"Prior", XK_Prior},
  {"Page_Up", XK_Page_Up},
  {"Next", XK_Next},
  {"Page_Down", XK_Page_Down},
  {"End", XK_End},
  {"Begin", XK_Begin},
  {"Select", XK_Select},
  {"Print", XK_Print},
  {"Execute", XK_Execute},
  {"Insert", XK_Insert},
  {"Undo", XK_Undo},
  {"Redo", XK_Redo},
  {"Menu", XK_Menu},
  {"Find", XK_Find},
  {"Cancel", XK_Cancel},
  {"Help", XK_Help},
  {"Break", XK_Break},
  {"Mode_switch", XK_Mode_switch},
  {"script_switch", XK_script_switch},
  {"Num_Lock", XK_Num_Lock},
  {"KP_Space", XK_KP_Space},
  {"KP_Tab", XK_KP_Tab},
  {"KP_Enter", XK_KP_Enter},
  {"KP_F1", XK_KP_F1},
  {"KP_F2", XK_KP_F2},
  {"KP_F3", XK_KP_F3},
  {"KP_F4", XK_KP_F4},
  {"KP_Home", XK_KP_Home},
  {"KP_Left", XK_KP_Left},
  {"KP_Up", XK_KP_Up},
  {"KP_Right", XK_KP_Right},
  {"KP_Down", XK_KP_Down},
  {"KP_Prior", XK_KP_Prior},
  {"KP_Page_Up", XK_KP_Page_Up},
  {"KP_Next", XK_KP_Next},
  {"KP_Page_Down", XK_KP_Page_Down},
  {"KP_End", XK_KP_End},
  {"KP_Begin", XK_KP_Begin},
  {"KP_Insert", XK_KP_Insert},
  {"KP_Delete", XK_KP_Delete},
  {"KP_Equal", XK_KP_Equal},
  {"KP_Multiply", XK_KP_Multiply},
  {"KP_Add", XK_KP_Add},
  {"KP_Separator", XK_KP_Separator},
  {"KP_Subtract", XK_KP_Subtract},
  {"KP_Decimal", XK_KP_Decimal},
  {"KP_Divide", XK_KP_Divide},
  {"KP_0", XK_KP_0},
  {"KP_1", XK_KP_1},
  {"KP_2", XK_KP_2},
  {"KP_3", XK_KP_3},
  {"KP_4", XK_KP_4},
  {"KP_5", XK_KP_5},
  {"KP_6", XK_KP_6},
  {"KP_7", XK_KP_7},
  {"KP_8", XK_KP_8},
  {"KP_9", XK_KP_9},
  {"F1", XK_F1},
  {"F2", XK_F2},
  {"F3", XK_F3},
  {"F4", XK_F4},
  {"F5", XK_F5},
  {"F6", XK_F6},
  {"F7", XK_F7},
  {"F8", XK_F8},
  {"F9", XK_F9},
  {"F10", XK_F10},
  {"F11", XK_F11},
  {"L1", XK_L1},
  {"F12", XK_F12},
  {"L2", XK_L2},
  {"F13", XK_F13},
  {"L3", XK_L3},
  {"F14", XK_F14},
  {"L4", XK_L4},
  {"F15", XK_F15},
  {"L5", XK_L5},
  {"F16", XK_F16},
  {"L6", XK_L6},
  {"F17", XK_F17},
  {"L7", XK_L7},
  {"F18", XK_F18},
  {"L8", XK_L8},
  {"F19", XK_F19},
  {"L9", XK_L9},
  {"F20", XK_F20},
  {"L10", XK_L10},
  {"F21", XK_F21},
  {"R1", XK_R1},
  {"F22", XK_F22},
  {"R2", XK_R2},
  {"F23", XK_F23},
  {"R3", XK_R3},
  {"F24", XK_F24},
  {"R4", XK_R4},
  {"F25", XK_F25},
  {"R5", XK_R5},
  {"F26", XK_F26},
  {"R6", XK_R6},
  {"F27", XK_F27},
  {"R7", XK_R7},
  {"F28", XK_F28},
  {"R8", XK_R8},
  {"F29", XK_F29},
  {"R9", XK_R9},
  {"F30", XK_F30},
  {"R10", XK_R10},
  {"F31", XK_F31},
  {"R11", XK_R11},
  {"F32", XK_F32},
  {"R12", XK_R12},
  {"F33", XK_F33},
  {"R13", XK_R13},
  {"F34", XK_F34},
  {"R14", XK_R14},
  {"F35", XK_F35},
  {"R15", XK_R15},
  {"Shift_L", XK_Shift_L},
  {"Shift_R", XK_Shift_R},
  {"Control_L", XK_Control_L},
  {"Control_R", XK_Control_R},
  {"Caps_Lock", XK_Caps_Lock},
  {"Shift_Lock", XK_Shift_Lock},
  {"Meta_L", XK_Meta_L},
  {"Meta_R", XK_Meta_R},
  {"Alt_L", XK_Alt_L},
  {"Alt_R", XK_Alt_R},
  {"Super_L", XK_Super_L},
  {"Super_R", XK_Super_R},
  {"Hyper_L", XK_Hyper_L},
  {"Hyper_R", XK_Hyper_R},
#endif /* XK_MISCELLANY */
#ifdef XK_XKB_KEYS
  {"ISO_Lock", XK_ISO_Lock},
  {"ISO_Level2_Latch", XK_ISO_Level2_Latch},
  {"ISO_Level3_Shift", XK_ISO_Level3_Shift},
  {"ISO_Level3_Latch", XK_ISO_Level3_Latch},
  {"ISO_Level3_Lock", XK_ISO_Level3_Lock},
  {"ISO_Level5_Shift", XK_ISO_Level5_Shift},
  {"ISO_Level5_Latch", XK_ISO_Level5_Latch},
  {"ISO_Level5_Lock", XK_ISO_Level5_Lock},
  {"ISO_Group_Shift", XK_ISO_Group_Shift},
  {"ISO_Group_Latch", XK_ISO_Group_Latch},
  {"ISO_Group_Lock", XK_ISO_Group_Lock},
  {"ISO_Next_Group", XK_ISO_Next_Group},
  {"ISO_Next_Group_Lock", XK_ISO_Next_Group_Lock},
  {"ISO_Prev_Group", XK_ISO_Prev_Group},
  {"ISO_Prev_Group_Lock", XK_ISO_Prev_Group_Lock},
  {"ISO_First_Group", XK_ISO_First_Group},
  {"ISO_First_Group_Lock", XK_ISO_First_Group_Lock},
  {"ISO_Last_Group", XK_ISO_Last_Group},
  {"ISO_Last_Group_Lock", XK_ISO_Last_Group_Lock},
  {"ISO_Left_Tab", XK_ISO_Left_Tab},
  {"ISO_Move_Line_Up", XK_ISO_Move_Line_Up},
  {"ISO_Move_Line_Down", XK_ISO_Move_Line_Down},
  {"ISO_Partial_Line_Up", XK_ISO_Partial_Line_Up},
  {"ISO_Partial_Line_Down", XK_ISO_Partial_Line_Down},
  {"ISO_Partial_Space_Left", XK_ISO_Partial_Space_Left},
  {"ISO_Partial_Space_Right", XK_ISO_Partial_Space_Right},
  {"ISO_Set_Margin_Left", XK_ISO_Set_Margin_Left},
  {"ISO_Set_Margin_Right", XK_ISO_Set_Margin_Right},
  {"ISO_Release_Margin_Left", XK_ISO_Release_Margin_Left},
  {"ISO_Release_Margin_Right", XK_ISO_Release_Margin_Right},
  {"ISO_Release_Both_Margins", XK_ISO_Release_Both_Margins},
  {"ISO_Fast_Cursor_Left", XK_ISO_Fast_Cursor_Left},
  {"ISO_Fast_Cursor_Right", XK_ISO_Fast_Cursor_Right},
  {"ISO_Fast_Cursor_Up", XK_ISO_Fast_Cursor_Up},
  {"ISO_Fast_Cursor_Down", XK_ISO_Fast_Cursor_Down},
  {"ISO_Continuous_Underline", XK_ISO_Continuous_Underline},
  {"ISO_Discontinuous_Underline", XK_ISO_Discontinuous_Underline},
  {"ISO_Emphasize", XK_ISO_Emphasize},
  {"ISO_Center_Object", XK_ISO_Center_Object},
  {"ISO_Enter", XK_ISO_Enter},
  {"dead_grave", XK_dead_grave},
  {"dead_acute", XK_dead_acute},
  {"dead_circumflex", XK_dead_circumflex},
  {"dead_tilde", XK_dead_tilde},
  {"dead_perispomeni", XK_dead_perispomeni},
  {"dead_macron", XK_dead_macron},
  {"dead_breve", XK_dead_breve},
  {"dead_abovedot", XK_dead_abovedot},
  {"dead_diaeresis", XK_dead_diaeresis},
  {"dead_abovering", XK_dead_abovering},
  {"dead_doubleacute", XK_dead_doubleacute},
  {"dead_caron", XK_dead_caron},
  {"dead_cedilla", XK_dead_cedilla},
  {"dead_ogonek", XK_dead_ogonek},
  {"dead_iota", XK_dead_iota},
  {"dead_voiced_sound", XK_dead_voiced_sound},
  {"dead_semivoiced_sound", XK_dead_semivoiced_sound},
  {"dead_belowdot", XK_dead_belowdot},
  {"dead_hook", XK_dead_hook},
  {"dead_horn", XK_dead_horn},
  {"dead_stroke", XK_dead_stroke},
  {"dead_abovecomma", XK_dead_abovecomma},
  {"dead_psili", XK_dead_psili},
  {"dead_abovereversedcomma", XK_dead_abovereversedcomma},
  {"dead_dasia", XK_dead_dasia},
  {"dead_doublegrave", XK_dead_doublegrave},
  {"dead_belowring", XK_dead_belowring},
  {"dead_belowmacron", XK_dead_belowmacron},
  {"dead_belowcircumflex", XK_dead_belowcircumflex},
  {"dead_belowtilde", XK_dead_belowtilde},
  {"dead_belowbreve", XK_dead_belowbreve},
  {"dead_belowdiaeresis", XK_dead_belowdiaeresis},
  {"dead_invertedbreve", XK_dead_invertedbreve},
  {"dead_belowcomma", XK_dead_belowcomma},
  {"dead_currency", XK_dead_currency},
  {"dead_a", XK_dead_a},
  {"dead_A", XK_dead_A},
  {"dead_e", XK_dead_e},
  {"dead_E", XK_dead_E},
  {"dead_i", XK_dead_i},
  {"dead_I", XK_dead_I},
  {"dead_o", XK_dead_o},
  {"dead_O", XK_dead_O},
  {"dead_u", XK_dead_u},
  {"dead_U", XK_dead_U},
  {"dead_small_schwa", XK_dead_small_schwa},
  {"dead_capital_schwa", XK_dead_capital_schwa},
  {"First_Virtual_Screen", XK_First_Virtual_Screen},
  {"Prev_Virtual_Screen", XK_Prev_Virtual_Screen},
  {"Next_Virtual_Screen", XK_Next_Virtual_Screen},
  {"Last_Virtual_Screen", XK_Last_Virtual_Screen},
  {"Terminate_Server", XK_Terminate_Server},
  {"AccessX_Enable", XK_AccessX_Enable},
  {"AccessX_Feedback_Enable", XK_AccessX_Feedback_Enable},
  {"RepeatKeys_Enable", XK_RepeatKeys_Enable},
  {"SlowKeys_Enable", XK_SlowKeys_Enable},
  {"BounceKeys_Enable", XK_BounceKeys_Enable},
  {"StickyKeys_Enable", XK_StickyKeys_Enable},
  {"MouseKeys_Enable", XK_MouseKeys_Enable},
  {"MouseKeys_Accel_Enable", XK_MouseKeys_Accel_Enable},
  {"Overlay1_Enable", XK_Overlay1_Enable},
  {"Overlay2_Enable", XK_Overlay2_Enable},
  {"AudibleBell_Enable", XK_AudibleBell_Enable},
  {"Pointer_Left", XK_Pointer_Left},
  {"Pointer_Right", XK_Pointer_Right},
  {"Pointer_Up", XK_Pointer_Up},
  {"Pointer_Down", XK_Pointer_Down},
  {"Pointer_UpLeft", XK_Pointer_UpLeft},
  {"Pointer_UpRight", XK_Pointer_UpRight},
  {"Pointer_DownLeft", XK_Pointer_DownLeft},
  {"Pointer_DownRight", XK_Pointer_DownRight},
  {"Pointer_Button_Dflt", XK_Pointer_Button_Dflt},
  {"Pointer_Button1", XK_Pointer_Button1},
  {"Pointer_Button2", XK_Pointer_Button2},
  {"Pointer_Button3", XK_Pointer_Button3},
  {"Pointer_Button4", XK_Pointer_Button4},
  {"Pointer_Button5", XK_Pointer_Button5},
  {"Pointer_DblClick_Dflt", XK_Pointer_DblClick_Dflt},
  {"Pointer_DblClick1", XK_Pointer_DblClick1},
  {"Pointer_DblClick2", XK_Pointer_DblClick2},
  {"Pointer_DblClick3", XK_Pointer_DblClick3},
  {"Pointer_DblClick4", XK_Pointer_DblClick4},
  {"Pointer_DblClick5", XK_Pointer_DblClick5},
  {"Pointer_Drag_Dflt", XK_Pointer_Drag_Dflt},
  {"Pointer_Drag1", XK_Pointer_Drag1},
  {"Pointer_Drag2", XK_Pointer_Drag2},
  {"Pointer_Drag3", XK_Pointer_Drag3},
  {"Pointer_Drag4", XK_Pointer_Drag4},
  {"Pointer_Drag5", XK_Pointer_Drag5},
  {"Pointer_EnableKeys", XK_Pointer_EnableKeys},
  {"Pointer_Accelerate", XK_Pointer_Accelerate},
  {"Pointer_DfltBtnNext", XK_Pointer_DfltBtnNext},
  {"Pointer_DfltBtnPrev", XK_Pointer_DfltBtnPrev},
#endif /* XK_XKB_KEYS */
#ifdef XK_3270
  {"3270_Duplicate", XK_3270_Duplicate},
  {"3270_FieldMark", XK_3270_FieldMark},
  {"3270_Right2", XK_3270_Right2},
  {"3270_Left2", XK_3270_Left2},
  {"3270_BackTab", XK_3270_BackTab},
  {"3270_EraseEOF", XK_3270_EraseEOF},
  {"3270_EraseInput", XK_3270_EraseInput},
  {"3270_Reset", XK_3270_Reset},
  {"3270_Quit", XK_3270_Quit},
  {"3270_PA1", XK_3270_PA1},
  {"3270_PA2", XK_3270_PA2},
  {"3270_PA3", XK_3270_PA3},
  {"3270_Test", XK_3270_Test},
  {"3270_Attn", XK_3270_Attn},
  {"3270_CursorBlink", XK_3270_CursorBlink},
  {"3270_AltCursor", XK_3270_AltCursor},
  {"3270_KeyClick", XK_3270_KeyClick},
  {"3270_Jump", XK_3270_Jump},
  {"3270_Ident", XK_3270_Ident},
  {"3270_Rule", XK_3270_Rule},
  {"3270_Copy", XK_3270_Copy},
  {"3270_Play", XK_3270_Play},
  {"3270_Setup", XK_3270_Setup},
  {"3270_Record", XK_3270_Record},
  {"3270_ChangeScreen", XK_3270_ChangeScreen},
  {"3270_DeleteWord", XK_3270_DeleteWord},
  {"3270_ExSelect", XK_3270_ExSelect},
  {"3270_CursorSelect", XK_3270_CursorSelect},
  {"3270_PrintScreen", XK_3270_PrintScreen},
  {"3270_Enter", XK_3270_Enter},
#endif /* XK_3270 */
#ifdef XK_LATIN1
  {"space", XK_space},
  {"exclam", XK_exclam},
  {"quotedbl", XK_quotedbl},
  {"numbersign", XK_numbersign},
  {"dollar", XK_dollar},
  {"percent", XK_percent},
  {"ampersand", XK_ampersand},
  {"apostrophe", XK_apostrophe},
  {"quoteright", XK_quoteright},
  {"parenleft", XK_parenleft},
  {"parenright", XK_parenright},
  {"asterisk", XK_asterisk},
  {"plus", XK_plus},
  {"comma", XK_comma},
  {"minus", XK_minus},
  {"period", XK_period},
  {"slash", XK_slash},
  {"0", XK_0},
  {"1", XK_1},
  {"2", XK_2},
  {"3", XK_3},
  {"4", XK_4},
  {"5", XK_5},
  {"6", XK_6},
  {"7", XK_7},
  {"8", XK_8},
  {"9", XK_9},
  {"colon", XK_colon},
  {"semicolon", XK_semicolon},
  {"less", XK_less},
  {"equal", XK_equal},
  {"greater", XK_greater},
  {"question", XK_question},
  {"at", XK_at},
  {"A", XK_A},
  {"B", XK_B},
  {"C", XK_C},
  {"D", XK_D},
  {"E", XK_E},
  {"F", XK_F},
  {"G", XK_G},
  {"H", XK_H},
  {"I", XK_I},
  {"J", XK_J},
  {"K", XK_K},
  {"L", XK_L},
  {"M", XK_M},
  {"N", XK_N},
  {"O", XK_O},
  {"P", XK_P},
  {"Q", XK_Q},
  {"R", XK_R},
  {"S", XK_S},
  {"T", XK_T},
  {"U", XK_U},
  {"V", XK_V},
  {"W", XK_W},
  {"X", XK_X},
  {"Y", XK_Y},
  {"Z", XK_Z},
  {"bracketleft", XK_bracketleft},
  {"backslash", XK_backslash},
  {"bracketright", XK_bracketright},
  {"asciicircum", XK_asciicircum},
  {"underscore", XK_underscore},
  {"grave", XK_grave},
  {"quoteleft", XK_quoteleft},
  {"a", XK_a},
  {"b", XK_b},
  {"c", XK_c},
  {"d", XK_d},
  {"e", XK_e},
  {"f", XK_f},
  {"g", XK_g},
  {"h", XK_h},
  {"i", XK_i},
  {"j", XK_j},
  {"k", XK_k},
  {"l", XK_l},
  {"m", XK_m},
  {"n", XK_n},
  {"o", XK_o},
  {"p", XK_p},
  {"q", XK_q},
  {"r", XK_r},
  {"s", XK_s},
  {"t", XK_t},
  {"u", XK_u},
  {"v", XK_v},
  {"w", XK_w},
  {"x", XK_x},
  {"y", XK_y},
  {"z", XK_z},
  {"braceleft", XK_braceleft},
  {"bar", XK_bar},
  {"braceright", XK_braceright},
  {"asciitilde", XK_asciitilde},
  {"nobreakspace", XK_nobreakspace},
  {"exclamdown", XK_exclamdown},
  {"cent", XK_cent},
  {"sterling", XK_sterling},
  {"currency", XK_currency},
  {"yen", XK_yen},
  {"brokenbar", XK_brokenbar},
  {"section", XK_section},
  {"diaeresis", XK_diaeresis},
  {"copyright", XK_copyright},
  {"ordfeminine", XK_ordfeminine},
  {"guillemotleft", XK_guillemotleft},
  {"notsign", XK_notsign},
  {"hyphen", XK_hyphen},
  {"registered", XK_registered},
  {"macron", XK_macron},
  {"degree", XK_degree},
  {"plusminus", XK_plusminus},
  {"twosuperior", XK_twosuperior},
  {"threesuperior", XK_threesuperior},
  {"acute", XK_acute},
  {"mu", XK_mu},
  {"paragraph", XK_paragraph},
  {"periodcentered", XK_periodcentered},
  {"cedilla", XK_cedilla},
  {"onesuperior", XK_onesuperior},
  {"masculine", XK_masculine},
  {"guillemotright", XK_guillemotright},
  {"onequarter", XK_onequarter},
  {"onehalf", XK_onehalf},
  {"threequarters", XK_threequarters},
  {"questiondown", XK_questiondown},
  {"Agrave", XK_Agrave},
  {"Aacute", XK_Aacute},
  {"Acircumflex", XK_Acircumflex},
  {"Atilde", XK_Atilde},
  {"Adiaeresis", XK_Adiaeresis},
  {"Aring", XK_Aring},
  {"AE", XK_AE},
  {"Ccedilla", XK_Ccedilla},
  {"Egrave", XK_Egrave},
  {"Eacute", XK_Eacute},
  {"Ecircumflex", XK_Ecircumflex},
  {"Ediaeresis", XK_Ediaeresis},
  {"Igrave", XK_Igrave},
  {"Iacute", XK_Iacute},
  {"Icircumflex", XK_Icircumflex},
  {"Idiaeresis", XK_Idiaeresis},
  {"ETH", XK_ETH},
  {"Eth", XK_Eth},
  {"Ntilde", XK_Ntilde},
  {"Ograve", XK_Ograve},
  {"Oacute", XK_Oacute},
  {"Ocircumflex", XK_Ocircumflex},
  {"Otilde", XK_Otilde},
  {"Odiaeresis", XK_Odiaeresis},
  {"multiply", XK_multiply},
  {"Oslash", XK_Oslash},
  {"Ooblique", XK_Ooblique},
  {"Ugrave", XK_Ugrave},
  {"Uacute", XK_Uacute},
  {"Ucircumflex", XK_Ucircumflex},
  {"Udiaeresis", XK_Udiaeresis},
  {"Yacute", XK_Yacute},
  {"THORN", XK_THORN},
  {"Thorn", XK_Thorn},
  {"ssharp", XK_ssharp},
  {"agrave", XK_agrave},
  {"aacute", XK_aacute},
  {"acircumflex", XK_acircumflex},
  {"atilde", XK_atilde},
  {"adiaeresis", XK_adiaeresis},
  {"aring", XK_aring},
  {"ae", XK_ae},
  {"ccedilla", XK_ccedilla},
  {"egrave", XK_egrave},
  {"eacute", XK_eacute},
  {"ecircumflex", XK_ecircumflex},
  {"ediaeresis", XK_ediaeresis},
  {"igrave", XK_igrave},
  {"iacute", XK_iacute},
  {"icircumflex", XK_icircumflex},
  {"idiaeresis", XK_idiaeresis},
  {"eth", XK_eth},
  {"ntilde", XK_ntilde},
  {"ograve", XK_ograve},
  {"oacute", XK_oacute},
  {"ocircumflex", XK_ocircumflex},
  {"otilde", XK_otilde},
  {"odiaeresis", XK_odiaeresis},
  {"division", XK_division},
  {"oslash", XK_oslash},
  {"ooblique", XK_ooblique},
  {"ugrave", XK_ugrave},
  {"uacute", XK_uacute},
  {"ucircumflex", XK_ucircumflex},
  {"udiaeresis", XK_udiaeresis},
  {"yacute", XK_yacute},
  {"thorn", XK_thorn},
  {"ydiaeresis", XK_ydiaeresis},
#endif /* XK_LATIN1 */
#ifdef XK_LATIN2
  {"Aogonek", XK_Aogonek},
  {"breve", XK_breve},
  {"Lstroke", XK_Lstroke},
  {"Lcaron", XK_Lcaron},
  {"Sacute", XK_Sacute},
  {"Scaron", XK_Scaron},
  {"Scedilla", XK_Scedilla},
  {"Tcaron", XK_Tcaron},
  {"Zacute", XK_Zacute},
  {"Zcaron", XK_Zcaron},
  {"Zabovedot", XK_Zabovedot},
  {"aogonek", XK_aogonek},
  {"ogonek", XK_ogonek},
  {"lstroke", XK_lstroke},
  {"lcaron", XK_lcaron},
  {"sacute", XK_sacute},
  {"caron", XK_caron},
  {"scaron", XK_scaron},
  {"scedilla", XK_scedilla},
  {"tcaron", XK_tcaron},
  {"zacute", XK_zacute},
  {"doubleacute", XK_doubleacute},
  {"zcaron", XK_zcaron},
  {"zabovedot", XK_zabovedot},
  {"Racute", XK_Racute},
  {"Abreve", XK_Abreve},
  {"Lacute", XK_Lacute},
  {"Cacute", XK_Cacute},
  {"Ccaron", XK_Ccaron},
  {"Eogonek", XK_Eogonek},
  {"Ecaron", XK_Ecaron},
  {"Dcaron", XK_Dcaron},
  {"Dstroke", XK_Dstroke},
  {"Nacute", XK_Nacute},
  {"Ncaron", XK_Ncaron},
  {"Odoubleacute", XK_Odoubleacute},
  {"Rcaron", XK_Rcaron},
  {"Uring", XK_Uring},
  {"Udoubleacute", XK_Udoubleacute},
  {"Tcedilla", XK_Tcedilla},
  {"racute", XK_racute},
  {"abreve", XK_abreve},
  {"lacute", XK_lacute},
  {"cacute", XK_cacute},
  {"ccaron", XK_ccaron},
  {"eogonek", XK_eogonek},
  {"ecaron", XK_ecaron},
  {"dcaron", XK_dcaron},
  {"dstroke", XK_dstroke},
  {"nacute", XK_nacute},
  {"ncaron", XK_ncaron},
  {"odoubleacute", XK_odoubleacute},
  {"udoubleacute", XK_udoubleacute},
  {"rcaron", XK_rcaron},
  {"uring", XK_uring},
  {"tcedilla", XK_tcedilla},
  {"abovedot", XK_abovedot},
#endif /* XK_LATIN2 */
#ifdef XK_LATIN3
  {"Hstroke", XK_Hstroke},
  {"Hcircumflex", XK_Hcircumflex},
  {"Iabovedot", XK_Iabovedot},
  {"Gbreve", XK_Gbreve},
  {"Jcircumflex", XK_Jcircumflex},
  {"hstroke", XK_hstroke},
  {"hcircumflex", XK_hcircumflex},
  {"idotless", XK_idotless},
  {"gbreve", XK_gbreve},
  {"jcircumflex", XK_jcircumflex},
  {"Cabovedot", XK_Cabovedot},
  {"Ccircumflex", XK_Ccircumflex},
  {"Gabovedot", XK_Gabovedot},
  {"Gcircumflex", XK_Gcircumflex},
  {"Ubreve", XK_Ubreve},
  {"Scircumflex", XK_Scircumflex},
  {"cabovedot", XK_cabovedot},
  {"ccircumflex", XK_ccircumflex},
  {"gabovedot", XK_gabovedot},
  {"gcircumflex", XK_gcircumflex},
  {"ubreve", XK_ubreve},
  {"scircumflex", XK_scircumflex},
#endif /* XK_LATIN3 */
#ifdef XK_LATIN4
  {"kra", XK_kra},
  {"kappa", XK_kappa},
  {"Rcedilla", XK_Rcedilla},
  {"Itilde", XK_Itilde},
  {"Lcedilla", XK_Lcedilla},
  {"Emacron", XK_Emacron},
  {"Gcedilla", XK_Gcedilla},
  {"Tslash", XK_Tslash},
  {"rcedilla", XK_rcedilla},
  {"itilde", XK_itilde},
  {"lcedilla", XK_lcedilla},
  {"emacron", XK_emacron},
  {"gcedilla", XK_gcedilla},
  {"tslash", XK_tslash},
  {"ENG", XK_ENG},
  {"eng", XK_eng},
  {"Amacron", XK_Amacron},
  {"Iogonek", XK_Iogonek},
  {"Eabovedot", XK_Eabovedot},
  {"Imacron", XK_Imacron},
  {"Ncedilla", XK_Ncedilla},
  {"Omacron", XK_Omacron},
  {"Kcedilla", XK_Kcedilla},
  {"Uogonek", XK_Uogonek},
  {"Utilde", XK_Utilde},
  {"Umacron", XK_Umacron},
  {"amacron", XK_amacron},
  {"iogonek", XK_iogonek},
  {"eabovedot", XK_eabovedot},
  {"imacron", XK_imacron},
  {"ncedilla", XK_ncedilla},
  {"omacron", XK_omacron},
  {"kcedilla", XK_kcedilla},
  {"uogonek", XK_uogonek},
  {"utilde", XK_utilde},
  {"umacron", XK_umacron},
#endif /* XK_LATIN4 */
#ifdef XK_LATIN8
  {"Babovedot", XK_Babovedot},
  {"babovedot", XK_babovedot},
  {"Dabovedot", XK_Dabovedot},
  {"Wgrave", XK_Wgrave},
  {"Wacute", XK_Wacute},
  {"dabovedot", XK_dabovedot},
  {"Ygrave", XK_Ygrave},
  {"Fabovedot", XK_Fabovedot},
  {"fabovedot", XK_fabovedot},
  {"Mabovedot", XK_Mabovedot},
  {"mabovedot", XK_mabovedot},
  {"Pabovedot", XK_Pabovedot},
  {"wgrave", XK_wgrave},
  {"pabovedot", XK_pabovedot},
  {"wacute", XK_wacute},
  {"Sabovedot", XK_Sabovedot},
  {"ygrave", XK_ygrave},
  {"Wdiaeresis", XK_Wdiaeresis},
  {"wdiaeresis", XK_wdiaeresis},
  {"sabovedot", XK_sabovedot},
  {"Wcircumflex", XK_Wcircumflex},
  {"Tabovedot", XK_Tabovedot},
  {"Ycircumflex", XK_Ycircumflex},
  {"wcircumflex", XK_wcircumflex},
  {"tabovedot", XK_tabovedot},
  {"ycircumflex", XK_ycircumflex},
#endif /* XK_LATIN8 */
#ifdef XK_LATIN9
  {"OE", XK_OE},
  {"oe", XK_oe},
  {"Ydiaeresis", XK_Ydiaeresis},
#endif /* XK_LATIN9 */
#ifdef XK_KATAKANA
  {"overline", XK_overline},
  {"kana_fullstop", XK_kana_fullstop},
  {"kana_openingbracket", XK_kana_openingbracket},
  {"kana_closingbracket", XK_kana_closingbracket},
  {"kana_comma", XK_kana_comma},
  {"kana_conjunctive", XK_kana_conjunctive},
  {"kana_middledot", XK_kana_middledot},
  {"kana_WO", XK_kana_WO},
  {"kana_a", XK_kana_a},
  {"kana_i", XK_kana_i},
  {"kana_u", XK_kana_u},
  {"kana_e", XK_kana_e},
  {"kana_o", XK_kana_o},
  {"kana_ya", XK_kana_ya},
  {"kana_yu", XK_kana_yu},
  {"kana_yo", XK_kana_yo},
  {"kana_tsu", XK_kana_tsu},
  {"kana_tu", XK_kana_tu},
  {"prolongedsound", XK_prolongedsound},
  {"kana_A", XK_kana_A},
  {"kana_I", XK_kana_I},
  {"kana_U", XK_kana_U},
  {"kana_E", XK_kana_E},
  {"kana_O", XK_kana_O},
  {"kana_KA", XK_kana_KA},
  {"kana_KI", XK_kana_KI},
  {"kana_KU", XK_kana_KU},
  {"kana_KE", XK_kana_KE},
  {"kana_KO", XK_kana_KO},
  {"kana_SA", XK_kana_SA},
  {"kana_SHI", XK_kana_SHI},
  {"kana_SU", XK_kana_SU},
  {"kana_SE", XK_kana_SE},
  {"kana_SO", XK_kana_SO},
  {"kana_TA", XK_kana_TA},
  {"kana_CHI", XK_kana_CHI},
  {"kana_TI", XK_kana_TI},
  {"kana_TSU", XK_kana_TSU},
  {"kana_TU", XK_kana_TU},
  {"kana_TE", XK_kana_TE},
  {"kana_TO", XK_kana_TO},
  {"kana_NA", XK_kana_NA},
  {"kana_NI", XK_kana_NI},
  {"kana_NU", XK_kana_NU},
  {"kana_NE", XK_kana_NE},
  {"kana_NO", XK_kana_NO},
  {"kana_HA", XK_kana_HA},
  {"kana_HI", XK_kana_HI},
  {"kana_FU", XK_kana_FU},
  {"kana_HU", XK_kana_HU},
  {"kana_HE", XK_kana_HE},
  {"kana_HO", XK_kana_HO},
  {"kana_MA", XK_kana_MA},
  {"kana_MI", XK_kana_MI},
  {"kana_MU", XK_kana_MU},
  {"kana_ME", XK_kana_ME},
  {"kana_MO", XK_kana_MO},
  {"kana_YA", XK_kana_YA},
  {"kana_YU", XK_kana_YU},
  {"kana_YO", XK_kana_YO},
  {"kana_RA", XK_kana_RA},
  {"kana_RI", XK_kana_RI},
  {"kana_RU", XK_kana_RU},
  {"kana_RE", XK_kana_RE},
  {"kana_RO", XK_kana_RO},
  {"kana_WA", XK_kana_WA},
  {"kana_N", XK_kana_N},
  {"voicedsound", XK_voicedsound},
  {"semivoicedsound", XK_semivoicedsound},
  {"kana_switch", XK_kana_switch},
#endif /* XK_KATAKANA */
#ifdef XK_ARABIC
  {"Farsi_0", XK_Farsi_0},
  {"Farsi_1", XK_Farsi_1},
  {"Farsi_2", XK_Farsi_2},
  {"Farsi_3", XK_Farsi_3},
  {"Farsi_4", XK_Farsi_4},
  {"Farsi_5", XK_Farsi_5},
  {"Farsi_6", XK_Farsi_6},
  {"Farsi_7", XK_Farsi_7},
  {"Farsi_8", XK_Farsi_8},
  {"Farsi_9", XK_Farsi_9},
  {"Arabic_percent", XK_Arabic_percent},
  {"Arabic_superscript_alef", XK_Arabic_superscript_alef},
  {"Arabic_tteh", XK_Arabic_tteh},
  {"Arabic_peh", XK_Arabic_peh},
  {"Arabic_tcheh", XK_Arabic_tcheh},
  {"Arabic_ddal", XK_Arabic_ddal},
  {"Arabic_rreh", XK_Arabic_rreh},
  {"Arabic_comma", XK_Arabic_comma},
  {"Arabic_fullstop", XK_Arabic_fullstop},
  {"Arabic_0", XK_Arabic_0},
  {"Arabic_1", XK_Arabic_1},
  {"Arabic_2", XK_Arabic_2},
  {"Arabic_3", XK_Arabic_3},
  {"Arabic_4", XK_Arabic_4},
  {"Arabic_5", XK_Arabic_5},
  {"Arabic_6", XK_Arabic_6},
  {"Arabic_7", XK_Arabic_7},
  {"Arabic_8", XK_Arabic_8},
  {"Arabic_9", XK_Arabic_9},
  {"Arabic_semicolon", XK_Arabic_semicolon},
  {"Arabic_question_mark", XK_Arabic_question_mark},
  {"Arabic_hamza", XK_Arabic_hamza},
  {"Arabic_maddaonalef", XK_Arabic_maddaonalef},
  {"Arabic_hamzaonalef", XK_Arabic_hamzaonalef},
  {"Arabic_hamzaonwaw", XK_Arabic_hamzaonwaw},
  {"Arabic_hamzaunderalef", XK_Arabic_hamzaunderalef},
  {"Arabic_hamzaonyeh", XK_Arabic_hamzaonyeh},
  {"Arabic_alef", XK_Arabic_alef},
  {"Arabic_beh", XK_Arabic_beh},
  {"Arabic_tehmarbuta", XK_Arabic_tehmarbuta},
  {"Arabic_teh", XK_Arabic_teh},
  {"Arabic_theh", XK_Arabic_theh},
  {"Arabic_jeem", XK_Arabic_jeem},
  {"Arabic_hah", XK_Arabic_hah},
  {"Arabic_khah", XK_Arabic_khah},
  {"Arabic_dal", XK_Arabic_dal},
  {"Arabic_thal", XK_Arabic_thal},
  {"Arabic_ra", XK_Arabic_ra},
  {"Arabic_zain", XK_Arabic_zain},
  {"Arabic_seen", XK_Arabic_seen},
  {"Arabic_sheen", XK_Arabic_sheen},
  {"Arabic_sad", XK_Arabic_sad},
  {"Arabic_dad", XK_Arabic_dad},
  {"Arabic_tah", XK_Arabic_tah},
  {"Arabic_zah", XK_Arabic_zah},
  {"Arabic_ain", XK_Arabic_ain},
  {"Arabic_ghain", XK_Arabic_ghain},
  {"Arabic_tatweel", XK_Arabic_tatweel},
  {"Arabic_feh", XK_Arabic_feh},
  {"Arabic_qaf", XK_Arabic_qaf},
  {"Arabic_kaf", XK_Arabic_kaf},
  {"Arabic_lam", XK_Arabic_lam},
  {"Arabic_meem", XK_Arabic_meem},
  {"Arabic_noon", XK_Arabic_noon},
  {"Arabic_ha", XK_Arabic_ha},
  {"Arabic_heh", XK_Arabic_heh},
  {"Arabic_waw", XK_Arabic_waw},
  {"Arabic_alefmaksura", XK_Arabic_alefmaksura},
  {"Arabic_yeh", XK_Arabic_yeh},
  {"Arabic_fathatan", XK_Arabic_fathatan},
  {"Arabic_dammatan", XK_Arabic_dammatan},
  {"Arabic_kasratan", XK_Arabic_kasratan},
  {"Arabic_fatha", XK_Arabic_fatha},
  {"Arabic_damma", XK_Arabic_damma},
  {"Arabic_kasra", XK_Arabic_kasra},
  {"Arabic_shadda", XK_Arabic_shadda},
  {"Arabic_sukun", XK_Arabic_sukun},
  {"Arabic_madda_above", XK_Arabic_madda_above},
  {"Arabic_hamza_above", XK_Arabic_hamza_above},
  {"Arabic_hamza_below", XK_Arabic_hamza_below},
  {"Arabic_jeh", XK_Arabic_jeh},
  {"Arabic_veh", XK_Arabic_veh},
  {"Arabic_keheh", XK_Arabic_keheh},
  {"Arabic_gaf", XK_Arabic_gaf},
  {"Arabic_noon_ghunna", XK_Arabic_noon_ghunna},
  {"Arabic_heh_doachashmee", XK_Arabic_heh_doachashmee},
  {"Farsi_yeh", XK_Farsi_yeh},
  {"Arabic_farsi_yeh", XK_Arabic_farsi_yeh},
  {"Arabic_yeh_baree", XK_Arabic_yeh_baree},
  {"Arabic_heh_goal", XK_Arabic_heh_goal},
  {"Arabic_switch", XK_Arabic_switch},
#endif /* XK_ARABIC */
#ifdef XK_CYRILLIC
  {"Cyrillic_GHE_bar", XK_Cyrillic_GHE_bar},
  {"Cyrillic_ghe_bar", XK_Cyrillic_ghe_bar},
  {"Cyrillic_ZHE_descender", XK_Cyrillic_ZHE_descender},
  {"Cyrillic_zhe_descender", XK_Cyrillic_zhe_descender},
  {"Cyrillic_KA_descender", XK_Cyrillic_KA_descender},
  {"Cyrillic_ka_descender", XK_Cyrillic_ka_descender},
  {"Cyrillic_KA_vertstroke", XK_Cyrillic_KA_vertstroke},
  {"Cyrillic_ka_vertstroke", XK_Cyrillic_ka_vertstroke},
  {"Cyrillic_EN_descender", XK_Cyrillic_EN_descender},
  {"Cyrillic_en_descender", XK_Cyrillic_en_descender},
  {"Cyrillic_U_straight", XK_Cyrillic_U_straight},
  {"Cyrillic_u_straight", XK_Cyrillic_u_straight},
  {"Cyrillic_U_straight_bar", XK_Cyrillic_U_straight_bar},
  {"Cyrillic_u_straight_bar", XK_Cyrillic_u_straight_bar},
  {"Cyrillic_HA_descender", XK_Cyrillic_HA_descender},
  {"Cyrillic_ha_descender", XK_Cyrillic_ha_descender},
  {"Cyrillic_CHE_descender", XK_Cyrillic_CHE_descender},
  {"Cyrillic_che_descender", XK_Cyrillic_che_descender},
  {"Cyrillic_CHE_vertstroke", XK_Cyrillic_CHE_vertstroke},
  {"Cyrillic_che_vertstroke", XK_Cyrillic_che_vertstroke},
  {"Cyrillic_SHHA", XK_Cyrillic_SHHA},
  {"Cyrillic_shha", XK_Cyrillic_shha},
  {"Cyrillic_SCHWA", XK_Cyrillic_SCHWA},
  {"Cyrillic_schwa", XK_Cyrillic_schwa},
  {"Cyrillic_I_macron", XK_Cyrillic_I_macron},
  {"Cyrillic_i_macron", XK_Cyrillic_i_macron},
  {"Cyrillic_O_bar", XK_Cyrillic_O_bar},
  {"Cyrillic_o_bar", XK_Cyrillic_o_bar},
  {"Cyrillic_U_macron", XK_Cyrillic_U_macron},
  {"Cyrillic_u_macron", XK_Cyrillic_u_macron},
  {"Serbian_dje", XK_Serbian_dje},
  {"Macedonia_gje", XK_Macedonia_gje},
  {"Cyrillic_io", XK_Cyrillic_io},
  {"Ukrainian_ie", XK_Ukrainian_ie},
  {"Ukranian_je", XK_Ukranian_je},
  {"Macedonia_dse", XK_Macedonia_dse},
  {"Ukrainian_i", XK_Ukrainian_i},
  {"Ukranian_i", XK_Ukranian_i},
  {"Ukrainian_yi", XK_Ukrainian_yi},
  {"Ukranian_yi", XK_Ukranian_yi},
  {"Cyrillic_je", XK_Cyrillic_je},
  {"Serbian_je", XK_Serbian_je},
  {"Cyrillic_lje", XK_Cyrillic_lje},
  {"Serbian_lje", XK_Serbian_lje},
  {"Cyrillic_nje", XK_Cyrillic_nje},
  {"Serbian_nje", XK_Serbian_nje},
  {"Serbian_tshe", XK_Serbian_tshe},
  {"Macedonia_kje", XK_Macedonia_kje},
  {"Ukrainian_ghe_with_upturn", XK_Ukrainian_ghe_with_upturn},
  {"Byelorussian_shortu", XK_Byelorussian_shortu},
  {"Cyrillic_dzhe", XK_Cyrillic_dzhe},
  {"Serbian_dze", XK_Serbian_dze},
  {"numerosign", XK_numerosign},
  {"Serbian_DJE", XK_Serbian_DJE},
  {"Macedonia_GJE", XK_Macedonia_GJE},
  {"Cyrillic_IO", XK_Cyrillic_IO},
  {"Ukrainian_IE", XK_Ukrainian_IE},
  {"Ukranian_JE", XK_Ukranian_JE},
  {"Macedonia_DSE", XK_Macedonia_DSE},
  {"Ukrainian_I", XK_Ukrainian_I},
  {"Ukranian_I", XK_Ukranian_I},
  {"Ukrainian_YI", XK_Ukrainian_YI},
  {"Ukranian_YI", XK_Ukranian_YI},
  {"Cyrillic_JE", XK_Cyrillic_JE},
  {"Serbian_JE", XK_Serbian_JE},
  {"Cyrillic_LJE", XK_Cyrillic_LJE},
  {"Serbian_LJE", XK_Serbian_LJE},
  {"Cyrillic_NJE", XK_Cyrillic_NJE},
  {"Serbian_NJE", XK_Serbian_NJE},
  {"Serbian_TSHE", XK_Serbian_TSHE},
  {"Macedonia_KJE", XK_Macedonia_KJE},
  {"Ukrainian_GHE_WITH_UPTURN", XK_Ukrainian_GHE_WITH_UPTURN},
  {"Byelorussian_SHORTU", XK_Byelorussian_SHORTU},
  {"Cyrillic_DZHE", XK_Cyrillic_DZHE},
  {"Serbian_DZE", XK_Serbian_DZE},
  {"Cyrillic_yu", XK_Cyrillic_yu},
  {"Cyrillic_a", XK_Cyrillic_a},
  {"Cyrillic_be", XK_Cyrillic_be},
  {"Cyrillic_tse", XK_Cyrillic_tse},
  {"Cyrillic_de", XK_Cyrillic_de},
  {"Cyrillic_ie", XK_Cyrillic_ie},
  {"Cyrillic_ef", XK_Cyrillic_ef},
  {"Cyrillic_ghe", XK_Cyrillic_ghe},
  {"Cyrillic_ha", XK_Cyrillic_ha},
  {"Cyrillic_i", XK_Cyrillic_i},
  {"Cyrillic_shorti", XK_Cyrillic_shorti},
  {"Cyrillic_ka", XK_Cyrillic_ka},
  {"Cyrillic_el", XK_Cyrillic_el},
  {"Cyrillic_em", XK_Cyrillic_em},
  {"Cyrillic_en", XK_Cyrillic_en},
  {"Cyrillic_o", XK_Cyrillic_o},
  {"Cyrillic_pe", XK_Cyrillic_pe},
  {"Cyrillic_ya", XK_Cyrillic_ya},
  {"Cyrillic_er", XK_Cyrillic_er},
  {"Cyrillic_es", XK_Cyrillic_es},
  {"Cyrillic_te", XK_Cyrillic_te},
  {"Cyrillic_u", XK_Cyrillic_u},
  {"Cyrillic_zhe", XK_Cyrillic_zhe},
  {"Cyrillic_ve", XK_Cyrillic_ve},
  {"Cyrillic_softsign", XK_Cyrillic_softsign},
  {"Cyrillic_yeru", XK_Cyrillic_yeru},
  {"Cyrillic_ze", XK_Cyrillic_ze},
  {"Cyrillic_sha", XK_Cyrillic_sha},
  {"Cyrillic_e", XK_Cyrillic_e},
  {"Cyrillic_shcha", XK_Cyrillic_shcha},
  {"Cyrillic_che", XK_Cyrillic_che},
  {"Cyrillic_hardsign", XK_Cyrillic_hardsign},
  {"Cyrillic_YU", XK_Cyrillic_YU},
  {"Cyrillic_A", XK_Cyrillic_A},
  {"Cyrillic_BE", XK_Cyrillic_BE},
  {"Cyrillic_TSE", XK_Cyrillic_TSE},
  {"Cyrillic_DE", XK_Cyrillic_DE},
  {"Cyrillic_IE", XK_Cyrillic_IE},
  {"Cyrillic_EF", XK_Cyrillic_EF},
  {"Cyrillic_GHE", XK_Cyrillic_GHE},
  {"Cyrillic_HA", XK_Cyrillic_HA},
  {"Cyrillic_I", XK_Cyrillic_I},
  {"Cyrillic_SHORTI", XK_Cyrillic_SHORTI},
  {"Cyrillic_KA", XK_Cyrillic_KA},
  {"Cyrillic_EL", XK_Cyrillic_EL},
  {"Cyrillic_EM", XK_Cyrillic_EM},
  {"Cyrillic_EN", XK_Cyrillic_EN},
  {"Cyrillic_O", XK_Cyrillic_O},
  {"Cyrillic_PE", XK_Cyrillic_PE},
  {"Cyrillic_YA", XK_Cyrillic_YA},
  {"Cyrillic_ER", XK_Cyrillic_ER},
  {"Cyrillic_ES", XK_Cyrillic_ES},
  {"Cyrillic_TE", XK_Cyrillic_TE},
  {"Cyrillic_U", XK_Cyrillic_U},
  {"Cyrillic_ZHE", XK_Cyrillic_ZHE},
  {"Cyrillic_VE", XK_Cyrillic_VE},
  {"Cyrillic_SOFTSIGN", XK_Cyrillic_SOFTSIGN},
  {"Cyrillic_YERU", XK_Cyrillic_YERU},
  {"Cyrillic_ZE", XK_Cyrillic_ZE},
  {"Cyrillic_SHA", XK_Cyrillic_SHA},
  {"Cyrillic_E", XK_Cyrillic_E},
  {"Cyrillic_SHCHA", XK_Cyrillic_SHCHA},
  {"Cyrillic_CHE", XK_Cyrillic_CHE},
  {"Cyrillic_HARDSIGN", XK_Cyrillic_HARDSIGN},
#endif /* XK_CYRILLIC */
#ifdef XK_GREEK
  {"Greek_ALPHAaccent", XK_Greek_ALPHAaccent},
  {"Greek_EPSILONaccent", XK_Greek_EPSILONaccent},
  {"Greek_ETAaccent", XK_Greek_ETAaccent},
  {"Greek_IOTAaccent", XK_Greek_IOTAaccent},
  {"Greek_IOTAdieresis", XK_Greek_IOTAdieresis},
  {"Greek_IOTAdiaeresis", XK_Greek_IOTAdiaeresis},
  {"Greek_OMICRONaccent", XK_Greek_OMICRONaccent},
  {"Greek_UPSILONaccent", XK_Greek_UPSILONaccent},
  {"Greek_UPSILONdieresis", XK_Greek_UPSILONdieresis},
  {"Greek_OMEGAaccent", XK_Greek_OMEGAaccent},
  {"Greek_accentdieresis", XK_Greek_accentdieresis},
  {"Greek_horizbar", XK_Greek_horizbar},
  {"Greek_alphaaccent", XK_Greek_alphaaccent},
  {"Greek_epsilonaccent", XK_Greek_epsilonaccent},
  {"Greek_etaaccent", XK_Greek_etaaccent},
  {"Greek_iotaaccent", XK_Greek_iotaaccent},
  {"Greek_iotadieresis", XK_Greek_iotadieresis},
  {"Greek_iotaaccentdieresis", XK_Greek_iotaaccentdieresis},
  {"Greek_omicronaccent", XK_Greek_omicronaccent},
  {"Greek_upsilonaccent", XK_Greek_upsilonaccent},
  {"Greek_upsilondieresis", XK_Greek_upsilondieresis},
  {"Greek_upsilonaccentdieresis", XK_Greek_upsilonaccentdieresis},
  {"Greek_omegaaccent", XK_Greek_omegaaccent},
  {"Greek_ALPHA", XK_Greek_ALPHA},
  {"Greek_BETA", XK_Greek_BETA},
  {"Greek_GAMMA", XK_Greek_GAMMA},
  {"Greek_DELTA", XK_Greek_DELTA},
  {"Greek_EPSILON", XK_Greek_EPSILON},
  {"Greek_ZETA", XK_Greek_ZETA},
  {"Greek_ETA", XK_Greek_ETA},
  {"Greek_THETA", XK_Greek_THETA},
  {"Greek_IOTA", XK_Greek_IOTA},
  {"Greek_KAPPA", XK_Greek_KAPPA},
  {"Greek_LAMDA", XK_Greek_LAMDA},
  {"Greek_LAMBDA", XK_Greek_LAMBDA},
  {"Greek_MU", XK_Greek_MU},
  {"Greek_NU", XK_Greek_NU},
  {"Greek_XI", XK_Greek_XI},
  {"Greek_OMICRON", XK_Greek_OMICRON},
  {"Greek_PI", XK_Greek_PI},
  {"Greek_RHO", XK_Greek_RHO},
  {"Greek_SIGMA", XK_Greek_SIGMA},
  {"Greek_TAU", XK_Greek_TAU},
  {"Greek_UPSILON", XK_Greek_UPSILON},
  {"Greek_PHI", XK_Greek_PHI},
  {"Greek_CHI", XK_Greek_CHI},
  {"Greek_PSI", XK_Greek_PSI},
  {"Greek_OMEGA", XK_Greek_OMEGA},
  {"Greek_alpha", XK_Greek_alpha},
  {"Greek_beta", XK_Greek_beta},
  {"Greek_gamma", XK_Greek_gamma},
  {"Greek_delta", XK_Greek_delta},
  {"Greek_epsilon", XK_Greek_epsilon},
  {"Greek_zeta", XK_Greek_zeta},
  {"Greek_eta", XK_Greek_eta},
  {"Greek_theta", XK_Greek_theta},
  {"Greek_iota", XK_Greek_iota},
  {"Greek_kappa", XK_Greek_kappa},
  {"Greek_lamda", XK_Greek_lamda},
  {"Greek_lambda", XK_Greek_lambda},
  {"Greek_mu", XK_Greek_mu},
  {"Greek_nu", XK_Greek_nu},
  {"Greek_xi", XK_Greek_xi},
  {"Greek_omicron", XK_Greek_omicron},
  {"Greek_pi", XK_Greek_pi},
  {"Greek_rho", XK_Greek_rho},
  {"Greek_sigma", XK_Greek_sigma},
  {"Greek_finalsmallsigma", XK_Greek_finalsmallsigma},
  {"Greek_tau", XK_Greek_tau},
  {"Greek_upsilon", XK_Greek_upsilon},
  {"Greek_phi", XK_Greek_phi},
  {"Greek_chi", XK_Greek_chi},
  {"Greek_psi", XK_Greek_psi},
  {"Greek_omega", XK_Greek_omega},
  {"Greek_switch", XK_Greek_switch},
#endif /* XK_GREEK */
#ifdef XK_TECHNICAL
  {"leftradical", XK_leftradical},
  {"topleftradical", XK_topleftradical},
  {"horizconnector", XK_horizconnector},
  {"topintegral", XK_topintegral},
  {"botintegral", XK_botintegral},
  {"vertconnector", XK_vertconnector},
  {"topleftsqbracket", XK_topleftsqbracket},
  {"botleftsqbracket", XK_botleftsqbracket},
  {"toprightsqbracket", XK_toprightsqbracket},
  {"botrightsqbracket", XK_botrightsqbracket},
  {"topleftparens", XK_topleftparens},
  {"botleftparens", XK_botleftparens},
  {"toprightparens", XK_toprightparens},
  {"botrightparens", XK_botrightparens},
  {"leftmiddlecurlybrace", XK_leftmiddlecurlybrace},
  {"rightmiddlecurlybrace", XK_rightmiddlecurlybrace},
  {"topleftsummation", XK_topleftsummation},
  {"botleftsummation", XK_botleftsummation},
  {"topvertsummationconnector", XK_topvertsummationconnector},
  {"botvertsummationconnector", XK_botvertsummationconnector},
  {"toprightsummation", XK_toprightsummation},
  {"botrightsummation", XK_botrightsummation},
  {"rightmiddlesummation", XK_rightmiddlesummation},
  {"lessthanequal", XK_lessthanequal},
  {"notequal", XK_notequal},
  {"greaterthanequal", XK_greaterthanequal},
  {"integral", XK_integral},
  {"therefore", XK_therefore},
  {"variation", XK_variation},
  {"infinity", XK_infinity},
  {"nabla", XK_nabla},
  {"approximate", XK_approximate},
  {"similarequal", XK_similarequal},
  {"ifonlyif", XK_ifonlyif},
  {"implies", XK_implies},
  {"identical", XK_identical},
  {"radical", XK_radical},
  {"includedin", XK_includedin},
  {"includes", XK_includes},
  {"intersection", XK_intersection},
  {"union", XK_union},
  {"logicaland", XK_logicaland},
  {"logicalor", XK_logicalor},
  {"partialderivative", XK_partialderivative},
  {"function", XK_function},
  {"leftarrow", XK_leftarrow},
  {"uparrow", XK_uparrow},
  {"rightarrow", XK_rightarrow},
  {"downarrow", XK_downarrow},
#endif /* XK_TECHNICAL */
#ifdef XK_SPECIAL
  {"blank", XK_blank},
  {"soliddiamond", XK_soliddiamond},
  {"checkerboard", XK_checkerboard},
  {"ht", XK_ht},
  {"ff", XK_ff},
  {"cr", XK_cr},
  {"lf", XK_lf},
  {"nl", XK_nl},
  {"vt", XK_vt},
  {"lowrightcorner", XK_lowrightcorner},
  {"uprightcorner", XK_uprightcorner},
  {"upleftcorner", XK_upleftcorner},
  {"lowleftcorner", XK_lowleftcorner},
  {"crossinglines", XK_crossinglines},
  {"horizlinescan1", XK_horizlinescan1},
  {"horizlinescan3", XK_horizlinescan3},
  {"horizlinescan5", XK_horizlinescan5},
  {"horizlinescan7", XK_horizlinescan7},
  {"horizlinescan9", XK_horizlinescan9},
  {"leftt", XK_leftt},
  {"rightt", XK_rightt},
  {"bott", XK_bott},
  {"topt", XK_topt},
  {"vertbar", XK_vertbar},
#endif /* XK_SPECIAL */
#ifdef XK_PUBLISHING
  {"emspace", XK_emspace},
  {"enspace", XK_enspace},
  {"em3space", XK_em3space},
  {"em4space", XK_em4space},
  {"digitspace", XK_digitspace},
  {"punctspace", XK_punctspace},
  {"thinspace", XK_thinspace},
  {"hairspace", XK_hairspace},
  {"emdash", XK_emdash},
  {"endash", XK_endash},
  {"signifblank", XK_signifblank},
  {"ellipsis", XK_ellipsis},
  {"doubbaselinedot", XK_doubbaselinedot},
  {"onethird", XK_onethird},
  {"twothirds", XK_twothirds},
  {"onefifth", XK_onefifth},
  {"twofifths", XK_twofifths},
  {"threefifths", XK_threefifths},
  {"fourfifths", XK_fourfifths},
  {"onesixth", XK_onesixth},
  {"fivesixths", XK_fivesixths},
  {"careof", XK_careof},
  {"figdash", XK_figdash},
  {"leftanglebracket", XK_leftanglebracket},
  {"decimalpoint", XK_decimalpoint},
  {"rightanglebracket", XK_rightanglebracket},
  {"marker", XK_marker},
  {"oneeighth", XK_oneeighth},
  {"threeeighths", XK_threeeighths},
  {"fiveeighths", XK_fiveeighths},
  {"seveneighths", XK_seveneighths},
  {"trademark", XK_trademark},
  {"signaturemark", XK_signaturemark},
  {"trademarkincircle", XK_trademarkincircle},
  {"leftopentriangle", XK_leftopentriangle},
  {"rightopentriangle", XK_rightopentriangle},
  {"emopencircle", XK_emopencircle},
  {"emopenrectangle", XK_emopenrectangle},
  {"leftsinglequotemark", XK_leftsinglequotemark},
  {"rightsinglequotemark", XK_rightsinglequotemark},
  {"leftdoublequotemark", XK_leftdoublequotemark},
  {"rightdoublequotemark", XK_rightdoublequotemark},
  {"prescription", XK_prescription},
  {"minutes", XK_minutes},
  {"seconds", XK_seconds},
  {"latincross", XK_latincross},
  {"hexagram", XK_hexagram},
  {"filledrectbullet", XK_filledrectbullet},
  {"filledlefttribullet", XK_filledlefttribullet},
  {"filledrighttribullet", XK_filledrighttribullet},
  {"emfilledcircle", XK_emfilledcircle},
  {"emfilledrect", XK_emfilledrect},
  {"enopencircbullet", XK_enopencircbullet},
  {"enopensquarebullet", XK_enopensquarebullet},
  {"openrectbullet", XK_openrectbullet},
  {"opentribulletup", XK_opentribulletup},
  {"opentribulletdown", XK_opentribulletdown},
  {"openstar", XK_openstar},
  {"enfilledcircbullet", XK_enfilledcircbullet},
  {"enfilledsqbullet", XK_enfilledsqbullet},
  {"filledtribulletup", XK_filledtribulletup},
  {"filledtribulletdown", XK_filledtribulletdown},
  {"leftpointer", XK_leftpointer},
  {"rightpointer", XK_rightpointer},
  {"club", XK_club},
  {"diamond", XK_diamond},
  {"heart", XK_heart},
  {"maltesecross", XK_maltesecross},
  {"dagger", XK_dagger},
  {"doubledagger", XK_doubledagger},
  {"checkmark", XK_checkmark},
  {"ballotcross", XK_ballotcross},
  {"musicalsharp", XK_musicalsharp},
  {"musicalflat", XK_musicalflat},
  {"malesymbol", XK_malesymbol},
  {"femalesymbol", XK_femalesymbol},
  {"telephone", XK_telephone},
  {"telephonerecorder", XK_telephonerecorder},
  {"phonographcopyright", XK_phonographcopyright},
  {"caret", XK_caret},
  {"singlelowquotemark", XK_singlelowquotemark},
  {"doublelowquotemark", XK_doublelowquotemark},
  {"cursor", XK_cursor},
#endif /* XK_PUBLISHING */
#ifdef XK_APL
  {"leftcaret", XK_leftcaret},
  {"rightcaret", XK_rightcaret},
  {"downcaret", XK_downcaret},
  {"upcaret", XK_upcaret},
  {"overbar", XK_overbar},
  {"downtack", XK_downtack},
  {"upshoe", XK_upshoe},
  {"downstile", XK_downstile},
  {"underbar", XK_underbar},
  {"jot", XK_jot},
  {"quad", XK_quad},
  {"uptack", XK_uptack},
  {"circle", XK_circle},
  {"upstile", XK_upstile},
  {"downshoe", XK_downshoe},
  {"rightshoe", XK_rightshoe},
  {"leftshoe", XK_leftshoe},
  {"lefttack", XK_lefttack},
  {"righttack", XK_righttack},
#endif /* XK_APL */
#ifdef XK_HEBREW
  {"hebrew_doublelowline", XK_hebrew_doublelowline},
  {"hebrew_aleph", XK_hebrew_aleph},
  {"hebrew_bet", XK_hebrew_bet},
  {"hebrew_beth", XK_hebrew_beth},
  {"hebrew_gimel", XK_hebrew_gimel},
  {"hebrew_gimmel", XK_hebrew_gimmel},
  {"hebrew_dalet", XK_hebrew_dalet},
  {"hebrew_daleth", XK_hebrew_daleth},
  {"hebrew_he", XK_hebrew_he},
  {"hebrew_waw", XK_hebrew_waw},
  {"hebrew_zain", XK_hebrew_zain},
  {"hebrew_zayin", XK_hebrew_zayin},
  {"hebrew_chet", XK_hebrew_chet},
  {"hebrew_het", XK_hebrew_het},
  {"hebrew_tet", XK_hebrew_tet},
  {"hebrew_teth", XK_hebrew_teth},
  {"hebrew_yod", XK_hebrew_yod},
  {"hebrew_finalkaph", XK_hebrew_finalkaph},
  {"hebrew_kaph", XK_hebrew_kaph},
  {"hebrew_lamed", XK_hebrew_lamed},
  {"hebrew_finalmem", XK_hebrew_finalmem},
  {"hebrew_mem", XK_hebrew_mem},
  {"hebrew_finalnun", XK_hebrew_finalnun},
  {"hebrew_nun", XK_hebrew_nun},
  {"hebrew_samech", XK_hebrew_samech},
  {"hebrew_samekh", XK_hebrew_samekh},
  {"hebrew_ayin", XK_hebrew_ayin},
  {"hebrew_finalpe", XK_hebrew_finalpe},
  {"hebrew_pe", XK_hebrew_pe},
  {"hebrew_finalzade", XK_hebrew_finalzade},
  {"hebrew_finalzadi", XK_hebrew_finalzadi},
  {"hebrew_zade", XK_hebrew_zade},
  {"hebrew_zadi", XK_hebrew_zadi},
  {"hebrew_qoph", XK_hebrew_qoph},
  {"hebrew_kuf", XK_hebrew_kuf},
  {"hebrew_resh", XK_hebrew_resh},
  {"hebrew_shin", XK_hebrew_shin},
  {"hebrew_taw", XK_hebrew_taw},
  {"hebrew_taf", XK_hebrew_taf},
  {"Hebrew_switch", XK_Hebrew_switch},
#endif /* XK_HEBREW */
#ifdef XK_THAI
  {"Thai_kokai", XK_Thai_kokai},
  {"Thai_khokhai", XK_Thai_khokhai},
  {"Thai_khokhuat", XK_Thai_khokhuat},
  {"Thai_khokhwai", XK_Thai_khokhwai},
  {"Thai_khokhon", XK_Thai_khokhon},
  {"Thai_khorakhang", XK_Thai_khorakhang},
  {"Thai_ngongu", XK_Thai_ngongu},
  {"Thai_chochan", XK_Thai_chochan},
  {"Thai_choching", XK_Thai_choching},
  {"Thai_chochang", XK_Thai_chochang},
  {"Thai_soso", XK_Thai_soso},
  {"Thai_chochoe", XK_Thai_chochoe},
  {"Thai_yoying", XK_Thai_yoying},
  {"Thai_dochada", XK_Thai_dochada},
  {"Thai_topatak", XK_Thai_topatak},
  {"Thai_thothan", XK_Thai_thothan},
  {"Thai_thonangmontho", XK_Thai_thonangmontho},
  {"Thai_thophuthao", XK_Thai_thophuthao},
  {"Thai_nonen", XK_Thai_nonen},
  {"Thai_dodek", XK_Thai_dodek},
  {"Thai_totao", XK_Thai_totao},
  {"Thai_thothung", XK_Thai_thothung},
  {"Thai_thothahan", XK_Thai_thothahan},
  {"Thai_thothong", XK_Thai_thothong},
  {"Thai_nonu", XK_Thai_nonu},
  {"Thai_bobaimai", XK_Thai_bobaimai},
  {"Thai_popla", XK_Thai_popla},
  {"Thai_phophung", XK_Thai_phophung},
  {"Thai_fofa", XK_Thai_fofa},
  {"Thai_phophan", XK_Thai_phophan},
  {"Thai_fofan", XK_Thai_fofan},
  {"Thai_phosamphao", XK_Thai_phosamphao},
  {"Thai_moma", XK_Thai_moma},
  {"Thai_yoyak", XK_Thai_yoyak},
  {"Thai_rorua", XK_Thai_rorua},
  {"Thai_ru", XK_Thai_ru},
  {"Thai_loling", XK_Thai_loling},
  {"Thai_lu", XK_Thai_lu},
  {"Thai_wowaen", XK_Thai_wowaen},
  {"Thai_sosala", XK_Thai_sosala},
  {"Thai_sorusi", XK_Thai_sorusi},
  {"Thai_sosua", XK_Thai_sosua},
  {"Thai_hohip", XK_Thai_hohip},
  {"Thai_lochula", XK_Thai_lochula},
  {"Thai_oang", XK_Thai_oang},
  {"Thai_honokhuk", XK_Thai_honokhuk},
  {"Thai_paiyannoi", XK_Thai_paiyannoi},
  {"Thai_saraa", XK_Thai_saraa},
  {"Thai_maihanakat", XK_Thai_maihanakat},
  {"Thai_saraaa", XK_Thai_saraaa},
  {"Thai_saraam", XK_Thai_saraam},
  {"Thai_sarai", XK_Thai_sarai},
  {"Thai_saraii", XK_Thai_saraii},
  {"Thai_saraue", XK_Thai_saraue},
  {"Thai_sarauee", XK_Thai_sarauee},
  {"Thai_sarau", XK_Thai_sarau},
  {"Thai_sarauu", XK_Thai_sarauu},
  {"Thai_phinthu", XK_Thai_phinthu},
  {"Thai_maihanakat_maitho", XK_Thai_maihanakat_maitho},
  {"Thai_baht", XK_Thai_baht},
  {"Thai_sarae", XK_Thai_sarae},
  {"Thai_saraae", XK_Thai_saraae},
  {"Thai_sarao", XK_Thai_sarao},
  {"Thai_saraaimaimuan", XK_Thai_saraaimaimuan},
  {"Thai_saraaimaimalai", XK_Thai_saraaimaimalai},
  {"Thai_lakkhangyao", XK_Thai_lakkhangyao},
  {"Thai_maiyamok", XK_Thai_maiyamok},
  {"Thai_maitaikhu", XK_Thai_maitaikhu},
  {"Thai_maiek", XK_Thai_maiek},
  {"Thai_maitho", XK_Thai_maitho},
  {"Thai_maitri", XK_Thai_maitri},
  {"Thai_maichattawa", XK_Thai_maichattawa},
  {"Thai_thanthakhat", XK_Thai_thanthakhat},
  {"Thai_nikhahit", XK_Thai_nikhahit},
  {"Thai_leksun", XK_Thai_leksun},
  {"Thai_leknung", XK_Thai_leknung},
  {"Thai_leksong", XK_Thai_leksong},
  {"Thai_leksam", XK_Thai_leksam},
  {"Thai_leksi", XK_Thai_leksi},
  {"Thai_lekha", XK_Thai_lekha},
  {"Thai_lekhok", XK_Thai_lekhok},
  {"Thai_lekchet", XK_Thai_lekchet},
  {"Thai_lekpaet", XK_Thai_lekpaet},
  {"Thai_lekkao", XK_Thai_lekkao},
#endif /* XK_THAI */
#ifdef XK_KOREAN
  {"Hangul", XK_Hangul},
  {"Hangul_Start", XK_Hangul_Start},
  {"Hangul_End", XK_Hangul_End},
  {"Hangul_Hanja", XK_Hangul_Hanja},
  {"Hangul_Jamo", XK_Hangul_Jamo},
  {"Hangul_Romaja", XK_Hangul_Romaja},
  {"Hangul_Codeinput", XK_Hangul_Codeinput},
  {"Hangul_Jeonja", XK_Hangul_Jeonja},
  {"Hangul_Banja", XK_Hangul_Banja},
  {"Hangul_PreHanja", XK_Hangul_PreHanja},
  {"Hangul_PostHanja", XK_Hangul_PostHanja},
  {"Hangul_SingleCandidate", XK_Hangul_SingleCandidate},
  {"Hangul_MultipleCandidate", XK_Hangul_MultipleCandidate},
  {"Hangul_PreviousCandidate", XK_Hangul_PreviousCandidate},
  {"Hangul_Special", XK_Hangul_Special},
  {"Hangul_switch", XK_Hangul_switch},
  {"Hangul_Kiyeog", XK_Hangul_Kiyeog},
  {"Hangul_SsangKiyeog", XK_Hangul_SsangKiyeog},
  {"Hangul_KiyeogSios", XK_Hangul_KiyeogSios},
  {"Hangul_Nieun", XK_Hangul_Nieun},
  {"Hangul_NieunJieuj", XK_Hangul_NieunJieuj},
  {"Hangul_NieunHieuh", XK_Hangul_NieunHieuh},
  {"Hangul_Dikeud", XK_Hangul_Dikeud},
  {"Hangul_SsangDikeud", XK_Hangul_SsangDikeud},
  {"Hangul_Rieul", XK_Hangul_Rieul},
  {"Hangul_RieulKiyeog", XK_Hangul_RieulKiyeog},
  {"Hangul_RieulMieum", XK_Hangul_RieulMieum},
  {"Hangul_RieulPieub", XK_Hangul_RieulPieub},
  {"Hangul_RieulSios", XK_Hangul_RieulSios},
  {"Hangul_RieulTieut", XK_Hangul_RieulTieut},
  {"Hangul_RieulPhieuf", XK_Hangul_RieulPhieuf},
  {"Hangul_RieulHieuh", XK_Hangul_RieulHieuh},
  {"Hangul_Mieum", XK_Hangul_Mieum},
  {"Hangul_Pieub", XK_Hangul_Pieub},
  {"Hangul_SsangPieub", XK_Hangul_SsangPieub},
  {"Hangul_PieubSios", XK_Hangul_PieubSios},
  {"Hangul_Sios", XK_Hangul_Sios},
  {"Hangul_SsangSios", XK_Hangul_SsangSios},
  {"Hangul_Ieung", XK_Hangul_Ieung},
  {"Hangul_Jieuj", XK_Hangul_Jieuj},
  {"Hangul_SsangJieuj", XK_Hangul_SsangJieuj},
  {"Hangul_Cieuc", XK_Hangul_Cieuc},
  {"Hangul_Khieuq", XK_Hangul_Khieuq},
  {"Hangul_Tieut", XK_Hangul_Tieut},
  {"Hangul_Phieuf", XK_Hangul_Phieuf},
  {"Hangul_Hieuh", XK_Hangul_Hieuh},
  {"Hangul_A", XK_Hangul_A},
  {"Hangul_AE", XK_Hangul_AE},
  {"Hangul_YA", XK_Hangul_YA},
  {"Hangul_YAE", XK_Hangul_YAE},
  {"Hangul_EO", XK_Hangul_EO},
  {"Hangul_E", XK_Hangul_E},
  {"Hangul_YEO", XK_Hangul_YEO},
  {"Hangul_YE", XK_Hangul_YE},
  {"Hangul_O", XK_Hangul_O},
  {"Hangul_WA", XK_Hangul_WA},
  {"Hangul_WAE", XK_Hangul_WAE},
  {"Hangul_OE", XK_Hangul_OE},
  {"Hangul_YO", XK_Hangul_YO},
  {"Hangul_U", XK_Hangul_U},
  {"Hangul_WEO", XK_Hangul_WEO},
  {"Hangul_WE", XK_Hangul_WE},
  {"Hangul_WI", XK_Hangul_WI},
  {"Hangul_YU", XK_Hangul_YU},
  {"Hangul_EU", XK_Hangul_EU},
  {"Hangul_YI", XK_Hangul_YI},
  {"Hangul_I", XK_Hangul_I},
  {"Hangul_J_Kiyeog", XK_Hangul_J_Kiyeog},
  {"Hangul_J_SsangKiyeog", XK_Hangul_J_SsangKiyeog},
  {"Hangul_J_KiyeogSios", XK_Hangul_J_KiyeogSios},
  {"Hangul_J_Nieun", XK_Hangul_J_Nieun},
  {"Hangul_J_NieunJieuj", XK_Hangul_J_NieunJieuj},
  {"Hangul_J_NieunHieuh", XK_Hangul_J_NieunHieuh},
  {"Hangul_J_Dikeud", XK_Hangul_J_Dikeud},
  {"Hangul_J_Rieul", XK_Hangul_J_Rieul},
  {"Hangul_J_RieulKiyeog", XK_Hangul_J_RieulKiyeog},
  {"Hangul_J_RieulMieum", XK_Hangul_J_RieulMieum},
  {"Hangul_J_RieulPieub", XK_Hangul_J_RieulPieub},
  {"Hangul_J_RieulSios", XK_Hangul_J_RieulSios},
  {"Hangul_J_RieulTieut", XK_Hangul_J_RieulTieut},
  {"Hangul_J_RieulPhieuf", XK_Hangul_J_RieulPhieuf},
  {"Hangul_J_RieulHieuh", XK_Hangul_J_RieulHieuh},
  {"Hangul_J_Mieum", XK_Hangul_J_Mieum},
  {"Hangul_J_Pieub", XK_Hangul_J_Pieub},
  {"Hangul_J_PieubSios", XK_Hangul_J_PieubSios},
  {"Hangul_J_Sios", XK_Hangul_J_Sios},
  {"Hangul_J_SsangSios", XK_Hangul_J_SsangSios},
  {"Hangul_J_Ieung", XK_Hangul_J_Ieung},
  {"Hangul_J_Jieuj", XK_Hangul_J_Jieuj},
  {"Hangul_J_Cieuc", XK_Hangul_J_Cieuc},
  {"Hangul_J_Khieuq", XK_Hangul_J_Khieuq},
  {"Hangul_J_Tieut", XK_Hangul_J_Tieut},
  {"Hangul_J_Phieuf", XK_Hangul_J_Phieuf},
  {"Hangul_J_Hieuh", XK_Hangul_J_Hieuh},
  {"Hangul_RieulYeorinHieuh", XK_Hangul_RieulYeorinHieuh},
  {"Hangul_SunkyeongeumMieum", XK_Hangul_SunkyeongeumMieum},
  {"Hangul_SunkyeongeumPieub", XK_Hangul_SunkyeongeumPieub},
  {"Hangul_PanSios", XK_Hangul_PanSios},
  {"Hangul_KkogjiDalrinIeung", XK_Hangul_KkogjiDalrinIeung},
  {"Hangul_SunkyeongeumPhieuf", XK_Hangul_SunkyeongeumPhieuf},
  {"Hangul_YeorinHieuh", XK_Hangul_YeorinHieuh},
  {"Hangul_AraeA", XK_Hangul_AraeA},
  {"Hangul_AraeAE", XK_Hangul_AraeAE},
  {"Hangul_J_PanSios", XK_Hangul_J_PanSios},
  {"Hangul_J_KkogjiDalrinIeung", XK_Hangul_J_KkogjiDalrinIeung},
  {"Hangul_J_YeorinHieuh", XK_Hangul_J_YeorinHieuh},
  {"Korean_Won", XK_Korean_Won},
#endif /* XK_KOREAN */
#ifdef XK_ARMENIAN
  {"Armenian_ligature_ew", XK_Armenian_ligature_ew},
  {"Armenian_full_stop", XK_Armenian_full_stop},
  {"Armenian_verjaket", XK_Armenian_verjaket},
  {"Armenian_separation_mark", XK_Armenian_separation_mark},
  {"Armenian_but", XK_Armenian_but},
  {"Armenian_hyphen", XK_Armenian_hyphen},
  {"Armenian_yentamna", XK_Armenian_yentamna},
  {"Armenian_exclam", XK_Armenian_exclam},
  {"Armenian_amanak", XK_Armenian_amanak},
  {"Armenian_accent", XK_Armenian_accent},
  {"Armenian_shesht", XK_Armenian_shesht},
  {"Armenian_question", XK_Armenian_question},
  {"Armenian_paruyk", XK_Armenian_paruyk},
  {"Armenian_AYB", XK_Armenian_AYB},
  {"Armenian_ayb", XK_Armenian_ayb},
  {"Armenian_BEN", XK_Armenian_BEN},
  {"Armenian_ben", XK_Armenian_ben},
  {"Armenian_GIM", XK_Armenian_GIM},
  {"Armenian_gim", XK_Armenian_gim},
  {"Armenian_DA", XK_Armenian_DA},
  {"Armenian_da", XK_Armenian_da},
  {"Armenian_YECH", XK_Armenian_YECH},
  {"Armenian_yech", XK_Armenian_yech},
  {"Armenian_ZA", XK_Armenian_ZA},
  {"Armenian_za", XK_Armenian_za},
  {"Armenian_E", XK_Armenian_E},
  {"Armenian_e", XK_Armenian_e},
  {"Armenian_AT", XK_Armenian_AT},
  {"Armenian_at", XK_Armenian_at},
  {"Armenian_TO", XK_Armenian_TO},
  {"Armenian_to", XK_Armenian_to},
  {"Armenian_ZHE", XK_Armenian_ZHE},
  {"Armenian_zhe", XK_Armenian_zhe},
  {"Armenian_INI", XK_Armenian_INI},
  {"Armenian_ini", XK_Armenian_ini},
  {"Armenian_LYUN", XK_Armenian_LYUN},
  {"Armenian_lyun", XK_Armenian_lyun},
  {"Armenian_KHE", XK_Armenian_KHE},
  {"Armenian_khe", XK_Armenian_khe},
  {"Armenian_TSA", XK_Armenian_TSA},
  {"Armenian_tsa", XK_Armenian_tsa},
  {"Armenian_KEN", XK_Armenian_KEN},
  {"Armenian_ken", XK_Armenian_ken},
  {"Armenian_HO", XK_Armenian_HO},
  {"Armenian_ho", XK_Armenian_ho},
  {"Armenian_DZA", XK_Armenian_DZA},
  {"Armenian_dza", XK_Armenian_dza},
  {"Armenian_GHAT", XK_Armenian_GHAT},
  {"Armenian_ghat", XK_Armenian_ghat},
  {"Armenian_TCHE", XK_Armenian_TCHE},
  {"Armenian_tche", XK_Armenian_tche},
  {"Armenian_MEN", XK_Armenian_MEN},
  {"Armenian_men", XK_Armenian_men},
  {"Armenian_HI", XK_Armenian_HI},
  {"Armenian_hi", XK_Armenian_hi},
  {"Armenian_NU", XK_Armenian_NU},
  {"Armenian_nu", XK_Armenian_nu},
  {"Armenian_SHA", XK_Armenian_SHA},
  {"Armenian_sha", XK_Armenian_sha},
  {"Armenian_VO", XK_Armenian_VO},
  {"Armenian_vo", XK_Armenian_vo},
  {"Armenian_CHA", XK_Armenian_CHA},
  {"Armenian_cha", XK_Armenian_cha},
  {"Armenian_PE", XK_Armenian_PE},
  {"Armenian_pe", XK_Armenian_pe},
  {"Armenian_JE", XK_Armenian_JE},
  {"Armenian_je", XK_Armenian_je},
  {"Armenian_RA", XK_Armenian_RA},
  {"Armenian_ra", XK_Armenian_ra},
  {"Armenian_SE", XK_Armenian_SE},
  {"Armenian_se", XK_Armenian_se},
  {"Armenian_VEV", XK_Armenian_VEV},
  {"Armenian_vev", XK_Armenian_vev},
  {"Armenian_TYUN", XK_Armenian_TYUN},
  {"Armenian_tyun", XK_Armenian_tyun},
  {"Armenian_RE", XK_Armenian_RE},
  {"Armenian_re", XK_Armenian_re},
  {"Armenian_TSO", XK_Armenian_TSO},
  {"Armenian_tso", XK_Armenian_tso},
  {"Armenian_VYUN", XK_Armenian_VYUN},
  {"Armenian_vyun", XK_Armenian_vyun},
  {"Armenian_PYUR", XK_Armenian_PYUR},
  {"Armenian_pyur", XK_Armenian_pyur},
  {"Armenian_KE", XK_Armenian_KE},
  {"Armenian_ke", XK_Armenian_ke},
  {"Armenian_O", XK_Armenian_O},
  {"Armenian_o", XK_Armenian_o},
  {"Armenian_FE", XK_Armenian_FE},
  {"Armenian_fe", XK_Armenian_fe},
  {"Armenian_apostrophe", XK_Armenian_apostrophe},
#endif /* XK_ARMENIAN */
#ifdef XK_GEORGIAN
  {"Georgian_an", XK_Georgian_an},
  {"Georgian_ban", XK_Georgian_ban},
  {"Georgian_gan", XK_Georgian_gan},
  {"Georgian_don", XK_Georgian_don},
  {"Georgian_en", XK_Georgian_en},
  {"Georgian_vin", XK_Georgian_vin},
  {"Georgian_zen", XK_Georgian_zen},
  {"Georgian_tan", XK_Georgian_tan},
  {"Georgian_in", XK_Georgian_in},
  {"Georgian_kan", XK_Georgian_kan},
  {"Georgian_las", XK_Georgian_las},
  {"Georgian_man", XK_Georgian_man},
  {"Georgian_nar", XK_Georgian_nar},
  {"Georgian_on", XK_Georgian_on},
  {"Georgian_par", XK_Georgian_par},
  {"Georgian_zhar", XK_Georgian_zhar},
  {"Georgian_rae", XK_Georgian_rae},
  {"Georgian_san", XK_Georgian_san},
  {"Georgian_tar", XK_Georgian_tar},
  {"Georgian_un", XK_Georgian_un},
  {"Georgian_phar", XK_Georgian_phar},
  {"Georgian_khar", XK_Georgian_khar},
  {"Georgian_ghan", XK_Georgian_ghan},
  {"Georgian_qar", XK_Georgian_qar},
  {"Georgian_shin", XK_Georgian_shin},
  {"Georgian_chin", XK_Georgian_chin},
  {"Georgian_can", XK_Georgian_can},
  {"Georgian_jil", XK_Georgian_jil},
  {"Georgian_cil", XK_Georgian_cil},
  {"Georgian_char", XK_Georgian_char},
  {"Georgian_xan", XK_Georgian_xan},
  {"Georgian_jhan", XK_Georgian_jhan},
  {"Georgian_hae", XK_Georgian_hae},
  {"Georgian_he", XK_Georgian_he},
  {"Georgian_hie", XK_Georgian_hie},
  {"Georgian_we", XK_Georgian_we},
  {"Georgian_har", XK_Georgian_har},
  {"Georgian_hoe", XK_Georgian_hoe},
  {"Georgian_fi", XK_Georgian_fi},
#endif /* XK_GEORGIAN */
#ifdef XK_CAUCASUS
  {"Xabovedot", XK_Xabovedot},
  {"Ibreve", XK_Ibreve},
  {"Zstroke", XK_Zstroke},
  {"Gcaron", XK_Gcaron},
  {"Ocaron", XK_Ocaron},
  {"Obarred", XK_Obarred},
  {"xabovedot", XK_xabovedot},
  {"ibreve", XK_ibreve},
  {"zstroke", XK_zstroke},
  {"gcaron", XK_gcaron},
  {"ocaron", XK_ocaron},
  {"obarred", XK_obarred},
  {"SCHWA", XK_SCHWA},
  {"schwa", XK_schwa},
  {"Lbelowdot", XK_Lbelowdot},
  {"lbelowdot", XK_lbelowdot},
#endif /* XK_CAUCASUS */
#ifdef XK_VIETNAMESE
  {"Abelowdot", XK_Abelowdot},
  {"abelowdot", XK_abelowdot},
  {"Ahook", XK_Ahook},
  {"ahook", XK_ahook},
  {"Acircumflexacute", XK_Acircumflexacute},
  {"acircumflexacute", XK_acircumflexacute},
  {"Acircumflexgrave", XK_Acircumflexgrave},
  {"acircumflexgrave", XK_acircumflexgrave},
  {"Acircumflexhook", XK_Acircumflexhook},
  {"acircumflexhook", XK_acircumflexhook},
  {"Acircumflextilde", XK_Acircumflextilde},
  {"acircumflextilde", XK_acircumflextilde},
  {"Acircumflexbelowdot", XK_Acircumflexbelowdot},
  {"acircumflexbelowdot", XK_acircumflexbelowdot},
  {"Abreveacute", XK_Abreveacute},
  {"abreveacute", XK_abreveacute},
  {"Abrevegrave", XK_Abrevegrave},
  {"abrevegrave", XK_abrevegrave},
  {"Abrevehook", XK_Abrevehook},
  {"abrevehook", XK_abrevehook},
  {"Abrevetilde", XK_Abrevetilde},
  {"abrevetilde", XK_abrevetilde},
  {"Abrevebelowdot", XK_Abrevebelowdot},
  {"abrevebelowdot", XK_abrevebelowdot},
  {"Ebelowdot", XK_Ebelowdot},
  {"ebelowdot", XK_ebelowdot},
  {"Ehook", XK_Ehook},
  {"ehook", XK_ehook},
  {"Etilde", XK_Etilde},
  {"etilde", XK_etilde},
  {"Ecircumflexacute", XK_Ecircumflexacute},
  {"ecircumflexacute", XK_ecircumflexacute},
  {"Ecircumflexgrave", XK_Ecircumflexgrave},
  {"ecircumflexgrave", XK_ecircumflexgrave},
  {"Ecircumflexhook", XK_Ecircumflexhook},
  {"ecircumflexhook", XK_ecircumflexhook},
  {"Ecircumflextilde", XK_Ecircumflextilde},
  {"ecircumflextilde", XK_ecircumflextilde},
  {"Ecircumflexbelowdot", XK_Ecircumflexbelowdot},
  {"ecircumflexbelowdot", XK_ecircumflexbelowdot},
  {"Ihook", XK_Ihook},
  {"ihook", XK_ihook},
  {"Ibelowdot", XK_Ibelowdot},
  {"ibelowdot", XK_ibelowdot},
  {"Obelowdot", XK_Obelowdot},
  {"obelowdot", XK_obelowdot},
  {"Ohook", XK_Ohook},
  {"ohook", XK_ohook},
  {"Ocircumflexacute", XK_Ocircumflexacute},
  {"ocircumflexacute", XK_ocircumflexacute},
  {"Ocircumflexgrave", XK_Ocircumflexgrave},
  {"ocircumflexgrave", XK_ocircumflexgrave},
  {"Ocircumflexhook", XK_Ocircumflexhook},
  {"ocircumflexhook", XK_ocircumflexhook},
  {"Ocircumflextilde", XK_Ocircumflextilde},
  {"ocircumflextilde", XK_ocircumflextilde},
  {"Ocircumflexbelowdot", XK_Ocircumflexbelowdot},
  {"ocircumflexbelowdot", XK_ocircumflexbelowdot},
  {"Ohornacute", XK_Ohornacute},
  {"ohornacute", XK_ohornacute},
  {"Ohorngrave", XK_Ohorngrave},
  {"ohorngrave", XK_ohorngrave},
  {"Ohornhook", XK_Ohornhook},
  {"ohornhook", XK_ohornhook},
  {"Ohorntilde", XK_Ohorntilde},
  {"ohorntilde", XK_ohorntilde},
  {"Ohornbelowdot", XK_Ohornbelowdot},
  {"ohornbelowdot", XK_ohornbelowdot},
  {"Ubelowdot", XK_Ubelowdot},
  {"ubelowdot", XK_ubelowdot},
  {"Uhook", XK_Uhook},
  {"uhook", XK_uhook},
  {"Uhornacute", XK_Uhornacute},
  {"uhornacute", XK_uhornacute},
  {"Uhorngrave", XK_Uhorngrave},
  {"uhorngrave", XK_uhorngrave},
  {"Uhornhook", XK_Uhornhook},
  {"uhornhook", XK_uhornhook},
  {"Uhorntilde", XK_Uhorntilde},
  {"uhorntilde", XK_uhorntilde},
  {"Uhornbelowdot", XK_Uhornbelowdot},
  {"uhornbelowdot", XK_uhornbelowdot},
  {"Ybelowdot", XK_Ybelowdot},
  {"ybelowdot", XK_ybelowdot},
  {"Yhook", XK_Yhook},
  {"yhook", XK_yhook},
  {"Ytilde", XK_Ytilde},
  {"ytilde", XK_ytilde},
  {"Ohorn", XK_Ohorn},
  {"ohorn", XK_ohorn},
  {"Uhorn", XK_Uhorn},
  {"uhorn", XK_uhorn},
#endif /* XK_VIETNAMESE */
#ifdef XK_CURRENCY
  {"EcuSign", XK_EcuSign},
  {"ColonSign", XK_ColonSign},
  {"CruzeiroSign", XK_CruzeiroSign},
  {"FFrancSign", XK_FFrancSign},
  {"LiraSign", XK_LiraSign},
  {"MillSign", XK_MillSign},
  {"NairaSign", XK_NairaSign},
  {"PesetaSign", XK_PesetaSign},
  {"RupeeSign", XK_RupeeSign},
  {"WonSign", XK_WonSign},
  {"NewSheqelSign", XK_NewSheqelSign},
  {"DongSign", XK_DongSign},
  {"EuroSign", XK_EuroSign},
#endif /* XK_CURRENCY */
#ifdef XK_MATHEMATICAL
  {"zerosuperior", XK_zerosuperior},
  {"foursuperior", XK_foursuperior},
  {"fivesuperior", XK_fivesuperior},
  {"sixsuperior", XK_sixsuperior},
  {"sevensuperior", XK_sevensuperior},
  {"eightsuperior", XK_eightsuperior},
  {"ninesuperior", XK_ninesuperior},
  {"zerosubscript", XK_zerosubscript},
  {"onesubscript", XK_onesubscript},
  {"twosubscript", XK_twosubscript},
  {"threesubscript", XK_threesubscript},
  {"foursubscript", XK_foursubscript},
  {"fivesubscript", XK_fivesubscript},
  {"sixsubscript", XK_sixsubscript},
  {"sevensubscript", XK_sevensubscript},
  {"eightsubscript", XK_eightsubscript},
  {"ninesubscript", XK_ninesubscript},
  {"partdifferential", XK_partdifferential},
  {"emptyset", XK_emptyset},
  {"elementof", XK_elementof},
  {"notelementof", XK_notelementof},
  {"containsas", XK_containsas},
  {"squareroot", XK_squareroot},
  {"cuberoot", XK_cuberoot},
  {"fourthroot", XK_fourthroot},
  {"dintegral", XK_dintegral},
  {"tintegral", XK_tintegral},
  {"because", XK_because},
  {"approxeq", XK_approxeq},
  {"notapproxeq", XK_notapproxeq},
  {"notidentical", XK_notidentical},
  {"stricteq", XK_stricteq},
#endif /* XK_MATHEMATICAL */
#ifdef XK_BRAILLE
  {"braille_dot_1", XK_braille_dot_1},
  {"braille_dot_2", XK_braille_dot_2},
  {"braille_dot_3", XK_braille_dot_3},
  {"braille_dot_4", XK_braille_dot_4},
  {"braille_dot_5", XK_braille_dot_5},
  {"braille_dot_6", XK_braille_dot_6},
  {"braille_dot_7", XK_braille_dot_7},
  {"braille_dot_8", XK_braille_dot_8},
  {"braille_dot_9", XK_braille_dot_9},
  {"braille_dot_10", XK_braille_dot_10},
  {"braille_blank", XK_braille_blank},
  {"braille_dots_1", XK_braille_dots_1},
  {"braille_dots_2", XK_braille_dots_2},
  {"braille_dots_12", XK_braille_dots_12},
  {"braille_dots_3", XK_braille_dots_3},
  {"braille_dots_13", XK_braille_dots_13},
  {"braille_dots_23", XK_braille_dots_23},
  {"braille_dots_123", XK_braille_dots_123},
  {"braille_dots_4", XK_braille_dots_4},
  {"braille_dots_14", XK_braille_dots_14},
  {"braille_dots_24", XK_braille_dots_24},
  {"braille_dots_124", XK_braille_dots_124},
  {"braille_dots_34", XK_braille_dots_34},
  {"braille_dots_134", XK_braille_dots_134},
  {"braille_dots_234", XK_braille_dots_234},
  {"braille_dots_1234", XK_braille_dots_1234},
  {"braille_dots_5", XK_braille_dots_5},
  {"braille_dots_15", XK_braille_dots_15},
  {"braille_dots_25", XK_braille_dots_25},
  {"braille_dots_125", XK_braille_dots_125},
  {"braille_dots_35", XK_braille_dots_35},
  {"braille_dots_135", XK_braille_dots_135},
  {"braille_dots_235", XK_braille_dots_235},
  {"braille_dots_1235", XK_braille_dots_1235},
  {"braille_dots_45", XK_braille_dots_45},
  {"braille_dots_145", XK_braille_dots_145},
  {"braille_dots_245", XK_braille_dots_245},
  {"braille_dots_1245", XK_braille_dots_1245},
  {"braille_dots_345", XK_braille_dots_345},
  {"braille_dots_1345", XK_braille_dots_1345},
  {"braille_dots_2345", XK_braille_dots_2345},
  {"braille_dots_12345", XK_braille_dots_12345},
  {"braille_dots_6", XK_braille_dots_6},
  {"braille_dots_16", XK_braille_dots_16},
  {"braille_dots_26", XK_braille_dots_26},
  {"braille_dots_126", XK_braille_dots_126},
  {"braille_dots_36", XK_braille_dots_36},
  {"braille_dots_136", XK_braille_dots_136},
  {"braille_dots_236", XK_braille_dots_236},
  {"braille_dots_1236", XK_braille_dots_1236},
  {"braille_dots_46", XK_braille_dots_46},
  {"braille_dots_146", XK_braille_dots_146},
  {"braille_dots_246", XK_braille_dots_246},
  {"braille_dots_1246", XK_braille_dots_1246},
  {"braille_dots_346", XK_braille_dots_346},
  {"braille_dots_1346", XK_braille_dots_1346},
  {"braille_dots_2346", XK_braille_dots_2346},
  {"braille_dots_12346", XK_braille_dots_12346},
  {"braille_dots_56", XK_braille_dots_56},
  {"braille_dots_156", XK_braille_dots_156},
  {"braille_dots_256", XK_braille_dots_256},
  {"braille_dots_1256", XK_braille_dots_1256},
  {"braille_dots_356", XK_braille_dots_356},
  {"braille_dots_1356", XK_braille_dots_1356},
  {"braille_dots_2356", XK_braille_dots_2356},
  {"braille_dots_12356", XK_braille_dots_12356},
  {"braille_dots_456", XK_braille_dots_456},
  {"braille_dots_1456", XK_braille_dots_1456},
  {"braille_dots_2456", XK_braille_dots_2456},
  {"braille_dots_12456", XK_braille_dots_12456},
  {"braille_dots_3456", XK_braille_dots_3456},
  {"braille_dots_13456", XK_braille_dots_13456},
  {"braille_dots_23456", XK_braille_dots_23456},
  {"braille_dots_123456", XK_braille_dots_123456},
  {"braille_dots_7", XK_braille_dots_7},
  {"braille_dots_17", XK_braille_dots_17},
  {"braille_dots_27", XK_braille_dots_27},
  {"braille_dots_127", XK_braille_dots_127},
  {"braille_dots_37", XK_braille_dots_37},
  {"braille_dots_137", XK_braille_dots_137},
  {"braille_dots_237", XK_braille_dots_237},
  {"braille_dots_1237", XK_braille_dots_1237},
  {"braille_dots_47", XK_braille_dots_47},
  {"braille_dots_147", XK_braille_dots_147},
  {"braille_dots_247", XK_braille_dots_247},
  {"braille_dots_1247", XK_braille_dots_1247},
  {"braille_dots_347", XK_braille_dots_347},
  {"braille_dots_1347", XK_braille_dots_1347},
  {"braille_dots_2347", XK_braille_dots_2347},
  {"braille_dots_12347", XK_braille_dots_12347},
  {"braille_dots_57", XK_braille_dots_57},
  {"braille_dots_157", XK_braille_dots_157},
  {"braille_dots_257", XK_braille_dots_257},
  {"braille_dots_1257", XK_braille_dots_1257},
  {"braille_dots_357", XK_braille_dots_357},
  {"braille_dots_1357", XK_braille_dots_1357},
  {"braille_dots_2357", XK_braille_dots_2357},
  {"braille_dots_12357", XK_braille_dots_12357},
  {"braille_dots_457", XK_braille_dots_457},
  {"braille_dots_1457", XK_braille_dots_1457},
  {"braille_dots_2457", XK_braille_dots_2457},
  {"braille_dots_12457", XK_braille_dots_12457},
  {"braille_dots_3457", XK_braille_dots_3457},
  {"braille_dots_13457", XK_braille_dots_13457},
  {"braille_dots_23457", XK_braille_dots_23457},
  {"braille_dots_123457", XK_braille_dots_123457},
  {"braille_dots_67", XK_braille_dots_67},
  {"braille_dots_167", XK_braille_dots_167},
  {"braille_dots_267", XK_braille_dots_267},
  {"braille_dots_1267", XK_braille_dots_1267},
  {"braille_dots_367", XK_braille_dots_367},
  {"braille_dots_1367", XK_braille_dots_1367},
  {"braille_dots_2367", XK_braille_dots_2367},
  {"braille_dots_12367", XK_braille_dots_12367},
  {"braille_dots_467", XK_braille_dots_467},
  {"braille_dots_1467", XK_braille_dots_1467},
  {"braille_dots_2467", XK_braille_dots_2467},
  {"braille_dots_12467", XK_braille_dots_12467},
  {"braille_dots_3467", XK_braille_dots_3467},
  {"braille_dots_13467", XK_braille_dots_13467},
  {"braille_dots_23467", XK_braille_dots_23467},
  {"braille_dots_123467", XK_braille_dots_123467},
  {"braille_dots_567", XK_braille_dots_567},
  {"braille_dots_1567", XK_braille_dots_1567},
  {"braille_dots_2567", XK_braille_dots_2567},
  {"braille_dots_12567", XK_braille_dots_12567},
  {"braille_dots_3567", XK_braille_dots_3567},
  {"braille_dots_13567", XK_braille_dots_13567},
  {"braille_dots_23567", XK_braille_dots_23567},
  {"braille_dots_123567", XK_braille_dots_123567},
  {"braille_dots_4567", XK_braille_dots_4567},
  {"braille_dots_14567", XK_braille_dots_14567},
  {"braille_dots_24567", XK_braille_dots_24567},
  {"braille_dots_124567", XK_braille_dots_124567},
  {"braille_dots_34567", XK_braille_dots_34567},
  {"braille_dots_134567", XK_braille_dots_134567},
  {"braille_dots_234567", XK_braille_dots_234567},
  {"braille_dots_1234567", XK_braille_dots_1234567},
  {"braille_dots_8", XK_braille_dots_8},
  {"braille_dots_18", XK_braille_dots_18},
  {"braille_dots_28", XK_braille_dots_28},
  {"braille_dots_128", XK_braille_dots_128},
  {"braille_dots_38", XK_braille_dots_38},
  {"braille_dots_138", XK_braille_dots_138},
  {"braille_dots_238", XK_braille_dots_238},
  {"braille_dots_1238", XK_braille_dots_1238},
  {"braille_dots_48", XK_braille_dots_48},
  {"braille_dots_148", XK_braille_dots_148},
  {"braille_dots_248", XK_braille_dots_248},
  {"braille_dots_1248", XK_braille_dots_1248},
  {"braille_dots_348", XK_braille_dots_348},
  {"braille_dots_1348", XK_braille_dots_1348},
  {"braille_dots_2348", XK_braille_dots_2348},
  {"braille_dots_12348", XK_braille_dots_12348},
  {"braille_dots_58", XK_braille_dots_58},
  {"braille_dots_158", XK_braille_dots_158},
  {"braille_dots_258", XK_braille_dots_258},
  {"braille_dots_1258", XK_braille_dots_1258},
  {"braille_dots_358", XK_braille_dots_358},
  {"braille_dots_1358", XK_braille_dots_1358},
  {"braille_dots_2358", XK_braille_dots_2358},
  {"braille_dots_12358", XK_braille_dots_12358},
  {"braille_dots_458", XK_braille_dots_458},
  {"braille_dots_1458", XK_braille_dots_1458},
  {"braille_dots_2458", XK_braille_dots_2458},
  {"braille_dots_12458", XK_braille_dots_12458},
  {"braille_dots_3458", XK_braille_dots_3458},
  {"braille_dots_13458", XK_braille_dots_13458},
  {"braille_dots_23458", XK_braille_dots_23458},
  {"braille_dots_123458", XK_braille_dots_123458},
  {"braille_dots_68", XK_braille_dots_68},
  {"braille_dots_168", XK_braille_dots_168},
  {"braille_dots_268", XK_braille_dots_268},
  {"braille_dots_1268", XK_braille_dots_1268},
  {"braille_dots_368", XK_braille_dots_368},
  {"braille_dots_1368", XK_braille_dots_1368},
  {"braille_dots_2368", XK_braille_dots_2368},
  {"braille_dots_12368", XK_braille_dots_12368},
  {"braille_dots_468", XK_braille_dots_468},
  {"braille_dots_1468", XK_braille_dots_1468},
  {"braille_dots_2468", XK_braille_dots_2468},
  {"braille_dots_12468", XK_braille_dots_12468},
  {"braille_dots_3468", XK_braille_dots_3468},
  {"braille_dots_13468", XK_braille_dots_13468},
  {"braille_dots_23468", XK_braille_dots_23468},
  {"braille_dots_123468", XK_braille_dots_123468},
  {"braille_dots_568", XK_braille_dots_568},
  {"braille_dots_1568", XK_braille_dots_1568},
  {"braille_dots_2568", XK_braille_dots_2568},
  {"braille_dots_12568", XK_braille_dots_12568},
  {"braille_dots_3568", XK_braille_dots_3568},
  {"braille_dots_13568", XK_braille_dots_13568},
  {"braille_dots_23568", XK_braille_dots_23568},
  {"braille_dots_123568", XK_braille_dots_123568},
  {"braille_dots_4568", XK_braille_dots_4568},
  {"braille_dots_14568", XK_braille_dots_14568},
  {"braille_dots_24568", XK_braille_dots_24568},
  {"braille_dots_124568", XK_braille_dots_124568},
  {"braille_dots_34568", XK_braille_dots_34568},
  {"braille_dots_134568", XK_braille_dots_134568},
  {"braille_dots_234568", XK_braille_dots_234568},
  {"braille_dots_1234568", XK_braille_dots_1234568},
  {"braille_dots_78", XK_braille_dots_78},
  {"braille_dots_178", XK_braille_dots_178},
  {"braille_dots_278", XK_braille_dots_278},
  {"braille_dots_1278", XK_braille_dots_1278},
  {"braille_dots_378", XK_braille_dots_378},
  {"braille_dots_1378", XK_braille_dots_1378},
  {"braille_dots_2378", XK_braille_dots_2378},
  {"braille_dots_12378", XK_braille_dots_12378},
  {"braille_dots_478", XK_braille_dots_478},
  {"braille_dots_1478", XK_braille_dots_1478},
  {"braille_dots_2478", XK_braille_dots_2478},
  {"braille_dots_12478", XK_braille_dots_12478},
  {"braille_dots_3478", XK_braille_dots_3478},
  {"braille_dots_13478", XK_braille_dots_13478},
  {"braille_dots_23478", XK_braille_dots_23478},
  {"braille_dots_123478", XK_braille_dots_123478},
  {"braille_dots_578", XK_braille_dots_578},
  {"braille_dots_1578", XK_braille_dots_1578},
  {"braille_dots_2578", XK_braille_dots_2578},
  {"braille_dots_12578", XK_braille_dots_12578},
  {"braille_dots_3578", XK_braille_dots_3578},
  {"braille_dots_13578", XK_braille_dots_13578},
  {"braille_dots_23578", XK_braille_dots_23578},
  {"braille_dots_123578", XK_braille_dots_123578},
  {"braille_dots_4578", XK_braille_dots_4578},
  {"braille_dots_14578", XK_braille_dots_14578},
  {"braille_dots_24578", XK_braille_dots_24578},
  {"braille_dots_124578", XK_braille_dots_124578},
  {"braille_dots_34578", XK_braille_dots_34578},
  {"braille_dots_134578", XK_braille_dots_134578},
  {"braille_dots_234578", XK_braille_dots_234578},
  {"braille_dots_1234578", XK_braille_dots_1234578},
  {"braille_dots_678", XK_braille_dots_678},
  {"braille_dots_1678", XK_braille_dots_1678},
  {"braille_dots_2678", XK_braille_dots_2678},
  {"braille_dots_12678", XK_braille_dots_12678},
  {"braille_dots_3678", XK_braille_dots_3678},
  {"braille_dots_13678", XK_braille_dots_13678},
  {"braille_dots_23678", XK_braille_dots_23678},
  {"braille_dots_123678", XK_braille_dots_123678},
  {"braille_dots_4678", XK_braille_dots_4678},
  {"braille_dots_14678", XK_braille_dots_14678},
  {"braille_dots_24678", XK_braille_dots_24678},
  {"braille_dots_124678", XK_braille_dots_124678},
  {"braille_dots_34678", XK_braille_dots_34678},
  {"braille_dots_134678", XK_braille_dots_134678},
  {"braille_dots_234678", XK_braille_dots_234678},
  {"braille_dots_1234678", XK_braille_dots_1234678},
  {"braille_dots_5678", XK_braille_dots_5678},
  {"braille_dots_15678", XK_braille_dots_15678},
  {"braille_dots_25678", XK_braille_dots_25678},
  {"braille_dots_125678", XK_braille_dots_125678},
  {"braille_dots_35678", XK_braille_dots_35678},
  {"braille_dots_135678", XK_braille_dots_135678},
  {"braille_dots_235678", XK_braille_dots_235678},
  {"braille_dots_1235678", XK_braille_dots_1235678},
  {"braille_dots_45678", XK_braille_dots_45678},
  {"braille_dots_145678", XK_braille_dots_145678},
  {"braille_dots_245678", XK_braille_dots_245678},
  {"braille_dots_1245678", XK_braille_dots_1245678},
  {"braille_dots_345678", XK_braille_dots_345678},
  {"braille_dots_1345678", XK_braille_dots_1345678},
  {"braille_dots_2345678", XK_braille_dots_2345678},
  {"braille_dots_12345678", XK_braille_dots_12345678},
#endif /* XK_BRAILLE */
  {NULL, 0x0},
};
#endif