/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// PciDeviceInfo Information about a PCI device
type PciDeviceInfo struct {
	Id  string `json:"id"`
	Bdf string `json:"bdf"`
}

// NewPciDeviceInfo instantiates a new PciDeviceInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPciDeviceInfo(id string, bdf string) *PciDeviceInfo {
	this := PciDeviceInfo{}
	this.Id = id
	this.Bdf = bdf
	return &this
}

// NewPciDeviceInfoWithDefaults instantiates a new PciDeviceInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPciDeviceInfoWithDefaults() *PciDeviceInfo {
	this := PciDeviceInfo{}
	return &this
}

// GetId returns the Id field value
func (o *PciDeviceInfo) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *PciDeviceInfo) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *PciDeviceInfo) SetId(v string) {
	o.Id = v
}

// GetBdf returns the Bdf field value
func (o *PciDeviceInfo) GetBdf() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Bdf
}

// GetBdfOk returns a tuple with the Bdf field value
// and a boolean to check if the value has been set.
func (o *PciDeviceInfo) GetBdfOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Bdf, true
}

// SetBdf sets field value
func (o *PciDeviceInfo) SetBdf(v string) {
	o.Bdf = v
}

func (o PciDeviceInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["id"] = o.Id
	}
	if true {
		toSerialize["bdf"] = o.Bdf
	}
	return json.Marshal(toSerialize)
}

type NullablePciDeviceInfo struct {
	value *PciDeviceInfo
	isSet bool
}

func (v NullablePciDeviceInfo) Get() *PciDeviceInfo {
	return v.value
}

func (v *NullablePciDeviceInfo) Set(val *PciDeviceInfo) {
	v.value = val
	v.isSet = true
}

func (v NullablePciDeviceInfo) IsSet() bool {
	return v.isSet
}

func (v *NullablePciDeviceInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePciDeviceInfo(val *PciDeviceInfo) *NullablePciDeviceInfo {
	return &NullablePciDeviceInfo{value: val, isSet: true}
}

func (v NullablePciDeviceInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePciDeviceInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
