/*
 *   Copyright (c) 1999-2001 Philippe Grandclement
 *
 *   This file is part of LORENE.
 *
 *   LORENE is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   LORENE is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with LORENE; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


char xdsdx_1d_C[] = "$Header: /cvsroot/Lorene/C++/Source/Non_class_members/Operators/xdsdx_1d.C,v 1.4 2014/10/13 08:53:27 j_novak Exp $" ;

/*
 * $Id: xdsdx_1d.C,v 1.4 2014/10/13 08:53:27 j_novak Exp $
 * $Log: xdsdx_1d.C,v $
 * Revision 1.4  2014/10/13 08:53:27  j_novak
 * Lorene classes and functions now belong to the namespace Lorene.
 *
 * Revision 1.3  2014/10/06 15:16:07  j_novak
 * Modified #include directives to use c++ syntax.
 *
 * Revision 1.2  2002/10/16 14:37:11  j_novak
 * Reorganization of #include instructions of standard C++, in order to
 * use experimental version 3 of gcc.
 *
 * Revision 1.1.1.1  2001/11/20 15:19:29  e_gourgoulhon
 * LORENE
 *
 * Revision 2.0  1999/10/11  09:55:46  phil
 * *** empty log message ***
 *
 *
 * $Header: /cvsroot/Lorene/C++/Source/Non_class_members/Operators/xdsdx_1d.C,v 1.4 2014/10/13 08:53:27 j_novak Exp $
 *
 */
 
 // Includes
#include <cstdlib>

#include "headcpp.h"
#include "type_parite.h"



		//----------------------------------
		// Routine pour les cas non prevus --
		//----------------------------------

namespace Lorene {
void _xdsdx_1d_pas_prevu(int nr, double* tb, double *xo) {
    cout << "xdsdx pas prevu..." << endl ;
    cout << "Nombre de points : " << nr << endl ;
    cout << "Valeurs : " << tb << "  " << xo <<endl ;
    abort() ;
    exit(-1) ;
}


			//---------------
			// cas R_CHEB ---
			//---------------

void _xdsdx_1d_r_cheb(int nr, double* tb, double *xo) {
    
    double somme = 0 ;
    //Premiere boucle sur r :
    for (int i=nr-1 ; i>= 0 ; i-=2) {
	if (i==nr-1) 
	    somme += i*tb[i] ;
	else somme += i*tb[i]+(i+2)*tb[i+2] ;
	xo[i] = somme ;
	}
    
    //Seconde boucle sur r :
    somme = 0 ;
    for (int i=nr-2 ; i>=0 ; i-=2) {
	if (i==nr-2)
	    somme += i*tb[i] ;
	else
	    somme += i*tb[i]+(i+2)*tb[i+2] ;
	xo[i] = somme ;
    }
    xo[0] *= .5 ;   
}

			//-----------------
			// cas R_CHEBP ---
			//----------------

void _xdsdx_1d_r_chebp(int nr, double* tb, double *xo) {
    
    double somme = 0 ;
    for (int i=nr-1 ; i>=0 ; i--) {
	if (i==nr-1)
	    somme += (2*i)*tb[i] ;
	else 
	    somme += (2*i)*tb[i]+(2*i+2)*tb[i+1] ;
	xo[i] = somme ;
    }
    
    xo[0] *= .5 ;
}

			//---------------
			// cas R_CHEBI --
			//---------------

void _xdsdx_1d_r_chebi(int nr, double* tb, double *xo) {

    double somme = 0 ;
    for (int i=nr-1 ; i>=0 ; i--) {
	if (i==nr-1)
	    somme += (2*i+1)*tb[i] ;
	else
	    somme += (2*i+1)*tb[i]+(2*i+3)*tb[i+1] ;
	xo[i] = somme ;
    
    }
}


		// ---------------------
		// La routine a appeler
		//----------------------
		
		
void xdsdx_1d(int nr, double** tb, int base_r)
{

		// Routines de derivation
    static void (*xdsdx_1d[MAX_BASE])(int, double*, double *) ;
    static int nap = 0 ;

		// Premier appel
    if (nap==0) {
	nap = 1 ;
	for (int i=0 ; i<MAX_BASE ; i++) {
	    xdsdx_1d[i] = _xdsdx_1d_pas_prevu ;
	}
		// Les routines existantes
	xdsdx_1d[R_CHEB >> TRA_R] = _xdsdx_1d_r_cheb ;
	xdsdx_1d[R_CHEBP >> TRA_R] = _xdsdx_1d_r_chebp ;
	xdsdx_1d[R_CHEBI >> TRA_R] = _xdsdx_1d_r_chebi ;
    }
    
    double *result = new double[nr] ;
    
    xdsdx_1d[base_r](nr, *tb, result) ;
    
    delete [] (*tb) ;
    (*tb) = result ;
}
}
