/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Arguments;
import com.google.caliper.MeasurementType;
import com.google.caliper.Vm;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class DalvikVm
extends Vm {
    DalvikVm() {
    }

    public static boolean isDalvikVm() {
        return "Dalvik".equals(System.getProperty("java.vm.name"));
    }

    public static String vmName() {
        return "app_process";
    }

    @Override
    public List<String> getVmSpecificOptions(MeasurementType type, Arguments arguments) {
        if (!arguments.getCaptureVmLog()) {
            return ImmutableList.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (arguments.getCaptureVmLog()) {
            // empty if block
        }
        return result;
    }

    @Override
    public ProcessBuilder newProcessBuilder(File workingDirectory, String classPath, ImmutableList<String> vmArgs, String className, ImmutableList<String> applicationArgs) {
        ProcessBuilder result = new ProcessBuilder(new String[0]);
        result.directory(workingDirectory);
        result.command().addAll((Collection<String>)vmArgs);
        result.command().add("-Djava.class.path=" + classPath);
        result.command().add(workingDirectory.getPath());
        result.command().add(className);
        result.command().addAll((Collection<String>)applicationArgs);
        return result;
    }
}

