/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.googlecode.ant;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.Base64Converter;

public class GoogleCodeUploadTask
extends Task {
    private String userName;
    private String password;
    private String projectName;
    private String fileName;
    private String targetFileName;
    private String summary;
    private String uploadUrl;
    private boolean verbose;
    private String labels;

    public void execute() throws BuildException {
        try {
            this.upload();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void upload() throws IOException {
        int n;
        String[] stringArray;
        System.clearProperty("javax.net.ssl.trustStoreProvider");
        System.clearProperty("javax.net.ssl.trustStoreType");
        URL uRL = this.createUploadURL();
        this.log("The upload URL is " + uRL);
        InputStream inputStream = new BufferedInputStream(new FileInputStream(this.fileName));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Authorization", "Basic " + GoogleCodeUploadTask.createAuthToken(this.userName, this.password));
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=CowMooCowMooCowCowCow");
        httpURLConnection.setRequestProperty("User-Agent", "Google Code Upload Ant Task 0.1");
        this.log("Attempting to connect (username is " + this.userName + ")...");
        httpURLConnection.connect();
        this.log("Sending request parameters...");
        OutputStream outputStream = httpURLConnection.getOutputStream();
        this.sendLine(outputStream, "--CowMooCowMooCowCowCow");
        this.sendLine(outputStream, "content-disposition: form-data; name=\"summary\"");
        this.sendLine(outputStream, "");
        this.sendLine(outputStream, this.summary);
        if (this.labels != null && (stringArray = this.labels.split("\\,")) != null && stringArray.length > 0) {
            this.log("Setting " + stringArray.length + " label(s)");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                this.sendLine(outputStream, "--CowMooCowMooCowCowCow");
                this.sendLine(outputStream, "content-disposition: form-data; name=\"label\"");
                this.sendLine(outputStream, "");
                this.sendLine(outputStream, stringArray[i].trim());
            }
        }
        this.log("Sending file... " + this.targetFileName);
        this.sendLine(outputStream, "--CowMooCowMooCowCowCow");
        this.sendLine(outputStream, "content-disposition: form-data; name=\"filename\"; filename=\"" + this.targetFileName + "\"");
        this.sendLine(outputStream, "Content-Type: application/octet-stream");
        this.sendLine(outputStream, "");
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.sendLine(outputStream, "");
        this.sendLine(outputStream, "--CowMooCowMooCowCowCow--");
        outputStream.flush();
        outputStream.close();
        inputStream = httpURLConnection.getInputStream();
        this.log("Upload finished. Reading response.");
        this.log("HTTP Response Headers: " + httpURLConnection.getHeaderFields());
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read(byArray)) >= 0) {
            stringBuilder.append(new String(byArray, 0, n, "ascii"));
        }
        this.log(stringBuilder.toString());
        inputStream.close();
        httpURLConnection.disconnect();
    }

    private void sendLine(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes("ascii"));
        outputStream.write("\r\n".getBytes("ascii"));
    }

    private static String createAuthToken(String string, String string2) {
        Base64Converter base64Converter = new Base64Converter();
        return base64Converter.encode(string + ":" + string2);
    }

    private URL createUploadURL() throws MalformedURLException {
        if (this.uploadUrl != null) {
            return new URL(this.uploadUrl);
        }
        if (this.projectName == null) {
            throw new NullPointerException("projectName must be set");
        }
        return new URL("https", this.projectName + ".googlecode.com", "/files");
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String string) {
        this.targetFileName = string;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String string) {
        this.uploadUrl = string;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String string) {
        this.labels = string;
    }
}

