/*
 * Copyright 2003-2007 Keith Seymour.
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file was auto-generated by the org.netlib.generate.JavaGenerator
 * program, a part of netlib-java.
 * 
 * @see http://code.google.com/p/netlib-java/
 */
package org.netlib.lapack;

import java.util.logging.Logger;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;
import org.netlib.utils.JNIMethods;

/**
 * LAPACK provider implementation which uses the Java Native Interface to access
 * system netlib libraries.
 *
 * @see http://www.netlib.org/
 * @author Samuel Halliday
 */
final class NativeLAPACK extends LAPACK {

	// singleton
	protected static final NativeLAPACK INSTANCE = new NativeLAPACK();

	// indicates if the JNI loaded OK. If this is false, calls to the native
	// methods will fail with UnsatisfiedLinkError
	protected final boolean isLoaded;

	private NativeLAPACK() {
		String libname = JNIMethods.getPortableLibraryName("jnilapack");
		try {
			System.loadLibrary(libname);
		} catch (UnsatisfiedLinkError e) {
			isLoaded = false;
			return;
		}
		isLoaded = true;
	}

	@Override
	public native void dbdsdc(String uplo, String compq, int n, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, double[] q, int[] iq, double[] work, int[] iwork, intW info);

	@Override
	public native void dbdsqr(String uplo, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void ddisna(String job, int m, int n, double[] d, double[] sep, intW info);

	@Override
	public native void dgbbrd(String vect, int m, int n, int ncc, int kl, int ku, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] pt, int ldpt, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dgbcon(String norm, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dgbequ(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info);

	@Override
	public native void dgbrfs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dgbsvx(String fact, String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgbtf2(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info);

	@Override
	public native void dgbtrf(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info);

	@Override
	public native void dgbtrs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dgebak(String job, String side, int n, int ilo, int ihi, double[] scale, int m, double[] v, int ldv, intW info);

	@Override
	public native void dgebal(String job, int n, double[] a, int lda, intW ilo, intW ihi, double[] scale, intW info);

	@Override
	public native void dgebd2(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, intW info);

	@Override
	public native void dgebrd(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, int lwork, intW info);

	@Override
	public native void dgecon(String norm, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dgeequ(int m, int n, double[] a, int lda, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info);

	@Override
	public native void dgeev(String jobvl, String jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	@Override
	public native void dgeevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] scale, doubleW abnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dgegs(String jobvsl, String jobvsr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, intW info);

	@Override
	public native void dgegv(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	@Override
	public native void dgehd2(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dgehrd(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgelq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dgelqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgels(String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] work, int lwork, intW info);

	@Override
	public native void dgelsd(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dgelss(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, intW info);

	@Override
	public native void dgelsx(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, intW info);

	@Override
	public native void dgelsy(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, int lwork, intW info);

	@Override
	public native void dgeql2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dgeqlf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgeqp3(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgeqpf(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, intW info);

	@Override
	public native void dgeqr2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dgeqrf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgerfs(String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgerq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dgerqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dgesc2(int n, double[] a, int lda, double[] rhs, int[] ipiv, int[] jpiv, doubleW scale);

	@Override
	public native void dgesdd(String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dgesvd(String jobu, String jobvt, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, intW info);

	@Override
	public native void dgesvx(String fact, String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgetc2(int n, double[] a, int lda, int[] ipiv, int[] jpiv, intW info);

	@Override
	public native void dgetf2(int m, int n, double[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void dgetrf(int m, int n, double[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void dgetri(int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, intW info);

	@Override
	public native void dgetrs(String trans, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dggbak(String job, String side, int n, int ilo, int ihi, double[] lscale, double[] rscale, int m, double[] v, int ldv, intW info);

	@Override
	public native void dggbal(String job, int n, double[] a, int lda, double[] b, int ldb, intW ilo, intW ihi, double[] lscale, double[] rscale, double[] work, intW info);

	@Override
	public native void dggev(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	@Override
	public native void dggevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] lscale, double[] rscale, doubleW abnrm, doubleW bbnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, boolean[] bwork, intW info);

	@Override
	public native void dggglm(int n, int m, int p, double[] a, int lda, double[] b, int ldb, double[] d, double[] x, double[] y, double[] work, int lwork, intW info);

	@Override
	public native void dgghrd(String compq, String compz, int n, int ilo, int ihi, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, intW info);

	@Override
	public native void dgglse(int m, int n, int p, double[] a, int lda, double[] b, int ldb, double[] c, double[] d, double[] x, double[] work, int lwork, intW info);

	@Override
	public native void dggqrf(int n, int m, int p, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info);

	@Override
	public native void dggrqf(int m, int p, int n, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info);

	@Override
	public native void dggsvd(String jobu, String jobv, String jobq, int m, int n, int p, intW k, intW l, double[] a, int lda, double[] b, int ldb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, int[] iwork, intW info);

	@Override
	public native void dggsvp(String jobu, String jobv, String jobq, int m, int p, int n, double[] a, int lda, double[] b, int ldb, double tola, double tolb, intW k, intW l, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, int[] iwork, double[] tau, double[] work, intW info);

	@Override
	public native void dgtcon(String norm, int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dgtrfs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] b, int ldb, intW info);

	@Override
	public native void dgtsvx(String fact, String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dgttrf(int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, intW info);

	@Override
	public native void dgttrs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dgtts2(int itrans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb);

	@Override
	public native void dhgeqz(String job, String compq, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] t, int ldt, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, double[] work, int lwork, intW info);

	@Override
	public native void dhsein(String side, String eigsrc, String initv, boolean[] select, int n, double[] h, int ldh, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, int[] ifaill, int[] ifailr, intW info);

	@Override
	public native void dhseqr(String job, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, double[] z, int ldz, double[] work, int lwork, intW info);

	@Override
	public native void dlabad(doubleW small, doubleW large);

	@Override
	public native void dlabrd(int m, int n, int nb, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] x, int ldx, double[] y, int ldy);

	@Override
	public native void dlacon(int n, double[] v, double[] x, int[] isgn, doubleW est, intW kase);

	@Override
	public native void dlacpy(String uplo, int m, int n, double[] a, int lda, double[] b, int ldb);

	@Override
	public native void dladiv(double a, double b, double c, double d, doubleW p, doubleW q);

	@Override
	public native void dlae2(double a, double b, double c, doubleW rt1, doubleW rt2);

	@Override
	public native void dlaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, double abstol, double reltol, double pivmin, double[] d, double[] e, double[] e2, int[] nval, double[] ab, double[] c, intW mout, int[] nab, double[] work, int[] iwork, intW info);

	@Override
	public native void dlaed0(int icompq, int qsiz, int n, double[] d, double[] e, double[] q, int ldq, double[] qstore, int ldqs, double[] work, int[] iwork, intW info);

	@Override
	public native void dlaed1(int n, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] work, int[] iwork, intW info);

	@Override
	public native void dlaed2(intW k, int n, int n1, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, double[] z, double[] dlamda, double[] w, double[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, intW info);

	@Override
	public native void dlaed3(int k, int n, int n1, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] q2, int[] indx, int[] ctot, double[] w, double[] s, intW info);

	@Override
	public native void dlaed4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam, intW info);

	@Override
	public native void dlaed5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam);

	@Override
	public native void dlaed6(int kniter, boolean orgati, double rho, double[] d, double[] z, double finit, doubleW tau, intW info);

	@Override
	public native void dlaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] work, int[] iwork, intW info);

	@Override
	public native void dlaed8(int icompq, intW k, int n, int qsiz, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] z, double[] dlamda, double[] q2, int ldq2, double[] w, int[] perm, intW givptr, int[] givcol, double[] givnum, int[] indxp, int[] indx, intW info);

	@Override
	public native void dlaed9(int k, int kstart, int kstop, int n, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] w, double[] s, int lds, intW info);

	@Override
	public native void dlaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] q, int[] qptr, double[] z, double[] ztemp, intW info);

	@Override
	public native void dlaein(boolean rightv, boolean noinit, int n, double[] h, int ldh, double wr, double wi, double[] vr, double[] vi, double[] b, int ldb, double[] work, double eps3, double smlnum, double bignum, intW info);

	@Override
	public native void dlaev2(double a, double b, double c, doubleW rt1, doubleW rt2, doubleW cs1, doubleW sn1);

	@Override
	public native void dlaexc(boolean wantq, int n, double[] t, int ldt, double[] q, int ldq, int j1, int n1, int n2, double[] work, intW info);

	@Override
	public native void dlag2(double[] a, int lda, double[] b, int ldb, double safmin, doubleW scale1, doubleW scale2, doubleW wr1, doubleW wr2, doubleW wi);

	@Override
	public native void dlags2(boolean upper, double a1, double a2, double a3, double b1, double b2, double b3, doubleW csu, doubleW snu, doubleW csv, doubleW snv, doubleW csq, doubleW snq);

	@Override
	public native void dlagtf(int n, double[] a, double lambda, double[] b, double[] c, double tol, double[] d, int[] in, intW info);

	@Override
	public native void dlagtm(String trans, int n, int nrhs, double alpha, double[] dl, double[] d, double[] du, double[] x, int ldx, double beta, double[] b, int ldb);

	@Override
	public native void dlagts(int job, int n, double[] a, double[] b, double[] c, double[] d, int[] in, double[] y, doubleW tol, intW info);

	@Override
	public native void dlagv2(double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, doubleW csl, doubleW snl, doubleW csr, doubleW snr);

	@Override
	public native void dlahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, intW info);

	@Override
	public native void dlahrd(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy);

	@Override
	public native void dlaic1(int job, int j, double[] x, double sest, double[] w, double gamma, doubleW sestpr, doubleW s, doubleW c);

	@Override
	public native void dlaln2(boolean ltrans, int na, int nw, double smin, double ca, double[] a, int lda, double d1, double d2, double[] b, int ldb, double wr, double wi, double[] x, int ldx, doubleW scale, doubleW xnorm, intW info);

	@Override
	public native void dlals0(int icompq, int nl, int nr, int sqre, int nrhs, double[] b, int ldb, double[] bx, int ldbx, int[] perm, int givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, int k, double c, double s, double[] work, intW info);

	@Override
	public native void dlalsa(int icompq, int smlsiz, int n, int nrhs, double[] b, int ldb, double[] bx, int ldbx, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info);

	@Override
	public native void dlalsd(String uplo, int smlsiz, int n, int nrhs, double[] d, double[] e, double[] b, int ldb, double rcond, intW rank, double[] work, int[] iwork, intW info);

	@Override
	public native void dlamrg(int n1, int n2, double[] a, int dtrd1, int dtrd2, int[] index);

	@Override
	public native void dlanv2(doubleW a, doubleW b, doubleW c, doubleW d, doubleW rt1r, doubleW rt1i, doubleW rt2r, doubleW rt2i, doubleW cs, doubleW sn);

	@Override
	public native void dlapll(int n, double[] x, int incx, double[] y, int incy, doubleW ssmin);

	@Override
	public native void dlapmt(boolean forwrd, int m, int n, double[] x, int ldx, int[] k);

	@Override
	public native void dlaqgb(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed);

	@Override
	public native void dlaqge(int m, int n, double[] a, int lda, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed);

	@Override
	public native void dlaqp2(int m, int n, int offset, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] work);

	@Override
	public native void dlaqps(int m, int n, int offset, int nb, intW kb, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] auxv, double[] f, int ldf);

	@Override
	public native void dlaqsb(String uplo, int n, int kd, double[] ab, int ldab, double[] s, double scond, double amax, StringW equed);

	@Override
	public native void dlaqsp(String uplo, int n, double[] ap, double[] s, double scond, double amax, StringW equed);

	@Override
	public native void dlaqsy(String uplo, int n, double[] a, int lda, double[] s, double scond, double amax, StringW equed);

	@Override
	public native void dlaqtr(boolean ltran, boolean lreal, int n, double[] t, int ldt, double[] b, double w, doubleW scale, double[] x, double[] work, intW info);

	@Override
	public native void dlar2v(int n, double[] x, double[] y, double[] z, int incx, double[] c, double[] s, int incc);

	@Override
	public native void dlarf(String side, int m, int n, double[] v, int incv, double tau, double[] c, int Ldc, double[] work);

	@Override
	public native void dlarfb(String side, String trans, String direct, String storev, int m, int n, int k, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork);

	@Override
	public native void dlarfg(int n, doubleW alpha, double[] x, int incx, doubleW tau);

	@Override
	public native void dlarft(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt);

	@Override
	public native void dlarfx(String side, int m, int n, double[] v, double tau, double[] c, int Ldc, double[] work);

	@Override
	public native void dlargv(int n, double[] x, int incx, double[] y, int incy, double[] c, int incc);

	@Override
	public native void dlarnv(int idist, int[] iseed, int n, double[] x);

	@Override
	public native void dlartg(double f, double g, doubleW cs, doubleW sn, doubleW r);

	@Override
	public native void dlartv(int n, double[] x, int incx, double[] y, int incy, double[] c, double[] s, int incc);

	@Override
	public native void dlaruv(int[] iseed, int n, double[] x);

	@Override
	public native void dlarz(String side, int m, int n, int l, double[] v, int incv, double tau, double[] c, int Ldc, double[] work);

	@Override
	public native void dlarzb(String side, String trans, String direct, String storev, int m, int n, int k, int l, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork);

	@Override
	public native void dlarzt(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt);

	@Override
	public native void dlas2(double f, double g, double h, doubleW ssmin, doubleW ssmax);

	@Override
	public native void dlascl(String type, int kl, int ku, double cfrom, double cto, int m, int n, double[] a, int lda, intW info);

	@Override
	public native void dlasd0(int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, int smlsiz, int[] iwork, double[] work, intW info);

	@Override
	public native void dlasd1(int nl, int nr, int sqre, double[] d, doubleW alpha, doubleW beta, double[] u, int ldu, double[] vt, int ldvt, int[] idxq, int[] iwork, double[] work, intW info);

	@Override
	public native void dlasd2(int nl, int nr, int sqre, intW k, double[] d, double[] z, double alpha, double beta, double[] u, int ldu, double[] vt, int ldvt, double[] dsigma, double[] u2, int ldu2, double[] vt2, int ldvt2, int[] idxp, int[] idx, int[] idxc, int[] idxq, int[] coltyp, intW info);

	@Override
	public native void dlasd3(int nl, int nr, int sqre, int k, double[] d, double[] q, int ldq, double[] dsigma, double[] u, int ldu, double[] u2, int ldu2, double[] vt, int ldvt, double[] vt2, int ldvt2, int[] idxc, int[] ctot, double[] z, intW info);

	@Override
	public native void dlasd4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW sigma, double[] work, intW info);

	@Override
	public native void dlasd5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dsigma, double[] work);

	@Override
	public native void dlasd6(int icompq, int nl, int nr, int sqre, double[] d, double[] vf, double[] vl, doubleW alpha, doubleW beta, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, intW k, doubleW c, doubleW s, double[] work, int[] iwork, intW info);

	@Override
	public native void dlasd7(int icompq, int nl, int nr, int sqre, intW k, double[] d, double[] z, double[] zw, double[] vf, double[] vfw, double[] vl, double[] vlw, double alpha, double beta, double[] dsigma, int[] idx, int[] idxp, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, doubleW c, doubleW s, intW info);

	@Override
	public native void dlasd8(int icompq, int k, double[] d, double[] z, double[] vf, double[] vl, double[] difl, double[] difr, int lddifr, double[] dsigma, double[] work, intW info);

	@Override
	public native void dlasda(int icompq, int smlsiz, int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info);

	@Override
	public native void dlasdq(String uplo, int sqre, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dlasdt(int n, intW lvl, intW nd, int[] inode, int[] ndiml, int[] ndimr, int msub);

	@Override
	public native void dlaset(String uplo, int m, int n, double alpha, double beta, double[] a, int lda);

	@Override
	public native void dlasq1(int n, double[] d, double[] e, double[] work, intW info);

	@Override
	public native void dlasq2(int n, double[] z, intW info);

	@Override
	public native void dlasq3(int i0, intW n0, double[] z, int pp, doubleW dmin, doubleW sigma, doubleW desig, doubleW qmax, intW nfail, intW iter, intW ndiv, boolean ieee);

	@Override
	public native void dlasq4(int i0, int n0, double[] z, int pp, int n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, doubleW tau, intW ttype);

	@Override
	public native void dlasq5(int i0, int n0, double[] z, int pp, double tau, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2, boolean ieee);

	@Override
	public native void dlasq6(int i0, int n0, double[] z, int pp, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2);

	@Override
	public native void dlasr(String side, String pivot, String direct, int m, int n, double[] c, double[] s, double[] a, int lda);

	@Override
	public native void dlasrt(String id, int n, double[] d, intW info);

	@Override
	public native void dlassq(int n, double[] x, int incx, doubleW scale, doubleW sumsq);

	@Override
	public native void dlasv2(double f, double g, double h, doubleW ssmin, doubleW ssmax, doubleW snr, doubleW csr, doubleW snl, doubleW csl);

	@Override
	public native void dlaswp(int n, double[] a, int lda, int k1, int k2, int[] ipiv, int incx);

	@Override
	public native void dlasy2(boolean ltranl, boolean ltranr, int isgn, int n1, int n2, double[] tl, int ldtl, double[] tr, int ldtr, double[] b, int ldb, doubleW scale, double[] x, int ldx, doubleW xnorm, intW info);

	@Override
	public native void dlasyf(String uplo, int n, int nb, intW kb, double[] a, int lda, int[] ipiv, double[] w, int ldw, intW info);

	@Override
	public native void dlatbs(String uplo, String trans, String diag, String normin, int n, int kd, double[] ab, int ldab, double[] x, doubleW scale, double[] cnorm, intW info);

	@Override
	public native void dlatdf(int ijob, int n, double[] z, int ldz, double[] rhs, doubleW rdsum, doubleW rdscal, int[] ipiv, int[] jpiv);

	@Override
	public native void dlatps(String uplo, String trans, String diag, String normin, int n, double[] ap, double[] x, doubleW scale, double[] cnorm, intW info);

	@Override
	public native void dlatrd(String uplo, int n, int nb, double[] a, int lda, double[] e, double[] tau, double[] w, int ldw);

	@Override
	public native void dlatrs(String uplo, String trans, String diag, String normin, int n, double[] a, int lda, double[] x, doubleW scale, double[] cnorm, intW info);

	@Override
	public native void dlatrz(int m, int n, int l, double[] a, int lda, double[] tau, double[] work);

	@Override
	public native void dlatzm(String side, int m, int n, double[] v, int incv, double tau, double[] c1, double[] c2, int Ldc, double[] work);

	@Override
	public native void dlauu2(String uplo, int n, double[] a, int lda, intW info);

	@Override
	public native void dlauum(String uplo, int n, double[] a, int lda, intW info);

	@Override
	public native void dopgtr(String uplo, int n, double[] ap, double[] tau, double[] q, int ldq, double[] work, intW info);

	@Override
	public native void dopmtr(String side, String uplo, String trans, int m, int n, double[] ap, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dorg2l(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dorg2r(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dorgbr(String vect, int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorghr(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorgl2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dorglq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorgql(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorgqr(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorgr2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	@Override
	public native void dorgrq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorgtr(String uplo, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dorm2l(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dorm2r(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dormbr(String vect, String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormhr(String side, String trans, int m, int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dorml2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dormlq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormql(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormqr(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormr2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dormr3(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	@Override
	public native void dormrq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormrz(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dormtr(String side, String uplo, String trans, int m, int n, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	@Override
	public native void dpbcon(String uplo, int n, int kd, double[] ab, int ldab, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dpbequ(String uplo, int n, int kd, double[] ab, int ldab, double[] s, doubleW scond, doubleW amax, intW info);

	@Override
	public native void dpbrfs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dpbstf(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	@Override
	public native void dpbsv(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info);

	@Override
	public native void dpbsvx(String fact, String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dpbtf2(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	@Override
	public native void dpbtrf(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	@Override
	public native void dpbtrs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info);

	@Override
	public native void dpocon(String uplo, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dpoequ(int n, double[] a, int lda, double[] s, doubleW scond, doubleW amax, intW info);

	@Override
	public native void dporfs(String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dposv(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info);

	@Override
	public native void dposvx(String fact, String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dpotf2(String uplo, int n, double[] a, int lda, intW info);

	@Override
	public native void dpotrf(String uplo, int n, double[] a, int lda, intW info);

	@Override
	public native void dpotri(String uplo, int n, double[] a, int lda, intW info);

	@Override
	public native void dpotrs(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info);

	@Override
	public native void dppcon(String uplo, int n, double[] ap, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dppequ(String uplo, int n, double[] ap, double[] s, doubleW scond, doubleW amax, intW info);

	@Override
	public native void dpprfs(String uplo, int n, int nrhs, double[] ap, double[] afp, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dppsv(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info);

	@Override
	public native void dppsvx(String fact, String uplo, int n, int nrhs, double[] ap, double[] afp, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dpptrf(String uplo, int n, double[] ap, intW info);

	@Override
	public native void dpptri(String uplo, int n, double[] ap, intW info);

	@Override
	public native void dpptrs(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info);

	@Override
	public native void dptcon(int n, double[] d, double[] e, double anorm, doubleW rcond, double[] work, intW info);

	@Override
	public native void dpteqr(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dptrfs(int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, intW info);

	@Override
	public native void dptsv(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info);

	@Override
	public native void dptsvx(String fact, int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, intW info);

	@Override
	public native void dpttrf(int n, double[] d, double[] e, intW info);

	@Override
	public native void dpttrs(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info);

	@Override
	public native void dptts2(int n, int nrhs, double[] d, double[] e, double[] b, int ldb);

	@Override
	public native void drscl(int n, double sa, double[] sx, int incx);

	@Override
	public native void dsbev(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dsbevd(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dsbevx(String jobz, String range, String uplo, int n, int kd, double[] ab, int ldab, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsbgst(String vect, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] x, int ldx, double[] work, intW info);

	@Override
	public native void dsbgv(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dsbgvd(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dsbgvx(String jobz, String range, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsbtrd(String vect, String uplo, int n, int kd, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] work, intW info);

	@Override
	public native void dspcon(String uplo, int n, double[] ap, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dspev(String jobz, String uplo, int n, double[] ap, double[] w, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dspevd(String jobz, String uplo, int n, double[] ap, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dspevx(String jobz, String range, String uplo, int n, double[] ap, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dspgst(int itype, String uplo, int n, double[] ap, double[] bp, intW info);

	@Override
	public native void dspgv(int itype, String jobz, String uplo, int n, double[] ap, double[] bp, double[] w, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dspgvd(int itype, String jobz, String uplo, int n, double[] ap, double[] bp, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dspgvx(int itype, String jobz, String range, String uplo, int n, double[] ap, double[] bp, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsprfs(String uplo, int n, int nrhs, double[] ap, double[] afp, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dspsv(String uplo, int n, int nrhs, double[] ap, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dspsvx(String fact, String uplo, int n, int nrhs, double[] ap, double[] afp, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dsptrd(String uplo, int n, double[] ap, double[] d, double[] e, double[] tau, intW info);

	@Override
	public native void dsptrf(String uplo, int n, double[] ap, int[] ipiv, intW info);

	@Override
	public native void dsptri(String uplo, int n, double[] ap, int[] ipiv, double[] work, intW info);

	@Override
	public native void dsptrs(String uplo, int n, int nrhs, double[] ap, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dstebz(String range, String order, int n, double vl, double vu, int il, int iu, double abstol, double[] d, double[] e, intW m, intW nsplit, double[] w, int[] iblock, int[] isplit, double[] work, int[] iwork, intW info);

	@Override
	public native void dstedc(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dstegr(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dstein(int n, double[] d, double[] e, int m, double[] w, int[] iblock, int[] isplit, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsteqr(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dsterf(int n, double[] d, double[] e, intW info);

	@Override
	public native void dstev(String jobz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info);

	@Override
	public native void dstevd(String jobz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dstevr(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dstevx(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsycon(String uplo, int n, double[] a, int lda, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dsyev(String jobz, String uplo, int n, double[] a, int lda, double[] w, double[] work, int lwork, intW info);

	@Override
	public native void dsyevd(String jobz, String uplo, int n, double[] a, int lda, double[] w, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dsyevr(String jobz, String range, String uplo, int n, double[] a, int lda, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dsyevx(String jobz, String range, String uplo, int n, double[] a, int lda, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsygs2(int itype, String uplo, int n, double[] a, int lda, double[] b, int ldb, intW info);

	@Override
	public native void dsygst(int itype, String uplo, int n, double[] a, int lda, double[] b, int ldb, intW info);

	@Override
	public native void dsygv(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w, double[] work, int lwork, intW info);

	@Override
	public native void dsygvd(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dsygvx(int itype, String jobz, String range, String uplo, int n, double[] a, int lda, double[] b, int ldb, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int[] ifail, intW info);

	@Override
	public native void dsyrfs(String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dsysv(String uplo, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, double[] work, int lwork, intW info);

	@Override
	public native void dsysvx(String fact, String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dsytd2(String uplo, int n, double[] a, int lda, double[] d, double[] e, double[] tau, intW info);

	@Override
	public native void dsytf2(String uplo, int n, double[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void dsytrd(String uplo, int n, double[] a, int lda, double[] d, double[] e, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native void dsytrf(String uplo, int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, intW info);

	@Override
	public native void dsytri(String uplo, int n, double[] a, int lda, int[] ipiv, double[] work, intW info);

	@Override
	public native void dsytrs(String uplo, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info);

	@Override
	public native void dtbcon(String norm, String uplo, String diag, int n, int kd, double[] ab, int ldab, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dtbrfs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dtbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info);

	@Override
	public native void dtgevc(String side, String howmny, boolean[] select, int n, double[] s, int lds, double[] p, int ldp, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, intW info);

	@Override
	public native void dtgex2(boolean wantq, boolean wantz, int n, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, int j1, int n1, int n2, double[] work, int lwork, intW info);

	@Override
	public native void dtgexc(boolean wantq, boolean wantz, int n, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, intW ifst, intW ilst, double[] work, int lwork, intW info);

	@Override
	public native void dtgsen(int ijob, boolean wantq, boolean wantz, boolean[] select, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, intW m, doubleW pl, doubleW pr, double[] dif, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dtgsja(String jobu, String jobv, String jobq, int m, int p, int n, int k, int l, double[] a, int lda, double[] b, int ldb, double tola, double tolb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, intW ncycle, intW info);

	@Override
	public native void dtgsna(String job, String howmny, boolean[] select, int n, double[] a, int lda, double[] b, int ldb, double[] vl, int ldvl, double[] vr, int ldvr, double[] s, double[] dif, int mm, intW m, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dtgsy2(String trans, int ijob, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, double[] d, int ldd, double[] e, int lde, double[] f, int ldf, doubleW scale, doubleW rdsum, doubleW rdscal, int[] iwork, intW pq, intW info);

	@Override
	public native void dtgsyl(String trans, int ijob, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, double[] d, int ldd, double[] e, int lde, double[] f, int ldf, doubleW scale, doubleW dif, double[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void dtpcon(String norm, String uplo, String diag, int n, double[] ap, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dtprfs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dtptri(String uplo, String diag, int n, double[] ap, intW info);

	@Override
	public native void dtptrs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, double[] b, int ldb, intW info);

	@Override
	public native void dtrcon(String norm, String uplo, String diag, int n, double[] a, int lda, doubleW rcond, double[] work, int[] iwork, intW info);

	@Override
	public native void dtrevc(String side, String howmny, boolean[] select, int n, double[] t, int ldt, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, intW info);

	@Override
	public native void dtrexc(String compq, int n, double[] t, int ldt, double[] q, int ldq, intW ifst, intW ilst, double[] work, intW info);

	@Override
	public native void dtrrfs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	@Override
	public native void dtrsen(String job, String compq, boolean[] select, int n, double[] t, int ldt, double[] q, int ldq, double[] wr, double[] wi, intW m, doubleW s, doubleW sep, double[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void dtrsna(String job, String howmny, boolean[] select, int n, double[] t, int ldt, double[] vl, int ldvl, double[] vr, int ldvr, double[] s, double[] sep, int mm, intW m, double[] work, int ldwork, int[] iwork, intW info);

	@Override
	public native void dtrsyl(String trana, String tranb, int isgn, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, doubleW scale, intW info);

	@Override
	public native void dtrti2(String uplo, String diag, int n, double[] a, int lda, intW info);

	@Override
	public native void dtrtri(String uplo, String diag, int n, double[] a, int lda, intW info);

	@Override
	public native void dtrtrs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info);

	@Override
	public native void dtzrqf(int m, int n, double[] a, int lda, double[] tau, intW info);

	@Override
	public native void dtzrzf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	@Override
	public native int ieeeck(int ispec, float zero, float one);

	@Override
	public native int ilaenv(int ispec, String name, String opts, int n1, int n2, int n3, int n4);

	@Override
	public native void sbdsdc(String uplo, String compq, int n, float[] d, float[] e, float[] u, int ldu, float[] vt, int ldvt, float[] q, int[] iq, float[] work, int[] iwork, intW info);

	@Override
	public native void sbdsqr(String uplo, int n, int ncvt, int nru, int ncc, float[] d, float[] e, float[] vt, int ldvt, float[] u, int ldu, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sdisna(String job, int m, int n, float[] d, float[] sep, intW info);

	@Override
	public native void sgbbrd(String vect, int m, int n, int ncc, int kl, int ku, float[] ab, int ldab, float[] d, float[] e, float[] q, int ldq, float[] pt, int ldpt, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sgbcon(String norm, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void sgbequ(int m, int n, int kl, int ku, float[] ab, int ldab, float[] r, float[] c, floatW rowcnd, floatW colcnd, floatW amax, intW info);

	@Override
	public native void sgbrfs(String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgbsv(int n, int kl, int ku, int nrhs, float[] ab, int ldab, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sgbsvx(String fact, String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, int[] ipiv, StringW equed, float[] r, float[] c, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgbtf2(int m, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, intW info);

	@Override
	public native void sgbtrf(int m, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, intW info);

	@Override
	public native void sgbtrs(String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sgebak(String job, String side, int n, int ilo, int ihi, float[] scale, int m, float[] v, int ldv, intW info);

	@Override
	public native void sgebal(String job, int n, float[] a, int lda, intW ilo, intW ihi, float[] scale, intW info);

	@Override
	public native void sgebd2(int m, int n, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] work, intW info);

	@Override
	public native void sgebrd(int m, int n, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] work, int lwork, intW info);

	@Override
	public native void sgecon(String norm, int n, float[] a, int lda, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void sgeequ(int m, int n, float[] a, int lda, float[] r, float[] c, floatW rowcnd, floatW colcnd, floatW amax, intW info);

	@Override
	public native void sgeev(String jobvl, String jobvr, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info);

	@Override
	public native void sgeevx(String balanc, String jobvl, String jobvr, String sense, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, intW ilo, intW ihi, float[] scale, floatW abnrm, float[] rconde, float[] rcondv, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void sgegs(String jobvsl, String jobvsr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vsl, int ldvsl, float[] vsr, int ldvsr, float[] work, int lwork, intW info);

	@Override
	public native void sgegv(String jobvl, String jobvr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info);

	@Override
	public native void sgehd2(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sgehrd(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgelq2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sgelqf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgels(String trans, int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] work, int lwork, intW info);

	@Override
	public native void sgelsd(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] s, float rcond, intW rank, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void sgelss(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] s, float rcond, intW rank, float[] work, int lwork, intW info);

	@Override
	public native void sgelsx(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, int[] jpvt, float rcond, intW rank, float[] work, intW info);

	@Override
	public native void sgelsy(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, int[] jpvt, float rcond, intW rank, float[] work, int lwork, intW info);

	@Override
	public native void sgeql2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sgeqlf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgeqp3(int m, int n, float[] a, int lda, int[] jpvt, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgeqpf(int m, int n, float[] a, int lda, int[] jpvt, float[] tau, float[] work, intW info);

	@Override
	public native void sgeqr2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sgeqrf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgerfs(String trans, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgerq2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sgerqf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sgesc2(int n, float[] a, int lda, float[] rhs, int[] ipiv, int[] jpiv, floatW scale);

	@Override
	public native void sgesdd(String jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void sgesv(int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sgesvd(String jobu, String jobvt, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt, float[] work, int lwork, intW info);

	@Override
	public native void sgesvx(String fact, String trans, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, StringW equed, float[] r, float[] c, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgetc2(int n, float[] a, int lda, int[] ipiv, int[] jpiv, intW info);

	@Override
	public native void sgetf2(int m, int n, float[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void sgetrf(int m, int n, float[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void sgetri(int n, float[] a, int lda, int[] ipiv, float[] work, int lwork, intW info);

	@Override
	public native void sgetrs(String trans, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sggbak(String job, String side, int n, int ilo, int ihi, float[] lscale, float[] rscale, int m, float[] v, int ldv, intW info);

	@Override
	public native void sggbal(String job, int n, float[] a, int lda, float[] b, int ldb, intW ilo, intW ihi, float[] lscale, float[] rscale, float[] work, intW info);

	@Override
	public native void sggev(String jobvl, String jobvr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info);

	@Override
	public native void sggevx(String balanc, String jobvl, String jobvr, String sense, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, intW ilo, intW ihi, float[] lscale, float[] rscale, floatW abnrm, floatW bbnrm, float[] rconde, float[] rcondv, float[] work, int lwork, int[] iwork, boolean[] bwork, intW info);

	@Override
	public native void sggglm(int n, int m, int p, float[] a, int lda, float[] b, int ldb, float[] d, float[] x, float[] y, float[] work, int lwork, intW info);

	@Override
	public native void sgghrd(String compq, String compz, int n, int ilo, int ihi, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, intW info);

	@Override
	public native void sgglse(int m, int n, int p, float[] a, int lda, float[] b, int ldb, float[] c, float[] d, float[] x, float[] work, int lwork, intW info);

	@Override
	public native void sggqrf(int n, int m, int p, float[] a, int lda, float[] taua, float[] b, int ldb, float[] taub, float[] work, int lwork, intW info);

	@Override
	public native void sggrqf(int m, int p, int n, float[] a, int lda, float[] taua, float[] b, int ldb, float[] taub, float[] work, int lwork, intW info);

	@Override
	public native void sggsvd(String jobu, String jobv, String jobq, int m, int n, int p, intW k, intW l, float[] a, int lda, float[] b, int ldb, float[] alpha, float[] beta, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, float[] work, int[] iwork, intW info);

	@Override
	public native void sggsvp(String jobu, String jobv, String jobq, int m, int p, int n, float[] a, int lda, float[] b, int ldb, float tola, float tolb, intW k, intW l, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, int[] iwork, float[] tau, float[] work, intW info);

	@Override
	public native void sgtcon(String norm, int n, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void sgtrfs(String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] dlf, float[] df, float[] duf, float[] du2, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgtsv(int n, int nrhs, float[] dl, float[] d, float[] du, float[] b, int ldb, intW info);

	@Override
	public native void sgtsvx(String fact, String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] dlf, float[] df, float[] duf, float[] du2, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sgttrf(int n, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, intW info);

	@Override
	public native void sgttrs(String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sgtts2(int itrans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float[] b, int ldb);

	@Override
	public native void shgeqz(String job, String compq, String compz, int n, int ilo, int ihi, float[] h, int ldh, float[] t, int ldt, float[] alphar, float[] alphai, float[] beta, float[] q, int ldq, float[] z, int ldz, float[] work, int lwork, intW info);

	@Override
	public native void shsein(String side, String eigsrc, String initv, boolean[] select, int n, float[] h, int ldh, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, int[] ifaill, int[] ifailr, intW info);

	@Override
	public native void shseqr(String job, String compz, int n, int ilo, int ihi, float[] h, int ldh, float[] wr, float[] wi, float[] z, int ldz, float[] work, int lwork, intW info);

	@Override
	public native void slabad(floatW small, floatW large);

	@Override
	public native void slabrd(int m, int n, int nb, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] x, int ldx, float[] y, int ldy);

	@Override
	public native void slacon(int n, float[] v, float[] x, int[] isgn, floatW est, intW kase);

	@Override
	public native void slacpy(String uplo, int m, int n, float[] a, int lda, float[] b, int ldb);

	@Override
	public native void sladiv(float a, float b, float c, float d, floatW p, floatW q);

	@Override
	public native void slae2(float a, float b, float c, floatW rt1, floatW rt2);

	@Override
	public native void slaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, float abstol, float reltol, float pivmin, float[] d, float[] e, float[] e2, int[] nval, float[] ab, float[] c, intW mout, int[] nab, float[] work, int[] iwork, intW info);

	@Override
	public native void slaed0(int icompq, int qsiz, int n, float[] d, float[] e, float[] q, int ldq, float[] qstore, int ldqs, float[] work, int[] iwork, intW info);

	@Override
	public native void slaed1(int n, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] work, int[] iwork, intW info);

	@Override
	public native void slaed2(intW k, int n, int n1, float[] d, float[] q, int ldq, int[] indxq, floatW rho, float[] z, float[] dlamda, float[] w, float[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, intW info);

	@Override
	public native void slaed3(int k, int n, int n1, float[] d, float[] q, int ldq, float rho, float[] dlamda, float[] q2, int[] indx, int[] ctot, float[] w, float[] s, intW info);

	@Override
	public native void slaed4(int n, int i, float[] d, float[] z, float[] delta, float rho, floatW dlam, intW info);

	@Override
	public native void slaed5(int i, float[] d, float[] z, float[] delta, float rho, floatW dlam);

	@Override
	public native void slaed6(int kniter, boolean orgati, float rho, float[] d, float[] z, float finit, floatW tau, intW info);

	@Override
	public native void slaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, float[] givnum, float[] work, int[] iwork, intW info);

	@Override
	public native void slaed8(int icompq, intW k, int n, int qsiz, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] z, float[] dlamda, float[] q2, int ldq2, float[] w, int[] perm, intW givptr, int[] givcol, float[] givnum, int[] indxp, int[] indx, intW info);

	@Override
	public native void slaed9(int k, int kstart, int kstop, int n, float[] d, float[] q, int ldq, float rho, float[] dlamda, float[] w, float[] s, int lds, intW info);

	@Override
	public native void slaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, float[] givnum, float[] q, int[] qptr, float[] z, float[] ztemp, intW info);

	@Override
	public native void slaein(boolean rightv, boolean noinit, int n, float[] h, int ldh, float wr, float wi, float[] vr, float[] vi, float[] b, int ldb, float[] work, float eps3, float smlnum, float bignum, intW info);

	@Override
	public native void slaev2(float a, float b, float c, floatW rt1, floatW rt2, floatW cs1, floatW sn1);

	@Override
	public native void slaexc(boolean wantq, int n, float[] t, int ldt, float[] q, int ldq, int j1, int n1, int n2, float[] work, intW info);

	@Override
	public native void slag2(float[] a, int lda, float[] b, int ldb, float safmin, floatW scale1, floatW scale2, floatW wr1, floatW wr2, floatW wi);

	@Override
	public native void slags2(boolean upper, float a1, float a2, float a3, float b1, float b2, float b3, floatW csu, floatW snu, floatW csv, floatW snv, floatW csq, floatW snq);

	@Override
	public native void slagtf(int n, float[] a, float lambda, float[] b, float[] c, float tol, float[] d, int[] in, intW info);

	@Override
	public native void slagtm(String trans, int n, int nrhs, float alpha, float[] dl, float[] d, float[] du, float[] x, int ldx, float beta, float[] b, int ldb);

	@Override
	public native void slagts(int job, int n, float[] a, float[] b, float[] c, float[] d, int[] in, float[] y, floatW tol, intW info);

	@Override
	public native void slagv2(float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, floatW csl, floatW snl, floatW csr, floatW snr);

	@Override
	public native void slahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, float[] h, int ldh, float[] wr, float[] wi, int iloz, int ihiz, float[] z, int ldz, intW info);

	@Override
	public native void slahrd(int n, int k, int nb, float[] a, int lda, float[] tau, float[] t, int ldt, float[] y, int ldy);

	@Override
	public native void slaic1(int job, int j, float[] x, float sest, float[] w, float gamma, floatW sestpr, floatW s, floatW c);

	@Override
	public native void slaln2(boolean ltrans, int na, int nw, float smin, float ca, float[] a, int lda, float d1, float d2, float[] b, int ldb, float wr, float wi, float[] x, int ldx, floatW scale, floatW xnorm, intW info);

	@Override
	public native void slals0(int icompq, int nl, int nr, int sqre, int nrhs, float[] b, int ldb, float[] bx, int ldbx, int[] perm, int givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, float[] poles, float[] difl, float[] difr, float[] z, int k, float c, float s, float[] work, intW info);

	@Override
	public native void slalsa(int icompq, int smlsiz, int n, int nrhs, float[] b, int ldb, float[] bx, int ldbx, float[] u, int ldu, float[] vt, int[] k, float[] difl, float[] difr, float[] z, float[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, float[] givnum, float[] c, float[] s, float[] work, int[] iwork, intW info);

	@Override
	public native void slalsd(String uplo, int smlsiz, int n, int nrhs, float[] d, float[] e, float[] b, int ldb, float rcond, intW rank, float[] work, int[] iwork, intW info);

	@Override
	public native void slamrg(int n1, int n2, float[] a, int strd1, int strd2, int[] index);

	@Override
	public native void slanv2(floatW a, floatW b, floatW c, floatW d, floatW rt1r, floatW rt1i, floatW rt2r, floatW rt2i, floatW cs, floatW sn);

	@Override
	public native void slapll(int n, float[] x, int incx, float[] y, int incy, floatW ssmin);

	@Override
	public native void slapmt(boolean forwrd, int m, int n, float[] x, int ldx, int[] k);

	@Override
	public native void slaqgb(int m, int n, int kl, int ku, float[] ab, int ldab, float[] r, float[] c, float rowcnd, float colcnd, float amax, StringW equed);

	@Override
	public native void slaqge(int m, int n, float[] a, int lda, float[] r, float[] c, float rowcnd, float colcnd, float amax, StringW equed);

	@Override
	public native void slaqp2(int m, int n, int offset, float[] a, int lda, int[] jpvt, float[] tau, float[] vn1, float[] vn2, float[] work);

	@Override
	public native void slaqps(int m, int n, int offset, int nb, intW kb, float[] a, int lda, int[] jpvt, float[] tau, float[] vn1, float[] vn2, float[] auxv, float[] f, int ldf);

	@Override
	public native void slaqsb(String uplo, int n, int kd, float[] ab, int ldab, float[] s, float scond, float amax, StringW equed);

	@Override
	public native void slaqsp(String uplo, int n, float[] ap, float[] s, float scond, float amax, StringW equed);

	@Override
	public native void slaqsy(String uplo, int n, float[] a, int lda, float[] s, float scond, float amax, StringW equed);

	@Override
	public native void slaqtr(boolean ltran, boolean lreal, int n, float[] t, int ldt, float[] b, float w, floatW scale, float[] x, float[] work, intW info);

	@Override
	public native void slar2v(int n, float[] x, float[] y, float[] z, int incx, float[] c, float[] s, int incc);

	@Override
	public native void slarf(String side, int m, int n, float[] v, int incv, float tau, float[] c, int Ldc, float[] work);

	@Override
	public native void slarfb(String side, String trans, String direct, String storev, int m, int n, int k, float[] v, int ldv, float[] t, int ldt, float[] c, int Ldc, float[] work, int ldwork);

	@Override
	public native void slarfg(int n, floatW alpha, float[] x, int incx, floatW tau);

	@Override
	public native void slarft(String direct, String storev, int n, int k, float[] v, int ldv, float[] tau, float[] t, int ldt);

	@Override
	public native void slarfx(String side, int m, int n, float[] v, float tau, float[] c, int Ldc, float[] work);

	@Override
	public native void slargv(int n, float[] x, int incx, float[] y, int incy, float[] c, int incc);

	@Override
	public native void slarnv(int idist, int[] iseed, int n, float[] x);

	@Override
	public native void slartg(float f, float g, floatW cs, floatW sn, floatW r);

	@Override
	public native void slartv(int n, float[] x, int incx, float[] y, int incy, float[] c, float[] s, int incc);

	@Override
	public native void slaruv(int[] iseed, int n, float[] x);

	@Override
	public native void slarz(String side, int m, int n, int l, float[] v, int incv, float tau, float[] c, int Ldc, float[] work);

	@Override
	public native void slarzb(String side, String trans, String direct, String storev, int m, int n, int k, int l, float[] v, int ldv, float[] t, int ldt, float[] c, int Ldc, float[] work, int ldwork);

	@Override
	public native void slarzt(String direct, String storev, int n, int k, float[] v, int ldv, float[] tau, float[] t, int ldt);

	@Override
	public native void slas2(float f, float g, float h, floatW ssmin, floatW ssmax);

	@Override
	public native void slascl(String type, int kl, int ku, float cfrom, float cto, int m, int n, float[] a, int lda, intW info);

	@Override
	public native void slasd0(int n, int sqre, float[] d, float[] e, float[] u, int ldu, float[] vt, int ldvt, int smlsiz, int[] iwork, float[] work, intW info);

	@Override
	public native void slasd1(int nl, int nr, int sqre, float[] d, floatW alpha, floatW beta, float[] u, int ldu, float[] vt, int ldvt, int[] idxq, int[] iwork, float[] work, intW info);

	@Override
	public native void slasd2(int nl, int nr, int sqre, intW k, float[] d, float[] z, float alpha, float beta, float[] u, int ldu, float[] vt, int ldvt, float[] dsigma, float[] u2, int ldu2, float[] vt2, int ldvt2, int[] idxp, int[] idx, int[] idxc, int[] idxq, int[] coltyp, intW info);

	@Override
	public native void slasd3(int nl, int nr, int sqre, int k, float[] d, float[] q, int ldq, float[] dsigma, float[] u, int ldu, float[] u2, int ldu2, float[] vt, int ldvt, float[] vt2, int ldvt2, int[] idxc, int[] ctot, float[] z, intW info);

	@Override
	public native void slasd4(int n, int i, float[] d, float[] z, float[] delta, float rho, floatW sigma, float[] work, intW info);

	@Override
	public native void slasd5(int i, float[] d, float[] z, float[] delta, float rho, floatW dsigma, float[] work);

	@Override
	public native void slasd6(int icompq, int nl, int nr, int sqre, float[] d, float[] vf, float[] vl, floatW alpha, floatW beta, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, float[] poles, float[] difl, float[] difr, float[] z, intW k, floatW c, floatW s, float[] work, int[] iwork, intW info);

	@Override
	public native void slasd7(int icompq, int nl, int nr, int sqre, intW k, float[] d, float[] z, float[] zw, float[] vf, float[] vfw, float[] vl, float[] vlw, float alpha, float beta, float[] dsigma, int[] idx, int[] idxp, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, floatW c, floatW s, intW info);

	@Override
	public native void slasd8(int icompq, int k, float[] d, float[] z, float[] vf, float[] vl, float[] difl, float[] difr, int lddifr, float[] dsigma, float[] work, intW info);

	@Override
	public native void slasda(int icompq, int smlsiz, int n, int sqre, float[] d, float[] e, float[] u, int ldu, float[] vt, int[] k, float[] difl, float[] difr, float[] z, float[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, float[] givnum, float[] c, float[] s, float[] work, int[] iwork, intW info);

	@Override
	public native void slasdq(String uplo, int sqre, int n, int ncvt, int nru, int ncc, float[] d, float[] e, float[] vt, int ldvt, float[] u, int ldu, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void slasdt(int n, intW lvl, intW nd, int[] inode, int[] ndiml, int[] ndimr, int msub);

	@Override
	public native void slaset(String uplo, int m, int n, float alpha, float beta, float[] a, int lda);

	@Override
	public native void slasq1(int n, float[] d, float[] e, float[] work, intW info);

	@Override
	public native void slasq2(int n, float[] z, intW info);

	@Override
	public native void slasq3(int i0, intW n0, float[] z, int pp, floatW dmin, floatW sigma, floatW desig, floatW qmax, intW nfail, intW iter, intW ndiv, boolean ieee);

	@Override
	public native void slasq4(int i0, int n0, float[] z, int pp, int n0in, float dmin, float dmin1, float dmin2, float dn, float dn1, float dn2, floatW tau, intW ttype);

	@Override
	public native void slasq5(int i0, int n0, float[] z, int pp, float tau, floatW dmin, floatW dmin1, floatW dmin2, floatW dn, floatW dnm1, floatW dnm2, boolean ieee);

	@Override
	public native void slasq6(int i0, int n0, float[] z, int pp, floatW dmin, floatW dmin1, floatW dmin2, floatW dn, floatW dnm1, floatW dnm2);

	@Override
	public native void slasr(String side, String pivot, String direct, int m, int n, float[] c, float[] s, float[] a, int lda);

	@Override
	public native void slasrt(String id, int n, float[] d, intW info);

	@Override
	public native void slassq(int n, float[] x, int incx, floatW scale, floatW sumsq);

	@Override
	public native void slasv2(float f, float g, float h, floatW ssmin, floatW ssmax, floatW snr, floatW csr, floatW snl, floatW csl);

	@Override
	public native void slaswp(int n, float[] a, int lda, int k1, int k2, int[] ipiv, int incx);

	@Override
	public native void slasy2(boolean ltranl, boolean ltranr, int isgn, int n1, int n2, float[] tl, int ldtl, float[] tr, int ldtr, float[] b, int ldb, floatW scale, float[] x, int ldx, floatW xnorm, intW info);

	@Override
	public native void slasyf(String uplo, int n, int nb, intW kb, float[] a, int lda, int[] ipiv, float[] w, int ldw, intW info);

	@Override
	public native void slatbs(String uplo, String trans, String diag, String normin, int n, int kd, float[] ab, int ldab, float[] x, floatW scale, float[] cnorm, intW info);

	@Override
	public native void slatdf(int ijob, int n, float[] z, int ldz, float[] rhs, floatW rdsum, floatW rdscal, int[] ipiv, int[] jpiv);

	@Override
	public native void slatps(String uplo, String trans, String diag, String normin, int n, float[] ap, float[] x, floatW scale, float[] cnorm, intW info);

	@Override
	public native void slatrd(String uplo, int n, int nb, float[] a, int lda, float[] e, float[] tau, float[] w, int ldw);

	@Override
	public native void slatrs(String uplo, String trans, String diag, String normin, int n, float[] a, int lda, float[] x, floatW scale, float[] cnorm, intW info);

	@Override
	public native void slatrz(int m, int n, int l, float[] a, int lda, float[] tau, float[] work);

	@Override
	public native void slatzm(String side, int m, int n, float[] v, int incv, float tau, float[] c1, float[] c2, int Ldc, float[] work);

	@Override
	public native void slauu2(String uplo, int n, float[] a, int lda, intW info);

	@Override
	public native void slauum(String uplo, int n, float[] a, int lda, intW info);

	@Override
	public native void sopgtr(String uplo, int n, float[] ap, float[] tau, float[] q, int ldq, float[] work, intW info);

	@Override
	public native void sopmtr(String side, String uplo, String trans, int m, int n, float[] ap, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sorg2l(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sorg2r(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sorgbr(String vect, int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorghr(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorgl2(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sorglq(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorgql(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorgqr(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorgr2(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info);

	@Override
	public native void sorgrq(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorgtr(String uplo, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void sorm2l(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sorm2r(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sormbr(String vect, String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormhr(String side, String trans, int m, int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sorml2(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sormlq(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormql(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormqr(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormr2(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sormr3(String side, String trans, int m, int n, int k, int l, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info);

	@Override
	public native void sormrq(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormrz(String side, String trans, int m, int n, int k, int l, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void sormtr(String side, String uplo, String trans, int m, int n, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info);

	@Override
	public native void spbcon(String uplo, int n, int kd, float[] ab, int ldab, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void spbequ(String uplo, int n, int kd, float[] ab, int ldab, float[] s, floatW scond, floatW amax, intW info);

	@Override
	public native void spbrfs(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void spbstf(String uplo, int n, int kd, float[] ab, int ldab, intW info);

	@Override
	public native void spbsv(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info);

	@Override
	public native void spbsvx(String fact, String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void spbtf2(String uplo, int n, int kd, float[] ab, int ldab, intW info);

	@Override
	public native void spbtrf(String uplo, int n, int kd, float[] ab, int ldab, intW info);

	@Override
	public native void spbtrs(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info);

	@Override
	public native void spocon(String uplo, int n, float[] a, int lda, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void spoequ(int n, float[] a, int lda, float[] s, floatW scond, floatW amax, intW info);

	@Override
	public native void sporfs(String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sposv(String uplo, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info);

	@Override
	public native void sposvx(String fact, String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void spotf2(String uplo, int n, float[] a, int lda, intW info);

	@Override
	public native void spotrf(String uplo, int n, float[] a, int lda, intW info);

	@Override
	public native void spotri(String uplo, int n, float[] a, int lda, intW info);

	@Override
	public native void spotrs(String uplo, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info);

	@Override
	public native void sppcon(String uplo, int n, float[] ap, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void sppequ(String uplo, int n, float[] ap, float[] s, floatW scond, floatW amax, intW info);

	@Override
	public native void spprfs(String uplo, int n, int nrhs, float[] ap, float[] afp, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sppsv(String uplo, int n, int nrhs, float[] ap, float[] b, int ldb, intW info);

	@Override
	public native void sppsvx(String fact, String uplo, int n, int nrhs, float[] ap, float[] afp, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void spptrf(String uplo, int n, float[] ap, intW info);

	@Override
	public native void spptri(String uplo, int n, float[] ap, intW info);

	@Override
	public native void spptrs(String uplo, int n, int nrhs, float[] ap, float[] b, int ldb, intW info);

	@Override
	public native void sptcon(int n, float[] d, float[] e, float anorm, floatW rcond, float[] work, intW info);

	@Override
	public native void spteqr(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void sptrfs(int n, int nrhs, float[] d, float[] e, float[] df, float[] ef, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, intW info);

	@Override
	public native void sptsv(int n, int nrhs, float[] d, float[] e, float[] b, int ldb, intW info);

	@Override
	public native void sptsvx(String fact, int n, int nrhs, float[] d, float[] e, float[] df, float[] ef, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, intW info);

	@Override
	public native void spttrf(int n, float[] d, float[] e, intW info);

	@Override
	public native void spttrs(int n, int nrhs, float[] d, float[] e, float[] b, int ldb, intW info);

	@Override
	public native void sptts2(int n, int nrhs, float[] d, float[] e, float[] b, int ldb);

	@Override
	public native void srscl(int n, float sa, float[] sx, int incx);

	@Override
	public native void ssbev(String jobz, String uplo, int n, int kd, float[] ab, int ldab, float[] w, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void ssbevd(String jobz, String uplo, int n, int kd, float[] ab, int ldab, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void ssbevx(String jobz, String range, String uplo, int n, int kd, float[] ab, int ldab, float[] q, int ldq, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssbgst(String vect, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] x, int ldx, float[] work, intW info);

	@Override
	public native void ssbgv(String jobz, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] w, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void ssbgvd(String jobz, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void ssbgvx(String jobz, String range, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] q, int ldq, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssbtrd(String vect, String uplo, int n, int kd, float[] ab, int ldab, float[] d, float[] e, float[] q, int ldq, float[] work, intW info);

	@Override
	public native void sspcon(String uplo, int n, float[] ap, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void sspev(String jobz, String uplo, int n, float[] ap, float[] w, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void sspevd(String jobz, String uplo, int n, float[] ap, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sspevx(String jobz, String range, String uplo, int n, float[] ap, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void sspgst(int itype, String uplo, int n, float[] ap, float[] bp, intW info);

	@Override
	public native void sspgv(int itype, String jobz, String uplo, int n, float[] ap, float[] bp, float[] w, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void sspgvd(int itype, String jobz, String uplo, int n, float[] ap, float[] bp, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sspgvx(int itype, String jobz, String range, String uplo, int n, float[] ap, float[] bp, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssprfs(String uplo, int n, int nrhs, float[] ap, float[] afp, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void sspsv(String uplo, int n, int nrhs, float[] ap, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sspsvx(String fact, String uplo, int n, int nrhs, float[] ap, float[] afp, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void ssptrd(String uplo, int n, float[] ap, float[] d, float[] e, float[] tau, intW info);

	@Override
	public native void ssptrf(String uplo, int n, float[] ap, int[] ipiv, intW info);

	@Override
	public native void ssptri(String uplo, int n, float[] ap, int[] ipiv, float[] work, intW info);

	@Override
	public native void ssptrs(String uplo, int n, int nrhs, float[] ap, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void sstebz(String range, String order, int n, float vl, float vu, int il, int iu, float abstol, float[] d, float[] e, intW m, intW nsplit, float[] w, int[] iblock, int[] isplit, float[] work, int[] iwork, intW info);

	@Override
	public native void sstedc(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sstegr(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sstein(int n, float[] d, float[] e, int m, float[] w, int[] iblock, int[] isplit, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssteqr(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void ssterf(int n, float[] d, float[] e, intW info);

	@Override
	public native void sstev(String jobz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info);

	@Override
	public native void sstevd(String jobz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sstevr(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void sstevx(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssycon(String uplo, int n, float[] a, int lda, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void ssyev(String jobz, String uplo, int n, float[] a, int lda, float[] w, float[] work, int lwork, intW info);

	@Override
	public native void ssyevd(String jobz, String uplo, int n, float[] a, int lda, float[] w, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void ssyevr(String jobz, String range, String uplo, int n, float[] a, int lda, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void ssyevx(String jobz, String range, String uplo, int n, float[] a, int lda, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssygs2(int itype, String uplo, int n, float[] a, int lda, float[] b, int ldb, intW info);

	@Override
	public native void ssygst(int itype, String uplo, int n, float[] a, int lda, float[] b, int ldb, intW info);

	@Override
	public native void ssygv(int itype, String jobz, String uplo, int n, float[] a, int lda, float[] b, int ldb, float[] w, float[] work, int lwork, intW info);

	@Override
	public native void ssygvd(int itype, String jobz, String uplo, int n, float[] a, int lda, float[] b, int ldb, float[] w, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void ssygvx(int itype, String jobz, String range, String uplo, int n, float[] a, int lda, float[] b, int ldb, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int[] ifail, intW info);

	@Override
	public native void ssyrfs(String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void ssysv(String uplo, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, float[] work, int lwork, intW info);

	@Override
	public native void ssysvx(String fact, String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void ssytd2(String uplo, int n, float[] a, int lda, float[] d, float[] e, float[] tau, intW info);

	@Override
	public native void ssytf2(String uplo, int n, float[] a, int lda, int[] ipiv, intW info);

	@Override
	public native void ssytrd(String uplo, int n, float[] a, int lda, float[] d, float[] e, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native void ssytrf(String uplo, int n, float[] a, int lda, int[] ipiv, float[] work, int lwork, intW info);

	@Override
	public native void ssytri(String uplo, int n, float[] a, int lda, int[] ipiv, float[] work, intW info);

	@Override
	public native void ssytrs(String uplo, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info);

	@Override
	public native void stbcon(String norm, String uplo, String diag, int n, int kd, float[] ab, int ldab, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void stbrfs(String uplo, String trans, String diag, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void stbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info);

	@Override
	public native void stgevc(String side, String howmny, boolean[] select, int n, float[] s, int lds, float[] p, int ldp, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, intW info);

	@Override
	public native void stgex2(boolean wantq, boolean wantz, int n, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, int j1, int n1, int n2, float[] work, int lwork, intW info);

	@Override
	public native void stgexc(boolean wantq, boolean wantz, int n, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, intW ifst, intW ilst, float[] work, int lwork, intW info);

	@Override
	public native void stgsen(int ijob, boolean wantq, boolean wantz, boolean[] select, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] q, int ldq, float[] z, int ldz, intW m, floatW pl, floatW pr, float[] dif, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void stgsja(String jobu, String jobv, String jobq, int m, int p, int n, int k, int l, float[] a, int lda, float[] b, int ldb, float tola, float tolb, float[] alpha, float[] beta, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, float[] work, intW ncycle, intW info);

	@Override
	public native void stgsna(String job, String howmny, boolean[] select, int n, float[] a, int lda, float[] b, int ldb, float[] vl, int ldvl, float[] vr, int ldvr, float[] s, float[] dif, int mm, intW m, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void stgsy2(String trans, int ijob, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, float[] d, int ldd, float[] e, int lde, float[] f, int ldf, floatW scale, floatW rdsum, floatW rdscal, int[] iwork, intW pq, intW info);

	@Override
	public native void stgsyl(String trans, int ijob, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, float[] d, int ldd, float[] e, int lde, float[] f, int ldf, floatW scale, floatW dif, float[] work, int lwork, int[] iwork, intW info);

	@Override
	public native void stpcon(String norm, String uplo, String diag, int n, float[] ap, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void stprfs(String uplo, String trans, String diag, int n, int nrhs, float[] ap, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void stptri(String uplo, String diag, int n, float[] ap, intW info);

	@Override
	public native void stptrs(String uplo, String trans, String diag, int n, int nrhs, float[] ap, float[] b, int ldb, intW info);

	@Override
	public native void strcon(String norm, String uplo, String diag, int n, float[] a, int lda, floatW rcond, float[] work, int[] iwork, intW info);

	@Override
	public native void strevc(String side, String howmny, boolean[] select, int n, float[] t, int ldt, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, intW info);

	@Override
	public native void strexc(String compq, int n, float[] t, int ldt, float[] q, int ldq, intW ifst, intW ilst, float[] work, intW info);

	@Override
	public native void strrfs(String uplo, String trans, String diag, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info);

	@Override
	public native void strsen(String job, String compq, boolean[] select, int n, float[] t, int ldt, float[] q, int ldq, float[] wr, float[] wi, intW m, floatW s, floatW sep, float[] work, int lwork, int[] iwork, int liwork, intW info);

	@Override
	public native void strsna(String job, String howmny, boolean[] select, int n, float[] t, int ldt, float[] vl, int ldvl, float[] vr, int ldvr, float[] s, float[] sep, int mm, intW m, float[] work, int ldwork, int[] iwork, intW info);

	@Override
	public native void strsyl(String trana, String tranb, int isgn, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, floatW scale, intW info);

	@Override
	public native void strti2(String uplo, String diag, int n, float[] a, int lda, intW info);

	@Override
	public native void strtri(String uplo, String diag, int n, float[] a, int lda, intW info);

	@Override
	public native void strtrs(String uplo, String trans, String diag, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info);

	@Override
	public native void stzrqf(int m, int n, float[] a, int lda, float[] tau, intW info);

	@Override
	public native void stzrzf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info);

	@Override
	public native double dlamch(String cmach);

	@Override
	public native void dlamc1(intW beta, intW t, booleanW rnd, booleanW ieee1);

	@Override
	public native void dlamc2(intW beta, intW t, booleanW rnd, doubleW eps, intW emin, doubleW rmin, intW emax, doubleW rmax);

	@Override
	public native void dlamc4(intW emin, double start, int base);

	@Override
	public native void dlamc5(int beta, int p, int emin, boolean ieee, intW emax, doubleW rmax);

	@Override
	public native void slamc1(intW beta, intW t, booleanW rnd, booleanW ieee1);

	@Override
	public native void slamc2(intW beta, intW t, booleanW rnd, floatW eps, intW emin, floatW rmin, intW emax, floatW rmax);

	@Override
	public native void slamc4(intW emin, float start, int base);

	@Override
	public native void slamc5(int beta, int p, int emin, boolean ieee, intW emax, floatW rmax);

}
