      subroutine argos_prep_input(irtdb)
c
c $Id$
c
      implicit none
c
#include "rtdb.fh"
#include "inp.fh"
#include "global.fh"
#include "mafdecls.fh"
c
      integer irtdb
      character*255 item,atom,type,atomi,atomj,atomk,atoml
c
      integer mcount
      parameter(mcount=10)
      integer mfract
      parameter(mfract=250)
c
      character*3 slvnam
      character*80 source
      character*10 slvmdl
      character*80 ffield,sysnam
      character*255 commnd,modify,title(2,3)
      character*255 dirs(9)
      character*80 card,string
      integer newtop,newseq,newrst,icount(10),multip,ncount
      integer nfract,ifract(mfract)
c
      integer len,numcmd,nummod,mgrid,mnoe,mpmf,maxscf,num,mset(2),nset
      integer isgm,icyren,model,nxlnk,iconst,npmfr,isarep,lrgpdb
      real*8 touch,xpnd(3),rgrid,edge,edges(3),dnoe(5),qscale,charge
      real*8 polar,value,forcon,forc2,box(3)
      character*11 cfix
      real*8 rfix
      character*1 altloc,chain,his
      integer ires,jres,kres,i,j,k,ignore,igroup,jgroup,kgroup,lgroup
      integer nxrep,nyrep,nzrep,itran,jtran,nkeepw,irot,jrot,irenum,n
      real*8 rrep,rdist,xtran(3),arot,xrot(3)
      real*8 value1,value2
      character*4 scount(mcount)
      real*8 fcount
      real*8 xrmin,xrmax,yrmin,yrmax,zrmin,zrmax
      real*8 scale,cpk,rshell,xmerge(3)
      integer irepeat,nrepeat,iopt,jopt,kopt,irrand,invert,irrep
      integer iskip,jskip,kskip
      integer nrgrid,iogrid(5),rogrid(2,5)
      integer itopol,ititle,ntitle,nmoves,icomb,icolgrp,jcolgrp
c
      logical ltouch,lrdcoo,lslvnt,needwt,lwrcoo,ltitle
c
c      if(ga_nodeid().eq.0) then
c      if(util_print('prepare',print_medium)) then
c      write(6,*)
c      write(6,*)
c      call util_print_centered(6,'PREPARE Input Module',40,.true.)
c      write(6,*)
c      write(6,*)
c      endif
c      endif
c
c     set the defaults
c     ----------------
c
      title(1,1)='NWChem topology file'
      title(1,2)=' '
      title(1,3)='Generated by the NWChem prepare module'
      title(2,1)='NWChem restart file'
      title(2,2)=' '
      title(2,3)='Generated by the NWChem prepare module'
      ntitle=-1
c
      ffield=' '
      do 313 i=1,9
      dirs(i)=' '
  313 continue
c
      sysnam=' '
      slvnam='HOH'
      slvmdl='spce      '
      altloc='A'
      chain='*'
      his=' '
      newtop=0
      newseq=0
      newrst=0
      source=' '
      mgrid=24
      rgrid=0.4d0
      mnoe=0
      mpmf=0
      maxscf=0
      qscale=-1.0d0
      ncount=0
      nfract=0
      icyren=0
      iconst=0
      model=0
      nxlnk=0
      ignore=0
      nxrep=0
      nyrep=0
      nzrep=0
      irrep=0
      rrep=0.25d0
      rdist=0.0d0
      scale=-1.0d0
      cpk=-1.0d0
      nrepeat=0
      fcount=1.0d0
      nrgrid=0
      itopol=0
      icomb=0
c
      touch=0.25d0
      xpnd(1)=0.00d0
      xpnd(2)=0.00d0
      xpnd(3)=0.00d0
      box(1)=0.0d0
      box(2)=0.0d0
      box(3)=0.0d0
c
      ltouch=.false.
      lrdcoo=.false.
      lwrcoo=.false.
      lslvnt=.false.
      needwt=.false.
c
      if(.not.rtdb_cget(irtdb,'file_prefix',1,commnd))
     + call md_abort('rtdb_cget failed on file_prefix',9999)
      modify=commnd(1:index(commnd,' ')-1)//'.mod '
      open(unit=67,file=modify(1:index(modify,' ')-1),
     + form='formatted',status='unknown',err=9999)
      rewind(unit=67)
      nummod=0
      commnd=commnd(1:index(commnd,' ')-1)//'.cmd '
      open(unit=68,file=commnd(1:index(commnd,' ')-1),
     + form='formatted',status='unknown',err=9999)
      rewind(unit=68)
      write(68,7801)
c 7801 format('rdcoor ',/,'center',/,'boxsiz')
 7801 format('rdcoor ')
      numcmd=numcmd+1
      lrdcoo=.true.
      numcmd=0
c
c     read the prepare input block
c     ----------------------------
c
    1 continue
c
      if(.not.inp_read())
     + call md_abort('argos_prep_input: inp_read failed',0)
c
    2 continue
c
      if(.not.inp_a(item)) goto 1
c
    3 continue
c
c     end
c     ---
c
      if(inp_compare(.false.,'end',item)) then
      goto 9
      endif
c
c     title
c     -----
c
      if(inp_compare(.false.,'title',item)) then
   56 continue
      ntitle=0
      ltitle=inp_a(item)
      ititle=0
      if(ltitle) then
      if(inp_compare(.false.,'topology',item)) then
      ititle=1
      elseif(inp_compare(.false.,'restart',item)) then
      ititle=2
      endif
      endif
c
      if(ititle.eq.0.or.ititle.eq.1) then
      title(1,1)=' '
      title(1,2)=' '
      title(1,3)=' '
      endif
      if(ititle.eq.0.or.ititle.eq.2) then
      title(2,1)=' '
      title(2,2)=' '
      title(2,3)=' '
      endif
c
   57 continue
c
      if(.not.inp_read())
     + call md_abort('argos_prep_input: inp_read failed',0)
      if(.not.inp_line(card))
     + call md_abort('argos_prep_input: inp_line',0)
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: inp_read failed',0)
      if(inp_compare(.false.,'title',item)) goto 56
      if(inp_compare(.false.,'end_title',item)) goto 1
      ntitle=ntitle+1
      if(ntitle.gt.3)
     + call md_abort('argos_prep_input: too many title lines',0)
      if(ititle.eq.0) then
      title(1,ntitle)=card
      title(2,ntitle)=card
      endif
      if(ititle.eq.1) title(1,ntitle)=card
      if(ititle.eq.2) title(2,ntitle)=card
c
      goto 57
      endif
c
c     print & noprint
c     ---------------
c
      if(inp_compare(.false.,'print',item).or.
     + inp_compare(.false.,'noprint',item)) then
      call util_print_input(irtdb,'prepar')
      goto 1
      endif
c
c     force field
c     -----------
c
    5 continue
      if(inp_compare(.false.,'amber',item)) then
      ffield='amber '
      if(icomb.eq.0) icomb=3
      goto 2
      endif
      if(inp_compare(.false.,'charmm',item)) then
      ffield='charmm '
      if(icomb.eq.0) icomb=3
      goto 2
      endif
      if(inp_compare(.false.,'gromos',item)) then
      ffield='gromos '
      goto 2
      endif
      if(inp_compare(.false.,'oplsa',item)) then
      ffield='oplsa '
      goto 2
      endif
      if(inp_compare(.false.,'oplsg',item)) then
      ffield='oplsg '
      goto 2
      endif
      if(inp_compare(.false.,'ffield',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: error ffield',0)
      goto 5
      endif
c
c     default parameter combination rules
c     -----------------------------------
c
c     1: C6 and C12
c     2: epsilon and sigma
c     3: epsilon and R*
c     4: B and A
c
      if(inp_compare(.false.,'parameters',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: error parameter',0)
      if(inp_compare(.false.,'epsilon',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: error parameter',0)
      if(inp_compare(.false.,'sigma',item)) then
      icomb=2
      elseif(inp_compare(.false.,'r*',item)) then
      icomb=3
      else
      call md_abort('argos_prep_input: unknown parameter format',0)
      endif
      elseif(inp_compare(.false.,'c6',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: error parameter',0)
      if(.not.inp_compare(.false.,'c12',item))
     + call md_abort('argos_prep_input: unknown parameter format',0)
      icomb=1
      elseif(inp_compare(.false.,'b',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: error parameter',0)
      if(.not.inp_compare(.false.,'a',item))
     + call md_abort('argos_prep_input: unknown parameter format',0)
      icomb=4
      else
      call md_abort('argos_prep_input: unknown parameter format',0)
      endif
      goto 2
      endif
c
c
c     topology function
c     -----------------
c
      if(inp_compare(.false.,'first',item)) then
      itopol=1
      goto 2
      endif
      if(inp_compare(.false.,'free',item).or.
     + inp_compare(.false.,'mcti',item)) then
      itopol=2
      goto 2
      endif
      if(inp_compare(.false.,'qhop',item)) then
      itopol=3
      goto 2
      endif
c
c     directories
c     -----------
c
      do 314 i=1,9
      write(string,'(a,i1)') 'directory_',i
      if(inp_compare(.false.,string,item)) then
      if(.not.inp_a(dirs(i)))
     + call md_abort('argos_prep_input: error dirs',i)
      len=index(dirs(i),' ')-1
      if(len.gt.0.and.dirs(i)(len:len).ne.'/'.and.
     + dirs(i)(len-3:len).ne.'.par') dirs(i)(len+1:len+2)='/ '
      goto 2
      endif
  314 continue
c
c     sysnam
c     ------
c
      if(inp_compare(.false.,'system',item)) then
      if(.not.inp_a(sysnam))
     + call md_abort('argos_prep_input: error sysnam',0)
      if(ntitle.lt.0) then
      title(1,1)=
     + 'NWChem topology file for '//sysnam(1:index(sysnam,' ')-1)
      title(2,1)=
     + 'NWChem restart file for '//sysnam(1:index(sysnam,' ')-1)
      endif
      goto 2
      endif
c
c     source
c     ------
c
      if(inp_compare(.false.,'source',item)) then
      if(.not.inp_a(source))
     + call md_abort('argos_prep_input: error source',0)
      goto 2
      endif
c
c     ignore not found bonded parameters for quantum atoms
c
      if(inp_compare(.false.,'ignore',item)) then
      ignore=1
      goto 2
      endif
c
c     max atoms in scf and charge scaling
c     -----------------------------------
c
      if(inp_compare(.false.,'maxscf',item)) then
      if(.not.inp_i(maxscf))
     + call md_abort('argos_prep_input: error maxscf',0)
      goto 2
      endif
      if(inp_compare(.false.,'qscale',item)) then
      if(.not.inp_f(qscale))
     + call md_abort('argos_prep_input: error qscale',0)
      goto 2
      endif
c
c     povray scaling
c     --------------
c
      if(inp_compare(.false.,'scale',item)) then
      if(.not.inp_f(scale))
     + call md_abort('argos_prep_input: error qscale',0)
      goto 2
      endif
      if(inp_compare(.false.,'cpk',item)) then
      if(.not.inp_f(cpk)) cpk=1.0d0
      goto 2
      endif
c
c     slvnam & slvmdl
c     ---------------
c
      if(inp_compare(.false.,'solvent',item)) then
      num=0
   20 continue
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: solvent',9999)
      if(inp_compare(.false.,'name',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: solvent',9999)
      slvnam=item(1:3)
      if(num.eq.2) goto 2
      num=1
      goto 20
      else
      if(inp_compare(.false.,'model',item)) then
      if(.not.inp_a(slvmdl))
     + call md_abort('argos_prep_input: solvent',9999)
      if(num.eq.1) goto 2
      num=2
      goto 20
      endif
      endif
      endif
c
c     alternate location
c     ------------------
c
      if(inp_compare(.false.,'altloc',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: altloc',9999)
      altloc=item(1:1)
      goto 2
      endif
c
c     chain
c     -----
c
      if(inp_compare(.false.,'chain',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: chain',9999)
      chain=item(1:1)
      goto 2
      endif
c
c     histidine protonation
c     ---------------------
c
      if(inp_compare(.false.,'histidine',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: chain',9999)
      if(inp_compare(.false.,'hid',item)) his='D'
      if(inp_compare(.false.,'hie',item)) his='E'
      if(inp_compare(.false.,'hip',item)) his='P'
      goto 2
      endif
c
c     topology
c     --------
c
      if(inp_compare(.false.,'new_top',item)) then
      newtop=1
   21 continue
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'new_seq',item)) then
      newseq=1
      goto 2
      endif
      goto 3
      endif
c
c     model
c     -----
c
      if(inp_compare(.false.,'model',item)) then
      if(.not.inp_i(model))
     + call md_abort('argos_prep_input: model',9999)
      goto 2
      endif
c
c     newrst
c     ------
c
      if(inp_compare(.false.,'new_rst',item)) then
      newrst=1
      goto 2
      endif
c
c     counterion grid parameters
c     --------------------------
c
      if(inp_compare(.false.,'grid',item)) then
      if(.not.inp_i(mgrid)) call md_abort('argos_prep_input: grid',9999)
      do 6865 i=1,4
      if(inp_f(rgrid)) goto 6867
      if(i.eq.4) goto 6867
      if(.not.inp_a(item)) call md_abort('argos_prep_input: grid',9999)
      j=-1
      if(inp_compare(.false.,'inside',item)) j=0
      if(inp_compare(.false.,'outside',item)) j=1
      if(j.eq.-1) call md_abort('argos_prep_input: remove',9999)
      nrgrid=nrgrid+1
      if(inp_a(item)) then
      if(inp_compare(.false.,'x',item)) then
      if(.not.inp_f(xrmin)) call md_abort('argos_prep_input remove x',0)
      if(.not.inp_f(xrmax)) call md_abort('argos_prep_input remove x',0)
      iogrid(nrgrid)=1+j
      rogrid(1,nrgrid)=xrmin
      rogrid(2,nrgrid)=xrmax
      endif
      if(inp_compare(.false.,'y',item)) then
      if(.not.inp_f(yrmin)) call md_abort('argos_prep_input remove y',0)
      if(.not.inp_f(yrmax)) call md_abort('argos_prep_input remove y',0)
      iogrid(nrgrid)=3+j
      rogrid(1,nrgrid)=yrmin
      rogrid(2,nrgrid)=yrmax
      endif
      if(inp_compare(.false.,'z',item)) then
      if(.not.inp_f(zrmin)) call md_abort('argos_prep_input remove z',0)
      if(.not.inp_f(zrmax)) call md_abort('argos_prep_input remove z',0)
      iogrid(nrgrid)=5+j
      rogrid(1,nrgrid)=zrmin
      rogrid(2,nrgrid)=zrmax
      endif
      if(inp_compare(.false.,'xy',item)) then
      if(.not.inp_f(zrmin))
     + call md_abort('argos_prep_input remove xy',0)
      if(.not.inp_f(zrmax))
     + call md_abort('argos_prep_input remove xy',0)
      iogrid(nrgrid)=7+j
      rogrid(1,nrgrid)=zrmin
      rogrid(2,nrgrid)=zrmax
      endif
      if(inp_compare(.false.,'xyz',item)) then
      if(.not.inp_f(zrmin))
     + call md_abort('argos_prep_input remove xyz',0)
      if(.not.inp_f(zrmax))
     + call md_abort('argos_prep_input remove xyz',0)
      iogrid(nrgrid)=9+j
      rogrid(1,nrgrid)=zrmin
      rogrid(2,nrgrid)=zrmax
      endif
      else
      goto 6867
      endif
 6865 continue
 6867 continue
      goto 2
      endif
c
c     rename commands
c     ---------------
c
      if(inp_compare(.false.,'sscyx',item)) then
      icyren=1
      goto 2
      endif
c
c     completion
c     ----------
c
      if(inp_compare(.false.,'construct',item)) then
      iconst=1
      goto 2
      endif
      if(inp_compare(.false.,'hbuild',item)) then
      iconst=1
      goto 2
      endif
c
c     divide molecules into fractions
c     -------------------------------
c
      if(inp_compare(.false.,'fraction',item)) then
    4 continue
      if(.not.inp_i(i)) goto 2
      nfract=nfract+1
      if(nfract.gt.mfract) call md_abort('Too many fractions',nfract)
      ifract(nfract)=i
      goto 4
      endif
c
c     add counter ions to sequence file
c     ---------------------------------
c
      if(inp_compare(.false.,'counter',item)) then
      ncount=ncount+1
      if(ncount.gt.mcount) call md_abort('Too many counters',ncount)
      if(.not.inp_i(icount(ncount))) then
      if(.not.inp_f(fcount))
     + call md_abort('argos_prep_input: counter',9999)
      ncount=ncount-1
      goto 2
      else
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: counter',9999)
      scount(ncount)=item(1:4)
      goto 2
      endif
      endif
c
c     fix commands
c     ------------
c
      if(inp_compare(.false.,'fix',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: fix',9999)
      if(inp_compare(.false.,'atoms',item)) then
      cfix(8:11)='atm '
      else if(inp_compare(.false.,'segments',item)) then
      cfix(8:11)='sgm '
      else
      call md_abort('argos_prep_input: fix',9999)
      endif
      if(.not.inp_a(item)) call md_abort('argos_prep_input: fix',9999)
      if(inp_compare(.false.,'beyond',item)) then
      cfix(1:7)='fixout '
      else if(inp_compare(.false.,'within',item)) then
      cfix(1:7)='fixwin '
      else
      call md_abort('argos_prep_input: fix',9999)
      endif
      if(.not.inp_f(rfix)) call md_abort('argos_prep_input: fix',9999)
      if(.not.inp_a(item)) call md_abort('argos_prep_input: fix',9999)
      write(68,6841) cfix,rfix,item
 6841 format(a11,f12.6,1x,a)
      numcmd=numcmd+1
      goto 2
      endif
c
c     topology modification commands
c     ------------------------------
c
      if(inp_compare(.false.,'modify',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: modify',9999)
c
      if(inp_compare(.false.,'atom',item)) then
      if(.not.inp_a(atom))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
 3312 continue
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3312
      endif
      if(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3312
      endif
      if(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3312
      endif
      if(inp_compare(.false.,'charge',item)) then
      if(.not.inp_f(charge))
     + call md_abort('argos_prep_input: charge',9999)
      write(67,6701) (atom(1:index(atom,' ')-1),mset(i),charge,i=1,nset)
 6701 format('atom ',a,t19,i1,' chg ',f12.6)
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'polar',item)) then
      if(.not.inp_f(polar))
     + call md_abort('argos_prep_input: polar',9999)
      write(67,6702) (atom(1:index(atom,' ')-1),mset(i),polar,i=1,nset)
 6702 format('atom ',a,t19,i1,' pol ',f12.9)
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'type',item)) then
      if(.not.inp_a(type)) call md_abort('argos_prep_input: type',9999)
      write(67,6703) (atom(1:index(atom,' ')-1),mset(i),
     + type(1:index(type,' ')-1),i=1,nset)
 6703 format('atom ',a,t19,i1,' typ ',a)
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'dummy',item)) then
      write(67,6704) (atom(1:index(atom,' ')-1),mset(i),i=1,nset)
 6704 format('atom ',a,t19,i1,' dum ')
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'self',item)) then
      write(67,6705) (atom(1:index(atom,' ')-1),mset(i),i=1,nset)
 6705 format('atom ',a,t19,i1,' ego ')
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'quantum',item)) then
      write(67,6706) (atom(1:index(atom,' ')-1),mset(i),i=1,nset)
 6706 format('atom ',a,t19,i1,' qtm ')
      nummod=nummod+1
      goto 3312
      endif
      if(inp_compare(.false.,'quantum_high',item)) then
      write(67,6717) (atom(1:index(atom,' ')-1),mset(i),i=1,nset)
 6717 format('atom ',a,t19,i1,' QTM ')
      nummod=nummod+1
      goto 3312
      else
      call md_abort('argos_prep_input: atom',9999)
      endif
c
      else if(inp_compare(.false.,'segment',item)) then
      if(.not.inp_i(isgm))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
 3313 continue
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'protonation',item)) then
      if(.not.inp_i(i)) call md_abort('argos_prep_input: modify',9999)
      write(67,6720) isgm,i
 6720 format('segment ',i5,t18,i2,' hop ')
      nummod=nummod+1
      goto 3313
      endif
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3313
      endif
      if(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3313
      endif
      if(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3313
      endif
      if(inp_compare(.false.,'dummy',item)) then
      write(67,6707) (isgm,mset(i),i=1,nset)
 6707 format('segment ',i5,t19,i1,' dum ')
      nummod=nummod+1
      goto 3313
      endif
      if(inp_compare(.false.,'self',item)) then
      write(67,6708) (isgm,mset(i),i=1,nset)
 6708 format('segment ',i5,t19,i1,' ego ')
      nummod=nummod+1
      goto 3313
      endif
      if(inp_compare(.false.,'uncharged',item)) then
      write(67,6719) (isgm,mset(i),i=1,nset)
 6719 format('segment ',i5,t19,i1,' noq ')
      nummod=nummod+1
      goto 3313
      endif
      if(inp_compare(.false.,'quantum',item)) then
      write(67,6709) (isgm,mset(i),i=1,nset)
 6709 format('segment ',i5,t19,i1,' qtm ')
      nummod=nummod+1
      goto 3313
      endif
      if(inp_compare(.false.,'quantum_high',item)) then
      write(67,6718) (isgm,mset(i),i=1,nset)
 6718 format('segment ',i5,t19,i1,' QTM ')
      nummod=nummod+1
      goto 3313
      else
      call md_abort('argos_prep_input: segment',9999)
      endif
c
      else if(inp_compare(.false.,'bond',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
 3314 continue
      if(inp_f(value)) then
      if(.not.inp_f(forcon))
     + call md_abort('argos_prep_input: modify',9999)
      write(67,6710) (mset(i),value,forcon,atomi(1:index(atomi,' ')-1),
     + atomj(1:index(atomj,' ')-1),i=1,nset)
 6710 format('bond ',i1,1x,f12.6,e12.5,1x,a,1x,a)
      nummod=nummod+1
      endif
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3314
      endif
      if(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3314
      endif
      if(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3314
      else
      call md_abort('argos_prep_input: bond',9999)
      endif
c
      else if(inp_compare(.false.,'angle',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomk))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
 3315 continue
      if(inp_f(value)) then
      if(.not.inp_f(forcon))
     + call md_abort('argos_prep_input: modify',9999)
      write(67,6711) (mset(i),value,forcon,atomi(1:index(atomi,' ')-1),
     + atomj(1:index(atomj,' ')-1),atomk(1:index(atomk,' ')-1),i=1,nset)
 6711 format('angle ',i1,1x,f12.6,e12.5,1x,a,1x,a,1x,a)
      nummod=nummod+1
      endif
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3315
      elseif(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3315
      elseif(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3315
      else
      call md_abort('argos_prep_input: angle',9999)
      endif
c
      else if(inp_compare(.false.,'torsion',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomk))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atoml))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
      multip=0
 3316 continue
      if(inp_f(value)) then
      if(.not.inp_f(forcon))
     + call md_abort('argos_prep_input: modify',9999)
      write(67,6712) (mset(i),multip,value,forcon,
     + atomi(1:index(atomi,' ')-1),atomj(1:index(atomj,' ')-1),
     + atomk(1:index(atomk,' ')-1),atoml(1:index(atoml,' ')-1),i=1,nset)
 6712 format('torsion ',i1,1x,i1,1x,f12.6,e12.5,1x,a,1x,a,1x,a,1x,a)
      nummod=nummod+1
      endif
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3316
      endif
      if(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3316
      endif
      if(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3316
      endif
      if(inp_compare(.false.,'multiplicity',item)) then
      if(.not.inp_i(multip))
     + call md_abort('argos_prep_input: multip',9999)
      if(multip.lt.0.or.multip.gt.3)
     + call md_abort('argos_prep_input: multip',9999)
      goto 3316
      else
      call md_abort('argos_prep_input: torsion',9999)
      endif
c
      else if(inp_compare(.false.,'plane',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atomk))
     + call md_abort('argos_prep_input: modify',9999)
      if(.not.inp_a(atoml))
     + call md_abort('argos_prep_input: modify',9999)
      mset(1)=0
      nset=1
 3317 continue
      if(inp_f(value)) then
      if(.not.inp_f(forcon))
     + call md_abort('argos_prep_input: modify',9999)
      write(67,6713) (mset(i),value,forcon,
     + atomi(1:index(atomi,' ')-1),atomj(1:index(atomj,' ')-1),
     + atomk(1:index(atomk,' ')-1),atoml(1:index(atoml,' ')-1),i=1,nset)
 6713 format('plane ',i1,1x,f12.6,e12.5,1x,a,1x,a,1x,a,1x,a)
      nummod=nummod+1
      endif
      if(.not.inp_a(item)) goto 1
      if(inp_compare(.false.,'set',item)) then
      if(.not.inp_i(mset(1)))
     + call md_abort('argos_prep_input: mset',9999)
      if(mset(1).lt.0.or.mset(1).gt.3)
     + call md_abort('argos_prep_input: mset',9999)
      goto 3317
      endif
      if(inp_compare(.false.,'initial',item)) then
      mset(1)=1
      mset(2)=2
      nset=2
      goto 3317
      endif
      if(inp_compare(.false.,'final',item)) then
      mset(1)=3
      nset=1
      goto 3317
      else
      call md_abort('argos_prep_input: plane',9999)
      endif
c
      elseif(inp_compare(.false.,'sequence',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: sequence',9999)
 3318 continue
      write(67,6716) item
 6716 format('sequence ',a)
      nummod=nummod+1
      if(inp_a(item)) goto 3318
      goto 1
c
      else
      call md_abort('argos_prep_input: modify',9999)
      endif
      goto 2
      endif
c
c     topology link commands
c     ----------------------
c
      if(inp_compare(.false.,'link',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: link atom 1',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: link atom 2',9999)
      i=index(atomi,':')
      if(i.le.1) call md_abort('argos_prep_input: link atom 1',9999)
      read(atomi(1:i-1),*) ires
      atomi=atomi(i+1:80)
      i=index(atomj,':')
      if(i.le.1) call md_abort('argos_prep_input: link atom 2',9999)
      read(atomj(1:i-1),*) jres
      atomj=atomj(i+1:80)
      if(atomi(1:1).eq.'_') atomi(1:1)=' '
      if(atomj(1:1).eq.'_') atomj(1:1)=' '
      write(67,6715) ires,atomi(1:4),jres,atomj(1:4)
 6715 format('link ',i5,a4,i5,a4)
      nummod=nummod+1
      nxlnk=nxlnk+1
      goto 1
      endif
c
c     update
c
      if(inp_compare(.false.,'update',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: update',9999)
c
      if(inp_compare(.false.,'lists',item)) then
      write(67,6714)
 6714 format('update')
      nummod=nummod+1
      else
      call md_abort('argos_prep_input: update',9999)
      endif
      goto 2
      endif
c
c     noe's
c     -----
c
      if(inp_compare(.false.,'noe',item)) then
      if(.not.inp_a(atomi)) call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_a(atomj)) call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_f(dnoe(1)))
     + call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_f(dnoe(2)))
     + call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_f(dnoe(3)))
     + call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_f(dnoe(4)))
     + call md_abort('argos_prep_input: noe',9999)
      if(.not.inp_f(dnoe(5)))
     + call md_abort('argos_prep_input: noe',9999)
      mnoe=mnoe+1
      write(68,6820) atomi(1:index(atomi,' ')-1),
     + atomj(1:index(atomj,' ')-1),dnoe
 6820 format('disres',1x,a,1x,a,/,3f12.6,2e12.5)
      numcmd=numcmd+1
      goto 2
      endif
c
c     repeat selections
c     -----------------
c
      if(inp_compare(.false.,'select_repeat',item)) then
      if(.not.inp_i(nrepeat)) then
      nrepeat=0
      irepeat=0
      goto 2
      endif
      if(.not.inp_i(irepeat))
     + call md_abort('argos_prep_input: sel_rep',9999)
      goto 2
      endif
c
c     select
c     ------
c
      if(inp_compare(.false.,'select',item)) then
      if(.not.inp_i(igroup))
     + call md_abort('argos_prep_input: select',9999)
      if(.not.inp_a(atomi)) call md_abort('argos_prep_input: noe',9999)
 6830 continue
      write(68,6831) igroup,atomi(1:index(atomi,' ')-1)
 6831 format('select',i5,1x,a)
      numcmd=numcmd+1
      if(nrepeat.gt.1) then
      if(index(atomi,':').gt.1) then
      n=index(atomi,':')-1
      if(n.eq.1) read(atomi(1:index(atomi,':')-1),'(i1)') k
      if(n.eq.2) read(atomi(1:index(atomi,':')-1),'(i2)') k
      if(n.eq.3) read(atomi(1:index(atomi,':')-1),'(i3)') k
      if(n.eq.4) read(atomi(1:index(atomi,':')-1),'(i4)') k
      if(n.eq.5) read(atomi(1:index(atomi,':')-1),'(i5)') k
      if(n.eq.6) read(atomi(1:index(atomi,':')-1),'(i6)') k
      do 6832 i=2,nrepeat
      j=(i-1)*irepeat-1
      write(atomj,'(i5,a,a)')
     + k+j,atomi(index(atomi,':'):index(atomi,' ')),' ;'
      write(68,6831) igroup,atomj(1:index(atomj,';')-1)
      numcmd=numcmd+1
 6832 continue
      endif
      endif
      if(.not.inp_a(atomi)) goto 1
      goto 6830
      endif
c
c     pmf
c     ---
c
      if(inp_compare(.false.,'pmf',item)) then
      mpmf=mpmf+1
      iopt=0
      jopt=0
      kopt=0
 6883 continue
      if(.not.inp_a(type)) call md_abort('argos_prep_input: pmf',9999)
      if(inp_compare(.false.,'all',type)) then
      iopt=1
      goto 6883
      endif
      if(inp_compare(.false.,'combine',type)) then
      iopt=2
      goto 6883
      endif
      if(inp_compare(.false.,'bias',type)) then
      jopt=1
      goto 6883
      endif
      if(inp_compare(.false.,'constraint',type)) then
      jopt=2
      goto 6883
      endif
      if(inp_compare(.false.,'moi',type)) then
      kopt=1
      goto 6883
      endif
      if(.not.inp_i(igroup)) call md_abort('argos_prep_input: pmf',9999)
      if(type(1:8).eq.'distance'.or.type(1:9).eq.'zdistance'.or.
     + type(1:8).eq.'basepair') then
      if(.not.inp_i(jgroup)) call md_abort('argos_prep_input: pmf',9999)
      endif
      if(type(1:5).eq.'angle') then
      if(.not.inp_i(jgroup)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_i(kgroup)) call md_abort('argos_prep_input: pmf',9999)
      endif
      if(type(1:7).eq.'torsion') then
      if(.not.inp_i(jgroup)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_i(kgroup)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_i(lgroup)) call md_abort('argos_prep_input: pmf',9999)
      endif
      if(type(1:8).eq.'improper') then
      if(.not.inp_i(jgroup)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_i(kgroup)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_i(lgroup)) call md_abort('argos_prep_input: pmf',9999)
      endif
      if(type(1:6).ne.'zalign'.and.type(1:5).ne.'zaxis'.and.
     + type(1:7).ne.'xyplane') then
      if(type(1:8).eq.'basepair') then
      if(.not.inp_f(value1)) value1=2.8d-1
      if(.not.inp_f(value2)) value2=2.8d-1
      else
      if(.not.inp_f(value1)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_f(value2)) call md_abort('argos_prep_input: pmf',9999)
      endif
      else
      value1=0.0d0
      value2=0.0d0
      endif
      if(type(1:8).eq.'basepair') then
      if(.not.inp_f(forcon)) forcon=1.0d4
      if(.not.inp_f(forc2)) forc2=1.0d4
      else
      if(.not.inp_f(forcon)) call md_abort('argos_prep_input: pmf',9999)
      if(.not.inp_f(forc2)) call md_abort('argos_prep_input: pmf',9999)
      endif
      if(type(1:6).eq.'zalign') then
      write(68,6844) iopt,jopt,kopt,igroup,forcon,forc2
 6844 format('pmf lin',4i5,15x,24x,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:5).eq.'zaxis') then
      write(68,6879) iopt,jopt,kopt,igroup,forcon,forc2
 6879 format('pmf zax',4i5,15x,24x,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:9).eq.'zaxis-cog') then
      write(68,6871) iopt,jopt,kopt,igroup,forcon,forc2
 6871 format('pmf ZAX',4i5,15x,24x,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:7).eq.'xyplane') then
      write(68,6845) iopt,jopt,kopt,igroup,forcon,forc2
 6845 format('pmf pla',4i5,15x,24x,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:8).eq.'distance') then
      write(68,6840) iopt,jopt,kopt,igroup,jgroup,
     +value1,value2,forcon,forc2
 6840 format('pmf dis',5i5,10x,2f12.6,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:9).eq.'zdistance') then
      write(68,6870) iopt,jopt,kopt,igroup,jgroup,
     +value1,value2,forcon,forc2
 6870 format('pmf zdi',5i5,10x,2f12.6,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:5).eq.'angle') then
      write(68,6842) iopt,jopt,kopt,igroup,jgroup,kgroup,
     + value1,value2,forcon,forc2
 6842 format('pmf ang',6i5,5x,2f12.6,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:7).eq.'torsion') then
      write(68,6843) iopt,jopt,kopt,igroup,jgroup,kgroup,lgroup,
     + value1,value2,forcon,forc2
 6843 format('pmf tor',7i5,2f12.6,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:8).eq.'improper') then
      write(68,6847) iopt,jopt,kopt,igroup,jgroup,kgroup,lgroup,
     + value1,value2,forcon,forc2
 6847 format('pmf imp',7i5,2f12.6,2e12.5)
      numcmd=numcmd+1
      elseif(type(1:8).eq.'basepair') then
      write(68,6858) iopt,jopt,kopt,igroup,jgroup,
     + value1,value2,forcon,forc2
 6858 format('pmf bas',5i5,10x,2f12.6,2e12.5)
      numcmd=numcmd+1
      endif
      goto 2
      endif
c
c     repeat selections and pmfs
c     --------------------------
c
      if(inp_compare(.false.,'pmf_repeat',item)) then
      if(.not.inp_i(npmfr))
     + call md_abort('argos_prep_input: pmf_repeat',9999)
      if(.not.inp_i(isarep))
     + call md_abort('argos_prep_input: pmf_repeat',9999)
      write(68,6846) npmfr,isarep
 6846 format('rep_pmf',i5,i10)
      numcmd=numcmd+1
      goto 2
      endif
c
c     touch
c     -----
c
      if(inp_compare(.false.,'touch',item)) then
      if(.not.inp_f(touch))
     + call md_abort('argos_prep_input: touch',9999)
      write(68,6801) touch
 6801 format('touch ',f12.6)
      ltouch=.true.
      numcmd=numcmd+1
      goto 2
      endif
c
c     crop
c     -----
c
      if(inp_compare(.false.,'crop',item)) then
      write(68,6876)
 6876 format('crop   ')
      numcmd=numcmd+1
      goto 2
      endif
c
c     boxsiz
c     ------
c
      if(inp_compare(.false.,'boxsize',item)) then
      write(68,6877)
 6877 format('boxsiz ')
      numcmd=numcmd+1
      goto 2
      endif
c
c     cubic
c     -----
c
      if(inp_compare(.false.,'cube',item)) then
      write(68,6875)
 6875 format('boxsiz ',/,'cubic  ')
      numcmd=numcmd+1
      goto 2
      endif
c
c     periodic
c     --------
c
      if(inp_compare(.false.,'periodic',item)) then
      write(68,6802)
 6802 format('period ')
      numcmd=numcmd+1
      goto 2
      endif
c
c     vacuum
c     ------
c
      if(inp_compare(.false.,'vacuo',item)) then
      write(68,6803)
 6803 format('vacuum ')
      numcmd=numcmd+1
      goto 2
      endif
c
c     center
c     ------
c
      if(inp_compare(.false.,'center',item)) then
      write(68,6818)
 6818 format('center ',/,'boxsiz')
      numcmd=numcmd+1
      goto 2
      endif
c
c     centerz
c     -------
c
      if(inp_compare(.false.,'centerx',item)) then
      write(68,6827)
 6827 format('centrx ',/,'boxsiz')
      numcmd=numcmd+1
      goto 2
      endif
      if(inp_compare(.false.,'centery',item)) then
      write(68,6828)
 6828 format('centry ',/,'boxsiz')
      numcmd=numcmd+1
      goto 2
      endif
      if(inp_compare(.false.,'centerz',item)) then
      write(68,6829)
 6829 format('centrz ',/,'boxsiz')
      numcmd=numcmd+1
      goto 2
      endif
c
c     collapse
c     --------
c
      if(inp_compare(.false.,'collapsexy',item)) then
      if(.not.inp_i(nmoves)) nmoves=-1
      write(68,6882) nmoves
 6882 format('collapsexy',i5)
      numcmd=numcmd+1
      goto 2
      endif
      if(inp_compare(.false.,'collapsez',item)) then
      if(.not.inp_i(nmoves)) nmoves=-1
      write(68,6881) nmoves
 6881 format('collapsez ',i5)
      numcmd=numcmd+1
      goto 2
      endif
      if(inp_compare(.false.,'collapse_group',item)) then
      if(.not.inp_i(icolgrp))
     + call md_abort('argos_prep_input collapse_group')
      if(.not.inp_i(jcolgrp))
     + call md_abort('argos_prep_input collapse_group')
      write(68,6885) icolgrp,jcolgrp
 6885 format('collapsgr ',2i5)
      numcmd=numcmd+1
      goto 2
      endif
c
c     orient
c     ------
c
      if(inp_compare(.false.,'orient',item)) then
      write(68,6819)
 6819 format('orient ',/,'boxsiz')
      numcmd=numcmd+1
      goto 2
      endif
c
c     translate
c     ---------
c
      if(inp_compare(.false.,'translate',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: translate',9999)
      if(inp_compare(.false.,'molecule',item)) then
      if(.not.inp_i(itran))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_i(jtran)) jtran=itran
      if(.not.inp_f(xtran(1)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(2)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(3)))
     + call md_abort('argos_prep_input: translate',9999)
      write(68,6852) itran,jtran,xtran
 6852 format('tramol ',2i5,3f12.6)
      numcmd=numcmd+1
      elseif(inp_compare(.false.,'segment',item)) then
      if(.not.inp_i(itran))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_i(jtran)) jtran=itran
      if(.not.inp_f(xtran(1)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(2)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(3)))
     + call md_abort('argos_prep_input: translate',9999)
      write(68,6853) itran,jtran,xtran
 6853 format('trasgm ',2i5,3f12.6)
      numcmd=numcmd+1
      elseif(inp_compare(.false.,'atom',item)) then
      if(.not.inp_i(itran))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_i(jtran)) jtran=itran
      if(.not.inp_f(xtran(1)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(2)))
     + call md_abort('argos_prep_input: translate',9999)
      if(.not.inp_f(xtran(3)))
     + call md_abort('argos_prep_input: translate',9999)
      write(68,6854) itran,jtran,xtran
 6854 format('traatm ',2i5,3f12.6)
      numcmd=numcmd+1
      else
      call md_abort('argos_prep_input: translate',9999)
      endif
      goto 2
      endif
c
c     rotate
c     ------
c
      if(inp_compare(.false.,'rotate',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: rotate',9999)
      if(inp_compare(.false.,'molecule',item)) then
      if(.not.inp_i(irot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_i(jrot)) jrot=irot
      if(.not.inp_f(arot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(1)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(2)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(3)))
     + call md_abort('argos_prep_input: rotate',9999)
      write(68,6872) irot,jrot,arot,xrot
 6872 format('rotmol ',2i5,4f12.6)
      numcmd=numcmd+1
      elseif(inp_compare(.false.,'segment',item)) then
      if(.not.inp_i(irot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_i(jrot)) jrot=irot
      if(.not.inp_f(arot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(1)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(2)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(3)))
     + call md_abort('argos_prep_input: rotate',9999)
      write(68,6873) irot,jrot,arot,xrot
 6873 format('rotsgm ',2i5,4f12.6)
      numcmd=numcmd+1
      elseif(inp_compare(.false.,'atom',item)) then
      if(.not.inp_i(irot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_i(jrot)) jrot=irot
      if(.not.inp_f(arot))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(1)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(2)))
     + call md_abort('argos_prep_input: rotate',9999)
      if(.not.inp_f(xrot(3)))
     + call md_abort('argos_prep_input: rotate',9999)
      write(68,6874) irot,jrot,arot,xrot
 6874 format('rotatm ',2i5,4f12.6)
      numcmd=numcmd+1
      else
      call md_abort('argos_prep_input: rotate',9999)
      endif
      goto 2
      endif
c
c     remove solvent
c     --------------
c
      if(inp_compare(.false.,'remove',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: remove',9999)
      if(inp_compare(.false.,'solvent',item)) then
      xrmin=0.0d0
      xrmax=0.0d0
      yrmin=0.0d0
      yrmax=0.0d0
      zrmin=0.0d0
      zrmax=0.0d0
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: remove',9999)
      j=-1
      if(inp_compare(.false.,'beyond',item)) then
      j=2
      if(.not.inp_f(xrmin)) call md_abort('argos_prep_input remove',0)
      goto 6857
      endif
      if(inp_compare(.false.,'inside',item)) j=1
      if(inp_compare(.false.,'outside',item)) j=0
      if(j.eq.-1) call md_abort('argos_prep_input: remove',9999)
      do 6855 i=1,3
      if(inp_a(item)) then
      if(inp_compare(.false.,'x',item)) then
      if(.not.inp_f(xrmin)) call md_abort('argos_prep_input remove',0)
      if(.not.inp_f(xrmax)) call md_abort('argos_prep_input remove',0)
      endif
      if(inp_compare(.false.,'y',item)) then
      if(.not.inp_f(yrmin)) call md_abort('argos_prep_input remove',0)
      if(.not.inp_f(yrmax)) call md_abort('argos_prep_input remove',0)
      endif
      if(inp_compare(.false.,'z',item)) then
      if(.not.inp_f(zrmin)) call md_abort('argos_prep_input remove',0)
      if(.not.inp_f(zrmax)) call md_abort('argos_prep_input remove',0)
      endif
      else
      goto 6857
      endif
 6855 continue
 6857 continue
      write(68,6856) xrmin,xrmax,yrmin,yrmax,zrmin,zrmax,j
 6856 format('removw ',6f12.6,i1)
      numcmd=numcmd+1
      goto 2
      endif
      endif
c
c     expand with
c     -----------
c
      if(inp_compare(.false.,'expand',item)) then
      if(.not.inp_f(xpnd(1)))
     + call md_abort('argos_prep_input: xpndw',9999)
      if(.not.inp_f(xpnd(2))) xpnd(2)=xpnd(1)
      if(.not.inp_f(xpnd(3))) xpnd(3)=xpnd(2)
      write(68,6849) xpnd
 6849 format('expand with ',3f12.6)
      numcmd=numcmd+1
      goto 2
      endif
c
c     expand-set with
c     ---------------
c
      if(inp_compare(.false.,'envelope',item)) then
      if(.not.inp_f(xpnd(1)))
     + call md_abort('argos_prep_input: xpndw',9999)
      if(.not.inp_f(xpnd(2))) xpnd(2)=xpnd(1)
      if(.not.inp_f(xpnd(3))) xpnd(3)=xpnd(2)
      goto 2
      endif
c
c     solvate
c     -------
c
      if(inp_compare(.false.,'solvate',item)) then
      if(.not.ltouch) write(68,6804) touch
 6804 format('touch ',f12.6)
      ltouch=.true.
      if(.not.lrdcoo) write(68,7804)
 7804 format('rdcoor ')
      lrdcoo=.true.
      if(.not.lslvnt) write(68,7805)
 7805 format('solvnt ')
      lslvnt=.true.
      if(inp_f(rshell)) write(68,7806) rshell
 7806 format('rshell ',f12.6)
      if(.not.inp_a(item)) then
      write(68,6805) xpnd
 6805 format('period ',/,'solvat cube ',/,
     + 'expand with ',3f12.6,/,'wr_rst')
      lwrcoo=.true.
      numcmd=numcmd+1
      goto 1
      else
      if(inp_compare(.false.,'cube',item)) then
      if(.not.inp_f(edge)) then
      write(68,6811)
 6811 format('period',/,'solvat cube')
      write(68,7807) xpnd
 7807 format('expand with ',3f12.6)
      else
      write(68,6812) edge
 6812 format('period',/,'solvat cube',f12.6)
      write(68,7807) xpnd
      endif
      elseif(inp_compare(.false.,'box',item)) then
      if(.not.inp_f(edges(1))) then
      write(68,6813)
 6813 format('period',/,'solvat box')
      write(68,7807) xpnd
      else
      if(.not.inp_f(edges(2))) edges(2)=edges(1)
      if(.not.inp_f(edges(3))) edges(3)=edges(2)
      write(68,6814) edges
 6814 format('period',/,'solvat box',3f12.6)
      write(68,7807) xpnd
      endif
      elseif(inp_compare(.false.,'troct',item)) then
      if(.not.inp_f(edge)) then
      write(68,6821)
 6821 format('period',/,'solvat troct')
      write(68,7807) xpnd
      else
      write(68,6822) edge
 6822 format('period',/,'solvat troct',f12.6)
      write(68,7807) xpnd
      endif
      elseif(inp_compare(.false.,'sphere',item)) then
      if(.not.inp_f(edge)) then
      write(68,6815)
 6815 format('vacuum',/,'solvat sphere')
      else
      write(68,6816) edge
 6816 format('vacuum',/,'solvat sphere',f12.6)
      endif
      endif
      endif
      needwt=.true.
      numcmd=numcmd+1
      goto 2
      endif
c
c     box
c     ---
c
      if(inp_compare(.false.,'box',item)) then
      if(.not.inp_f(box(1))) call md_abort('argos_prep_input: box',9999)
      if(.not.inp_f(box(2))) call md_abort('argos_prep_input: box',9999)
      if(.not.inp_f(box(3))) call md_abort('argos_prep_input: box',9999)
      write(68,8686) box
 8686 format('setbox',3f12.6)
      numcmd=numcmd+1
      goto 2
      endif
c
c     write
c     -----
c
      if(inp_compare(.false.,'write',item)) then
      irenum=0
      lrgpdb=0
      if(.not.inp_a(item)) call md_abort('argos_prep_input: write',9999)
      if(inp_compare(.false.,'large',item)) then
      lrgpdb=1
      if(.not.inp_a(item)) call md_abort('argos_prep_input: write',9999)
      endif
      if(inp_compare(.false.,'solute',item)) then
      if(.not.inp_i(nkeepw)) nkeepw=-1
      if(.not.inp_a(item)) call md_abort('argos_prep_input: write',9999)
      if(inp_compare(.false.,'renumber',item)) then
      irenum=1
      if(.not.inp_a(item)) call md_abort('argos_prep_input: write',9999)
      endif
      if(inp_compare(.false.,'pdb',item)) then
      if(.not.inp_a(item)) then
      write(68,6806) irenum,lrgpdb,nkeepw,' '
      lwrcoo=.true.
      numcmd=numcmd+1
      else
      write(68,6806) irenum,lrgpdb,nkeepw,item(1:index(item,' ')-1)
 6806 format('wr_pdb',2i1,'solute ',i10,a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(inp_compare(.false.,'xyz',item)) then
      if(.not.inp_a(item)) then
      write(68,6824) nkeepw,' '
      lwrcoo=.true.
      numcmd=numcmd+1
      else
      write(68,6824) nkeepw,item(1:index(item,' ')-1)
 6824 format('wr_xyz solute ',i10,a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(index(item,'.pdb').gt.0) then
      write(68,6806) irenum,lrgpdb,nkeepw,item(1:index(item,' ')-1)
      lwrcoo=.true.
      numcmd=numcmd+1
      elseif(index(item,'.xyz').gt.0) then
      write(68,6824) irenum,nkeepw,item(1:index(item,' ')-1)
      lwrcoo=.true.
      numcmd=numcmd+1
      else
      call md_abort('argos_prep_input: write solute',9999)
      endif
      elseif(inp_compare(.false.,'pdb',item)) then
 6839 continue
      if(.not.inp_a(item)) then
      write(68,6807) irenum,lrgpdb,' '
      lwrcoo=.true.
      numcmd=numcmd+1
      else
      write(68,6807) irenum,lrgpdb,item(1:index(item,' ')-1)
 6807 format('wr_pdb',2i1,a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(inp_compare(.false.,'rst',item)) then
      if(.not.inp_a(item)) then
      write(68,6808) ' '
      else
      write(68,6808) item(1:index(item,' ')-1)
 6808 format('wr_rst ',a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(inp_compare(.false.,'rst_old',item)) then
      if(.not.inp_a(item)) then
      write(68,6808) ' '
      else
      write(68,6848) item(1:index(item,' ')-1)
 6848 format('wr_old ',a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(inp_compare(.false.,'xyz',item)) then
      if(.not.inp_a(item)) then
      write(68,6823) ' '
      else
      write(68,6823) item(1:index(item,' ')-1)
 6823 format('wr_xyz ',a)
      lwrcoo=.true.
      numcmd=numcmd+1
      endif
      elseif(index(item,'.pdb').gt.0) then
      write(68,6807) irenum,lrgpdb,item(1:index(item,' ')-1)
      lwrcoo=.true.
      numcmd=numcmd+1
      elseif(index(item,'.rst').gt.0) then
      write(68,6808) item(1:index(item,' ')-1)
      lwrcoo=.true.
      numcmd=numcmd+1
      elseif(index(item,'.rst_old').gt.0) then
      write(68,6848) item(1:index(item,'.rst_old')+3)
      lwrcoo=.true.
      numcmd=numcmd+1
      elseif(index(item,'.xyz').gt.0) then
      write(68,6823) item(1:index(item,' ')-1)
      lwrcoo=.true.
      numcmd=numcmd+1
      elseif(index(item,'.pov').gt.0) then
      write(68,6826) item(1:index(item,' ')-1)
 6826 format('wr_pov ',a)
      lwrcoo=.true.
      numcmd=numcmd+1
      else
      call md_abort('Problem with write file',0)
      endif
      needwt=.false.
      numcmd=numcmd+1
      goto 2
      endif
c
c     read
c     ----
c
      if(inp_compare(.false.,'read',item)) then
      if(.not.inp_a(item)) then
      write(68,6817)
 6817 format('rdcoor')
      else
      if(inp_compare(.false.,'pdb',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: read',9999)
      if(numcmd.eq.0) rewind(68)
      write(68,6809) item(1:index(item,' ')-1)
 6809 format('rd_pdb ',a)
      lrdcoo=.true.
      elseif(inp_compare(.false.,'rst',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: read',9999)
      if(numcmd.eq.0) rewind(68)
      write(68,6810) item(1:index(item,' ')-1)
 6810 format('rd_rst ',a)
      lrdcoo=.true.
      elseif(inp_compare(.false.,'rst_old',item)) then
      if(.not.inp_a(item)) call md_abort('argos_prep_input: read',9999)
      if(numcmd.eq.0) rewind(68)
      write(68,6825) item(1:index(item,' ')-1)
 6825 format('rd_old ',a)
      lrdcoo=.true.
      elseif(index(item,'.pdb').gt.0) then
      if(numcmd.eq.0) rewind(68)
      write(68,6809) item(1:index(item,' ')-1)
      lrdcoo=.true.
      elseif(index(item,'.rst').gt.0) then
      if(numcmd.eq.0) rewind(68)
      write(68,6810) item(1:index(item,' ')-1)
      lrdcoo=.true.
      elseif(index(item,'.qrs').gt.0) then
      if(numcmd.eq.0) rewind(68)
      write(68,6810) item(1:index(item,' ')-1)
      lrdcoo=.true.
      elseif(index(item,'.rst_old').gt.0) then
      if(numcmd.eq.0) rewind(68)
      write(68,6825) item(1:index(item,'.rst_old')+3)
      lrdcoo=.true.
      endif
      endif
      numcmd=numcmd+1
      goto 2
      endif
c
c     align
c     -----
c
      if(inp_compare(.false.,'align',item)) then
      if(.not.inp_a(atomi))
     + call md_abort('argos_prep_input: align',9999)
      if(.not.inp_a(atomj))
     + call md_abort('argos_prep_input: align',9999)
      if(.not.inp_a(atomk))
     + call md_abort('argos_prep_input: align',9999)
      i=index(atomi,':')
      if(i.le.1) call md_abort('argos_prep_input: align atom 1',9999)
      read(atomi(1:i-1),*) ires
      atomi=atomi(i+1:80)
      i=index(atomj,':')
      if(i.le.1) call md_abort('argos_prep_input: align atom 2',9999)
      read(atomj(1:i-1),*) jres
      atomj=atomj(i+1:80)
      i=index(atomk,':')
      if(i.le.1) call md_abort('argos_prep_input: align atom 3',9999)
      read(atomk(1:i-1),*) kres
      atomk=atomk(i+1:80)
      if(atomi(1:1).eq.'_') atomi(1:1)=' '
      if(atomj(1:1).eq.'_') atomj(1:1)=' '
      if(atomk(1:1).eq.'_') atomk(1:1)=' '
      write(68,6850) ires,atomi(1:4),jres,atomj(1:4),kres,atomk(1:4)
 6850 format('align  ',i5,a4,i5,a4,i5,a4)
      numcmd=numcmd+1
      goto 1
      endif
c
c     repeat
c     ------
c
      if(inp_compare(.false.,'repeat',item)) then
      iopt=0
      irrand=0
      invert=0
      irrep=0
 6838 continue
      if(.not.inp_i(nxrep)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: repeat 1',9999)
      if(inp_compare(.false.,'random',item)) then
      irrand=4
      goto 6838
      endif
      if(inp_compare(.false.,'randomx',item)) then
      irrand=1
      goto 6838
      endif
      if(inp_compare(.false.,'randomy',item)) then
      irrand=2
      goto 6838
      endif
      if(inp_compare(.false.,'randomz',item)) then
      irrand=3
      goto 6838
      endif
      if(inp_compare(.false.,'invert',item)) then
      invert=1
      goto 6838
      endif
      if(inp_compare(.false.,'rest',item)) then
      irrep=1
      goto 6838
      endif
      if(inp_compare(.false.,'chains',item)) iopt=1
      if(inp_compare(.false.,'molecules',item)) iopt=2
      if(inp_compare(.false.,'fractions',item)) iopt=3
      if(.not.inp_i(nxrep))
     + call md_abort('argos_prep_input: repeat 2',9999)
      endif
      if(.not.inp_i(nyrep))
     + call md_abort('argos_prep_input: repeat 3',9999)
      if(.not.inp_i(nzrep))
     + call md_abort('argos_prep_input: repeat 4',9999)
      if(.not.inp_f(rrep)) then
      endif
      if(.not.inp_f(rdist)) then
      endif
      if(nxrep.lt.0) call md_abort('argos_prep_input: repeat 5',9999)
      if(nyrep.lt.0) call md_abort('argos_prep_input: repeat 6',9999)
      if(nzrep.lt.-2) call md_abort('argos_prep_input: repeat 7',9999)
      write(68,6851) nxrep,nyrep,nzrep,rrep,rdist,iopt,irrand,invert,
     + irrep
 6851 format('repeat ',3i5,2f12.6,4i5)
      numcmd=numcmd+1
      goto 1
      endif
c
c     skip
c     ----
c
      if(inp_compare(.false.,'skip',item)) then
      if(.not.inp_i(iskip)) call md_abort('argos_prep_input: skip',9999)
      if(.not.inp_i(jskip)) call md_abort('argos_prep_input: skip',9999)
      if(.not.inp_i(kskip)) call md_abort('argos_prep_input: skip',9999)
      write(68,6859) iskip,jskip,kskip
 6859 format('skip   ',3i5)
      numcmd=numcmd+1
      goto 1
      endif
c
c     merge pdb file
c     --------------
c
      if(inp_compare(.false.,'merge',item)) then
      xmerge(1)=0.0d0
      xmerge(2)=0.0d0
      xmerge(3)=0.0d0
      if(.not.inp_f(xmerge(1))) goto 6884
      if(.not.inp_f(xmerge(2))) goto 6884
      if(.not.inp_f(xmerge(3))) goto 6884
 6884 continue
      if(.not.inp_a(item)) call md_abort('argos_prep_input: merge',9999)
      xmerge(1)=1.0d1*xmerge(1)
      xmerge(2)=1.0d1*xmerge(2)
      xmerge(3)=1.0d1*xmerge(3)
      write(68,6869) xmerge,item(1:index(item,' ')-1)
 6869 format('merge ',3f8.3,a)
      numcmd=numcmd+1
      goto 1
      endif
c
c     maintenance directives
c     ----------------------
c
      if(inp_compare(.false.,'master',item)) then
      if(.not.inp_a(item))
     + call md_abort('argos_prep_input: master',9999)
      write(68,6880) item(1:index(item,' ')-1)
 6880 format('master ',a)
      numcmd=numcmd+1
      goto 1
      endif
c
c
      write(6,1000) item
 1000 format('argos_prep_input: unknown field ',a)
      call md_abort('argos_prep_input: error reading input file',0)
c
c     end
c     ---
c
    9 continue
c
c     put on rtdb
c     -----------
c
      if(.not.rtdb_cput(irtdb,'prep:title',6,title))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(ffield(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:ffield',1,ffield))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      do 316 i=1,9
      if(dirs(i)(1:1).ne.' ') then
      write(string,'(a,i1)') 'prep:dir_',i
      if(.not.rtdb_cput(irtdb,string,1,dirs(i)))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
  316 continue
c
      if(sysnam(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:sysnam',1,sysnam))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(source(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:source',1,source))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(altloc(1:1).ne.'A') then
      if(.not.rtdb_cput(irtdb,'prep:altloc',1,altloc))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(chain(1:1).ne.'A') then
      if(.not.rtdb_cput(irtdb,'prep:chain',1,chain))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(his(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:his',1,his))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(model.ne.0) then
      if(.not.rtdb_put(irtdb,'prep:model',mt_int,1,model))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(slvnam(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:slvnam',1,slvnam))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
      if(slvmdl(1:1).ne.' ') then
      if(.not.rtdb_cput(irtdb,'prep:slvmdl',1,slvmdl))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(.not.rtdb_put(irtdb,'prep:newtop',mt_int,1,newtop))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:newseq',mt_int,1,newseq))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:newrst',mt_int,1,newrst))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(.not.rtdb_put(irtdb,'prep:nfract',mt_int,1,nfract))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(nfract.gt.0) then
      if(.not.rtdb_put(irtdb,'prep:ifract',mt_int,nfract,ifract))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
c
      if(.not.rtdb_put(irtdb,'prep:iconst',mt_int,1,iconst))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:icyren',mt_int,1,icyren))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:ncount',mt_int,1,ncount))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(ncount.gt.0) then
      if(.not.rtdb_put(irtdb,'prep:icount',mt_int,ncount,icount))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_cput(irtdb,'prep:scount',ncount,scount))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
      if(.not.rtdb_put(irtdb,'prep:fcount',mt_dbl,1,fcount))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(mgrid.gt.0) then
      if(.not.rtdb_put(irtdb,'prep:mgrid',mt_int,1,mgrid))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:rgrid',mt_dbl,1,rgrid))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:nrgrid',mt_int,1,nrgrid))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(nrgrid.gt.0) then
      if(.not.rtdb_put(irtdb,'prep:iogrid',mt_int,nrgrid,iogrid))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:rogrid',mt_int,2*nrgrid,rogrid))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
      endif
c
      if(.not.rtdb_put(irtdb,'prep:itopol',mt_int,1,itopol))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(.not.rtdb_put(irtdb,'prep:ignore',mt_int,1,ignore))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(.not.rtdb_put(irtdb,'prep:icomb',mt_int,1,icomb))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(maxscf.ge.0) then
      if(.not.rtdb_put(irtdb,'prep:maxscf',mt_int,1,maxscf))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
      if(qscale.gt.0.0d0) then
      if(.not.rtdb_put(irtdb,'prep:qscale',mt_dbl,1,qscale))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      endif
      if(.not.rtdb_put(irtdb,'prep:scale',mt_dbl,1,scale))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:cpk',mt_dbl,1,cpk))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(.not.rtdb_put(irtdb,'prep:mnoe',mt_int,1,mnoe))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:mpmf',mt_int,1,mpmf))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
      if(.not.rtdb_put(irtdb,'prep:nxlnk',mt_int,1,nxlnk))
     + call md_abort('argos_prep_input: rtdb_put failed',0)
c
      if(nummod.gt.0) then
      close(unit=67)
      else
      close(unit=67,status='delete')
      endif
c
      if(numcmd.gt.0) then
      if(.not.lwrcoo) then
      write(68,7809)
 7809 format('wr_rst')
      endif
      close(unit=68)
      else
      close(unit=68,status='delete')
      endif
c
      return
c
 9999 continue
      call md_abort('argos_prep_input failed',9999)
      return
      end
