// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_MakePolygon_HeaderFile
#define _BRepLib_MakePolygon_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Vertex.hxx>
#include <TopoDS_Edge.hxx>
#include <BRepLib_MakeShape.hxx>
#include <Standard_Boolean.hxx>
class StdFail_NotDone;
class gp_Pnt;
class TopoDS_Vertex;
class TopoDS_Edge;
class TopoDS_Wire;


//! Class to build polygonal wires.
//!
//! A polygonal wire may be build from
//!
//! - 2,4,3 points.
//!
//! - 2,3,4 vertices.
//!
//! - any number of points.
//!
//! - any number of vertices.
//!
//! When a point or vertex is added to the  polygon if
//! it is identic  to the previous  point no  edge  is
//! built. The method added can be used to test it.
class BRepLib_MakePolygon  : public BRepLib_MakeShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates an empty MakePolygon.
  Standard_EXPORT BRepLib_MakePolygon();
  
  Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1, const gp_Pnt& P2);
  
  Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1, const gp_Pnt& P2, const gp_Pnt& P3, const Standard_Boolean Close = Standard_False);
  
  Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1, const gp_Pnt& P2, const gp_Pnt& P3, const gp_Pnt& P4, const Standard_Boolean Close = Standard_False);
  
  Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1, const TopoDS_Vertex& V2);
  
  Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1, const TopoDS_Vertex& V2, const TopoDS_Vertex& V3, const Standard_Boolean Close = Standard_False);
  
  Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1, const TopoDS_Vertex& V2, const TopoDS_Vertex& V3, const TopoDS_Vertex& V4, const Standard_Boolean Close = Standard_False);
  
  Standard_EXPORT   void Add (const gp_Pnt& P) ;
  
  Standard_EXPORT   void Add (const TopoDS_Vertex& V) ;
  
  //! Returns  True if  the last   vertex  or point  was
  //! succesfully added.
  Standard_EXPORT   Standard_Boolean Added()  const;
  
  Standard_EXPORT   void Close() ;
  
  Standard_EXPORT  const  TopoDS_Vertex& FirstVertex()  const;
  
  Standard_EXPORT  const  TopoDS_Vertex& LastVertex()  const;
  
  //! Returns the last edge added to the polygon.
  Standard_EXPORT  const  TopoDS_Edge& Edge()  const;
Standard_EXPORT operator TopoDS_Edge() const;
  
  Standard_EXPORT  const  TopoDS_Wire& Wire()  const;
Standard_EXPORT operator TopoDS_Wire() const;




protected:





private:



  TopoDS_Vertex myFirstVertex;
  TopoDS_Vertex myLastVertex;
  TopoDS_Edge myEdge;


};







#endif // _BRepLib_MakePolygon_HeaderFile
