-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2025 Equinor

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 23 Jan 07  14:20
--           Input File : Z:\res\sim\ior\linn\gap\PB1.PIPE.OUT
--          Output File : Z:\res\INCLUDE\VFP\PB1.PIPE.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : 
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : PipeLine Only
--
--           Completion : 
--          Gravel Pack : 
--
--          Inflow Type : 
--           Gas Coning : 
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : B-2H
--             Platform : Treasure Prospect
--              Analyst : amoe
--                 Date : 05 Feb 02  12:50
--
--
--
--  Surface Equipment Correlation :  Beggs and Brill - (0.936) (0.957)
--      Vertical Lift Correlation :  Petroleum Experts 2
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1             Manifold          0 (m)
--                      Last Node :    4            Xmas Tree        394 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      3           394       'LIQ'      'WCT'      'GOR'            /


-- 'LIQ' units - SM3/DAY
  100.0   500.0  1000.0  1500.0  2500.0 
 4000.0  6000.0  8000.0 10000.0 12000.0 
15000.0 20000.0 /

-- 'THP' units - BARSA
  16.01   21.01   26.01   31.01   41.01 
  51.01   61.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.5 
    0.7    0.75     0.9       1 /

-- 'GOR' units - SM3/SM3
     90     100     150     200     500 
    700    1000    5000   10000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1   47.14   44.56   31.10   28.82   30.55 
              35.75   44.98   55.79   67.65   80.29 
             100.36  137.38 
/
 1  1  2  1   47.14   44.33   29.54   28.29   30.41 
              36.14   46.13   57.67   70.20   83.53 
             104.60  143.26 
/
 1  1  3  1   47.14   43.30   26.26   26.88   30.71 
              38.96   52.29   66.99   82.58   98.89 
             124.52  170.77 
/
 1  1  4  1   47.14   42.41   25.22   26.59   31.88 
              42.39   58.55   75.99   94.22  113.11 
             142.76  196.13 
/
 1  1  5  1   46.92   35.84   25.39   30.54   43.13 
              64.40   94.05  124.38  155.54  187.79 
             238.91  333.84 
/
 1  1  6  1   45.47   30.97   27.35   34.58   51.66 
              79.01  116.17  154.11  193.33  234.39 
             300.47  426.28 
/
 1  1  7  1   41.90   26.95   30.95   41.65   64.77 
             100.28  148.16  197.48  249.40  304.79 
             395.90  574.70 
/
 1  1  8  1   26.15   51.81   97.49  142.74  234.71 
             388.47  634.87  935.67 1289.03 1701.55 
            2423.56 3904.41 
/
 1  1  9  1   25.33   94.14  181.04  271.22  477.66 
             873.43 1549.58 2421.27 3488.89 4762.59 
            7124.18 12276.57 
/
 1  2  1  1   47.73   45.27   32.87   29.54   30.99 
              35.81   44.53   54.88   66.34   78.66 
              98.27  134.79 
/
 1  2  2  1   47.73   45.05   31.15   28.97   30.77 
              36.09   45.52   56.57   68.69   81.63 
             102.21  140.25 
/
 1  2  3  1   47.73   44.06   26.86   27.29   30.72 
              38.38   50.99   65.05   80.06   95.84 
             120.71  165.84 
/
 1  2  4  1   47.73   43.21   25.67   26.77   31.59 
              41.37   56.67   73.32   90.82  109.04 
             137.69  189.37 
/
 1  2  5  1   47.68   37.59   25.15   29.79   41.38 
              61.23   89.16  117.86  147.32  177.84 
             226.06  315.11 
/
 1  2  6  1   46.66   32.66   26.73   33.28   48.94 
              74.47  109.38  145.00  181.80  220.17 
             281.63  397.60 
/
 1  2  7  1   43.78   28.27   29.80   39.40   60.76 
              93.82  138.50  184.39  232.42  283.36 
             366.63  528.70 
/
 1  2  8  1   26.64   47.73   89.27  130.53  213.51 
             349.94  564.74  824.13 1137.43 1479.33 
            2095.76 3348.11 
/
 1  2  9  1   24.04   85.79  164.48  244.95  425.36 
             761.72 1340.46 2075.69 2973.92 4024.85 
            5963.28 10191.11 
/
 1  3  1  1   48.32   46.00   34.79   30.41   31.55 
              35.96   44.13   53.98   65.01   76.92 
              96.06  132.02 
/
 1  3  2  1   48.32   45.79   33.16   29.77   31.24 
              36.12   44.95   55.46   67.11   79.66 
              99.68  137.04 
/
 1  3  3  1   48.32   44.86   27.70   27.83   30.82 
              37.86   49.68   63.04   77.43   92.64 
             116.71  160.61 
/
 1  3  4  1   48.32   44.06   26.23   27.06   31.37 
              40.38   54.75   70.55   87.27  104.77 
             132.35  182.26 
/
 1  3  5  1   48.33   39.27   24.98   29.09   39.62 
              58.01   84.15  111.14  138.90  167.64 
             212.95  296.23 
/
 1  3  6  1   47.75   34.75   26.17   32.06   46.26 
              69.85  102.44  135.73  170.07  205.77 
             262.71  369.32 
/
 1  3  7  1   45.56   29.83   28.73   37.19   56.73 
              87.30  128.73  171.19  215.39  262.03 
             337.70  483.36 
/
 1  3  8  1   27.33   43.68   81.03  118.26  192.64 
             312.48  498.25  718.75  977.65 1272.73 
            1790.44 2839.41 
/
 1  3  9  1   22.84   77.42  147.99  219.22  375.34 
             660.55 1146.10 1755.46 2492.34 3360.07 
            4918.17 8315.11 
/
 1  4  1  1   48.92   46.75   36.74   31.45   32.25 
              36.24   43.81   53.11   63.65   75.11 
              93.73  129.08 
/
 1  4  2  1   48.92   46.56   35.34   30.76   31.86 
              36.27   44.45   54.37   65.50   77.57 
              96.99  133.62 
/
 1  4  3  1   48.92   45.70   29.20   28.54   31.05 
              37.42   48.39   61.00   74.70   89.27 
             112.46  155.04 
/
 1  4  4  1   48.92   44.94   26.95   27.50   31.25 
              39.43   52.80   67.66   83.56  100.25 
             126.70  174.70 
/
 1  4  5  1   48.92   40.91   24.93   28.47   37.93 
              54.73   78.99  104.20  130.20  157.11 
             199.50  277.05 
/
 1  4  6  1   48.71   37.17   25.69   30.90   43.61 
              65.18   95.29  126.22  158.08  191.12 
             243.61  341.15 
/
 1  4  7  1   47.17   31.77   27.75   35.16   52.66 
              80.64  118.78  157.79  198.25  240.64 
             309.13  439.21 
/
 1  4  8  1   28.28   39.70   72.75  105.94  171.99 
             276.07  434.64  619.75  835.52 1090.88 
            1507.36 2370.47 
/
 1  4  9  1   21.71   69.03  131.52  193.94  327.50 
             565.87  972.72 1460.91 2057.08 2752.27 
            3988.01 6646.53 
/
 1  5  1  1   50.13   48.33   40.79   34.22   34.29 
              37.37   43.61   51.64   61.02   71.36 
              88.83  122.35 
/
 1  5  2  1   50.13   48.18   39.79   33.44   33.73 
              37.13   43.86   52.40   62.28   73.14 
              91.19  126.08 
/
 1  5  3  1   50.13   47.48   34.66   30.69   32.10 
              37.02   46.02   56.83   68.91   82.02 
             103.09  142.73 
/
 1  5  4  1   50.13   46.85   30.13   29.12   31.55 
              37.89   48.90   61.65   75.57   90.46 
             114.25  158.18 
/
 1  5  5  1   50.13   44.00   25.35   27.62   34.73 
              48.08   68.13   89.43  111.61  134.65 
             171.03  237.13 
/
 1  5  6  1   50.13   41.78   25.18   28.81   38.48 
              55.64   80.44  106.28  132.95  160.62 
             204.30  284.41 
/
 1  5  7  1   49.85   37.59   26.02   31.45   44.64 
              66.91   98.02  130.00  163.01  197.33 
             251.97  353.69 
/
 1  5  8  1   31.34   32.02   56.13   81.07  130.84 
             206.59  315.94  440.16  580.32  738.35 
            1009.24 1550.47 
/
 1  5  9  1   26.95   52.30   98.45  144.21  237.54 
             393.82  644.29  948.49 1306.04 1719.07 
            2442.88 3926.05 
/
 1  6  1  1   51.35   50.01   45.09   38.39   37.96 
              39.83   44.58   51.03   58.77   68.25 
              84.22  113.65 
/
 1  6  2  1   51.35   49.91   44.49   37.64   37.27 
              39.37   44.44   51.26   59.45   68.98 
              85.59  116.62 
/
 1  6  3  1   51.35   49.43   41.39   34.63   34.75 
              37.99   44.60   53.08   63.02   74.02 
              92.54  128.46 
/
 1  6  4  1   51.35   48.99   38.29   32.57   33.34 
              37.57   45.62   55.59   66.97   79.49 
              99.87  138.88 
/
 1  6  5  1   51.35   46.82   27.28   28.05   32.36 
              41.60   56.48   73.02   90.68  109.29 
             138.92  192.95 
/
 1  6  6  1   51.35   45.70   26.04   27.74   33.90 
              45.91   64.33   84.21  105.09  126.89 
             161.37  224.26 
/
 1  6  7  1   51.35   43.86   25.44   28.46   37.10 
              52.73   75.75   99.99  125.14  151.26 
             192.60  268.23 
/
 1  6  8  1   38.14   25.47   39.68   55.84   89.11 
             139.27  208.06  281.47  361.59  449.64 
             597.91  888.61 
/
 1  6  9  1   30.08   36.08   64.99   94.35  152.76 
             243.34  378.43  533.64  711.71  913.47 
            1260.77 1957.90 
/
 1  7  1  1   51.66   50.44   46.18   39.75   39.25 
              40.79   45.14   50.98   58.42   67.98 
              83.29  110.97 
/
 1  7  2  1   51.66   50.36   45.68   39.04   38.58 
              40.30   44.92   51.25   58.80   68.47 
              84.31  113.66 
/
 1  7  3  1   51.66   49.95   43.13   36.11   35.97 
              38.67   44.61   52.40   61.67   72.00 
              89.86  124.57 
/
 1  7  4  1   51.66   49.56   40.53   33.99   34.31 
              37.93   45.12   54.24   64.82   76.53 
              95.90  133.50 
/
 1  7  5  1   51.66   47.63   28.33   28.71   32.14 
              40.16   53.52   68.61   84.91  102.23 
             129.94  180.60 
/
 1  7  6  1   51.66   46.61   26.73   27.88   33.03 
              43.55   60.08   78.21   97.42  117.58 
             149.58  207.95 
/
 1  7  7  1   51.66   45.25   25.73   28.03   35.37 
              49.13   69.81   91.84  114.85  138.79 
             176.70  245.88 
/
 1  7  8  1   41.19   25.25   35.75   49.54   78.41 
             122.27  181.95  244.64  312.10  385.32 
             507.44  746.35 
/
 1  7  9  1   31.74   32.22   56.55   81.70  131.93 
             208.50  319.33  445.61  587.17  746.81 
            1019.40 1564.78 
/
 1  8  1  1   52.59   51.78   49.63   45.54   45.13 
              46.12   49.70   53.76   59.83   67.08 
              78.07  100.70 
/
 1  8  2  1   52.59   51.74   49.38   44.91   44.49 
              45.49   48.37   53.21   59.83   67.46 
              78.88  102.12 
/
 1  8  3  1   52.59   51.56   48.29   42.56   42.03 
              43.02   46.92   51.24   59.26   68.35 
              82.65  109.00 
/
 1  8  4  1   52.59   51.40   47.31   40.94   40.42 
              41.67   46.01   51.93   59.65   69.39 
              84.93  114.82 
/
 1  8  5  1   52.59   50.44   41.14   34.55   34.84 
              38.41   45.89   55.37   66.38   78.63 
              98.81  138.08 
/
 1  8  6  1   52.59   49.86   36.88   32.22   33.28 
              38.30   47.65   59.02   71.84   85.85 
             108.62  151.77 
/
 1  8  7  1   52.59   49.08   31.18   30.15   32.48 
              39.32   51.18   64.94   80.03   96.25 
             122.42  170.74 
/
 1  8  8  1   51.86   38.08   26.59   32.16   45.82 
              68.91  101.19  134.52  169.06  205.07 
             262.61  369.78 
/
 1  8  9  1   44.66   28.45   32.19   43.52   67.96 
             105.60  156.71  209.76  266.00  326.31 
             425.50  616.96 
/
 1  9  1  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  2  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  3  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  4  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  5  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  6  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  7  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  8  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 1  9  9  1   53.22   52.83   52.70   52.73   53.06 
              54.00   56.00   58.82   62.44   66.87 
              75.01   92.61 
/
 2  1  1  1   52.09   49.87   39.35   35.16   36.31 
              40.73   49.02   59.09   70.40   82.64 
             102.22  138.80 
/
 2  1  2  1   52.09   49.67   37.86   34.55   36.04 
              40.94   49.95   60.75   72.76   85.69 
             106.32  144.54 
/
 2  1  3  1   52.09   48.74   32.51   32.72   35.75 
              42.97   55.28   69.31   84.41  100.39 
             125.66  171.58 
/
 2  1  4  1   52.10   47.93   31.18   32.02   36.43 
              45.81   61.01   77.80   95.62  114.24 
             143.61  196.61 
/
 2  1  5  1   52.10   43.42   30.17   34.53   45.94 
              66.12   95.07  125.05  155.97  188.05 
             239.04  333.78 
/
 2  1  6  1   51.68   38.95   31.58   38.00   53.68 
              80.17  116.82  154.49  193.52  234.44 
             300.44  426.08 
/
 2  1  7  1   49.46   34.56   34.64   44.07   66.19 
             101.05  148.54  197.66  249.44  304.73 
             395.72  574.86 
/
 2  1  8  1   32.27   53.50   98.21  143.11  234.79 
             388.34  635.14  935.82 1287.45 1713.69 
            2421.53 3895.67 
/
 2  1  9  1   28.98   94.89  181.26  271.26  477.49 
             869.86 1558.28 2420.44 3478.40 4748.53 
            7124.31 12276.68 
/
 2  2  1  1   52.69   50.56   40.82   35.96   36.86 
              40.96   48.77   58.39   69.29   81.16 
             100.32  136.36 
/
 2  2  2  1   52.69   50.36   39.47   35.31   36.52 
              41.06   49.54   59.86   71.43   83.98 
             104.08  141.66 
/
 2  2  3  1   52.69   49.48   33.56   33.26   35.92 
              42.60   54.18   67.56   82.07   97.49 
             122.00  166.75 
/
 2  2  4  1   52.69   48.71   31.72   32.36   36.31 
              45.00   59.33   75.30   92.37  110.29 
             138.64  189.93 
/
 2  2  5  1   52.69   44.78   30.10   33.96   44.40 
              63.11   90.31  118.63  147.86  178.17 
             226.24  315.10 
/
 2  2  6  1   52.53   40.88   31.13   36.91   51.23 
              75.76  110.13  145.48  182.05  220.32 
             281.64  397.44 
/
 2  2  7  1   50.94   35.96   33.68   42.13   62.35 
              94.72  138.98  184.60  232.50  283.34 
             366.49  528.40 
/
 2  2  8  1   32.96   49.60   90.10  130.92  213.61 
             349.85  564.81  824.82 1127.24 1488.64 
            2093.69 3345.15 
/
 2  2  9  1   27.81   86.65  164.76  245.02  425.23 
             762.26 1346.70 2074.82 2965.42 4013.49 
            5963.45 10191.26 
/
 2  3  1  1   53.29   51.27   42.35   36.89   37.53 
              41.29   48.58   57.72   68.18   79.63 
              98.31  133.78 
/
 2  3  2  1   53.29   51.09   41.14   36.20   37.12 
              41.28   49.20   58.98   70.08   82.19 
             101.75  138.63 
/
 2  3  3  1   53.29   50.26   35.16   33.93   36.20 
              42.30   53.11   65.77   79.66   94.48 
             118.14  161.64 
/
 2  3  4  1   53.29   49.53   32.40   32.82   36.29 
              44.24   57.61   72.73   89.00  106.16 
             133.41  182.94 
/
 2  3  5  1   53.29   46.07   30.12   33.47   42.90 
              60.10   85.45  112.03  139.54  168.05 
             213.20  296.27 
/
 2  3  6  1   53.29   42.88   30.76   35.86   48.80 
              71.33  103.30  136.30  170.40  205.98 
             262.78  369.21 
/
 2  3  7  1   52.26   37.71   32.78   40.29   58.49 
              88.30  129.29  171.46  215.53  262.06 
             337.60  483.10 
/
 2  3  8  1   33.86   45.78   81.98  118.79  192.81 
             312.42  497.94  719.25  977.45 1270.63 
            1800.10 2836.38 
/
 2  3  9  1   30.25   78.41  148.34  219.34  375.24 
             660.74 1145.40 1754.58 2491.03 3351.29 
            4905.65 8315.31 
/
 2  4  1  1   53.89   52.00   43.95   37.98   38.34 
              41.74   48.50   57.11   67.09   78.06 
              96.20  131.05 
/
 2  4  2  1   53.89   51.83   42.87   37.25   37.87 
              41.63   48.95   58.15   68.72   80.33 
              99.28  135.42 
/
 2  4  3  1   53.89   51.07   37.37   34.76   36.60 
              42.11   52.09   63.97   77.15   91.32 
             114.07  156.25 
/
 2  4  4  1   53.89   50.39   33.44   33.44   36.39 
              43.57   55.91   70.10   85.50  101.85 
             127.92  175.57 
/
 2  4  5  1   53.89   47.30   30.26   33.07   41.43 
              57.07   80.47  105.23  130.95  157.63 
             199.78  277.17 
/
 2  4  6  1   53.89   44.81   30.49   34.90   46.45 
              66.90   96.34  126.90  158.50  191.37 
             243.73  341.09 
/
 2  4  7  1   53.42   39.92   31.97   38.58   54.66 
              81.80  119.41  158.16  198.42  240.72 
             309.08  439.00 
/
 2  4  8  1   35.01   42.07   73.87  106.58  172.15 
             276.06  434.44  620.08  835.71 1080.03 
            1504.19 2367.42 
/
 2  4  9  1   31.99   70.19  131.96  194.12  327.44 
             565.57  965.75 1469.52 2055.72 2750.47 
            3978.62 6646.78 
/
 2  5  1  1   55.10   53.53   47.37   40.78   40.61 
              43.20   48.80   56.21   65.06   74.93 
              92.10  124.75 
/
 2  5  2  1   55.10   53.40   46.54   40.00   39.98 
              42.87   48.91   56.80   66.14   76.52 
              94.17  128.41 
/
 2  5  3  1   55.10   52.78   42.56   37.15   38.03 
              42.26   50.37   60.45   71.98   84.66 
             105.24  144.41 
/
 2  5  4  1   55.10   52.23   38.49   35.39   37.16 
              42.66   52.68   64.70   78.10   92.60 
             115.95  159.43 
/
 2  5  5  1   55.10   49.66   31.10   32.74   38.84 
              51.07   70.13   90.88  112.71  135.51 
             171.59  237.45 
/
 2  5  6  1   55.10   48.26   30.52   33.41   41.97 
              57.97   81.91  107.29  133.69  161.13 
             204.57  284.51 
/
 2  5  7  1   55.10   45.43   30.79   35.41   47.40 
              68.60   99.03  130.65  163.41  197.56 
             252.08  353.61 
/
 2  5  8  1   38.69   34.96   57.66   82.02  131.24 
             206.72  315.85  439.94  580.60  738.93 
            1009.07 1546.86 
/
 2  5  9  1   33.19   53.98   99.16  144.57  237.61 
             393.67  644.64  948.50 1304.00 1729.47 
            2440.26 3919.10 
/
 2  6  1  1   56.34   55.13   50.99   44.74   44.27 
              45.85   50.19   56.19   63.59   73.06 
              88.46  116.73 
/
 2  6  2  1   56.34   55.05   50.50   44.04   43.61 
              45.38   49.99   56.33   64.00   73.60 
              89.55  119.59 
/
 2  6  3  1   56.34   54.64   48.02   41.18   41.05 
              43.79   49.75   57.62   67.03   77.56 
              95.69  131.00 
/
 2  6  4  1   56.34   54.26   45.54   39.11   39.45 
              43.09   50.35   59.63   70.45   82.51 
             102.39  140.91 
/
 2  6  5  1   56.34   52.33   33.57   33.93   37.39 
              45.57   59.45   75.30   92.48  110.77 
             140.05  193.65 
/
 2  6  6  1   56.34   51.32   31.99   33.12   38.34 
              49.22   66.66   85.91  106.40  127.93 
             162.14  224.64 
/
 2  6  7  1   56.34   50.02   31.00   33.31   40.84 
              55.34   77.45  101.18  126.03  151.93 
             192.98  268.41 
/
 2  6  8  1   46.44   31.61   42.15   57.50   89.99 
             139.70  208.18  281.43  361.43  449.39 
             598.22  888.54 
/
 2  6  9  1   37.14   38.67   66.28   95.09  153.07 
             243.37  378.27  533.81  712.22  913.34 
            1257.75 1955.55 
/
 2  7  1  1   56.65   55.55   51.92   45.98   45.48 
              46.80   50.82   55.64   63.56   72.95 
              87.55  114.26 
/
 2  7  2  1   56.65   55.48   51.51   45.33   44.85 
              46.32   50.55   56.27   63.89   73.39 
              88.57  116.87 
/
 2  7  3  1   56.65   55.13   49.45   42.61   42.32 
              44.58   49.96   57.20   65.96   75.85 
              93.36  127.42 
/
 2  7  4  1   56.65   54.80   47.35   40.54   40.56 
              43.64   50.13   58.60   68.64   79.87 
              98.74  135.83 
/
 2  7  5  1   56.65   53.09   35.53   34.80   37.45 
              44.50   56.83   71.23   87.03  103.97 
             131.31  181.57 
/
 2  7  6  1   56.65   52.17   32.87   33.57   37.80 
              47.21   62.76   80.21   98.98  118.84 
             150.53  208.49 
/
 2  7  7  1   56.65   50.99   31.51   33.16   39.47 
              52.11   71.81   93.28  115.93  139.64 
             177.24  246.18 
/
 2  7  8  1   49.84   33.98   38.66   51.51   79.51 
             122.84  182.15  244.67  312.01  385.13 
             507.14  746.86 
/
 2  7  9  1   39.13   35.16   58.08   82.65  132.33 
             208.61  319.24  445.38  587.48  747.15 
            1019.25 1560.89 
/
 2  8  1  1   57.59   56.83   55.00   51.57   51.22 
              52.25   56.48   59.95   65.42   71.98 
              82.71  104.93 
/
 2  8  2  1   57.59   56.80   54.77   50.95   50.59 
              51.63   55.23   59.41   65.40   72.40 
              83.44  106.25 
/
 2  8  3  1   57.59   56.64   53.78   48.57   48.11 
              49.10   52.86   57.22   64.84   73.57 
              87.15  112.71 
/
 2  8  4  1   57.59   56.50   52.97   47.06   46.55 
              47.63   51.69   56.64   64.67   74.32 
              89.47  118.40 
/
 2  8  5  1   57.59   55.69   47.99   41.09   41.13 
              44.10   50.87   59.71   70.17   81.96 
             101.64  140.41 
/
 2  8  6  1   57.59   55.18   44.69   38.72   39.34 
              43.61   52.09   62.74   75.01   88.59 
             110.88  153.51 
/
 2  8  7  1   57.59   54.49   39.58   36.46   38.10 
              44.07   54.93   67.97   82.55   98.35 
             124.10  171.97 
/
 2  8  8  1   57.56   46.43   31.44   36.11   48.57 
              70.57  102.19  135.17  169.43  205.27 
             262.69  369.67 
/
 2  8  9  1   52.94   36.39   35.86   45.91   69.34 
             106.32  157.00  209.90  266.00  326.21 
             425.27  617.26 
/
 2  9  1  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  2  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  3  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  4  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  5  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  6  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  7  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  8  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 2  9  9  1   58.23   57.83   57.70   57.74   58.07 
              59.01   61.00   63.82   67.44   71.87 
              80.02   97.61 
/
 3  1  1  1   57.04   55.09   46.37   41.35   42.09 
              45.93   53.44   62.85   73.62   85.42 
             104.55  140.65 
/
 3  1  2  1   57.04   54.90   45.17   40.69   41.72 
              46.00   54.18   64.30   75.78   88.31 
             108.46  146.22 
/
 3  1  3  1   57.04   54.06   39.37   38.58   41.00 
              47.39   58.75   72.10   86.73  102.32 
             127.20  172.72 
/
 3  1  4  1   57.05   53.32   37.10   37.60   41.29 
              49.71   63.95   80.09   97.44  115.75 
             144.77  197.45 
/
 3  1  5  1   57.05   49.88   35.24   38.92   49.27 
              68.31   96.46  126.03  156.69  188.60 
             239.36  333.93 
/
 3  1  6  1   57.04   46.53   36.17   41.83   56.34 
              81.72  117.80  155.15  193.95  234.71 
             300.59  426.05 
/
 3  1  7  1   55.97   41.69   38.69   47.21   68.04 
             102.13  149.18  198.03  249.67  304.83 
             395.69  574.66 
/
 3  1  8  1   38.43   55.64   99.20  143.68  235.00 
             388.33  634.93  936.13 1288.33 1698.98 
            2437.60 3894.12 
/
 3  1  9  1   35.05   95.91  181.65  271.42  477.42 
             869.44 1549.91 2434.55 3477.71 4747.57 
            7103.83 12276.72 
/
 3  2  1  1   57.64   55.76   47.64   42.19   42.72 
              46.29   53.35   62.33   72.70   84.12 
             102.81  138.38 
/
 3  2  2  1   57.64   55.59   46.54   41.50   42.30 
              46.26   53.95   63.60   74.64   86.76 
             106.40  143.51 
/
 3  2  3  1   57.64   54.79   40.98   39.21   41.30 
              47.19   57.85   70.53   84.55   99.59 
             123.67  168.01 
/
 3  2  4  1   57.64   54.09   37.72   38.06   41.33 
              49.09   62.44   77.78   94.36  111.94 
             139.92  190.88 
/
 3  2  5  1   57.64   50.93   35.29   38.51   47.90 
              65.50   91.84  119.72  148.68  178.80 
             226.63  315.31 
/
 3  2  6  1   57.64   48.22   35.87   40.91   54.09 
              77.51  111.19  146.23  182.59  220.61 
             281.85  397.45 
/
 3  2  7  1   57.10   43.28   37.88   45.55   64.36 
              95.90  139.67  185.07  232.75  283.50 
             366.51  528.24 
/
 3  2  8  1   39.27   51.96   91.22  131.59  213.87 
             349.87  564.63  824.46 1128.34 1477.06 
            2106.35 3343.60 
/
 3  2  9  1   37.37   87.80  165.22  245.23  425.19 
             761.89 1340.98 2085.36 2964.74 4012.55 
            5946.17 10191.32 
/
 3  3  1  1   58.24   56.46   48.98   43.15   43.46 
              46.74   53.35   61.86   71.80   82.79 
             101.00  135.99 
/
 3  3  2  1   58.24   56.30   47.98   42.43   42.98 
              46.61   53.80   62.93   73.50   85.16 
             104.25  140.66 
/
 3  3  3  1   58.24   55.55   42.96   39.96   41.70 
              47.07   56.99   68.96   82.33   96.77 
             119.99  163.05 
/
 3  3  4  1   58.24   54.89   38.80   38.63   41.46 
              48.53   60.95   75.40   91.17  107.99 
             134.85  184.00 
/
 3  3  5  1   58.24   51.91   35.44   38.19   46.58 
              62.69   87.16  113.26  140.46  168.78 
             213.67  296.54 
/
 3  3  6  1   58.24   49.84   35.66   40.06   51.91 
              73.31  104.50  137.11  170.98  206.36 
             262.99  369.28 
/
 3  3  7  1   58.06   45.26   37.16   43.94   60.76 
              89.67  130.09  172.01  215.86  262.28 
             337.67  482.99 
/
 3  3  8  1   40.31   48.39   83.26  119.51  193.14 
             312.50  497.81  718.97  978.04 1271.08 
            1786.67 2834.87 
/
 3  3  9  1   37.42   79.72  148.88  219.60  375.25 
             660.53 1146.37 1761.66 2506.97 3350.35 
            4904.30 8294.78 
/
 3  4  1  1   58.85   57.17   50.38   44.26   44.34 
              47.31   53.45   61.46   70.93   81.46 
              99.20  133.41 
/
 3  4  2  1   58.85   57.02   49.48   43.51   43.81 
              47.10   53.75   62.33   72.38   83.53 
             102.02  137.67 
/
 3  4  3  1   58.85   56.34   45.03   40.87   42.24 
              47.08   56.20   67.40   80.06   93.85 
             116.13  157.83 
/
 3  4  4  1   58.85   55.72   40.64   39.36   41.72 
              48.08   59.49   72.99   87.90  103.88 
             129.54  176.78 
/
 3  4  5  1   58.85   52.91   35.72   37.97   45.36 
              59.92   82.38  106.62  132.01  158.47 
             200.41  277.46 
/
 3  4  6  1   58.85   51.33   35.58   39.31   49.81 
              69.11   97.75  127.89  159.23  191.93 
             244.04  341.23 
/
 3  4  7  1   58.85   47.65   36.55   42.40   57.30 
              83.33  120.38  158.81  198.82  240.98 
             309.22  438.94 
/
 3  4  8  1   41.67   44.83   75.32  107.44  172.58 
             276.19  434.36  619.85  835.86 1081.09 
            1504.07 2383.60 
/
 3  4  9  1   37.73   71.71  132.61  194.45  327.51 
             565.42  966.02 1459.66 2067.13 2749.54 
            3977.27 6630.06 
/
 3  5  1  1   60.07   58.66   53.42   47.02   46.74 
              48.98   54.10   61.02   69.38   78.87 
              95.73  127.56 
/
 3  5  2  1   60.07   58.55   52.73   46.26   46.08 
              48.60   54.10   61.47   70.34   80.28 
              97.66  131.14 
/
 3  5  3  1   60.07   58.00   49.38   43.39   43.92 
              47.64   55.03   64.49   75.49   87.75 
             107.85  146.51 
/
 3  5  4  1   60.07   57.50   46.11   41.53   42.83 
              47.68   56.87   68.21   81.09   95.18 
             118.06  161.09 
/
 3  5  5  1   60.07   55.15   36.87   38.05   43.35 
              54.52   72.64   92.76  114.19  136.71 
             172.50  238.01 
/
 3  5  6  1   60.07   53.93   35.99   38.31   45.89 
              60.81   83.82  108.67  134.74  161.97 
             205.19  284.86 
/
 3  5  7  1   60.07   52.11   35.86   39.79   50.73 
              70.76  100.39  131.61  164.12  198.09 
             252.36  353.73 
/
 3  5  8  1   45.93   38.59   59.66   83.28  131.93 
             207.00  315.91  439.84  580.38  738.58 
            1009.81 1546.40 
/
 3  5  9  1   39.45   56.11  100.14  145.14  237.81 
             393.64  644.41  948.99 1304.32 1715.73 
            2457.05 3917.11 
/
 3  6  1  1   61.32   60.22   56.60   50.76   50.29 
              51.69   55.73   60.82   68.71   78.08 
              92.85  120.12 
/
 3  6  2  1   61.32   60.15   56.19   50.12   49.67 
              51.22   55.50   61.46   68.89   78.35 
              93.84  122.90 
/
 3  6  3  1   61.32   59.79   54.11   47.41   47.17 
              49.54   55.01   62.40   71.36   81.46 
              99.27  133.97 
/
 3  6  4  1   61.32   59.45   52.01   45.37   45.46 
              48.67   55.31   64.00   74.33   85.94 
             105.34  143.38 
/
 3  6  5  1   61.32   57.72   40.38   39.82   42.63 
              49.95   62.88   78.06   94.75  112.66 
             141.56  194.78 
/
 3  6  6  1   61.32   56.79   37.92   38.68   43.12 
              52.99   69.47   88.07  108.12  129.34 
             163.24  225.42 
/
 3  6  7  1   61.32   55.61   36.63   38.41   45.03 
              58.47   79.62  102.77  127.25  152.92 
             193.72  268.79 
/
 3  6  8  1   54.49   39.44   45.22   59.61   91.18 
             140.32  208.42  281.56  361.42  449.28 
             597.98  888.98 
/
 3  6  9  1   44.11   41.73   67.92   96.13  153.61 
             243.57  378.24  533.63  711.92  913.90 
            1257.85 1952.59 
/
 3  7  1  1   61.64   60.62   57.42   51.90   51.42 
              52.65   56.51   60.87   68.87   78.05 
              92.06  117.79 
/
 3  7  2  1   61.64   60.56   57.08   51.31   50.83 
              52.14   56.13   60.89   69.08   78.28 
              93.12  120.36 
/
 3  7  3  1   61.64   60.26   55.35   48.78   48.42 
              50.39   55.35   62.16   70.47   80.19 
              97.34  130.66 
/
 3  7  4  1   61.64   59.97   53.59   46.79   46.66 
              49.33   55.28   63.23   72.80   83.60 
             102.11  138.61 
/
 3  7  5  1   61.63   58.44   43.32   40.82   42.91 
              49.18   60.60   74.31   89.61  106.16 
             133.09  182.91 
/
 3  7  6  1   61.63   57.60   38.96   39.33   42.84 
              51.31   65.89   82.70  100.98  120.50 
             151.84  209.45 
/
 3  7  7  1   61.63   56.52   37.31   38.50   43.97 
              55.55   74.31   95.15  117.40  140.82 
             178.15  246.72 
/
 3  7  8  1   57.57   41.25   42.37   53.98   80.97 
             123.64  182.54  244.86  312.08  385.10 
             506.98  746.52 
/
 3  7  9  1   46.40   38.80   60.04   83.91  133.01 
             208.89  319.29  445.27  587.25  747.04 
            1020.02 1560.74 
/
 3  8  1  1   62.59   61.88   60.30   57.46   57.14 
              58.17   62.66   65.66   70.64   76.87 
              87.40  109.26 
/
 3  8  2  1   62.59   61.84   60.08   56.85   56.53 
              57.60   61.80   65.44   70.61   77.26 
              88.08  110.52 
/
 3  8  3  1   62.59   61.69   59.15   54.43   54.03 
              55.07   58.74   63.20   70.49   78.70 
              91.60  116.62 
/
 3  8  4  1   62.59   61.58   58.43   52.90   52.41 
              53.44   57.36   61.82   70.05   79.51 
              94.25  122.20 
/
 3  8  5  1   62.59   60.87   54.24   47.33   47.23 
              49.78   56.01   64.31   74.31   85.65 
             104.88  143.16 
/
 3  8  6  1   62.59   60.42   51.48   44.98   45.34 
              49.03   56.82   66.85   78.60   91.77 
             113.56  155.71 
/
 3  8  7  1   62.59   59.81   47.38   42.63   43.79 
              49.07   59.09   71.45   85.50  100.92 
             126.20  173.60 
/
 3  8  8  1   62.58   53.61   36.55   40.48   51.89 
              72.71  103.55  136.10  170.13  205.79 
             262.94  369.76 
/
 3  8  9  1   60.10   43.75   39.91   49.02   71.14 
             107.37  157.62  210.23  266.19  326.27 
             425.20  617.01 
/
 3  9  1  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  2  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  3  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  4  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  5  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  6  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  7  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  8  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 3  9  9  1   63.23   62.84   62.70   62.74   63.07 
              64.01   66.01   68.82   72.44   76.87 
              85.02  102.60 
/
 4  1  1  1   61.99   60.25   52.76   47.41   47.85 
              51.25   58.11   66.93   77.20   88.56 
             107.24  142.87 
/
 4  1  2  1   61.99   60.08   51.74   46.72   47.42 
              51.21   58.70   68.20   79.18   91.28 
             110.97  148.25 
/
 4  1  3  1   61.99   59.30   46.66   44.41   46.36 
              52.07   62.59   75.27   89.40  104.63 
             129.06  174.16 
/
 4  1  4  1   61.99   58.62   43.01   43.24   46.35 
              53.94   67.27   82.76   99.64  117.59 
             146.24  198.56 
/
 4  1  5  1   61.99   55.59   40.45   43.58   52.94 
              70.90   98.19  127.29  157.66  189.37 
             239.92  334.26 
/
 4  1  6  1   61.99   53.33   40.99   46.00   59.41 
              83.66  119.03  156.00  194.61  235.23 
             300.81  426.18 
/
 4  1  7  1   61.73   48.64   43.03   50.84   70.28 
             103.50  150.01  198.62  250.05  305.06 
             395.82  574.59 
/
 4  1  8  1   44.57   58.19  100.46  144.39  235.37 
             388.43  634.81  935.84 1288.19 1700.75 
            2419.34 3893.19 
/
 4  1  9  1   42.77   97.19  182.20  271.70  477.45 
             869.22 1549.97 2427.65 3477.28 4746.93 
            7102.82 12247.47 
/
 4  2  1  1   62.59   60.91   53.91   48.26   48.53 
              51.69   58.16   66.57   76.45   87.43 
             105.67  140.76 
/
 4  2  2  1   62.59   60.75   52.97   47.55   48.05 
              51.57   58.62   67.67   78.21   89.90 
             109.08  145.71 
/
 4  2  3  1   62.59   60.02   48.29   45.10   46.75 
              52.01   61.86   73.88   87.40  102.07 
             125.70  169.59 
/
 4  2  4  1   62.59   59.37   44.10   43.77   46.50 
              53.49   65.94   80.61   96.73  113.94 
             141.53  192.10 
/
 4  2  5  1   62.59   56.45   40.60   43.30   51.75 
              68.29   93.74  121.10  149.75  179.67 
             227.28  315.64 
/
 4  2  6  1   62.59   54.71   40.82   45.23   57.40 
              79.66  112.55  147.18  183.29  221.19 
             282.14  397.64 
/
 4  2  7  1   62.54   50.42   42.37   49.31   66.84 
              97.43  140.63  185.73  233.23  283.79 
             366.68  528.22 
/
 4  2  8  1   45.52   54.69   92.63  132.40  214.31 
             350.02  564.56  824.23 1127.75 1478.35 
            2091.90 3363.70 
/
 4  2  9  1   42.80   89.24  165.84  245.57  425.27 
             761.73 1340.58 2075.37 2978.87 4011.94 
            5945.22 10165.61 
/
 4  3  1  1   63.20   61.59   55.13   49.24   49.32 
              52.24   58.29   66.27   75.74   86.30 
             104.05  138.51 
/
 4  3  2  1   63.20   61.45   54.26   48.50   48.80 
              52.03   58.61   67.18   77.26   88.49 
             107.12  143.05 
/
 4  3  3  1   63.20   60.76   50.03   45.91   47.25 
              52.05   61.19   72.51   85.38   99.43 
             122.20  164.80 
/
 4  3  4  1   63.20   60.16   45.82   44.42   46.76 
              53.11   64.65   78.44   93.73  110.17 
             136.62  185.36 
/
 4  3  5  1   63.19   57.37   40.85   43.12   50.63 
              65.72   89.23  114.79  141.66  169.75 
             214.42  296.96 
/
 4  3  6  1   63.19   55.97   40.75   44.55   55.40 
              75.68  106.06  138.23  171.83  207.03 
             263.42  369.53 
/
 4  3  7  1   63.19   52.52   41.81   47.87   63.55 
              91.34  131.14  172.72  216.36  262.65 
             337.91  483.03 
/
 4  3  8  1   46.73   51.26   84.84  120.46  193.65 
             312.68  497.79  718.78  977.73 1271.36 
            1787.55 2832.80 
/
 4  3  9  1   43.04   81.36  149.60  220.01  375.38 
             660.41 1145.82 1755.56 2500.17 3368.81 
            4903.41 8293.29 
/
 4  4  1  1   63.81   62.29   56.41   50.34   50.24 
              52.89   58.53   66.05   75.07   85.18 
             102.57  136.11 
/
 4  4  2  1   63.81   62.16   55.62   49.60   49.67 
              52.61   58.71   66.77   76.35   87.07 
             105.10  140.28 
/
 4  4  3  1   63.81   61.54   51.83   46.88   47.89 
              52.21   60.61   71.18   83.33   96.73 
             118.54  159.77 
/
 4  4  4  1   63.81   60.97   48.05   45.23   47.14 
              52.85   63.42   76.27   90.67  106.28 
             131.50  178.31 
/
 4  4  5  1   63.80   58.39   41.24   43.05   49.62 
              63.16   84.69  108.34  133.36  159.58 
             201.26  278.04 
/
 4  4  6  1   63.80   57.10   40.82   43.99   53.50 
              71.74   99.49  129.16  160.21  192.71 
             244.62  341.55 
/
 4  4  7  1   63.80   54.58   41.37   46.55   60.36 
              85.26  121.59  159.64  199.48  241.48 
             309.48  439.05 
/
 4  4  8  1   48.28   47.98   77.07  108.56  173.19 
             276.44  434.40  619.72  835.60 1080.51 
            1505.56 2364.22 
/
 4  4  9  1   43.54   73.58  133.46  194.95  327.69 
             565.36  965.74 1460.64 2054.80 2762.74 
            3976.44 6628.67 
/
 4  5  1  1   65.04   63.75   59.16   53.04   52.70 
              54.69   59.43   65.96   73.90   83.25 
              99.68  130.64 
/
 4  5  2  1   65.04   63.65   58.57   52.31   52.04 
              54.27   59.36   66.30   74.73   84.32 
             101.42  134.18 
/
 4  5  3  1   65.04   63.16   55.66   49.47   49.74 
              53.08   59.89   68.80   79.32   91.16 
             110.79  148.98 
/
 4  5  4  1   65.04   62.71   52.87   47.55   48.51 
              52.86   61.34   72.06   84.43   98.12 
             120.55  163.09 
/
 4  5  5  1   65.04   60.54   42.64   43.47   48.11 
              58.34   75.54   95.01  116.00  138.21 
             173.70  238.87 
/
 4  5  6  1   65.04   59.43   41.52   43.39   50.15 
              64.04   86.12  110.39  136.09  163.06 
             206.04  285.37 
/
 4  5  7  1   65.04   58.03   41.08   44.43   54.37 
              73.33  102.11  132.84  165.07  198.84 
             252.91  354.03 
/
 4  5  8  1   53.04   42.80   62.02   84.87  132.80 
             207.48  316.10  439.86  580.28  738.36 
            1009.46 1547.98 
/
 4  5  9  1   45.69   58.65  101.40  145.84  238.17 
             393.73  644.28  948.69 1304.78 1716.99 
            2437.42 3915.94 
/
 4  6  1  1   66.30   65.27   62.05   56.57   56.12 
              57.41   61.30   65.59   73.95   83.01 
              97.42  123.68 
/
 4  6  2  1   66.30   65.21   61.69   55.98   55.52 
              56.93   60.97   66.14   74.04   83.43 
              98.46  126.45 
/
 4  6  3  1   66.30   64.90   59.89   53.42   53.11 
              55.22   60.32   67.30   75.85   85.61 
             103.16  137.29 
/
 4  6  4  1   66.30   64.60   58.07   51.44   51.38 
              54.23   60.39   68.60   78.48   89.67 
             108.63  146.19 
/
 4  6  5  1   66.30   63.02   47.74   45.67   47.99 
              54.60   66.66   81.18   97.39  114.92 
             143.42  196.20 
/
 4  6  6  1   66.30   62.16   43.81   44.30   48.11 
              57.10   72.65   90.63  110.20  131.08 
             164.63  226.45 
/
 4  6  7  1   66.30   61.07   42.29   43.65   49.53 
              61.95   82.19  104.71  128.80  154.18 
             194.71  269.50 
/
 4  6  8  1   62.04   46.25   48.96   62.13   92.72 
             141.22  208.93  281.81  361.56  449.30 
             597.86  888.68 
/
 4  6  9  1   51.03   45.36   69.94   97.42  154.28 
             243.90  378.34  533.57  711.72  913.59 
            1258.46 1952.65 
/
 4  7  1  1   66.62   65.66   62.80   57.65   57.24 
              58.47   62.23   66.66   74.29   83.01 
              96.43  121.46 
/
 4  7  2  1   66.62   65.61   62.49   57.08   56.63 
              57.88   61.74   66.12   74.40   83.42 
              97.65  124.02 
/
 4  7  3  1   66.62   65.35   61.00   54.72   54.33 
              56.09   60.74   67.20   75.15   84.79 
             101.52  134.17 
/
 4  7  4  1   66.62   65.09   59.49   52.83   52.60 
              54.97   60.51   68.02   77.19   87.59 
             105.81  141.73 
/
 4  7  5  1   66.62   63.71   50.76   46.77   48.42 
              54.07   64.69   77.75   92.55  108.73 
             135.21  184.57 
/
 4  7  6  1   66.62   62.94   45.53   45.09   48.04 
              55.72   69.40   85.55  103.36  122.51 
             153.47  210.69 
/
 4  7  7  1   66.62   61.94   43.10   43.97   48.73 
              59.35   77.19   97.39  119.20  142.32 
             179.34  247.59 
/
 4  7  8  1   64.44   48.18   46.37   56.98   82.78 
             124.73  183.18  245.27  312.32  385.21 
             506.95  746.31 
/
 4  7  9  1   53.53   43.04   62.42   85.49  133.87 
             209.36  319.47  445.29  587.14  746.82 
            1019.66 1562.12 
/
 4  8  1  1   67.59   66.91   65.56   63.16   62.87 
              63.87   68.90   70.99   75.82   81.76 
              92.13  113.63 
/
 4  8  2  1   67.59   66.88   65.34   62.62   62.31 
              63.36   68.12   70.79   75.78   82.11 
              92.76  114.85 
/
 4  8  3  1   67.59   66.74   64.45   60.20   59.86 
              60.97   63.42   69.18   75.89   83.66 
              96.05  120.68 
/
 4  8  4  1   67.59   66.63   63.77   58.58   58.15 
              59.20   63.03   67.63   75.52   84.56 
              98.87  126.14 
/
 4  8  5  1   67.59   66.01   60.17   53.36   53.16 
              55.40   61.21   69.08   78.68   89.63 
             108.55  146.24 
/
 4  8  6  1   67.59   65.61   57.76   51.06   51.24 
              54.49   61.72   71.21   82.49   95.27 
             116.58  158.24 
/
 4  8  7  1   67.59   65.05   54.28   48.67   49.50 
              54.22   63.52   75.26   88.81  103.84 
             128.65  175.57 
/
 4  8  8  1   67.58   59.99   41.80   45.13   55.52 
              75.26  105.24  137.33  171.06  206.53 
             263.48  370.05 
/
 4  8  9  1   66.49   50.90   44.26   52.61   73.34 
             108.71  158.45  210.79  266.52  326.51 
             425.28  616.90 
/
 4  9  1  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  2  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  3  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  4  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  5  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  6  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  7  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  8  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 4  9  9  1   68.24   67.84   67.71   67.75   68.07 
              69.02   71.01   73.82   77.45   81.87 
              90.02  107.60 
/
 5  1  1  1   71.87   70.43   64.59   59.17   59.25 
              62.02   67.90   75.74   85.14   95.67 
             113.54  148.10 
/
 5  1  2  1   71.87   70.29   63.79   58.46   58.73 
              61.83   68.25   76.72   86.79   98.06 
             116.87  153.21 
/
 5  1  3  1   71.87   69.63   59.88   55.94   57.23 
              61.92   71.04   82.50   95.66  110.12 
             133.68  177.85 
/
 5  1  4  1   71.87   69.04   56.07   54.49   56.78 
              63.08   74.80   89.02  104.94  122.17 
             149.99  201.51 
/
 5  1  5  1   71.86   66.30   51.08   53.38   61.13 
              77.11  102.56  130.57  160.26  191.52 
             241.62  335.42 
/
 5  1  6  1   71.86   65.05   51.06   55.01   66.51 
              88.60  122.25  158.38  196.45  236.77 
             301.99  426.82 
/
 5  1  7  1   71.85   62.14   52.32   58.78   75.96 
             107.05  152.32  200.26  251.28  306.08 
             396.44  574.86 
/
 5  1  8  1   56.77   64.05  103.69  146.42  236.50 
             388.93  634.87  935.55 1287.60 1699.51 
            2421.41 3892.42 
/
 5  1  9  1   53.58  100.51  183.72  272.63  477.79 
             869.04 1548.97 2421.23 3480.01 4759.42 
            7101.51 12245.02 
/
 5  2  1  1   72.47   71.08   65.60   60.04   59.99 
              62.58   68.15   75.64   84.68   94.85 
             112.39  146.24 
/
 5  2  2  1   72.47   70.95   64.85   59.31   59.44 
              62.32   68.39   76.46   86.12   96.99 
             115.30  151.00 
/
 5  2  3  1   72.47   70.33   61.24   56.69   57.76 
              62.08   70.60   81.45   94.00  107.90 
             130.63  173.57 
/
 5  2  4  1   72.47   69.77   57.70   55.13   57.10 
              62.89   73.80   87.21  102.36  118.84 
             145.58  195.30 
/
 5  2  5  1   72.47   67.17   51.38   53.32   60.25 
              74.84   98.46  124.67  152.60  182.03 
             229.15  317.03 
/
 5  2  6  1   72.47   65.93   51.09   54.51   64.81 
              84.99  116.15  149.80  185.34  222.91 
             283.46  398.43 
/
 5  2  7  1   72.46   63.75   51.91   57.58   73.01 
             101.29  143.16  187.57  234.63  284.88 
             367.44  528.61 
/
 5  2  8  1   57.99   60.93   96.14  134.69  215.59 
             350.63  564.72  824.03 1127.27 1477.27 
            2092.68 3344.00 
/
 5  2  9  1   53.90   92.93  167.56  246.62  425.71 
             761.65 1339.77 2075.22 2966.46 4018.47 
            5944.06 10163.43 
/
 5  3  1  1   73.09   71.75   66.68   61.00   60.83 
              63.23   68.48   75.60   84.26   94.05 
             111.24  144.27 
/
 5  3  2  1   73.09   71.63   65.97   60.27   60.25 
              62.91   68.60   76.25   85.50   95.92 
             113.79  148.71 
/
 5  3  3  1   73.09   71.06   62.66   57.57   58.38 
              62.33   70.24   80.43   92.35  105.63 
             127.47  169.13 
/
 5  3  4  1   73.09   70.53   59.45   55.89   57.53 
              62.79   72.87   85.42   99.74  115.43 
             141.02  188.86 
/
 5  3  5  1   73.09   68.10   51.79   53.35   59.47 
              72.64   94.37  118.71  144.80  172.37 
             216.51  298.52 
/
 5  3  6  1   73.08   66.87   51.22   54.11   63.20 
              81.44  110.03  141.18  174.16  208.95 
             264.92  370.48 
/
 5  3  7  1   73.08   65.23   51.59   56.49   70.17 
              95.69  133.97  174.79  218.00  263.90 
             338.82  483.55 
/
 5  3  8  1   59.51   58.11   88.70  123.02  195.05 
             313.34  498.06  718.71  977.37 1270.75 
            1787.35 2835.70 
/
 5  3  9  1   54.44   85.49  151.57  221.23  375.92 
             660.45 1145.37 1754.31 2491.53 3352.20 
            4918.74 8291.34 
/
 5  4  1  1   73.71   72.44   67.81   62.08   61.81 
              63.99   68.90   75.64   83.86   93.28 
             110.20  142.17 
/
 5  4  2  1   73.71   72.33   67.18   61.35   61.18 
              63.61   68.92   76.13   84.93   94.87 
             112.36  146.29 
/
 5  4  3  1   73.71   71.81   64.16   58.60   59.14 
              62.71   69.99   79.49   90.72  103.35 
             124.22  164.51 
/
 5  4  4  1   73.71   71.32   61.28   56.81   58.09 
              62.81   72.02   83.67   97.11  111.96 
             136.29  182.16 
/
 5  4  5  1   73.71   69.06   52.34   53.50   58.82 
              70.53   90.28  112.68  136.87  162.51 
             203.62  279.82 
/
 5  4  6  1   73.70   67.87   51.49   53.83   61.72 
              77.97  103.89  132.46  162.83  194.87 
             246.33  342.73 
/
 5  4  7  1   73.70   66.52   51.44   55.54   67.43 
              90.16  124.78  162.00  201.30  243.00 
             310.56  439.66 
/
 5  4  8  1   61.44   55.75   81.44  111.48  174.83 
             277.38  434.81  619.78  835.38 1080.04 
            1504.41 2366.36 
/
 5  4  9  1   55.26   78.25  135.74  196.37  328.38 
             565.53  965.43 1459.65 2055.25 2750.81 
            3975.87 6626.95 
/
 5  5  1  1   74.97   73.86   70.16   64.61   64.22 
              65.89   70.11   76.02   83.50   92.93 
             108.34  137.38 
/
 5  5  2  1   74.97   73.78   69.70   63.94   63.59 
              65.44   69.95   76.23   83.95   93.51 
             109.74  140.86 
/
 5  5  3  1   74.97   73.38   67.38   61.23   61.20 
              63.99   69.94   77.95   87.66   98.70 
             117.50  154.78 
/
 5  5  4  1   74.97   73.00   65.19   59.29   59.79 
              63.41   70.79   80.46   91.93  104.87 
             126.35  167.96 
/
 5  5  5  1   74.97   71.12   54.11   54.48   58.09 
              66.78   82.23  100.45  120.51  142.04 
             176.83  241.29 
/
 5  5  6  1   74.97   70.14   52.63   53.84   59.33 
              71.38   91.68  114.70  139.57  165.98 
             208.38  287.13 
/
 5  5  7  1   74.97   68.86   51.74   54.23   62.52 
              79.48  106.41  136.08  167.63  200.96 
             254.57  355.13 
/
 5  5  8  1   67.01   54.84   67.77   88.93  135.21 
             208.82  316.87  440.27  580.40  738.24 
            1009.04 1546.80 
/
 5  5  9  1   58.09   64.49  104.60  147.86  239.29 
             394.20  644.30  948.37 1304.16 1716.35 
            2439.64 3914.21 
/
 5  6  1  1   76.26   75.34   72.66   67.83   67.52 
              68.83   72.55   77.04   84.76   93.13 
             106.22  131.12 
/
 5  6  2  1   76.26   75.29   72.37   67.26   66.86 
              68.19   72.01   76.47   84.61   93.57 
             107.55  133.89 
/
 5  6  3  1   76.26   75.04   70.96   64.98   64.61 
              66.39   70.94   77.32   85.19   94.99 
             111.70  144.61 
/
 5  6  4  1   76.26   74.80   69.54   63.15   62.93 
              65.29   70.72   78.17   87.32   97.77 
             116.26  152.65 
/
 5  6  5  1   76.26   73.46   61.54   57.23   58.84 
              64.38   75.00   88.29  103.54  120.33 
             147.99  199.83 
/
 5  6  6  1   76.26   72.72   56.48   55.55   58.43 
              66.03   79.91   96.61  115.26  135.42 
             168.21  229.24 
/
 5  6  7  1   76.26   71.76   53.60   54.40   59.09 
              69.79   88.24  109.52  132.72  157.49 
             197.38  271.52 
/
 5  6  8  1   75.06   59.35   57.11   68.46   96.61 
             143.56  210.44  282.76  362.21  449.73 
             597.99  888.40 
/
 5  6  9  1   64.64   54.34   74.91  100.85  156.23 
             245.03  378.86  533.76  711.63  913.26 
            1257.83 1953.42 
/
 5  7  1  1   76.59   75.72   73.37   69.03   68.75 
              70.06   72.72   78.34   85.11   92.91 
             105.15  129.13 
/
 5  7  2  1   76.59   75.68   73.08   68.34   68.03 
              69.32   73.04   77.65   85.06   93.42 
             106.53  131.62 
/
 5  7  3  1   76.59   75.47   71.88   66.17   65.75 
              67.26   71.46   77.39   85.14   94.81 
             110.54  141.71 
/
 5  7  4  1   76.59   75.26   70.70   64.45   64.13 
              66.10   71.03   77.89   86.36   96.14 
             114.00  148.76 
/
 5  7  5  1   76.59   74.11   63.89   58.44   59.49 
              64.22   73.54   85.44   99.29  114.71 
             140.29  188.71 
/
 5  7  6  1   76.59   73.44   59.55   56.53   58.67 
              65.13   77.25   92.14  109.01  127.43 
             157.57  213.91 
/
 5  7  7  1   76.58   72.57   54.62   55.02   58.71 
              67.77   83.85  102.80  123.69  146.13 
             182.45  249.98 
/
 5  7  8  1   76.29   61.70   55.05   64.21   87.31 
             127.52  184.97  246.56  313.21  385.81 
             507.28  746.23 
/
 5  7  9  1   67.54   55.54   68.15   89.53  136.27 
             210.69  320.12  445.68  587.24  746.68 
            1019.23 1561.18 
/
 5  8  1  1   77.58   76.97   75.92   74.13   73.91 
              74.89   80.34   81.49   86.09   91.58 
             101.63  122.43 
/
 5  8  2  1   77.58   76.94   75.75   73.71   73.45 
              74.46   79.98   81.31   86.05   91.86 
             102.21  123.60 
/
 5  8  3  1   77.58   76.80   74.93   71.58   71.33 
              72.49   76.30   80.60   86.08   93.50 
             105.12  129.11 
/
 5  8  4  1   77.58   76.70   74.28   69.81   69.49 
              70.64   74.38   79.33   86.38   94.52 
             108.03  134.23 
/
 5  8  5  1   77.58   76.21   71.42   64.97   64.66 
              66.51   71.70   78.90   87.85   98.10 
             116.67  153.19 
/
 5  8  6  1   77.58   75.88   69.50   62.81   62.76 
              65.41   71.80   80.42   90.91  103.00 
             123.39  164.16 
/
 5  8  7  1   77.58   75.42   66.78   60.44   60.87 
              64.74   72.91   83.58   96.23  110.51 
             134.38  180.36 
/
 5  8  8  1   77.57   71.21   52.53   54.94   63.63 
              81.37  109.50  140.53  173.60  208.63 
             265.12  371.10 
/
 5  8  9  1   77.56   64.84   53.60   60.52   78.96 
             112.17  160.65  212.38  267.70  327.32 
             425.79  617.07 
/
 5  9  1  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  2  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  3  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  4  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  5  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  6  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  7  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  8  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 5  9  9  1   78.25   77.85   77.72   77.75   78.08 
              79.02   81.02   83.83   87.45   91.88 
             100.02  117.60 
/
 6  1  1  1   81.72   80.51   75.75   70.59   70.47 
              72.83   78.02   85.11   93.77  103.59 
             120.87  154.05 
/
 6  1  2  1   81.72   80.39   75.07   69.87   69.91 
              72.54   78.20   85.86   95.16  105.68 
             123.76  159.12 
/
 6  1  3  1   81.72   79.82   71.86   67.27   68.15 
              72.12   80.16   90.59  102.86  116.59 
             139.23  182.47 
/
 6  1  4  1   81.72   79.30   68.75   65.67   67.40 
              72.77   83.17   96.23  111.22  127.71 
             154.68  205.31 
/
 6  1  5  1   81.72   76.83   61.83   63.56   70.08 
              84.28  107.98  134.78  163.69  194.43 
             243.99  337.26 
/
 6  1  6  1   81.72   75.63   61.43   64.60   74.50 
              94.63  126.49  161.56  199.01  238.90 
             303.76  428.15 
/
 6  1  7  1   81.71   74.10   62.10   67.53   82.79 
             111.61  155.38  202.57  253.17  307.58 
             397.67  575.54 
/
 6  1  8  1   68.96   71.04  107.73  149.11  238.05 
             389.88  635.30  935.60 1287.34 1698.97 
            2419.76 3894.54 
/
 6  1  9  1   64.62  104.76  185.83  273.99  478.48 
             869.19 1548.58 2419.75 3478.74 4749.35 
            7106.36 12243.43 
/
 6  2  1  1   82.34   81.15   76.69   71.44   71.23 
              73.45   78.39   85.18   93.49  103.02 
             120.10  152.42 
/
 6  2  2  1   82.34   81.04   76.04   70.72   70.65 
              73.11   78.48   85.80   94.74  104.87 
             122.64  157.18 
/
 6  2  3  1   82.34   80.51   73.04   68.06   68.75 
              72.43   79.95   89.81  101.50  114.67 
             136.49  178.50 
/
 6  2  4  1   82.34   80.02   70.17   66.37   67.83 
              72.77   82.44   94.73  108.96  124.70 
             150.58  199.38 
/
 6  2  5  1   82.34   77.70   62.23   63.64   69.46 
              82.34  104.23  129.21  156.31  185.18 
             231.75  319.03 
/
 6  2  6  1   82.33   76.51   61.59   64.30   73.11 
              91.38  120.73  153.31  188.17  225.24 
             285.40  399.90 
/
 6  2  7  1   82.33   75.18   61.87   66.60   80.18 
             106.34  146.51  190.11  236.65  286.61 
             368.73  529.45 
/
 6  2  8  1   70.45   68.65  100.58  137.65  217.34 
             351.71  565.27  824.21 1127.14 1476.86 
            2091.91 3343.60 
/
 6  2  9  1   65.16   97.61  169.91  248.15  426.52 
             761.92 1339.50 2074.04 2964.39 4013.75 
            5948.12 10162.08 
/
 6  3  1  1   82.97   81.81   77.66   72.37   72.09 
              74.15   78.83   85.32   93.27  102.80 
             119.31  150.69 
/
 6  3  2  1   82.97   81.71   77.08   71.67   71.48 
              73.78   78.84   85.80   94.33  104.09 
             121.50  155.14 
/
 6  3  3  1   82.97   81.22   74.30   68.97   69.45 
              72.83   79.82   89.09  100.17  112.75 
             133.68  174.41 
/
 6  3  4  1   82.97   80.77   71.68   67.20   68.38 
              72.87   81.80   93.28  106.70  121.65 
             146.35  193.26 
/
 6  3  5  1   82.96   78.59   62.75   63.82   68.94 
              80.50  100.51  123.62  148.86  175.82 
             219.35  300.76 
/
 6  3  6  1   82.96   77.43   61.86   64.10   71.83 
              88.21  115.01  145.02  177.28  211.57 
             267.06  372.13 
/
 6  3  7  1   82.95   76.14   61.77   65.79   77.70 
             101.17  137.71  177.61  220.25  265.83 
             340.36  484.56 
/
 6  3  8  1   72.25   66.41   93.62  126.38  197.04 
             314.57  498.71  719.02  977.37 1270.49 
            1786.74 2833.60 
/
 6  3  9  1   65.94   90.67  154.22  222.95  376.89 
             660.85 1145.25 1753.77 2489.91 3351.00 
            4905.63 8290.21 
/
 6  4  1  1   83.60   82.49   78.67   73.40   73.07 
              74.95   79.36   85.52   93.11  102.68 
             118.58  148.83 
/
 6  4  2  1   83.60   82.40   78.16   72.71   72.44 
              74.53   79.28   85.87   93.97  103.65 
             120.47  152.96 
/
 6  4  3  1   83.60   81.96   75.63   70.01   70.28 
              73.34   79.80   88.44   98.89  110.79 
             130.81  170.19 
/
 6  4  4  1   83.60   81.54   73.26   68.17   69.05 
              73.09   81.25   91.89  104.46  118.58 
             142.01  186.96 
/
 6  4  5  1   83.60   79.52   63.41   64.13   68.56 
              78.78   96.84  118.03  141.31  166.32 
             206.76  282.31 
/
 6  4  6  1   83.59   78.46   62.27   64.03   70.70 
              85.16  109.33  136.70  166.29  197.80 
             248.72  344.56 
/
 6  4  7  1   83.59   77.17   61.81   65.12   75.38 
              96.14  128.99  165.15  203.83  245.11 
             312.31  440.96 
/
 6  4  8  1   74.43   64.93   86.89  115.28  177.12 
             278.70  435.61  620.24  835.54 1079.94 
            1503.96 2364.66 
/
 6  4  9  1   66.97   83.82  138.77  198.35  329.52 
             566.07  965.45 1459.27 2054.55 2748.89 
            3977.95 6631.14 
/
 6  5  1  1   84.89   83.90   80.79   75.77   75.38 
              76.87   80.78   85.27   93.80  102.98 
             117.49  144.58 
/
 6  5  2  1   84.89   83.83   80.41   75.16   74.79 
              76.42   80.51   86.16   94.10  103.46 
             118.76  148.06 
/
 6  5  3  1   84.89   83.50   78.52   72.61   72.42 
              74.86   80.19   87.53   96.59  106.93 
             125.31  161.48 
/
 6  5  4  1   84.89   83.17   76.66   70.71   70.94 
              74.07   80.65   89.48  100.18  112.44 
             133.04  173.74 
/
 6  5  5  1   84.89   81.52   66.59   65.51   68.40 
              75.91   89.85  106.86  126.01  146.83 
             180.84  244.49 
/
 6  5  6  1   84.89   80.64   63.72   64.48   69.06 
              79.62   98.22  120.03  144.00  169.77 
             211.51  289.60 
/
 6  5  7  1   84.88   79.50   62.51   64.40   71.43 
              86.58  111.77  140.24  171.02  203.82 
             256.91  356.94 
/
 6  5  8  1   80.75   66.82   74.99   94.01  138.33 
             210.77  318.15  441.09  580.95  738.54 
            1009.01 1546.33 
/
 6  5  9  1   70.45   71.46  108.63  150.53  240.82 
             395.14  644.71  948.39 1303.86 1715.78 
            2437.96 3916.98 
/
 6  6  1  1   86.21   85.37   83.13   79.03   78.85 
              80.26   82.46   88.58   95.00  102.81 
             114.93  138.88 
/
 6  6  2  1   86.21   85.32   82.83   78.31   78.08 
              79.47   83.18   87.93   95.26  103.38 
             116.45  141.58 
/
 6  6  3  1   86.21   85.12   81.64   76.14   75.76 
              77.34   81.52   87.45   95.26  104.91 
             120.87  152.42 
/
 6  6  4  1   86.21   84.91   80.48   74.45   74.16 
              76.22   81.15   88.03   96.59  106.46 
             124.57  159.95 
/
 6  6  5  1   86.21   83.77   73.90   68.59   69.74 
              74.52   84.01   96.25  110.60  126.67 
             153.48  204.36 
/
 6  6  6  1   86.21   83.11   69.78   66.74   68.97 
              75.55   88.03  103.55  121.27  140.73 
             172.71  232.85 
/
 6  6  7  1   86.21   82.25   64.87   65.28   69.11 
              78.44   95.26  115.32  137.61  161.69 
             200.88  274.30 
/
 6  6  8  1   86.13   72.21   65.99   75.95  101.50 
             146.72  212.51  284.34  363.32  450.49 
             598.58  888.56 
/
 6  6  9  1   78.04   66.66   80.98  105.20  158.91 
             246.60  379.89  534.31  711.95  913.32 
            1257.55 1952.70 
/
 6  7  1  1   86.55   85.76   83.82   80.31   80.15 
              81.50   84.88   89.62   95.17  102.55 
             113.95  137.22 
/
 6  7  2  1   86.55   85.71   83.53   79.55   79.36 
              80.76   83.37   89.21   95.34  103.14 
             115.31  139.53 
/
 6  7  3  1   86.55   85.54   82.45   77.21   76.82 
              78.20   82.16   86.73   95.64  105.08 
             119.89  149.65 
/
 6  7  4  1   86.55   85.36   81.48   75.66   75.31 
              77.05   81.56   87.93   95.84  105.93 
             122.87  156.53 
/
 6  7  5  1   86.55   84.38   75.85   69.85   70.52 
              74.62   82.95   93.88  106.88  121.59 
             146.27  193.76 
/
 6  7  6  1   86.55   83.80   72.35   67.83   69.42 
              75.01   85.86   99.63  115.59  133.28 
             162.61  218.00 
/
 6  7  7  1   86.54   83.02   67.28   66.07   69.02 
              76.88   91.44  109.18  129.15  150.89 
             186.44  253.16 
/
 6  7  8  1   86.51   74.94   64.37   72.24   93.14 
             131.24  187.45  248.37  314.61  386.90 
             508.04  746.62 
/
 6  7  9  1   81.31   67.59   75.36   94.59  139.37 
             212.68  321.39  446.34  587.77  746.95 
            1019.17 1560.69 
/
 6  8  1  1   87.57   87.00   86.16   84.77   84.63 
              85.59   90.88   91.84   96.27  101.47 
             111.17  131.39 
/
 6  8  2  1   87.57   86.98   86.02   84.42   84.23 
              85.22   90.58   91.68   96.25  101.69 
             111.68  132.45 
/
 6  8  3  1   87.57   86.85   85.33   82.67   82.40 
              83.52   88.21   91.04   96.23  103.12 
             114.38  137.74 
/
 6  8  4  1   87.57   86.75   84.69   80.96   80.73 
              81.98   84.76   90.60   96.44  104.33 
             117.09  142.59 
/
 6  8  5  1   87.57   86.34   82.24   76.18   75.83 
              77.44   82.21   88.92   97.30  107.45 
             125.45  160.90 
/
 6  8  6  1   87.57   86.07   80.69   74.17   74.00 
              76.26   82.05   90.02   99.88  111.29 
             131.05  170.93 
/
 6  8  7  1   87.57   85.67   78.41   71.88   72.07 
              75.36   82.70   92.53  104.40  118.00 
             140.99  186.06 
/
 6  8  8  1   87.55   81.96   63.37   65.19   72.52 
              88.43  114.80  144.65  176.95  211.46 
             267.44  372.87 
/
 6  8  9  1   87.54   78.10   63.45   69.22   85.72 
             116.66  163.69  214.63  269.54  328.83 
             426.96  617.74 
/
 6  9  1  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  2  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  3  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  4  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  5  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  6  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  7  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  8  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 6  9  9  1   88.27   87.86   87.72   87.76   88.09 
              89.03   91.03   93.84   97.46  101.88 
             110.02  127.60 
/
 7  1  1  1   91.56   90.52   86.54   81.72   81.52 
              83.59   88.27   94.79  102.77  112.35 
             128.97  160.46 
/
 7  1  2  1   91.56   90.42   85.94   81.03   80.95 
              83.24   88.34   95.37  104.01  113.89 
             131.52  165.58 
/
 7  1  3  1   91.56   89.92   83.18   78.42   79.03 
              82.49   89.69   99.27  110.74  123.79 
             145.56  187.88 
/
 7  1  4  1   91.56   89.45   80.56   76.74   78.08 
              82.76   92.10  104.15  118.28  134.06 
             160.16  209.88 
/
 7  1  5  1   91.56   87.22   72.61   73.91   79.51 
              92.19  114.23  139.82  167.88  198.03 
             247.01  339.68 
/
 7  1  6  1   91.56   86.05   71.92   74.51   83.14 
             101.45  131.57  165.52  202.27  241.64 
             306.02  429.90 
/
 7  1  7  1   91.55   84.76   72.15   76.78   90.35 
             117.15  159.19  205.51  255.57  309.67 
             399.39  576.84 
/
 7  1  8  1   81.17   79.23  112.56  152.50  240.10 
             391.22  636.04  936.00 1287.41 1698.75 
            2419.17 3891.75 
/
 7  1  9  1   75.76  109.87  188.50  275.80  479.56 
             869.67 1548.49 2419.22 3476.59 4747.99 
            7104.55 12242.42 
/
 7  2  1  1   92.19   91.16   87.40   82.55   82.28 
              84.24   88.72   94.98  102.68  112.32 
             128.49  159.03 
/
 7  2  2  1   92.19   91.07   86.86   81.86   81.70 
              83.86   88.72   95.45  103.73  113.46 
             130.70  163.84 
/
 7  2  3  1   92.19   90.60   84.27   79.23   79.68 
              82.89   89.65   98.71  109.64  122.13 
             143.10  184.22 
/
 7  2  4  1   92.19   90.16   81.84   77.48   78.59 
              82.90   91.59  102.92  116.31  131.35 
             156.34  204.23 
/
 7  2  5  1   92.19   88.06   73.09   74.11   79.08 
              90.55  110.81  134.59  160.81  189.06 
             234.99  321.66 
/
 7  2  6  1   92.18   86.93   72.18   74.36   82.00 
              98.54  126.18  157.58  191.70  228.26 
             287.86  401.94 
/
 7  2  7  1   92.18   85.67   72.08   76.06   88.07 
             112.28  150.69  193.26  239.32  288.82 
             370.61  530.79 
/
 7  2  8  1   82.85   77.13  105.86  141.41  219.61 
             353.20  566.15  824.74 1127.34 1476.78 
            2091.46 3341.41 
/
 7  2  9  1   76.49  103.04  172.87  250.15  427.73 
             762.52 1339.54 2073.65 2963.65 4012.55 
            5946.52 10166.88 
/
 7  3  1  1   92.83   91.82   88.30   83.45   83.13 
              84.97   89.23   95.23  103.05  112.26 
             128.01  157.51 
/
 7  3  2  1   92.83   91.73   87.82   82.78   82.53 
              84.56   89.16   95.60  103.51  113.23 
             129.88  162.00 
/
 7  3  3  1   92.83   91.31   85.42   80.15   80.43 
              83.39   89.69   98.21  108.59  120.45 
             140.61  180.46 
/
 7  3  4  1   92.83   90.90   83.19   78.34   79.21 
              83.14   91.17  101.75  114.36  128.63 
             152.45  198.45 
/
 7  3  5  1   92.82   88.93   73.68   74.40   78.77 
              89.02  107.45  129.38  153.71  180.02 
             222.88  303.60 
/
 7  3  6  1   92.82   87.89   72.55   74.32   81.00 
              95.75  120.86  149.66  181.11  214.87 
             269.81  374.25 
/
 7  3  7  1   92.82   86.63   72.12   75.47   85.94 
             107.55  142.31  181.13  223.13  268.27 
             342.36  486.08 
/
 7  3  8  1   84.85   75.96   99.38  130.53  199.60 
             316.24  499.79  719.70  977.72 1270.57 
            1786.45 2832.85 
/
 7  3  9  1   77.42   96.43  157.53  225.19  378.25 
             661.52 1145.44 1753.53 2489.32 3348.91 
            4904.21 8294.42 
/
 7  4  1  1   93.48   92.49   89.24   84.42   84.09 
              85.77   89.82   95.14  103.44  112.45 
             127.61  155.86 
/
 7  4  2  1   93.48   92.42   88.80   83.78   83.47 
              85.35   89.69   95.80  103.56  113.14 
             129.20  160.03 
/
 7  4  3  1   93.47   92.04   86.63   81.18   81.29 
              83.99   89.83   97.80  107.59  118.80 
             138.17  176.63 
/
 7  4  4  1   93.47   91.67   84.61   79.34   79.96 
              83.50   90.86  100.67  112.46  125.91 
             148.47  192.53 
/
 7  4  5  1   93.47   89.85   74.43   74.84   78.60 
              87.64  104.19  124.19  146.59  170.90 
             210.63  285.43 
/
 7  4  6  1   93.47   88.89   73.07   74.41   80.15 
              93.10  115.61  141.77  170.51  201.43 
             251.76  347.00 
/
 7  4  7  1   93.46   87.65   72.31   75.03   83.99 
             102.94  134.03  169.09  207.07  247.83 
             314.54  442.77 
/
 7  4  8  1   87.30   76.43   93.25  119.93  179.98 
             280.59  436.86  621.02  836.06 1080.19 
            1503.86 2364.07 
/
 7  4  9  1   78.68   90.16  142.46  200.89  331.06 
             566.93  965.81 1459.21 2054.14 2748.20 
            3975.14 6629.48 
/
 7  5  1  1   94.80   93.89   91.20   86.65   86.37 
              87.88   91.66   96.39  104.34  112.96 
             126.38  152.00 
/
 7  5  2  1   94.80   93.84   90.88   86.08   85.73 
              87.26   91.17   95.78  104.47  113.64 
             127.92  155.55 
/
 7  5  3  1   94.80   93.56   89.28   83.71   83.46 
              85.64   90.52   97.35  105.83  115.81 
             133.74  168.87 
/
 7  5  4  1   94.80   93.28   87.68   81.88   81.96 
              84.73   90.71   98.89  108.94  120.52 
             140.39  180.28 
/
 7  5  5  1   94.79   91.81   79.16   76.49   78.87 
              85.48   98.15  114.04  132.29  152.42 
             185.63  248.41 
/
 7  5  6  1   94.79   91.01   74.77   75.21   79.10 
              88.45  105.53  126.16  149.25  174.33 
             215.35  292.71 
/
 7  5  7  1   94.79   89.98   73.32   74.76   80.83 
              94.43  117.95  145.21  175.16  207.38 
             259.89  359.31 
/
 7  5  8  1   93.34   78.54   82.99  100.04  142.22 
             213.25  319.78  442.38  581.84  739.23 
            1009.36 1546.21 
/
 7  5  9  1   82.85   79.66  113.44  153.90  242.85 
             396.47  645.41  948.76 1303.90 1715.53 
            2437.36 3914.13 
/
 7  6  1  1   96.16   95.38   93.52   90.21   90.10 
              91.49   95.09   99.46  105.01  112.36 
             123.73  146.97 
/
 7  6  2  1   96.16   95.33   93.22   89.39   89.29 
              90.76   93.32   99.32  105.21  113.06 
             125.23  149.52 
/
 7  6  3  1   96.16   95.15   92.11   87.02   86.66 
              88.13   92.12   96.80  105.75  115.35 
             130.14  160.51 
/
 7  6  4  1   96.16   94.98   91.13   85.47   85.15 
              87.02   91.58   98.03  106.06  116.27 
             133.51  167.84 
/
 7  6  5  1   96.16   93.99   85.51   79.77   80.61 
              84.83   93.44  104.79  118.34  133.73 
             159.67  209.65 
/
 7  6  6  1   96.16   93.40   82.05   77.82   79.61 
              85.41   96.75  111.21  128.05  146.80 
             177.98  237.21 
/
 7  6  7  1   96.15   92.62   77.11   76.17   79.36 
              87.62  103.01  121.91  143.31  166.70 
             205.13  277.75 
/
 7  6  8  1   96.11   84.91   75.34   84.09  107.50 
             150.63  215.19  286.35  365.01  451.89 
             599.54  889.15 
/
 7  6  9  1   91.30   78.23   88.34  110.41  162.21 
             248.68  381.21  535.36  712.65  913.75 
            1257.63 1952.30 
/
 7  7  1  1   96.51   95.78   94.21   91.44   91.25 
              92.52   97.05  100.01  105.25  112.00 
             122.99  145.55 
/
 7  7  2  1   96.51   95.73   93.92   90.70   90.56 
              91.92   95.57   99.84  105.36  112.74 
             124.22  147.76 
/
 7  7  3  1   96.51   95.57   92.84   88.01   87.71 
              89.15   93.02   97.92  106.14  115.06 
             129.36  157.81 
/
 7  7  4  1   96.51   95.42   92.02   86.60   86.24 
              87.84   92.05   98.05  106.23  115.95 
             132.11  164.83 
/
 7  7  5  1   96.51   94.57   87.22   81.06   81.47 
              85.11   92.68  102.81  115.08  129.14 
             152.96  199.58 
/
 7  7  6  1   96.50   94.06   84.28   78.99   80.20 
              85.13   94.98  107.78  122.89  139.89 
             168.41  222.85 
/
 7  7  7  1   96.50   93.36   80.01   77.08   79.48 
              86.43   99.70  116.32  135.39  156.44 
             191.20  257.05 
/
 7  7  8  1   96.46   87.47   74.08   80.92   99.92 
             135.71  190.58  250.75  316.60  388.57 
             509.36  747.30 
/
 7  7  9  1   94.36   79.39   83.37  100.60  143.25 
             215.17  323.12  447.62  588.64  747.62 
            1019.49 1560.54 
/
 7  8  1  1   97.56   97.02   96.33   95.24   95.15 
              96.10  101.19  102.09  106.31  111.41 
             120.82  140.58 
/
 7  8  2  1   97.56   97.00   96.21   94.93   94.81 
              95.78  101.01  101.96  106.38  111.59 
             121.27  141.52 
/
 7  8  3  1   97.56   96.89   95.62   93.44   93.20 
              94.29   99.76  101.38  106.37  112.76 
             123.76  146.47 
/
 7  8  4  1   97.56   96.79   95.04   91.97   91.75 
              92.98   97.00  100.96  106.51  114.15 
             126.25  151.16 
/
 7  8  5  1   97.56   96.43   92.82   87.12   86.75 
              88.22   92.68   99.01  106.94  117.38 
             134.60  169.09 
/
 7  8  6  1   97.56   96.20   91.52   85.27   85.02 
              87.03   92.38   99.84  109.18  120.02 
             139.41  178.32 
/
 7  8  7  1   97.56   95.85   89.56   83.08   83.11 
              86.00   92.71  101.86  113.07  126.07 
             148.24  192.49 
/
 7  8  8  1   97.54   92.53   74.24   75.62   81.90 
              96.23  120.95  149.58  181.06  214.99 
             270.38  375.18 
/
 7  8  9  1   97.52   89.92   73.57   78.44   93.20 
             122.13  167.41  217.50  271.86  330.87 
             428.60  618.65 
/
 7  9  1  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  2  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  3  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  4  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  5  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  6  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  7  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  8  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
 7  9  9  1   98.28   97.86   97.73   97.77   98.10 
              99.04  101.03  103.84  107.46  111.89 
             120.03  137.60 
/
