.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_SENDQUERY" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_sendquery \- send a query string to the backend connection without waiting for a result

.SH SYNOPSIS

.nf
pg_sendquery [\fI-paramarray\fR [\fI-variables\fR] arrayVar] \fIconn\fR \fIcommandString\fR [\fIargs\fR]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_sendquery\fR submits a command to the
PostgreSQL server.
This function works like \fBpg_exec\fR, except that
it does not return a result.  Rather, the command is issued
to the backend asynchronously.
.PP
The result is either an error message or nothing.  An empty
return indicates that the command was dispatched to the
backend.
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear. See pg_select for more info.
.PP
If the [-variables] flag is provided, then embedded Tcl variables are passed as parameters. Variables can be flagged with ':' and array references and namespaces are supported. Complex variable names can usually be embedded with :{nasty-name-here} though no attempt at duplicating Tcl brace-escaping is made.
If the variable does not exist,
then NULL is substituted.
Each such name must occur in a location where a value or field name could appear. See pg_select for more info.
.SH "ARGUMENTS"
.TP
\fB[-paramarray arrayname]\fR
Perform parameter substitution via `quoted` elements of the array using PQexecParams or PQSendQueryParams.
.TP
\fB[-variables]\fR
Substitute Tcl variables found in the SQL string using PQexecParams or PQSendQueryParams.
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the command.
.TP
\fB\fIcommandString\fB\fR
The SQL command to execute.
.TP
\fB\fIargs\fB\fR
For PostgreSQL versions greater than 7.4, \fIargs\fR
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution. Nulls are represented by the string "NULL".
.SH "RETURN VALUE"
.PP
A Tcl error will be returned if
\fBpgtcl\fR was unable to issue the command.
Otherwise, an empty string will be return.  It is up to the
developer to use \fBpg_getresult\fR to obtain
results from commands issued with \fBpg_sendquery\fR\&.
