/* $Cambridge: hermes/src/prayer/session/favourite.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* List of favourite mail folders */

struct favourite_list {
    struct list *list;          /* List of favourits */
    char *preferred;            /* Name of preferred favourite */
};

struct favourite_list *favourite_list_create(void);
void favourite_list_free(struct favourite_list *fl);
void favourite_preferred(struct favourite_list *fl, char *preferred);

BOOL favourite_add(struct favourite_list *fl, char *name);
BOOL favourite_delete(struct favourite_list *fl, char *name);
BOOL
favourite_rename(struct favourite_list *fl, char *oldname, char *newname);

void
favourite_parse_line(struct favourite_list *fl, char *line,
                     struct session *session);

void favourite_print_options(struct favourite_list *fl, struct buffer *b);

void
favourite_template_vals(struct favourite_list *fl,
                        struct template_vals *tvals,
                        char *array);
