(use gauche.test)
(use file.util)
(use srfi-1)

(test-start "scmail.config")

(use scmail.config)
(test-module 'scmail.config)

(with-module
 scmail.config
 ;; disable choosing old files.
 (define (choose path) path))

(define temporary-directory (build-path (current-directory) "test.dot.scmail"))

(test* "scmail-config-default-file" #t
       (string=?
        (scmail-config-default-file)
        (expand-path "~/.scmail/config")))

(test "scmail-config-set-directory!" #t
      (lambda ()
        (scmail-config-set-directory! temporary-directory)
        #t))

(test* "scmail-config-default-file" #t
       (string=?
        (scmail-config-default-file)
        (build-path temporary-directory "config")))

(test "scmail-config-make-directory" #t
      (lambda ()
        (scmail-config-make-directory)
        (file-is-directory? temporary-directory)))
;; try again to check whether it works if the directory already existed.
(test "scmail-config-make-directory" #t
      (lambda ()
        (scmail-config-make-directory)
        (file-is-directory? temporary-directory)))
(remove-directory* temporary-directory)

(test* "scmail-config" #t
       (is-a? (scmail-config) <config>))

(test* "scmail-config-get-path" #t
       (every (lambda (pair)
                (let ((slot (car pair))
                      (path (build-path temporary-directory (cdr pair))))
                  (string=?
                   (scmail-config-get-path slot)
                   path)))
              '(
                (deliver-rules . "deliver-rules")
                (refile-rules . "refile-rules")
                (log-file . "log")
                (token-table . "token-table.dbm")
                (digest . "digest.dbm")
                )))

(test "scmail-config-read" #t
      (lambda ()
        (scmail-config-read (build-path (current-directory) 
                                        "../dot.scmail/config.sample"))
        (is-a? (scmail-config) <config>)))


(test* "scmail-config-get-path" #t
       (every (lambda (pair)
                (let ((slot (car pair))
                      (path (build-path (expand-path "~/.scmail")
                                        (cdr pair))))
                  (string=?
                   (scmail-config-get-path slot)
                   path)))
              '(
                (deliver-rules . "deliver-rules")
                (refile-rules . "refile-rules")
                (log-file . "log")
                (token-table . "token-table.dbm")
                (digest . "digest.dbm")
                )))

(test-end)
