/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.SelectItem;
import adql.query.operand.ADQLOperand;
import java.util.ArrayList;
import java.util.List;

public class ClauseSelect
extends ClauseADQL<SelectItem> {
    private boolean distinct = false;
    private int limit = -1;

    public ClauseSelect() {
        this(false, -1);
    }

    public ClauseSelect(boolean distinctColumns) {
        this(distinctColumns, -1);
    }

    public ClauseSelect(int limit) {
        this(false, limit);
    }

    public ClauseSelect(boolean distinctColumns, int limit) {
        super("SELECT");
        this.distinct = distinctColumns;
        this.limit = limit;
    }

    public ClauseSelect(ClauseSelect toCopy) throws Exception {
        super(toCopy);
        this.distinct = toCopy.distinct;
        this.limit = toCopy.limit;
    }

    public final boolean distinctColumns() {
        return this.distinct;
    }

    public final void setDistinctColumns(boolean distinct) {
        this.distinct = distinct;
    }

    public final boolean hasLimit() {
        return this.limit >= 0;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setNoLimit() {
        this.limit = -1;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean add(ADQLOperand operand) throws NullPointerException {
        if (operand == null) {
            throw new NullPointerException("It is impossible to add NULL items to a SELECT clause!");
        }
        return this.add(new SelectItem(operand));
    }

    @Override
    public void add(int index, ADQLOperand operand) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (operand == null) {
            throw new NullPointerException("It is impossible to add NULL items to a SELECT clause!");
        }
        this.add(index, new SelectItem(operand));
    }

    @Override
    public ADQLOperand set(int index, ADQLOperand operand) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (operand == null) {
            throw new NullPointerException("It is impossible to replace a SELECT item by a NULL item into a SELECT clause!");
        }
        SelectItem item = this.set(index, new SelectItem(operand));
        return item.getOperand();
    }

    public ADQLOperand searchByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return ((SelectItem)this.get(index)).getOperand();
    }

    public ADQLOperand searchByAlias(String alias) {
        List<SelectItem> founds = this.searchByAlias(alias, true);
        if (founds.isEmpty()) {
            return null;
        }
        return founds.get(0).getOperand();
    }

    public List<SelectItem> searchByAlias(String alias, boolean caseSensitive) {
        if (alias == null) {
            return new ArrayList<SelectItem>(0);
        }
        ArrayList<SelectItem> founds = new ArrayList<SelectItem>();
        for (SelectItem item : this) {
            if (!item.hasAlias()) continue;
            if (!caseSensitive) {
                if (item.isCaseSensitive()) {
                    if (!item.getAlias().equals(alias.toLowerCase())) continue;
                    founds.add(item);
                    continue;
                }
                if (!item.getAlias().equalsIgnoreCase(alias)) continue;
                founds.add(item);
                continue;
            }
            if (item.isCaseSensitive()) {
                if (!item.getAlias().equals(alias)) continue;
                founds.add(item);
                continue;
            }
            if (!item.getAlias().toLowerCase().equals(alias)) continue;
            founds.add(item);
        }
        return founds;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ClauseSelect(this);
    }

    @Override
    public String toADQL() {
        String adql = null;
        for (int i = 0; i < this.size(); ++i) {
            adql = i == 0 ? this.getName() + (this.distinct ? " DISTINCT" : "") + (this.hasLimit() ? " TOP " + this.limit : "") : adql + " " + this.getSeparator(i);
            adql = adql + " " + ((SelectItem)this.get(i)).toADQL();
        }
        return adql;
    }
}

