#Very non-portable workaround to detect if the current cmake process is
#outputing to a valid looking terminal (on LINUX only)
if(EXISTS /proc/self/fd/1)
    get_filename_component(STDOUT /proc/self/fd/1 REALPATH)
else()
    set(STDOUT "INVALID")
endif()
if(EXISTS /proc/self/fd/2)
    get_filename_component(STDERR /proc/self/fd/2 REALPATH)
else()
    set(STDERR "INVALID")
endif()

string(FIND ${STDOUT} "tty" isTTYstdout)
string(FIND ${STDERR} "tty" isTTYstderr)
string(FIND ${STDOUT} "pts" isPTSstdout)
string(FIND ${STDERR} "pts" isPTSstderr)
if(((isTTYstdout GREATER 0) OR (isPTSstdout GREATER 0)) AND
    (isTTYstderr GREATER 0) OR (isPTSstdout GREATER 0))
    set(VALID_TTY TRUE)
else()
    set(VALID_TTY FALSE)
endif()

if(VALID_TTY)
    string(ASCII 27 Esc)
    set(ColorReset "${Esc}[m")
    set(ColorBold  "${Esc}[1m")
    set(Red         "${Esc}[31m")
    set(Green       "${Esc}[32m")
    set(Yellow      "${Esc}[33m")
    set(Blue        "${Esc}[34m")
    set(Magenta     "${Esc}[35m")
    set(Cyan        "${Esc}[36m")
    set(White       "${Esc}[37m")
    set(BoldRed     "${Esc}[1;31m")
    set(BoldGreen   "${Esc}[1;32m")
    set(BoldYellow  "${Esc}[1;33m")
    set(BoldBlue    "${Esc}[1;34m")
    set(BoldMagenta "${Esc}[1;35m")
    set(BoldCyan    "${Esc}[1;36m")
    set(BoldWhite   "${Esc}[1;37m")
endif()


# Module Based Off Of
# https://stackoverflow.com/questions/18968979/how-to-get-colorized-output-with-cmake
if(NOT DEFINED MESSAGE_REDEFINED)
    function(message)
        list(GET ARGV 0 MessageType)
        if(MessageType STREQUAL FATAL_ERROR OR MessageType STREQUAL SEND_ERROR)
            list(REMOVE_AT ARGV 0)
            _message(${MessageType} "${BoldRed}${ARGV}${ColorReset}")
        elseif(MessageType STREQUAL WARNING)
            list(REMOVE_AT ARGV 0)
            _message(${MessageType} "${BoldYellow}${ARGV}${ColorReset}")
        elseif(MessageType STREQUAL AUTHOR_WARNING)
            list(REMOVE_AT ARGV 0)
            _message(${MessageType} "${BoldCyan}${ARGV}${ColorReset}")
        elseif(MessageType STREQUAL STATUS)
            list(REMOVE_AT ARGV 0)
            _message(${MessageType} "${ARGV}")
        else()
            _message("${ARGV}")
        endif()
    endfunction()
    set(MESSAGE_REDEFINED TRUE)
endif()
